/*     */ package org.jboss.ws.tools.wsdl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import javax.wsdl.xml.WSDLLocator;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.utils.ResourceURL;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ class WSDLLocatorImpl
/*     */   implements WSDLLocator
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(WSDLDefinitionsFactory.class);
/*     */   private EntityResolver entityResolver;
/*     */   private URL wsdlLocation;
/*     */   private String latestImportURI;
/*     */ 
/*     */   public WSDLLocatorImpl(EntityResolver entityResolver, URL wsdlLocation)
/*     */   {
/*  52 */     if (wsdlLocation == null) {
/*  53 */       throw new IllegalArgumentException("WSDL file argument cannot be null");
/*     */     }
/*  55 */     this.entityResolver = entityResolver;
/*  56 */     this.wsdlLocation = wsdlLocation;
/*     */   }
/*     */ 
/*     */   public InputSource getBaseInputSource()
/*     */   {
/*  61 */     log.trace("getBaseInputSource [wsdlUrl=" + this.wsdlLocation + "]");
/*     */     try
/*     */     {
/*  64 */       InputStream inputStream = new ResourceURL(this.wsdlLocation).openStream();
/*  65 */       if (inputStream == null) {
/*  66 */         throw new IllegalArgumentException("Cannot obtain wsdl from [" + this.wsdlLocation + "]");
/*     */       }
/*  68 */       return new InputSource(inputStream);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/*  72 */     throw new RuntimeException("Cannot access wsdl from [" + this.wsdlLocation + "], " + e.getMessage());
/*     */   }
/*     */ 
/*     */   public String getBaseURI()
/*     */   {
/*  78 */     return this.wsdlLocation.toExternalForm();
/*     */   }
/*     */ 
/*     */   public InputSource getImportInputSource(String parent, String resource)
/*     */   {
/*  83 */     log.trace("getImportInputSource [parent=" + parent + ",resource=" + resource + "]");
/*     */ 
/*  85 */     URL parentURL = null;
/*     */     try
/*     */     {
/*  88 */       parentURL = new URL(parent);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*  92 */       log.error("Not a valid URL: " + parent);
/*  93 */       return null;
/*     */     }
/*     */ 
/*  96 */     String wsdlImport = null;
/*  97 */     String external = parentURL.toExternalForm();
/*     */ 
/* 100 */     if ((resource.startsWith("http://")) || (resource.startsWith("https://")))
/*     */     {
/* 102 */       wsdlImport = resource;
/*     */     }
/* 106 */     else if (resource.startsWith("/"))
/*     */     {
/* 108 */       String beforePath = external.substring(0, external.indexOf(parentURL.getPath()));
/* 109 */       wsdlImport = beforePath + resource;
/*     */     }
/*     */     else
/*     */     {
/* 115 */       String parentDir = external.substring(0, external.lastIndexOf("/"));
/*     */ 
/* 118 */       while (resource.startsWith("./")) {
/* 119 */         resource = resource.substring(2);
/*     */       }
/*     */ 
/* 122 */       while (resource.startsWith("../"))
/*     */       {
/* 124 */         parentDir = parentDir.substring(0, parentDir.lastIndexOf("/"));
/* 125 */         resource = resource.substring(3);
/*     */       }
/*     */ 
/* 128 */       wsdlImport = parentDir + "/" + resource;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 133 */       log.trace("Trying to resolve: " + wsdlImport);
/* 134 */       InputSource inputSource = this.entityResolver.resolveEntity(wsdlImport, wsdlImport);
/* 135 */       if (inputSource != null)
/*     */       {
/* 137 */         this.latestImportURI = wsdlImport;
/*     */       }
/*     */       else
/*     */       {
/* 141 */         throw new IllegalArgumentException("Cannot resolve imported resource: " + wsdlImport);
/*     */       }
/*     */ 
/* 144 */       return inputSource;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 148 */       throw rte;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 152 */     throw new WSException("Cannot access imported wsdl [" + wsdlImport + "], " + e.getMessage());
/*     */   }
/*     */ 
/*     */   public String getLatestImportURI()
/*     */   {
/* 158 */     return this.latestImportURI;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.wsdl.WSDLLocatorImpl
 * JD-Core Version:    0.6.0
 */