/*    */ package org.jboss.wsf.spi.tools;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.wsf.spi.util.ServiceLoader;
/*    */ 
/*    */ public abstract class WSContractProvider
/*    */ {
/* 32 */   private static String DEFAULT_PROVIDER = "org.jboss.ws.tools.jaxws.impl.JBossWSProviderFactoryImpl";
/*    */   public static final String PROVIDER_PROPERTY = "org.jboss.wsf.spi.tools.ProviderFactoryImpl";
/*    */ 
/*    */   public static WSContractProvider newInstance()
/*    */   {
/* 49 */     return newInstance(Thread.currentThread().getContextClassLoader());
/*    */   }
/*    */ 
/*    */   public static WSContractProvider newInstance(ClassLoader loader)
/*    */   {
/* 61 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/*    */     try
/*    */     {
/* 64 */       Thread.currentThread().setContextClassLoader(loader);
/* 65 */       WSContractProviderFactory factory = (WSContractProviderFactory)ServiceLoader.loadService("org.jboss.wsf.spi.tools.ProviderFactoryImpl", DEFAULT_PROVIDER);
/* 66 */       WSContractProvider localWSContractProvider = factory.createProvider(loader);
/*    */       return localWSContractProvider; } finally { Thread.currentThread().setContextClassLoader(oldLoader); } throw localObject;
/*    */   }
/*    */ 
/*    */   public abstract void setGenerateWsdl(boolean paramBoolean);
/*    */ 
/*    */   public abstract void setGenerateSource(boolean paramBoolean);
/*    */ 
/*    */   public abstract void setOutputDirectory(File paramFile);
/*    */ 
/*    */   public abstract void setResourceDirectory(File paramFile);
/*    */ 
/*    */   public abstract void setSourceDirectory(File paramFile);
/*    */ 
/*    */   public abstract void setClassLoader(ClassLoader paramClassLoader);
/*    */ 
/*    */   public abstract void provide(String paramString);
/*    */ 
/*    */   public abstract void provide(Class<?> paramClass);
/*    */ 
/*    */   public abstract void setMessageStream(PrintStream paramPrintStream);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.tools.WSContractProvider
 * JD-Core Version:    0.6.0
 */