/*     */ package org.jboss.wsf.spi.util;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public abstract class ServiceLoader
/*     */ {
/*     */   public static Object loadService(String propertyName, String defaultFactory)
/*     */   {
/*  61 */     Object factory = loadFromServices(propertyName, null);
/*  62 */     if (factory == null)
/*     */     {
/*  64 */       factory = loadFromPropertiesFile(propertyName, null);
/*     */     }
/*  66 */     if (factory == null)
/*     */     {
/*  68 */       factory = loadFromSystemProperty(propertyName, defaultFactory);
/*     */     }
/*  70 */     return factory;
/*     */   }
/*     */ 
/*     */   public static Object loadFromServices(String propertyName, String defaultFactory)
/*     */   {
/*  77 */     Object factory = null;
/*  78 */     String factoryName = null;
/*  79 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */ 
/*  82 */     String filename = "META-INF/services/" + propertyName;
/*  83 */     InputStream inStream = loader.getResourceAsStream(filename);
/*  84 */     if (inStream != null)
/*     */     {
/*     */       try
/*     */       {
/*  88 */         BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
/*  89 */         factoryName = br.readLine();
/*  90 */         br.close();
/*  91 */         if (factoryName != null)
/*     */         {
/*  93 */           Class factoryClass = loader.loadClass(factoryName);
/*  94 */           factory = factoryClass.newInstance();
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*  99 */         throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 104 */     if ((factory == null) && (defaultFactory != null))
/*     */     {
/* 106 */       factory = loadDefault(defaultFactory);
/*     */     }
/*     */ 
/* 109 */     return factory;
/*     */   }
/*     */ 
/*     */   public static Object loadFromSystemProperty(String propertyName, String defaultFactory)
/*     */   {
/* 116 */     Object factory = null;
/* 117 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 119 */     PrivilegedAction action = new PropertyAccessAction(propertyName);
/* 120 */     String factoryName = (String)AccessController.doPrivileged(action);
/* 121 */     if (factoryName != null)
/*     */     {
/*     */       try
/*     */       {
/* 126 */         Class factoryClass = loader.loadClass(factoryName);
/* 127 */         factory = factoryClass.newInstance();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 131 */         throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 136 */     if ((factory == null) && (defaultFactory != null))
/*     */     {
/* 138 */       factory = loadDefault(defaultFactory);
/*     */     }
/*     */ 
/* 141 */     return factory;
/*     */   }
/*     */ 
/*     */   public static Object loadFromPropertiesFile(String propertyName, String defaultFactory)
/*     */   {
/* 151 */     Object factory = null;
/* 152 */     String factoryName = null;
/* 153 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 157 */     PrivilegedAction action = new PropertyAccessAction("java.home");
/* 158 */     String javaHome = (String)AccessController.doPrivileged(action);
/* 159 */     File jaxmFile = new File(javaHome + "/lib/jaxws.properties");
/* 160 */     if (jaxmFile.exists())
/*     */     {
/*     */       try
/*     */       {
/* 164 */         action = new PropertyFileAccessAction(jaxmFile.getCanonicalPath());
/* 165 */         Properties jaxmProperties = (Properties)AccessController.doPrivileged(action);
/* 166 */         factoryName = jaxmProperties.getProperty(propertyName);
/* 167 */         if (factoryName != null)
/*     */         {
/* 170 */           Class factoryClass = loader.loadClass(factoryName);
/* 171 */           factory = factoryClass.newInstance();
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 176 */         throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 181 */     if ((factory == null) && (defaultFactory != null))
/*     */     {
/* 183 */       factory = loadDefault(defaultFactory);
/*     */     }
/*     */ 
/* 186 */     return factory;
/*     */   }
/*     */ 
/*     */   private static Object loadDefault(String defaultFactory)
/*     */   {
/* 191 */     Object factory = null;
/* 192 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 195 */     if (defaultFactory != null)
/*     */     {
/*     */       try
/*     */       {
/* 200 */         Class factoryClass = loader.loadClass(defaultFactory);
/* 201 */         factory = factoryClass.newInstance();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 205 */         throw new IllegalStateException("Failed to load: " + defaultFactory, t);
/*     */       }
/*     */     }
/*     */ 
/* 209 */     return factory;
/*     */   }
/*     */ 
/*     */   private static class PropertyFileAccessAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     private String filename;
/*     */ 
/*     */     PropertyFileAccessAction(String filename)
/*     */     {
/* 233 */       this.filename = filename;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/*     */       try
/*     */       {
/* 240 */         InputStream inStream = new FileInputStream(this.filename);
/* 241 */         Properties props = new Properties();
/* 242 */         props.load(inStream);
/* 243 */         return props;
/*     */       }
/*     */       catch (IOException ex) {
/*     */       }
/* 247 */       throw new SecurityException("Cannot load properties: " + this.filename, ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class PropertyAccessAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     private String name;
/*     */ 
/*     */     PropertyAccessAction(String name)
/*     */     {
/* 218 */       this.name = name;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 223 */       return System.getProperty(this.name);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.util.ServiceLoader
 * JD-Core Version:    0.6.0
 */