/*    */ package org.jboss.wsf.stack.jbws;
/*    */ 
/*    */ import org.jboss.ws.extensions.eventing.deployment.EventingEndpointDeployment;
/*    */ import org.jboss.ws.extensions.eventing.metadata.EventingEpMetaExt;
/*    */ import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerFactory;
/*    */ import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
/*    */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*    */ import org.jboss.wsf.spi.deployment.Deployment;
/*    */ import org.jboss.wsf.spi.deployment.DeploymentAspect;
/*    */ import org.jboss.wsf.spi.deployment.Endpoint;
/*    */ import org.jboss.wsf.spi.deployment.Service;
/*    */ 
/*    */ public class EventingDeploymentAspect extends DeploymentAspect
/*    */ {
/*    */   public void create(Deployment dep)
/*    */   {
/* 48 */     for (Endpoint ep : dep.getService().getEndpoints())
/*    */     {
/* 50 */       ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
/* 51 */       if (sepMetaData == null) {
/* 52 */         throw new IllegalStateException("Cannot obtain endpoint meta data");
/*    */       }
/* 54 */       EventingEpMetaExt ext = (EventingEpMetaExt)sepMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/08/eventing");
/* 55 */       if (ext != null)
/*    */       {
/* 63 */         EventingEndpointDeployment desc = new EventingEndpointDeployment(ext.getEventSourceNS(), ext.getNotificationSchema(), ext.getNotificationRootElementNS());
/* 64 */         desc.setEndpointAddress(sepMetaData.getEndpointAddress());
/* 65 */         desc.setPortName(sepMetaData.getPortName());
/*    */ 
/* 67 */         SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();
/* 68 */         SubscriptionManagerMBean manager = factory.getSubscriptionManager();
/* 69 */         manager.registerEventSource(desc);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public void destroy(Deployment dep)
/*    */   {
/* 77 */     for (Endpoint ep : dep.getService().getEndpoints())
/*    */     {
/* 79 */       ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
/* 80 */       if (sepMetaData == null) {
/* 81 */         throw new IllegalStateException("Cannot obtain endpoint meta data");
/*    */       }
/* 83 */       EventingEpMetaExt ext = (EventingEpMetaExt)sepMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/08/eventing");
/* 84 */       if (ext != null)
/*    */       {
/* 86 */         SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();
/* 87 */         SubscriptionManagerMBean manager = factory.getSubscriptionManager();
/* 88 */         manager.removeEventSource(ext.getEventSourceURI());
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.stack.jbws.EventingDeploymentAspect
 * JD-Core Version:    0.6.0
 */