/*     */ package org.jboss.wsf.stack.jbws;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.Writer;
/*     */ import java.net.URI;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.servlet.ServletContext;
/*     */ import javax.servlet.ServletException;
/*     */ import javax.servlet.ServletInputStream;
/*     */ import javax.servlet.ServletOutputStream;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import javax.xml.ws.addressing.AddressingProperties;
/*     */ import javax.xml.ws.addressing.AttributedURI;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonBinding;
/*     */ import org.jboss.ws.core.CommonBindingProvider;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.CommonSOAPFaultException;
/*     */ import org.jboss.ws.core.HTTPMessageImpl;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.MessageTrace;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
/*     */ import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
/*     */ import org.jboss.ws.core.server.MimeHeaderSource;
/*     */ import org.jboss.ws.core.server.ServiceEndpointInvoker;
/*     */ import org.jboss.ws.core.server.ServletHeaderSource;
/*     */ import org.jboss.ws.core.server.ServletRequestContext;
/*     */ import org.jboss.ws.core.server.WSDLRequestHandler;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.MessageFactoryImpl;
/*     */ import org.jboss.ws.core.soap.SOAPConnectionImpl;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.utils.ThreadLocalAssociation;
/*     */ import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.Deployment;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint.EndpointState;
/*     */ import org.jboss.wsf.spi.deployment.Service;
/*     */ import org.jboss.wsf.spi.invocation.InvocationContext;
/*     */ import org.jboss.wsf.spi.invocation.RequestHandler;
/*     */ import org.jboss.wsf.spi.management.EndpointMetrics;
/*     */ import org.jboss.wsf.spi.management.ServerConfig;
/*     */ import org.jboss.wsf.spi.management.ServerConfigFactory;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public class RequestHandlerImpl
/*     */   implements RequestHandler
/*     */ {
/* 106 */   private static final Logger log = Logger.getLogger(RequestHandlerImpl.class);
/*     */   private ServerConfig serverConfig;
/*     */   private MessageFactoryImpl msgFactory;
/*     */ 
/*     */   RequestHandlerImpl()
/*     */   {
/* 113 */     SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 114 */     this.serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
/* 115 */     this.msgFactory = new MessageFactoryImpl();
/*     */   }
/*     */ 
/*     */   public void handleHttpRequest(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException
/*     */   {
/* 120 */     String method = req.getMethod();
/* 121 */     if (method.equals("POST"))
/*     */     {
/* 123 */       doPost(endpoint, req, res, context);
/*     */     }
/* 125 */     else if (method.equals("GET"))
/*     */     {
/* 127 */       doGet(endpoint, req, res, context);
/*     */     }
/*     */     else
/*     */     {
/* 131 */       throw new WSException("Unsupported method: " + method);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void doGet(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext context)
/*     */     throws ServletException, IOException
/*     */   {
/* 138 */     if ((req.getParameter("wsdl") != null) || (req.getParameter("WSDL") != null))
/*     */     {
/* 140 */       res.setContentType("text/xml");
/* 141 */       ServletOutputStream out = res.getOutputStream();
/*     */       try
/*     */       {
/* 144 */         ServletRequestContext reqContext = new ServletRequestContext(context, req, res);
/* 145 */         handleWSDLRequest(endpoint, out, reqContext);
/*     */       }
/*     */       catch (Exception ioex)
/*     */       {
/* 149 */         handleException(ex);
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 155 */           out.close();
/*     */         }
/*     */         catch (IOException ioex)
/*     */         {
/* 159 */           log.error("Cannot close output stream");
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 165 */       res.setStatus(405);
/* 166 */       res.setContentType("text/plain");
/* 167 */       Writer out = res.getWriter();
/* 168 */       out.write("HTTP GET not supported");
/* 169 */       out.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void doPost(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException
/*     */   {
/* 175 */     log.debug("doPost: " + req.getRequestURI());
/*     */ 
/* 177 */     ServletInputStream in = req.getInputStream();
/* 178 */     ServletOutputStream out = res.getOutputStream();
/*     */ 
/* 180 */     ClassLoader classLoader = endpoint.getService().getDeployment().getRuntimeClassLoader();
/* 181 */     if (classLoader == null) {
/* 182 */       throw new IllegalStateException("Deployment has no classloader associated");
/*     */     }
/*     */ 
/* 185 */     ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
/* 186 */     Thread.currentThread().setContextClassLoader(classLoader);
/*     */     try
/*     */     {
/* 189 */       ServletRequestContext reqContext = new ServletRequestContext(context, req, res);
/* 190 */       handleRequest(endpoint, in, out, reqContext);
/*     */     }
/*     */     catch (Exception ioex)
/*     */     {
/* 194 */       handleException(ex);
/*     */     }
/*     */     finally
/*     */     {
/* 199 */       Thread.currentThread().setContextClassLoader(ctxClassLoader);
/*     */       try
/*     */       {
/* 203 */         out.close();
/*     */       }
/*     */       catch (IOException ioex)
/*     */       {
/* 207 */         log.error("Cannot close output stream");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleRequest(Endpoint endpoint, InputStream inStream, OutputStream outStream, InvocationContext invContext)
/*     */   {
/* 214 */     log.debug("handleRequest: " + endpoint.getName());
/*     */ 
/* 216 */     ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
/* 217 */     if (sepMetaData == null) {
/* 218 */       throw new IllegalStateException("Cannot obtain endpoint meta data");
/*     */     }
/* 220 */     EndpointMetaData.Type type = sepMetaData.getType();
/*     */     CommonMessageContext msgContext;
/* 224 */     if (type == EndpointMetaData.Type.JAXRPC)
/*     */     {
/* 226 */       CommonMessageContext msgContext = new SOAPMessageContextJAXRPC();
/* 227 */       invContext.addAttachment(javax.xml.rpc.handler.MessageContext.class, msgContext);
/*     */     }
/*     */     else
/*     */     {
/* 231 */       msgContext = new SOAPMessageContextJAXWS();
/* 232 */       msgContext.put("javax.xml.ws.handler.message.outbound", new Boolean(false));
/* 233 */       msgContext.put("javax.xml.ws.binding.attachments.inbound", new HashMap());
/* 234 */       invContext.addAttachment(javax.xml.ws.handler.MessageContext.class, msgContext);
/*     */     }
/*     */ 
/* 238 */     HttpServletResponse httpResponse = null;
/* 239 */     ServletHeaderSource headerSource = null;
/* 240 */     if ((invContext instanceof ServletRequestContext))
/*     */     {
/* 242 */       ServletRequestContext reqContext = (ServletRequestContext)invContext;
/*     */ 
/* 244 */       ServletContext servletContext = reqContext.getServletContext();
/* 245 */       HttpServletRequest httpRequest = reqContext.getHttpServletRequest();
/* 246 */       httpResponse = reqContext.getHttpServletResponse();
/* 247 */       headerSource = new ServletHeaderSource(httpRequest, httpResponse);
/*     */ 
/* 249 */       if (type == EndpointMetaData.Type.JAXRPC)
/*     */       {
/* 251 */         msgContext.put("javax.xml.ws.servlet.context", servletContext);
/* 252 */         msgContext.put("javax.xml.ws.servlet.request", httpRequest);
/* 253 */         msgContext.put("javax.xml.ws.servlet.response", httpResponse);
/*     */       }
/*     */       else
/*     */       {
/* 257 */         msgContext.put("javax.xml.ws.http.request.headers", headerSource.getHeaderMap());
/* 258 */         msgContext.put("javax.xml.ws.http.request.method", httpRequest.getMethod());
/* 259 */         msgContext.put("javax.xml.ws.http.request.querystring", httpRequest.getQueryString());
/* 260 */         msgContext.put("javax.xml.ws.http.request.pathinfo", httpRequest.getPathInfo());
/* 261 */         msgContext.put("javax.xml.ws.servlet.context", servletContext);
/* 262 */         msgContext.put("javax.xml.ws.servlet.request", httpRequest);
/* 263 */         msgContext.put("javax.xml.ws.servlet.response", httpResponse);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 268 */     MessageContextAssociation.pushMessageContext(msgContext);
/* 269 */     msgContext.setEndpointMetaData(sepMetaData);
/*     */     try
/*     */     {
/* 273 */       MessageAbstraction resMessage = processRequest(endpoint, headerSource, invContext, inStream);
/*     */ 
/* 276 */       msgContext = MessageContextAssociation.peekMessageContext();
/*     */ 
/* 278 */       Map headers = (Map)msgContext.get("javax.xml.ws.http.response.headers");
/* 279 */       if ((headerSource != null) && (headers != null)) {
/* 280 */         headerSource.setHeaderMap(headers);
/*     */       }
/* 282 */       Integer code = (Integer)msgContext.get("javax.xml.ws.http.response.code");
/* 283 */       if ((httpResponse != null) && (code != null)) {
/* 284 */         httpResponse.setStatus(code.intValue());
/*     */       }
/* 286 */       boolean isFault = false;
/* 287 */       if ((resMessage instanceof SOAPMessage))
/*     */       {
/* 289 */         SOAPPart part = ((SOAPMessage)resMessage).getSOAPPart();
/* 290 */         if (part == null) {
/* 291 */           throw new SOAPException("Cannot obtain SOAPPart from response message");
/*     */         }
/*     */ 
/* 298 */         SOAPEnvelope soapEnv = part.getEnvelope();
/* 299 */         isFault = (soapEnv != null) && (soapEnv.getBody().hasFault());
/* 300 */         if ((httpResponse != null) && (isFault))
/*     */         {
/* 302 */           httpResponse.setStatus(500);
/*     */         }
/*     */       }
/*     */ 
/* 306 */       if (outStream != null)
/* 307 */         sendResponse(outStream, msgContext, isFault);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 311 */       WSException.rethrow(ex);
/*     */     }
/*     */     finally
/*     */     {
/* 317 */       CommonMessageContext.cleanupAttachments(MessageContextAssociation.peekMessageContext());
/*     */ 
/* 320 */       MessageContextAssociation.popMessageContext();
/*     */ 
/* 323 */       ThreadLocalAssociation.clear();
/* 324 */       DOMUtils.clearThreadLocals();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void sendResponse(OutputStream outputStream, CommonMessageContext msgContext, boolean isFault) throws SOAPException, IOException
/*     */   {
/* 330 */     MessageAbstraction resMessage = msgContext.getMessageAbstraction();
/* 331 */     String wsaTo = null;
/*     */ 
/* 334 */     AddressingProperties outProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.outbound");
/* 335 */     if ((outProps != null) && (outProps.getTo() != null))
/*     */     {
/* 337 */       AddressingConstantsImpl ADDR = new AddressingConstantsImpl();
/* 338 */       wsaTo = outProps.getTo().getURI().toString();
/* 339 */       if (wsaTo.equals(ADDR.getAnonymousURI()))
/* 340 */         wsaTo = null;
/*     */     }
/* 342 */     if (wsaTo != null)
/*     */     {
/* 344 */       log.debug("Sending response to addressing destination: " + wsaTo);
/* 345 */       new SOAPConnectionImpl().callOneWay((SOAPMessage)resMessage, wsaTo);
/*     */     }
/*     */     else
/*     */     {
/* 349 */       resMessage.writeTo(outputStream);
/*     */     }
/*     */   }
/*     */ 
/*     */   private MessageAbstraction processRequest(Endpoint ep, MimeHeaderSource headerSource, InvocationContext reqContext, InputStream inputStream)
/*     */     throws BindingException
/*     */   {
/* 359 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*     */ 
/* 361 */     ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
/* 362 */     if (sepMetaData == null) {
/* 363 */       throw new IllegalStateException("Cannot obtain endpoint meta data");
/*     */     }
/* 365 */     long beginProcessing = 0L;
/* 366 */     ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 369 */       Endpoint.EndpointState state = ep.getState();
/* 370 */       if (state != Endpoint.EndpointState.STARTED)
/*     */       {
/* 372 */         QName faultCode = Constants.SOAP11_FAULT_CODE_SERVER;
/* 373 */         String faultString = "Endpoint cannot handle requests in state: " + state;
/* 374 */         throw new CommonSOAPFaultException(faultCode, faultString);
/*     */       }
/*     */ 
/* 377 */       log.debug("BEGIN handleRequest: " + ep.getName());
/* 378 */       beginProcessing = initRequestMetrics(ep);
/*     */ 
/* 380 */       MimeHeaders headers = headerSource != null ? headerSource.getMimeHeaders() : null;
/*     */ 
/* 384 */       String bindingID = sepMetaData.getBindingId();
/*     */       MessageAbstraction reqMessage;
/*     */       MessageAbstraction reqMessage;
/* 385 */       if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID))
/*     */       {
/* 387 */         reqMessage = new HTTPMessageImpl(headers, inputStream);
/*     */       }
/*     */       else
/*     */       {
/* 392 */         this.msgFactory.setServiceMode(sepMetaData.getServiceMode());
/* 393 */         this.msgFactory.setStyle(sepMetaData.getStyle());
/*     */ 
/* 395 */         reqMessage = (SOAPMessageImpl)this.msgFactory.createMessage(headers, inputStream);
/*     */       }
/*     */ 
/* 399 */       msgContext.setMessageAbstraction(reqMessage);
/*     */ 
/* 402 */       MessageTrace.traceMessage("Incoming Request Message", reqMessage);
/*     */ 
/* 405 */       ClassLoader classLoader = sepMetaData.getClassLoader();
/* 406 */       Thread.currentThread().setContextClassLoader(classLoader);
/*     */ 
/* 409 */       ServiceEndpointInvoker epInvoker = (ServiceEndpointInvoker)ep.getAttachment(ServiceEndpointInvoker.class);
/* 410 */       if (epInvoker == null) {
/* 411 */         throw new IllegalStateException("Cannot obtain ServiceEndpointInvoker");
/*     */       }
/*     */ 
/* 414 */       epInvoker.invoke(reqContext);
/*     */ 
/* 417 */       msgContext = MessageContextAssociation.peekMessageContext();
/*     */ 
/* 420 */       MessageAbstraction resMessage = msgContext.getMessageAbstraction();
/* 421 */       if (resMessage != null) {
/* 422 */         postProcessResponse(headerSource, resMessage);
/*     */       }
/* 424 */       MessageAbstraction localMessageAbstraction1 = resMessage;
/*     */       MessageAbstraction resMessage;
/*     */       return localMessageAbstraction1;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 428 */       MessageAbstraction resMessage = msgContext.getMessageAbstraction();
/*     */ 
/* 432 */       if ((resMessage == null) || (!resMessage.isFaultMessage()))
/*     */       {
/* 434 */         bindingProvider = new CommonBindingProvider(sepMetaData);
/* 435 */         CommonBinding binding = bindingProvider.getCommonBinding();
/* 436 */         resMessage = binding.bindFaultMessage(ex);
/*     */       }
/*     */ 
/* 439 */       if (resMessage != null) {
/* 440 */         postProcessResponse(headerSource, resMessage);
/*     */       }
/* 442 */       CommonBindingProvider bindingProvider = resMessage;
/*     */       MessageAbstraction resMessage;
/*     */       return bindingProvider;
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 448 */         MessageAbstraction resMessage = msgContext.getMessageAbstraction();
/* 449 */         if (resMessage != null)
/*     */         {
/* 451 */           if (resMessage.isFaultMessage())
/*     */           {
/* 453 */             processFaultMetrics(ep, beginProcessing);
/*     */           }
/*     */           else
/*     */           {
/* 457 */             processResponseMetrics(ep, beginProcessing);
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 463 */         log.error("Cannot process metrics", ex);
/*     */       }
/*     */ 
/* 467 */       Thread.currentThread().setContextClassLoader(ctxClassLoader);
/* 468 */       log.debug("END handleRequest: " + ep.getName()); } throw localObject;
/*     */   }
/*     */ 
/*     */   private long initRequestMetrics(Endpoint endpoint)
/*     */   {
/* 474 */     long beginTime = 0L;
/*     */ 
/* 476 */     EndpointMetrics metrics = endpoint.getEndpointMetrics();
/* 477 */     if (metrics != null) {
/* 478 */       beginTime = metrics.processRequestMessage();
/*     */     }
/* 480 */     return beginTime;
/*     */   }
/*     */ 
/*     */   private void processResponseMetrics(Endpoint endpoint, long beginTime)
/*     */   {
/* 485 */     EndpointMetrics metrics = endpoint.getEndpointMetrics();
/* 486 */     if (metrics != null)
/* 487 */       metrics.processResponseMessage(beginTime);
/*     */   }
/*     */ 
/*     */   private void processFaultMetrics(Endpoint endpoint, long beginTime)
/*     */   {
/* 492 */     EndpointMetrics metrics = endpoint.getEndpointMetrics();
/* 493 */     if (metrics != null)
/* 494 */       metrics.processFaultMessage(beginTime);
/*     */   }
/*     */ 
/*     */   private void postProcessResponse(MimeHeaderSource headerSource, MessageAbstraction resMessage)
/*     */   {
/*     */     try
/*     */     {
/* 504 */       if ((headerSource != null) && ((resMessage instanceof SOAPMessage)))
/*     */       {
/* 506 */         XOPContext.eagerlyCreateAttachments();
/* 507 */         ((SOAPMessage)resMessage).saveChanges();
/* 508 */         headerSource.setMimeHeaders(resMessage.getMimeHeaders());
/*     */       }
/*     */ 
/* 512 */       MessageTrace.traceMessage("Outgoing Response Message", resMessage);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 516 */       WSException.rethrow("Faild to post process response message", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleWSDLRequest(Endpoint endpoint, OutputStream outputStream, InvocationContext context)
/*     */   {
/* 522 */     log.debug("handleWSDLRequest: " + endpoint.getName());
/*     */ 
/* 524 */     ServerEndpointMetaData epMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
/* 525 */     if (epMetaData == null) {
/* 526 */       throw new IllegalStateException("Cannot obtain endpoint meta data");
/*     */     }
/* 528 */     ServletRequestContext reqContext = (ServletRequestContext)context;
/* 529 */     HttpServletRequest req = reqContext.getHttpServletRequest();
/*     */     try
/*     */     {
/* 534 */       String resPath = req.getParameter("resource");
/* 535 */       URL reqURL = new URL(req.getRequestURL().toString());
/*     */ 
/* 537 */       String wsdlHost = reqURL.getProtocol() + "://" + reqURL.getHost();
/* 538 */       if (reqURL.getPort() != -1) {
/* 539 */         wsdlHost = wsdlHost + ":" + reqURL.getPort();
/*     */       }
/* 541 */       if (!"jbossws.undefined.host".equals(this.serverConfig.getWebServiceHost())) {
/* 542 */         wsdlHost = this.serverConfig.getWebServiceHost();
/*     */       }
/* 544 */       log.debug("WSDL request, using host: " + wsdlHost);
/*     */ 
/* 546 */       WSDLRequestHandler wsdlRequestHandler = new WSDLRequestHandler(epMetaData);
/* 547 */       Document document = wsdlRequestHandler.getDocumentForPath(reqURL, wsdlHost, resPath);
/*     */ 
/* 549 */       OutputStreamWriter writer = new OutputStreamWriter(outputStream);
/* 550 */       new DOMWriter(writer).setPrettyprint(true).print(document.getDocumentElement());
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 554 */       throw rte;
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 558 */       throw new WSException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleException(Exception ex) throws ServletException
/*     */   {
/* 564 */     log.error("Error processing web service request", ex);
/*     */ 
/* 566 */     if ((ex instanceof JAXRPCException)) {
/* 567 */       throw ((JAXRPCException)ex);
/*     */     }
/* 569 */     throw new ServletException(ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.stack.jbws.RequestHandlerImpl
 * JD-Core Version:    0.6.0
 */