/*    */ package org.jboss.xb;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.w3c.dom.Element;
/*    */ import org.w3c.dom.NamedNodeMap;
/*    */ import org.w3c.dom.Node;
/*    */ 
/*    */ public final class QNameBuilder
/*    */ {
/* 42 */   private static Logger log = Logger.getLogger(QNameBuilder.class);
/*    */ 
/*    */   public static QName buildQName(Element element, String combinedName)
/*    */   {
/* 52 */     if (combinedName == null) {
/* 53 */       return null;
/*    */     }
/* 55 */     int colonIndex = combinedName.indexOf(":");
/* 56 */     if (colonIndex < 0) {
/* 57 */       return new QName(combinedName);
/*    */     }
/* 59 */     String prefix = combinedName.substring(0, colonIndex);
/* 60 */     String localPart = combinedName.substring(colonIndex + 1);
/*    */ 
/* 62 */     Node currNode = element;
/* 63 */     String namespaceURI = getNamespaceURI(currNode, prefix);
/* 64 */     while ((namespaceURI == null) && (currNode != null))
/*    */     {
/* 66 */       Node parentNode = currNode.getParentNode();
/* 67 */       if ((parentNode != null) && (parentNode != currNode)) {
/* 68 */         namespaceURI = getNamespaceURI(parentNode, prefix);
/*    */       }
/* 70 */       if (parentNode == currNode) {
/*    */         break;
/*    */       }
/* 73 */       currNode = parentNode;
/*    */     }
/*    */ 
/* 76 */     if (namespaceURI != null) {
/* 77 */       return new QName(namespaceURI, localPart, prefix);
/*    */     }
/* 79 */     log.warn("Cannot find namespaceURI for name: " + combinedName);
/* 80 */     return new QName(localPart);
/*    */   }
/*    */ 
/*    */   private static String getNamespaceURI(Node node, String prefix)
/*    */   {
/* 88 */     String namespaceURI = null;
/* 89 */     NamedNodeMap attrs = node.getAttributes();
/* 90 */     if (attrs != null)
/*    */     {
/* 92 */       for (int i = 0; (namespaceURI == null) && (i < attrs.getLength()); i++)
/*    */       {
/* 94 */         Node attr = attrs.item(i);
/* 95 */         if (("xmlns:" + prefix).equals(attr.getNodeName()))
/* 96 */           namespaceURI = attr.getNodeValue();
/*    */       }
/*    */     }
/* 99 */     return namespaceURI;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.QNameBuilder
 * JD-Core Version:    0.6.0
 */