/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.introspection.FieldInfo;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public abstract class AbstractMarshaller
/*     */   implements Marshaller
/*     */ {
/*     */   protected final Logger log;
/*     */   protected String version;
/*     */   protected String encoding;
/*     */   protected List rootQNames;
/*     */   protected NamespaceRegistry nsRegistry;
/*     */   private Map classMappings;
/*     */   protected Map field2WildcardMap;
/*     */   protected Map cls2TypeMap;
/*     */   protected Content content;
/*     */   private Properties props;
/*     */ 
/*     */   public AbstractMarshaller()
/*     */   {
/*  48 */     this.log = Logger.getLogger(getClass());
/*     */ 
/*  50 */     this.version = "1.0";
/*  51 */     this.encoding = "UTF-8";
/*  52 */     this.rootQNames = new ArrayList();
/*     */ 
/*  54 */     this.nsRegistry = new NamespaceRegistry();
/*     */ 
/*  56 */     this.classMappings = Collections.EMPTY_MAP;
/*  57 */     this.field2WildcardMap = Collections.EMPTY_MAP;
/*  58 */     this.cls2TypeMap = Collections.EMPTY_MAP;
/*     */ 
/*  63 */     this.content = new Content();
/*     */   }
/*     */ 
/*     */   public void mapClassToGlobalElement(Class cls, String localName, String namespaceUri, String schemaUrl, ObjectModelProvider provider)
/*     */   {
/*  75 */     GenericObjectModelProvider delProv = null;
/*  76 */     if (provider != null)
/*     */     {
/*  78 */       delProv = (provider instanceof GenericObjectModelProvider) ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
/*     */     }
/*     */ 
/*  83 */     ClassMapping mapping = new ClassMapping(cls, localName, null, namespaceUri, schemaUrl, delProv);
/*     */ 
/*  91 */     addClassMapping(mapping);
/*     */   }
/*     */ 
/*     */   public void mapClassToGlobalType(Class cls, String localName, String nsUri, String schemaUrl, ObjectModelProvider provider)
/*     */   {
/* 100 */     ClassMapping mapping = new ClassMapping(cls, null, localName, nsUri, schemaUrl, (provider instanceof GenericObjectModelProvider) ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider));
/*     */ 
/* 110 */     addClassMapping(mapping);
/*     */   }
/*     */ 
/*     */   public void mapFieldToWildcard(Class cls, String field, ObjectLocalMarshaller marshaller)
/*     */   {
/* 115 */     FieldToWildcardMapping mapping = new FieldToWildcardMapping(cls, field, marshaller);
/* 116 */     switch (this.field2WildcardMap.size())
/*     */     {
/*     */     case 0:
/* 119 */       this.field2WildcardMap = Collections.singletonMap(cls, mapping);
/* 120 */       break;
/*     */     case 1:
/* 122 */       this.field2WildcardMap = new HashMap(this.field2WildcardMap);
/*     */     default:
/* 124 */       this.field2WildcardMap.put(cls, mapping);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void mapClassToXsiType(Class cls, String typeNs, String typeLocalPart)
/*     */   {
/* 130 */     QName typeQName = new QName(typeNs, typeLocalPart);
/* 131 */     switch (this.cls2TypeMap.size())
/*     */     {
/*     */     case 0:
/* 134 */       this.cls2TypeMap = Collections.singletonMap(cls, typeQName);
/* 135 */       break;
/*     */     case 1:
/* 137 */       this.cls2TypeMap = new HashMap(this.cls2TypeMap);
/*     */     default:
/* 139 */       this.cls2TypeMap.put(cls, typeQName);
/*     */     }
/*     */ 
/* 142 */     if (this.log.isTraceEnabled())
/*     */     {
/* 144 */       this.log.trace("mapped " + cls + " to xsi:type " + typeQName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setVersion(String version)
/*     */   {
/* 150 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public void setEncoding(String encoding)
/*     */   {
/* 155 */     this.encoding = encoding;
/*     */   }
/*     */ 
/*     */   public void mapPublicIdToSystemId(String publicId, String systemId)
/*     */   {
/* 160 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void addRootElement(String namespaceUri, String prefix, String name)
/*     */   {
/* 165 */     addRootElement(new QName(namespaceUri, name, prefix));
/*     */   }
/*     */ 
/*     */   public void addRootElement(QName qName)
/*     */   {
/* 170 */     this.rootQNames.add(qName);
/*     */   }
/*     */ 
/*     */   public void setProperty(String name, String value)
/*     */   {
/* 175 */     if (this.props == null)
/*     */     {
/* 177 */       this.props = new Properties();
/*     */     }
/* 179 */     this.props.setProperty(name, value);
/*     */   }
/*     */ 
/*     */   public String getProperty(String name)
/*     */   {
/* 184 */     return this.props == null ? null : this.props.getProperty(name);
/*     */   }
/*     */ 
/*     */   public void declareNamespace(String prefix, String uri)
/*     */   {
/* 199 */     if (prefix == null)
/*     */     {
/* 201 */       return;
/*     */     }
/*     */ 
/* 204 */     this.nsRegistry.addPrefixMapping(prefix, uri);
/*     */   }
/*     */ 
/*     */   public void removePrefixMapping(String prefix)
/*     */   {
/* 209 */     this.nsRegistry.removePrefixMapping(prefix);
/*     */   }
/*     */ 
/*     */   public String getPrefix(String ns)
/*     */   {
/* 214 */     String prefix = this.nsRegistry.getPrefix(ns);
/* 215 */     if ((prefix == null) && ("http://www.w3.org/XML/1998/namespace".equals(ns)))
/*     */     {
/* 217 */       prefix = "xml";
/*     */     }
/* 219 */     return prefix;
/*     */   }
/*     */ 
/*     */   protected void declareNs(AttributesImpl attrs)
/*     */   {
/* 224 */     for (Iterator i = this.nsRegistry.getRegisteredURIs(); i.hasNext(); )
/*     */     {
/* 226 */       String uri = (String)i.next();
/* 227 */       String prefix = this.nsRegistry.getPrefix(uri);
/* 228 */       declareNs(attrs, prefix, uri);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static void declareNs(AttributesImpl attrs, String prefix, String ns)
/*     */   {
/* 234 */     attrs.add(null, prefix, "xmlns:" + prefix, "CDATA", ns);
/*     */   }
/*     */ 
/*     */   protected String declareXsiType(QName typeQName, AttributesImpl attrs)
/*     */   {
/* 246 */     String result = null;
/* 247 */     String xsiPrefix = this.nsRegistry.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
/* 248 */     if (xsiPrefix == null)
/*     */     {
/* 250 */       declareNs(attrs, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
/* 251 */       xsiPrefix = "xsi";
/*     */     }
/*     */ 
/* 254 */     String pref = getPrefix(typeQName.getNamespaceURI());
/* 255 */     if (pref == null)
/*     */     {
/* 258 */       result = pref = typeQName.getLocalPart() + "_ns";
/*     */     }
/*     */ 
/* 261 */     String qName = prefixLocalName(pref, typeQName.getLocalPart());
/* 262 */     attrs.add("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix + ":type", "CDATA", qName);
/* 263 */     return result;
/*     */   }
/*     */ 
/*     */   protected static String prefixLocalName(String prefix, String local)
/*     */   {
/* 268 */     return prefix + ':' + local;
/*     */   }
/*     */ 
/*     */   public abstract void addAttribute(String paramString1, String paramString2, String paramString3, String paramString4);
/*     */ 
/*     */   protected boolean propertyIsTrueOrNotSet(String name)
/*     */   {
/* 277 */     String value = getProperty(name);
/* 278 */     return (value == null) || ("true".equalsIgnoreCase(value));
/*     */   }
/*     */ 
/*     */   protected void writeXmlVersion(Writer writer) throws IOException
/*     */   {
/* 283 */     String xmlVersion = getProperty("org.jboss.xml.binding.marshalling.version");
/* 284 */     if ((xmlVersion == null) || ("true".equalsIgnoreCase(xmlVersion)))
/*     */     {
/* 286 */       writer.write("<?xml version=\"");
/* 287 */       writer.write(this.version);
/* 288 */       writer.write("\" encoding=\"");
/* 289 */       writer.write(this.encoding);
/* 290 */       writer.write("\"?>\n");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ClassMapping getClassMapping(Class cls)
/*     */   {
/* 296 */     return (ClassMapping)this.classMappings.get(cls);
/*     */   }
/*     */ 
/*     */   private void addClassMapping(ClassMapping mapping)
/*     */   {
/* 301 */     if (this.classMappings == Collections.EMPTY_MAP)
/*     */     {
/* 303 */       this.classMappings = new HashMap();
/*     */     }
/* 305 */     this.classMappings.put(mapping.cls, mapping);
/*     */   }
/*     */ 
/*     */   public class ContentHandlerAdaptor
/*     */     implements ContentHandler
/*     */   {
/*     */     public ContentHandlerAdaptor()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setDocumentLocator(Locator locator)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void startDocument()
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void endDocument()
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void startPrefixMapping(String prefix, String uri)
/*     */       throws SAXException
/*     */     {
/* 514 */       AbstractMarshaller.this.content.startPrefixMapping(prefix, uri);
/*     */     }
/*     */ 
/*     */     public void endPrefixMapping(String prefix) throws SAXException
/*     */     {
/* 519 */       AbstractMarshaller.this.content.endPrefixMapping(prefix);
/*     */     }
/*     */ 
/*     */     public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException
/*     */     {
/* 524 */       AbstractMarshaller.this.content.startElement(uri, localName, qName, atts);
/*     */     }
/*     */ 
/*     */     public void endElement(String uri, String localName, String qName) throws SAXException
/*     */     {
/* 529 */       AbstractMarshaller.this.content.endElement(uri, localName, qName);
/*     */     }
/*     */ 
/*     */     public void characters(char[] ch, int start, int length) throws SAXException
/*     */     {
/* 534 */       AbstractMarshaller.this.content.characters(ch, start, length);
/*     */     }
/*     */ 
/*     */     public void ignorableWhitespace(char[] ch, int start, int length)
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void processingInstruction(String target, String data)
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void skippedEntity(String name)
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class StackImpl
/*     */     implements AbstractMarshaller.Stack
/*     */   {
/* 467 */     private List list = new ArrayList();
/*     */ 
/*     */     public void clear()
/*     */     {
/* 471 */       this.list.clear();
/*     */     }
/*     */ 
/*     */     public void push(Object o)
/*     */     {
/* 476 */       this.list.add(o);
/*     */     }
/*     */ 
/*     */     public Object pop()
/*     */     {
/* 481 */       return this.list.remove(this.list.size() - 1);
/*     */     }
/*     */ 
/*     */     public Object peek()
/*     */     {
/* 486 */       return this.list.get(this.list.size() - 1);
/*     */     }
/*     */ 
/*     */     public boolean isEmpty()
/*     */     {
/* 491 */       return this.list.isEmpty();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static abstract interface Stack
/*     */   {
/*     */     public abstract void clear();
/*     */ 
/*     */     public abstract void push(Object paramObject);
/*     */ 
/*     */     public abstract Object pop();
/*     */ 
/*     */     public abstract Object peek();
/*     */ 
/*     */     public abstract boolean isEmpty();
/*     */   }
/*     */ 
/*     */   protected class FieldToWildcardMapping
/*     */   {
/*     */     public final Class cls;
/*     */     public final ObjectLocalMarshaller marshaller;
/*     */     public final FieldInfo fieldInfo;
/*     */ 
/*     */     public FieldToWildcardMapping(Class cls, String field, ObjectLocalMarshaller marshaller)
/*     */     {
/* 402 */       if (AbstractMarshaller.this.log.isTraceEnabled())
/*     */       {
/* 404 */         AbstractMarshaller.this.log.trace("new FieldToWildcardMapping: [cls=" + cls.getName() + ",field=" + field + "]");
/*     */       }
/*     */ 
/* 412 */       this.cls = cls;
/* 413 */       this.marshaller = marshaller;
/* 414 */       this.fieldInfo = FieldInfo.getFieldInfo(cls, field, true);
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 419 */       if (this == o)
/*     */       {
/* 421 */         return true;
/*     */       }
/* 423 */       if (!(o instanceof FieldToWildcardMapping))
/*     */       {
/* 425 */         return false;
/*     */       }
/*     */ 
/* 428 */       FieldToWildcardMapping fieldToWildcardMapping = (FieldToWildcardMapping)o;
/*     */ 
/* 430 */       if (!this.cls.equals(fieldToWildcardMapping.cls))
/*     */       {
/* 432 */         return false;
/*     */       }
/*     */ 
/* 436 */       return this.fieldInfo.getName().equals(fieldToWildcardMapping.fieldInfo.getName());
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 445 */       int result = this.cls.hashCode();
/* 446 */       result = 29 * result + this.fieldInfo.getName().hashCode();
/* 447 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class ClassMapping
/*     */   {
/*     */     public final Class cls;
/*     */     public final QName elementName;
/*     */     public final QName typeName;
/*     */     public final String schemaUrl;
/*     */     public final GenericObjectModelProvider provider;
/*     */ 
/*     */     public ClassMapping(Class cls, String elementName, String typeName, String nsUri, String schemaUrl, GenericObjectModelProvider provider)
/*     */     {
/* 325 */       this.cls = cls;
/* 326 */       if (elementName != null)
/*     */       {
/* 328 */         this.elementName = (nsUri == null ? new QName(elementName) : new QName(nsUri, elementName));
/* 329 */         this.typeName = null;
/*     */       }
/* 331 */       else if (typeName != null)
/*     */       {
/* 333 */         this.elementName = null;
/* 334 */         this.typeName = (nsUri == null ? new QName(typeName) : new QName(nsUri, typeName));
/*     */       }
/*     */       else
/*     */       {
/* 338 */         throw new JBossXBRuntimeException("Element or type name must not null for " + cls);
/*     */       }
/*     */ 
/* 341 */       this.schemaUrl = schemaUrl;
/* 342 */       this.provider = provider;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 347 */       if (this == o)
/*     */       {
/* 349 */         return true;
/*     */       }
/* 351 */       if ((o == null) || (getClass() != o.getClass()))
/*     */       {
/* 353 */         return false;
/*     */       }
/*     */ 
/* 356 */       ClassMapping that = (ClassMapping)o;
/*     */ 
/* 358 */       if (this.cls != null ? !this.cls.equals(that.cls) : that.cls != null)
/*     */       {
/* 360 */         return false;
/*     */       }
/* 362 */       if (this.elementName != null ? !this.elementName.equals(that.elementName) : that.elementName != null)
/*     */       {
/* 364 */         return false;
/*     */       }
/* 366 */       if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null)
/*     */       {
/* 368 */         return false;
/*     */       }
/* 370 */       if (this.schemaUrl != null ? !this.schemaUrl.equals(that.schemaUrl) : that.schemaUrl != null)
/*     */       {
/* 372 */         return false;
/*     */       }
/*     */ 
/* 376 */       return this.typeName != null ? this.typeName.equals(that.typeName) : that.typeName == null;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 385 */       int result = this.cls != null ? this.cls.hashCode() : 0;
/* 386 */       result = 29 * result + (this.elementName != null ? this.elementName.hashCode() : 0);
/* 387 */       result = 29 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
/* 388 */       result = 29 * result + (this.schemaUrl != null ? this.schemaUrl.hashCode() : 0);
/* 389 */       result = 29 * result + (this.provider != null ? this.provider.hashCode() : 0);
/* 390 */       return result;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.AbstractMarshaller
 * JD-Core Version:    0.6.0
 */