/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class AttributesImpl
/*     */   implements Attributes
/*     */ {
/*     */   private final List attrList;
/*     */ 
/*     */   public AttributesImpl(Attributes attrs)
/*     */   {
/*  42 */     this(attrs == null ? 0 : attrs.getLength());
/*     */ 
/*  44 */     if (attrs != null)
/*     */     {
/*  46 */       for (int i = 0; i < attrs.getLength(); i++)
/*     */       {
/*  48 */         add(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttributesImpl(int size)
/*     */   {
/*  61 */     this.attrList = new ArrayList(size);
/*     */   }
/*     */ 
/*     */   public void add(String namespaceUri, String localName, String qName, String type, String value)
/*     */   {
/*  66 */     this.attrList.add(new AttributeImpl(namespaceUri, localName, qName, type, value));
/*     */   }
/*     */ 
/*     */   public void addAll(Attributes attrs)
/*     */   {
/*  71 */     for (int i = 0; i < attrs.getLength(); i++)
/*     */     {
/*  73 */       add(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getLength()
/*     */   {
/*  81 */     return this.attrList.size();
/*     */   }
/*     */ 
/*     */   public String getURI(int index)
/*     */   {
/*  86 */     return getAttribute(index).namespaceUri;
/*     */   }
/*     */ 
/*     */   public String getLocalName(int index)
/*     */   {
/*  91 */     return getAttribute(index).localName;
/*     */   }
/*     */ 
/*     */   public String getQName(int index)
/*     */   {
/*  96 */     return getAttribute(index).qName;
/*     */   }
/*     */ 
/*     */   public String getType(int index)
/*     */   {
/* 101 */     return getAttribute(index).type;
/*     */   }
/*     */ 
/*     */   public String getValue(int index)
/*     */   {
/* 106 */     return getAttribute(index).value;
/*     */   }
/*     */ 
/*     */   public int getIndex(String uri, String localName)
/*     */   {
/* 111 */     int i = 0;
/* 112 */     while (i < this.attrList.size())
/*     */     {
/* 114 */       AttributeImpl attr = getAttribute(i++);
/* 115 */       if ((attr.namespaceUri == null ? uri == null : attr.namespaceUri.equals(uri)) && (attr.localName == null ? localName == null : attr.localName.equals(localName)))
/*     */       {
/*     */         break;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 124 */     if (i == this.attrList.size()) {
/* 125 */       return -1;
/*     */     }
/* 127 */     return i;
/*     */   }
/*     */ 
/*     */   public int getIndex(String qName)
/*     */   {
/* 132 */     int i = 0;
/* 133 */     while (i < this.attrList.size())
/*     */     {
/* 135 */       AttributeImpl attr = getAttribute(i++);
/* 136 */       if (attr.qName.equals(qName))
/*     */       {
/*     */         break;
/*     */       }
/*     */     }
/*     */ 
/* 142 */     if (i == this.attrList.size()) {
/* 143 */       return -1;
/*     */     }
/* 145 */     return i;
/*     */   }
/*     */ 
/*     */   public String getType(String uri, String localName)
/*     */   {
/* 150 */     AttributeImpl attr = null;
/* 151 */     int i = 0;
/* 152 */     while (i < this.attrList.size())
/*     */     {
/* 154 */       attr = getAttribute(i++);
/* 155 */       if (attr.namespaceUri == null ? uri != null : !attr.namespaceUri.equals(uri)) continue; if (attr.localName == null) if (localName != null) continue; else if (!attr.localName.equals(localName))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/*     */ 
/*     */     }
/*     */ 
/* 164 */     if (attr == null) {
/* 165 */       return null;
/*     */     }
/* 167 */     return attr.type;
/*     */   }
/*     */ 
/*     */   public String getType(String qName)
/*     */   {
/* 172 */     AttributeImpl attr = null;
/* 173 */     int i = 0;
/* 174 */     while (i < this.attrList.size())
/*     */     {
/* 176 */       attr = getAttribute(i++);
/* 177 */       if (!attr.qName.equals(qName))
/*     */       {
/*     */         continue;
/*     */       }
/*     */     }
/*     */ 
/* 183 */     if (attr == null) {
/* 184 */       return null;
/*     */     }
/* 186 */     return attr.type;
/*     */   }
/*     */ 
/*     */   public String getValue(String uri, String localName)
/*     */   {
/* 191 */     AttributeImpl attr = null;
/* 192 */     int i = 0;
/* 193 */     while (i < this.attrList.size())
/*     */     {
/* 195 */       attr = getAttribute(i++);
/* 196 */       if (attr.namespaceUri == null ? uri != null : !attr.namespaceUri.equals(uri)) continue; if (attr.localName == null) if (localName != null) continue; else if (!attr.localName.equals(localName))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/*     */ 
/*     */     }
/*     */ 
/* 205 */     if (attr == null) {
/* 206 */       return null;
/*     */     }
/* 208 */     return attr.value;
/*     */   }
/*     */ 
/*     */   public String getValue(String qName)
/*     */   {
/* 213 */     AttributeImpl attr = null;
/* 214 */     int i = 0;
/* 215 */     while (i < this.attrList.size())
/*     */     {
/* 217 */       attr = getAttribute(i++);
/* 218 */       if (!attr.qName.equals(qName))
/*     */       {
/*     */         continue;
/*     */       }
/*     */     }
/*     */ 
/* 224 */     if (attr == null) {
/* 225 */       return null;
/*     */     }
/* 227 */     return attr.value;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*     */     String result;
/*     */     String result;
/* 235 */     if (this.attrList.isEmpty())
/*     */     {
/* 237 */       result = "[]";
/*     */     }
/*     */     else
/*     */     {
/* 241 */       StringBuffer sb = new StringBuffer();
/* 242 */       sb.append('[');
/* 243 */       sb.append(getQName(0)).append('=').append(getValue(0));
/* 244 */       for (int i = 1; i < this.attrList.size(); i++)
/*     */       {
/* 246 */         sb.append(", ").append(getQName(i)).append('=').append(getValue(i));
/*     */       }
/* 248 */       sb.append(']');
/* 249 */       result = sb.toString();
/*     */     }
/* 251 */     return result;
/*     */   }
/*     */ 
/*     */   private AttributeImpl getAttribute(int index)
/*     */   {
/* 258 */     return (AttributeImpl)this.attrList.get(index);
/*     */   }
/*     */   private static final class AttributeImpl {
/*     */     public final String namespaceUri;
/*     */     public final String localName;
/*     */     public final String qName;
/*     */     public final String type;
/*     */     public final String value;
/*     */ 
/*     */     public AttributeImpl(String namespaceUri, String localName, String qName, String type, String value) {
/* 273 */       this.namespaceUri = namespaceUri;
/* 274 */       this.localName = localName;
/* 275 */       this.qName = qName;
/* 276 */       this.type = type;
/* 277 */       this.value = value;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 282 */       if (this == o) return true;
/* 283 */       if (!(o instanceof AttributeImpl)) return false;
/*     */ 
/* 285 */       AttributeImpl attribute = (AttributeImpl)o;
/*     */ 
/* 287 */       if (this.localName != null ? !this.localName.equals(attribute.localName) : attribute.localName != null) return false;
/* 288 */       if (this.namespaceUri != null ? !this.namespaceUri.equals(attribute.namespaceUri) : attribute.namespaceUri != null) return false;
/* 289 */       if (this.qName != null ? !this.qName.equals(attribute.qName) : attribute.qName != null) return false;
/* 290 */       if (this.type != null ? !this.type.equals(attribute.type) : attribute.type != null) return false;
/* 291 */       return this.value != null ? this.value.equals(attribute.value) : attribute.value == null;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 299 */       int result = this.namespaceUri != null ? this.namespaceUri.hashCode() : 0;
/* 300 */       result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
/* 301 */       result = 29 * result + (this.qName != null ? this.qName.hashCode() : 0);
/* 302 */       result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
/* 303 */       result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
/* 304 */       return result;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.AttributesImpl
 * JD-Core Version:    0.6.0
 */