/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.io.StringWriter;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class Content
/*     */ {
/*  45 */   private static Logger log = Logger.getLogger(Content.class);
/*     */   private List content;
/*     */   private final boolean trace;
/*     */   private int index;
/*     */ 
/*     */   public Content()
/*     */   {
/*  47 */     this.content = new ArrayList();
/*  48 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public String getChildContent(String namespaceURI, String qName)
/*     */   {
/*  54 */     StartElement current = (StartElement)this.content.get(this.index);
/*     */ 
/*  56 */     boolean lookingForStart = true;
/*  57 */     StartElement start = null;
/*  58 */     boolean childFound = false;
/*  59 */     StringBuffer value = new StringBuffer();
/*     */ 
/*  61 */     int i = this.index + 1;
/*  62 */     Object next = this.content.get(i++);
/*  63 */     while (!current.isMyEnd(next))
/*     */     {
/*  65 */       if (lookingForStart)
/*     */       {
/*  67 */         if ((next instanceof StartElement))
/*     */         {
/*  69 */           start = (StartElement)next;
/*  70 */           lookingForStart = false;
/*     */ 
/*  72 */           if ((qName.equals(start.qName)) && (namespaceURI == null ? start.namespaceURI == null : namespaceURI.equals(start.namespaceURI)))
/*     */           {
/*  75 */             childFound = true;
/*     */           }
/*     */         }
/*     */       }
/*  79 */       else if ((next instanceof EndElement))
/*     */       {
/*  81 */         if (start.isMyEnd(next))
/*     */         {
/*  83 */           if (childFound)
/*     */           {
/*     */             break;
/*     */           }
/*     */ 
/*  89 */           lookingForStart = true;
/*     */         }
/*     */ 
/*     */       }
/*  93 */       else if ((childFound) && ((next instanceof Characters)))
/*     */       {
/*  95 */         Characters chars = (Characters)next;
/*  96 */         value.append(chars.ch, chars.start, chars.length);
/*     */       }
/*  98 */       next = this.content.get(i++);
/*     */     }
/* 100 */     return value.toString().trim();
/*     */   }
/*     */ 
/*     */   public void handleContent(ContentHandler handler) throws SAXException
/*     */   {
/* 105 */     handler.startDocument();
/*     */ 
/* 107 */     for (Iterator i = this.content.iterator(); i.hasNext(); )
/*     */     {
/* 109 */       Object item = i.next();
/* 110 */       if ((item instanceof StartElement))
/*     */       {
/* 112 */         StartElement start = (StartElement)item;
/* 113 */         handler.startElement(start.namespaceURI, start.localName, start.qName, start.attrs);
/*     */       }
/* 115 */       else if ((item instanceof EndElement))
/*     */       {
/* 117 */         EndElement end = (EndElement)item;
/* 118 */         handler.endElement(end.namespaceURI, end.localName, end.qName);
/*     */       }
/* 120 */       else if ((item instanceof Characters))
/*     */       {
/* 122 */         Characters ch = (Characters)item;
/* 123 */         handler.characters(ch.ch, ch.start, ch.length);
/*     */       }
/* 125 */       else if (!(item instanceof StartPrefixMapping))
/*     */       {
/* 135 */         if (!(item instanceof EndPrefixMapping))
/*     */         {
/* 147 */           throw new IllegalStateException("Unexpected element type: " + item);
/*     */         }
/*     */       }
/*     */     }
/* 151 */     handler.endDocument();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 156 */     StringWriter writer = new StringWriter();
/*     */     try
/*     */     {
/* 159 */       ContentWriter contentWriter = new ContentWriter(writer, true);
/* 160 */       handleContent(contentWriter);
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/* 164 */       writer.write(e.getMessage());
/*     */     }
/* 166 */     return writer.getBuffer().toString();
/*     */   }
/*     */ 
/*     */   public void startDocument()
/*     */   {
/* 173 */     this.content.clear();
/*     */   }
/*     */ 
/*     */   public void endDocument()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startPrefixMapping(String prefix, String uri)
/*     */   {
/* 182 */     StartPrefixMapping node = new StartPrefixMapping(prefix, uri);
/* 183 */     this.content.add(node);
/*     */   }
/*     */ 
/*     */   public void endPrefixMapping(String prefix)
/*     */   {
/* 188 */     EndPrefixMapping node = new EndPrefixMapping(prefix);
/* 189 */     this.content.add(node);
/*     */   }
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */   {
/* 194 */     StartElement startElement = new StartElement(namespaceURI, localName, qName, atts);
/* 195 */     this.content.add(startElement);
/*     */ 
/* 197 */     if (this.trace)
/*     */     {
/* 199 */       log.trace("startElement> uri=" + namespaceURI + ", local=" + localName + ", qn=" + qName + ", attrs=" + atts);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */   {
/* 205 */     EndElement endElement = new EndElement(namespaceURI, localName, qName);
/* 206 */     this.content.add(endElement);
/*     */ 
/* 208 */     if (this.trace)
/*     */     {
/* 210 */       log.trace("endElement> uri=" + namespaceURI + ", local=" + localName + ", qn=" + qName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */   {
/* 216 */     Characters characters = new Characters(ch, start, length);
/*     */ 
/* 220 */     this.content.add(characters);
/*     */ 
/* 222 */     if (this.trace)
/*     */     {
/* 224 */       log.trace("characters> " + characters);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void append(Content content)
/*     */   {
/* 235 */     for (Iterator i = content.content.iterator(); i.hasNext(); )
/*     */     {
/* 237 */       this.content.add(i.next());
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class EndPrefixMapping
/*     */     implements Content.Node
/*     */   {
/*     */     public final String prefix;
/*     */ 
/*     */     public EndPrefixMapping(String prefix)
/*     */     {
/* 385 */       this.prefix = prefix;
/*     */     }
/*     */ 
/*     */     public void read(ObjectModelBuilder builder)
/*     */     {
/* 390 */       builder.endPrefixMapping(this.prefix);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class StartPrefixMapping
/*     */     implements Content.Node
/*     */   {
/*     */     public final String prefix;
/*     */     public final String uri;
/*     */ 
/*     */     public StartPrefixMapping(String prefix, String uri)
/*     */     {
/* 335 */       this.prefix = prefix;
/* 336 */       this.uri = uri;
/*     */     }
/*     */ 
/*     */     public void read(ObjectModelBuilder builder)
/*     */     {
/* 341 */       builder.startPrefixMapping(this.prefix, this.uri);
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 346 */       if (this == o)
/*     */       {
/* 348 */         return true;
/*     */       }
/* 350 */       if (!(o instanceof StartPrefixMapping))
/*     */       {
/* 352 */         return false;
/*     */       }
/*     */ 
/* 355 */       StartPrefixMapping startPrefixMapping = (StartPrefixMapping)o;
/*     */ 
/* 357 */       if (this.prefix != null ? !this.prefix.equals(startPrefixMapping.prefix) : startPrefixMapping.prefix != null)
/*     */       {
/* 359 */         return false;
/*     */       }
/*     */ 
/* 363 */       return this.uri != null ? this.uri.equals(startPrefixMapping.uri) : startPrefixMapping.uri == null;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 372 */       int result = this.prefix != null ? this.prefix.hashCode() : 0;
/* 373 */       result = 29 * result + (this.uri != null ? this.uri.hashCode() : 0);
/* 374 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class StartElement
/*     */     implements Content.Node
/*     */   {
/*     */     private final String namespaceURI;
/*     */     private final String localName;
/*     */     private final String qName;
/*     */     private final Attributes attrs;
/*     */ 
/*     */     public StartElement(String namespaceURI, String localName, String qName, Attributes attrs)
/*     */     {
/* 303 */       this.namespaceURI = namespaceURI;
/* 304 */       this.localName = localName;
/* 305 */       this.qName = qName;
/* 306 */       this.attrs = new AttributesImpl(attrs);
/*     */     }
/*     */ 
/*     */     public boolean isMyEnd(Object element)
/*     */     {
/* 311 */       boolean itis = false;
/* 312 */       if ((element instanceof Content.EndElement))
/*     */       {
/* 314 */         Content.EndElement end = (Content.EndElement)element;
/* 315 */         itis = (this.namespaceURI == null ? Content.EndElement.access$700(end) == null : this.namespaceURI.equals(Content.EndElement.access$700(end))) && (this.qName.equals(Content.EndElement.access$900(end)));
/*     */       }
/*     */ 
/* 318 */       return itis;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 323 */       return '[' + this.namespaceURI + ',' + this.localName + ',' + this.qName + ']';
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class EndElement
/*     */     implements Content.Node
/*     */   {
/*     */     private final String namespaceURI;
/*     */     private final String localName;
/*     */     private final String qName;
/*     */ 
/*     */     public EndElement(String namespaceURI, String localName, String qName)
/*     */     {
/* 282 */       this.namespaceURI = namespaceURI;
/* 283 */       this.localName = localName;
/* 284 */       this.qName = qName;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 289 */       return '[' + this.namespaceURI + ',' + this.localName + ',' + this.qName + ']';
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Characters
/*     */     implements Content.Node
/*     */   {
/*     */     private final char[] ch;
/*     */     private final int start;
/*     */     private final int length;
/*     */ 
/*     */     public Characters(char[] ch, int start, int length)
/*     */     {
/* 261 */       this.ch = new char[length];
/* 262 */       System.arraycopy(ch, start, this.ch, 0, length);
/* 263 */       this.start = 0;
/* 264 */       this.length = length;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 269 */       return String.valueOf(this.ch, this.start, this.length);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract interface Node
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.Content
 * JD-Core Version:    0.6.0
 */