/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.jboss.xb.binding.introspection.FieldInfo;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class MappingObjectModelFactory
/*     */   implements GenericObjectModelFactory
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(MappingObjectModelFactory.class);
/*     */   private final Map elementToClassMapping;
/*     */   private final Map elementToFieldMapping;
/*     */ 
/*     */   public MappingObjectModelFactory()
/*     */   {
/*  51 */     this.elementToClassMapping = new HashMap();
/*     */ 
/*  56 */     this.elementToFieldMapping = new HashMap();
/*     */   }
/*     */ 
/*     */   public void mapElementToClass(String element, Class cls)
/*     */   {
/*  68 */     ElementToClassMapping mapping = new ElementToClassMapping(element, cls);
/*  69 */     addElementToClassMapping(mapping);
/*  70 */     if (log.isTraceEnabled())
/*     */     {
/*  72 */       log.trace(mapping);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void mapElementToField(String element, Class cls, String field, TypeBinding converter)
/*     */   {
/*  86 */     ElementToFieldMapping mapping = new ElementToFieldMapping(element, cls, field, converter);
/*  87 */     addElementToFieldMapping(mapping);
/*  88 */     if (log.isTraceEnabled())
/*     */     {
/*  90 */       log.trace(mapping);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 102 */     if (log.isTraceEnabled())
/*     */     {
/* 104 */       log.trace("newRoot root=" + root + " namespaceURI=" + namespaceURI + " localName=" + localName + " attributes=" + attrs);
/*     */     }
/*     */ 
/* 115 */     if (root == null)
/*     */     {
/* 117 */       ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
/* 118 */       if (mapping != null)
/*     */       {
/* 120 */         if (log.isTraceEnabled())
/*     */         {
/* 122 */           log.trace("creating root using " + mapping);
/*     */         }
/* 124 */         root = newInstance(mapping.cls);
/*     */       }
/*     */       else
/*     */       {
/* 128 */         root = create(namespaceURI, localName, ctx.getType());
/*     */       }
/*     */ 
/* 131 */       if (root == null)
/*     */       {
/* 133 */         throw new IllegalStateException("Failed to resolve Java type binding for root element: ns=" + namespaceURI + ", local=" + localName);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 139 */     if (attrs != null)
/*     */     {
/* 141 */       for (int i = 0; i < attrs.getLength(); i++)
/*     */       {
/*     */         try
/*     */         {
/* 145 */           if (attrs.getLocalName(i).length() > 0)
/*     */           {
/* 147 */             if (!attrs.getQName(i).startsWith("xsi:"))
/*     */             {
/* 149 */               setAttribute(root, attrs.getLocalName(i), attrs.getValue(i), ctx);
/*     */             }
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 155 */           String msg = "Failed to set attribute " + attrs.getQName(i) + "=" + attrs.getValue(i);
/* 156 */           log.error(msg, e);
/* 157 */           throw new IllegalStateException(msg + ": " + e.getMessage());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 162 */     return root;
/*     */   }
/*     */ 
/*     */   public Object newChild(Object o, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 173 */     if (log.isTraceEnabled())
/*     */     {
/* 175 */       log.trace("newChild object=" + o + " namespaceURI=" + namespaceURI + " localName=" + localName + " attributes=" + attrs);
/*     */     }
/*     */ 
/* 186 */     if (o == null)
/*     */     {
/* 188 */       throw new RuntimeException("Attempt to add a new child to a null parent localName=" + localName);
/*     */     }
/*     */ 
/* 191 */     Object child = null;
/*     */ 
/* 193 */     ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
/* 194 */     XSTypeDefinition type = ctx.getType();
/* 195 */     if (mapping != null)
/*     */     {
/* 197 */       if (log.isTraceEnabled())
/*     */       {
/* 199 */         log.trace("newChild using mapping " + mapping);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 204 */         if (!(o instanceof Collection))
/*     */         {
/* 206 */           ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
/*     */           FieldInfo fieldInfo;
/*     */           FieldInfo fieldInfo;
/* 211 */           if (fieldMapping != null)
/*     */           {
/* 213 */             fieldInfo = fieldMapping.fieldInfo;
/*     */           }
/*     */           else
/*     */           {
/* 217 */             String fieldName = Util.xmlNameToFieldName(localName, true);
/* 218 */             fieldInfo = FieldInfo.getFieldInfo(o.getClass(), fieldName, true);
/*     */           }
/*     */ 
/* 221 */           child = get(o, localName, fieldInfo);
/*     */         }
/*     */ 
/* 224 */         if (child == null)
/*     */         {
/* 226 */           child = newInstance(mapping.cls);
/*     */         }
/*     */ 
/* 229 */         if (attrs != null)
/*     */         {
/* 231 */           for (int i = 0; i < attrs.getLength(); i++)
/*     */           {
/* 233 */             if (attrs.getLocalName(i).length() <= 0)
/*     */               continue;
/* 235 */             if (attrs.getQName(i).startsWith("xsi:"))
/*     */               continue;
/* 237 */             setAttribute(child, attrs.getLocalName(i), attrs.getValue(i), ctx);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 245 */         throw e;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 249 */         throw new NestedRuntimeException("newChild failed for o=" + o + ", uri=" + namespaceURI + ", local=" + localName + ", attrs=" + attrs, e);
/*     */       }
/*     */ 
/*     */     }
/* 260 */     else if ((o instanceof Collection))
/*     */     {
/* 262 */       child = create(namespaceURI, localName, type);
/*     */     }
/*     */     else
/*     */     {
/*     */       Class oCls;
/*     */       Class oCls;
/* 267 */       if ((o instanceof Immutable))
/*     */       {
/* 269 */         oCls = ((Immutable)o).cls;
/*     */       }
/*     */       else
/*     */       {
/* 273 */         oCls = o.getClass();
/*     */       }
/*     */ 
/* 276 */       String fieldName = Util.xmlNameToFieldName(localName, true);
/* 277 */       FieldInfo fieldInfo = FieldInfo.getFieldInfo(oCls, fieldName, true);
/* 278 */       if (Collection.class.isAssignableFrom(fieldInfo.getType()))
/*     */       {
/* 280 */         child = get(o, localName, fieldInfo);
/*     */ 
/* 284 */         Object item = null;
/* 285 */         if ((type == null) || ((type != null) && (type.getTypeCategory() == 15)))
/*     */         {
/* 287 */           item = create(namespaceURI, localName, type);
/*     */         }
/*     */ 
/* 290 */         if (item != null)
/*     */         {
/* 292 */           if (child == null)
/*     */           {
/* 294 */             setChild(new ArrayList(), o, localName);
/*     */           }
/* 296 */           child = item;
/*     */         }
/* 300 */         else if (child == null)
/*     */         {
/* 302 */           child = new ArrayList();
/*     */         }
/*     */ 
/*     */       }
/* 306 */       else if (!Util.isAttributeType(fieldInfo.getType()))
/*     */       {
/* 309 */         ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
/*     */ 
/* 312 */         TypeBinding converter = fieldMapping == null ? null : fieldMapping.converter;
/*     */ 
/* 315 */         if (converter == null)
/*     */         {
/* 317 */           child = newInstance(fieldInfo.getType());
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 323 */     return child;
/*     */   }
/*     */ 
/*     */   public void addChild(Object parent, Object child, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/* 332 */     if (log.isTraceEnabled())
/*     */     {
/* 334 */       log.trace("addChild parent=" + parent + " child=" + child + " namespaceURI=" + namespaceURI + " localName=" + localName);
/*     */     }
/*     */ 
/* 345 */     if ((child instanceof Immutable))
/*     */     {
/* 347 */       child = ((Immutable)child).newInstance();
/*     */     }
/* 349 */     setChild(child, parent, localName);
/*     */   }
/*     */ 
/*     */   public void setValue(Object o, UnmarshallingContext ctx, String namespaceURI, String localName, String value)
/*     */   {
/* 354 */     if (log.isTraceEnabled())
/*     */     {
/* 356 */       log.trace("setValue object=" + o + " ctx=" + ctx + " namespaceURI=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */ 
/* 369 */     setAttribute(o, localName, value, ctx);
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 374 */     if (log.isTraceEnabled())
/*     */     {
/* 376 */       log.trace("completeRoot root=" + root + " navigator=" + navigator + " namespaceURI=" + namespaceURI + " localName=" + localName);
/*     */     }
/*     */ 
/* 387 */     if ((root instanceof Immutable))
/*     */     {
/* 389 */       root = ((Immutable)root).newInstance();
/*     */     }
/* 391 */     return root;
/*     */   }
/*     */ 
/*     */   private void addElementToClassMapping(ElementToClassMapping mapping)
/*     */   {
/* 398 */     this.elementToClassMapping.put(mapping.element, mapping);
/*     */   }
/*     */ 
/*     */   private void addElementToFieldMapping(ElementToFieldMapping mapping)
/*     */   {
/* 403 */     this.elementToFieldMapping.put(mapping.key, mapping);
/*     */   }
/*     */ 
/*     */   private void setChild(Object child, Object parent, String localName)
/*     */   {
/* 408 */     boolean trace = log.isTraceEnabled();
/* 409 */     Object value = child;
/* 410 */     if ((parent instanceof Collection))
/*     */     {
/* 412 */       if (trace)
/*     */       {
/* 414 */         log.trace("Add " + value + " to collection " + parent);
/*     */       }
/* 416 */       ((Collection)parent).add(value);
/*     */     }
/*     */     else
/*     */     {
/* 420 */       ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, parent.getClass()));
/*     */ 
/* 423 */       if (fieldMapping != null)
/*     */       {
/* 425 */         if (trace)
/*     */         {
/* 427 */           log.trace("Add " + value + " to " + parent + " using field mapping " + fieldMapping);
/*     */         }
/* 429 */         set(parent, value, localName, fieldMapping.fieldInfo);
/*     */       }
/*     */       else
/*     */       {
/* 433 */         Class parentCls = (parent instanceof Immutable) ? ((Immutable)parent).cls : parent.getClass();
/*     */ 
/* 437 */         String fieldName = Util.xmlNameToFieldName(localName, true);
/* 438 */         FieldInfo fieldInfo = FieldInfo.getFieldInfo(parentCls, fieldName, false);
/* 439 */         if (trace)
/*     */         {
/* 441 */           log.trace("Add " + value + " to property " + fieldName + " of " + parentCls);
/*     */         }
/*     */ 
/* 444 */         if (fieldInfo != null)
/*     */         {
/* 446 */           if ((!(child instanceof Collection)) && (Collection.class.isAssignableFrom(fieldInfo.getType())))
/*     */           {
/* 448 */             Object o = get(parent, localName, fieldInfo);
/* 449 */             Collection col = (Collection)o;
/* 450 */             if (trace)
/*     */             {
/* 452 */               log.trace("Add " + value + " to collection " + col + " retrieved from " + fieldName);
/*     */             }
/* 454 */             col.add(child);
/*     */           }
/*     */           else
/*     */           {
/* 458 */             set(parent, value, localName, fieldInfo);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setAttribute(Object o, String localName, String value, UnmarshallingContext ctx)
/*     */   {
/* 467 */     if ((o instanceof Collection))
/*     */     {
/* 469 */       XSTypeDefinition type = ctx.getType();
/* 470 */       if (type == null)
/*     */       {
/* 472 */         log.warn("Type is not available for collection item " + localName + "=" + value + " -> adding as string.");
/* 473 */         ((Collection)o).add(value);
/*     */       }
/*     */       else
/*     */       {
/* 477 */         if (type.getName() == null)
/*     */         {
/* 479 */           throw new IllegalStateException("Name is null for simple type?!");
/*     */         }
/*     */ 
/* 482 */         Object trgValue = SimpleTypeBindings.unmarshal(type.getName(), value, ctx.getNamespaceContext());
/* 483 */         ((Collection)o).add(trgValue);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 488 */       Object fieldValue = null;
/* 489 */       ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
/*     */ 
/* 493 */       if (fieldMapping != null)
/*     */       {
/* 495 */         fieldValue = fieldMapping.converter.unmarshal(value);
/* 496 */         set(o, fieldValue, localName, fieldMapping.fieldInfo);
/*     */       }
/*     */       else
/*     */       {
/*     */         Class oCls;
/*     */         Class oCls;
/* 501 */         if ((o instanceof Immutable))
/*     */         {
/* 503 */           oCls = ((Immutable)o).cls;
/*     */         }
/*     */         else
/*     */         {
/* 507 */           oCls = o.getClass();
/*     */         }
/*     */ 
/* 510 */         String fieldName = Util.xmlNameToFieldName(localName, true);
/* 511 */         FieldInfo fieldInfo = FieldInfo.getFieldInfo(oCls, fieldName, true);
/*     */ 
/* 513 */         fieldValue = SimpleTypeBindings.unmarshal(value, fieldInfo.getType());
/* 514 */         set(o, fieldValue, localName, fieldInfo);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static Object create(String namespaceURI, String localName, XSTypeDefinition type)
/*     */   {
/* 529 */     Object o = null;
/*     */ 
/* 531 */     String clsName = (type != null) && (type.getName() != null) ? Util.xmlNameToClassName(namespaceURI, type.getName(), true) : Util.xmlNameToClassName(namespaceURI, localName, true);
/*     */ 
/* 535 */     Class cls = null;
/*     */     try
/*     */     {
/* 538 */       cls = Thread.currentThread().getContextClassLoader().loadClass(clsName);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 542 */       if (log.isTraceEnabled())
/*     */       {
/* 544 */         log.trace("create: failed to load class " + clsName);
/*     */       }
/*     */     }
/*     */ 
/* 548 */     if (cls != null)
/*     */     {
/* 550 */       o = newInstance(cls);
/*     */     }
/*     */ 
/* 553 */     return o;
/*     */   }
/*     */ 
/*     */   private static Object get(Object o, String localName, FieldInfo fieldInfo)
/*     */   {
/* 558 */     if (log.isTraceEnabled())
/*     */     {
/* 560 */       log.trace("get object=" + o + " localName=" + localName);
/*     */     }
/*     */     Object value;
/*     */     Object value;
/* 564 */     if ((o instanceof Immutable))
/*     */     {
/* 566 */       Immutable con = (Immutable)o;
/* 567 */       value = con.getChild(localName);
/*     */     }
/*     */     else
/*     */     {
/* 571 */       value = fieldInfo.getValue(o);
/*     */     }
/* 573 */     return value;
/*     */   }
/*     */ 
/*     */   private static void set(Object parent, Object child, String localName, FieldInfo fieldInfo)
/*     */   {
/* 578 */     if (log.isTraceEnabled())
/*     */     {
/* 580 */       log.trace("set parent=" + parent + " child=" + child + " localName=" + localName);
/*     */     }
/*     */ 
/* 583 */     if (fieldInfo.isWritable())
/*     */     {
/* 585 */       fieldInfo.setValue(parent, child);
/*     */     }
/* 587 */     else if ((parent instanceof Immutable))
/*     */     {
/* 589 */       ((Immutable)parent).addChild(localName, child);
/*     */     }
/*     */     else
/*     */     {
/* 593 */       throw new IllegalStateException("Neither write method nor field were found for " + fieldInfo.getName() + " and the parent object is not an immutable container: parent=" + parent.getClass() + ", localName=" + localName + ", parent=" + parent + ", child=" + child);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static Object newInstance(Class cls)
/*     */   {
/* 603 */     if (log.isTraceEnabled())
/*     */     {
/* 605 */       log.trace("new " + cls.getName());
/*     */     }
/*     */     Object instance;
/*     */     try
/*     */     {
/* 611 */       Constructor ctor = cls.getConstructor(null);
/* 612 */       instance = ctor.newInstance(null);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 616 */       log.warn("No no-arg constructor in " + cls);
/* 617 */       instance = new Immutable(cls);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 621 */       throw new IllegalStateException("Failed to create an instance of " + cls + " with the no-arg constructor: " + e.getMessage());
/*     */     }
/*     */ 
/* 627 */     return instance;
/*     */   }
/*     */ 
/*     */   private class ElementToFieldMapping
/*     */   {
/*     */     public final String element;
/*     */     public final Class cls;
/*     */     public final TypeBinding converter;
/*     */     public final MappingObjectModelFactory.ElementToFieldMappingKey key;
/*     */     public final FieldInfo fieldInfo;
/*     */ 
/*     */     public ElementToFieldMapping(String element, Class cls, String fieldName, TypeBinding converter)
/*     */     {
/* 742 */       this.element = element;
/* 743 */       this.cls = cls;
/* 744 */       this.converter = converter;
/* 745 */       this.key = new MappingObjectModelFactory.ElementToFieldMappingKey(MappingObjectModelFactory.this, element, cls);
/* 746 */       this.fieldInfo = FieldInfo.getFieldInfo(cls, fieldName, true);
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 751 */       StringBuffer buffer = new StringBuffer();
/* 752 */       buffer.append("ElementToField@").append(System.identityHashCode(this));
/* 753 */       buffer.append("{element=").append(this.element);
/* 754 */       if (this.cls != null)
/*     */       {
/* 756 */         buffer.append(" class=").append(this.cls.getName());
/*     */       }
/* 758 */       buffer.append(" field=").append(this.fieldInfo.getName());
/* 759 */       if (this.converter != null)
/*     */       {
/* 761 */         buffer.append(" convertor=").append(this.converter.getClass().getName());
/*     */       }
/* 763 */       buffer.append("}");
/* 764 */       return buffer.toString();
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 769 */       if (this == o)
/*     */       {
/* 771 */         return true;
/*     */       }
/* 773 */       if (!(o instanceof ElementToFieldMapping))
/*     */       {
/* 775 */         return false;
/*     */       }
/*     */ 
/* 778 */       ElementToFieldMapping elementToFieldMapping = (ElementToFieldMapping)o;
/*     */ 
/* 780 */       if (this.cls != null ? !this.cls.equals(elementToFieldMapping.cls) : elementToFieldMapping.cls != null)
/*     */       {
/* 782 */         return false;
/*     */       }
/* 784 */       if (this.element != null ? !this.element.equals(elementToFieldMapping.element) : elementToFieldMapping.element != null)
/*     */       {
/* 786 */         return false;
/*     */       }
/*     */ 
/* 791 */       return this.fieldInfo.getName().equals(elementToFieldMapping.fieldInfo.getName());
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 800 */       int result = this.element != null ? this.element.hashCode() : 0;
/* 801 */       result = 29 * result + (this.cls != null ? this.cls.hashCode() : 0);
/* 802 */       result = 29 * result + this.fieldInfo.getName().hashCode();
/* 803 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   private class ElementToFieldMappingKey
/*     */   {
/*     */     public final String element;
/*     */     public final Class cls;
/*     */ 
/*     */     public ElementToFieldMappingKey(String element, Class cls)
/*     */     {
/* 692 */       this.element = element;
/* 693 */       this.cls = cls;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 698 */       if (this == o)
/*     */       {
/* 700 */         return true;
/*     */       }
/* 702 */       if (!(o instanceof ElementToFieldMappingKey))
/*     */       {
/* 704 */         return false;
/*     */       }
/*     */ 
/* 707 */       ElementToFieldMappingKey elementToFieldMappingKey = (ElementToFieldMappingKey)o;
/*     */ 
/* 709 */       if (this.cls != null ? !this.cls.equals(elementToFieldMappingKey.cls) : elementToFieldMappingKey.cls != null)
/*     */       {
/* 711 */         return false;
/*     */       }
/*     */ 
/* 717 */       return this.element != null ? this.element.equals(elementToFieldMappingKey.element) : elementToFieldMappingKey.element == null;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 726 */       int result = this.element != null ? this.element.hashCode() : 0;
/* 727 */       result = 29 * result + (this.cls != null ? this.cls.hashCode() : 0);
/* 728 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   private class ElementToClassMapping
/*     */   {
/*     */     public final String element;
/*     */     public final Class cls;
/*     */ 
/*     */     public ElementToClassMapping(String element, Class cls)
/*     */     {
/* 640 */       this.element = element;
/* 641 */       this.cls = cls;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 646 */       StringBuffer buffer = new StringBuffer();
/* 647 */       buffer.append("ElementToClass@").append(System.identityHashCode(this));
/* 648 */       buffer.append("{element=").append(this.element);
/* 649 */       if (this.cls != null)
/*     */       {
/* 651 */         buffer.append(" class=").append(this.cls.getName());
/*     */       }
/* 653 */       buffer.append("}");
/* 654 */       return buffer.toString();
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 659 */       if (this == o)
/*     */       {
/* 661 */         return true;
/*     */       }
/* 663 */       if (!(o instanceof ElementToClassMapping))
/*     */       {
/* 665 */         return false;
/*     */       }
/*     */ 
/* 668 */       ElementToClassMapping classMapping = (ElementToClassMapping)o;
/*     */ 
/* 672 */       return this.cls != null ? this.cls.equals(classMapping.cls) : classMapping.cls == null;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 680 */       return this.cls != null ? this.cls.hashCode() : 0;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.MappingObjectModelFactory
 * JD-Core Version:    0.6.0
 */