/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.xb.binding.introspection.FieldInfo;
/*     */ 
/*     */ public class MappingObjectModelProvider
/*     */   implements GenericObjectModelProvider
/*     */ {
/*  38 */   private static final Logger log = Logger.getLogger(MappingObjectModelProvider.class);
/*     */   private final Map classMappings;
/*     */   private final Map fieldMappings;
/*     */   private boolean ignoreLowLine;
/*     */   private boolean ignoreNotFoundField;
/*     */ 
/*     */   public MappingObjectModelProvider()
/*     */   {
/*  40 */     this.classMappings = new HashMap();
/*  41 */     this.fieldMappings = new HashMap();
/*  42 */     this.ignoreLowLine = true;
/*  43 */     this.ignoreNotFoundField = true;
/*     */   }
/*     */ 
/*     */   public boolean isIgnoreNotFoundField() {
/*  47 */     return this.ignoreNotFoundField;
/*     */   }
/*     */ 
/*     */   public void setIgnoreNotFoundField(boolean ignoreNotFoundField)
/*     */   {
/*  52 */     this.ignoreNotFoundField = ignoreNotFoundField;
/*     */   }
/*     */ 
/*     */   public void mapClassToElement(Class cls, String namespaceURI, String localName, ObjectModelProvider provider)
/*     */   {
/*  57 */     ClassToElementMapping mapping = new ClassToElementMapping(cls, namespaceURI, localName, (provider instanceof GenericObjectModelProvider) ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider));
/*     */ 
/*  61 */     this.classMappings.put(mapping.cls, mapping);
/*     */   }
/*     */ 
/*     */   public void mapFieldToElement(Class cls, String field, String namespaceURI, String localName, TypeBinding converter)
/*     */   {
/*  70 */     FieldToElementMapping mapping = new FieldToElementMapping(cls, field, namespaceURI, localName, converter);
/*  71 */     mapFieldToElement(mapping);
/*     */   }
/*     */ 
/*     */   public boolean isIgnoreLowLine()
/*     */   {
/*  76 */     return this.ignoreLowLine;
/*     */   }
/*     */ 
/*     */   public void setIgnoreLowLine(boolean ignoreLowLine)
/*     */   {
/*  81 */     this.ignoreLowLine = ignoreLowLine;
/*     */   }
/*     */ 
/*     */   public Object getChildren(Object o, MarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/*  88 */     Object children = null;
/*  89 */     if (!writeAsValue(o.getClass()))
/*     */     {
/*  91 */       children = getJavaValue(namespaceURI, localName, null, o, true, this.ignoreNotFoundField);
/*     */     }
/*  93 */     return children;
/*     */   }
/*     */ 
/*     */   public Object getElementValue(Object o, MarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/*     */     Object value;
/*     */     Object value;
/*  99 */     if (writeAsValue(o.getClass()))
/*     */     {
/* 101 */       value = o;
/*     */     }
/*     */     else
/*     */     {
/* 105 */       String fieldName = null;
/* 106 */       if ((ctx != null) && (ctx.isTypeComplex()))
/*     */       {
/* 109 */         fieldName = ctx.getSimpleContentProperty();
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 115 */         value = getJavaValue(namespaceURI, localName, fieldName, o, false, false);
/*     */       }
/*     */       catch (JBossXBRuntimeException e)
/*     */       {
/* 119 */         value = getJavaValue(namespaceURI, localName, null, o, false, this.ignoreNotFoundField);
/*     */       }
/*     */     }
/* 122 */     return value;
/*     */   }
/*     */ 
/*     */   public Object getAttributeValue(Object o, MarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/* 127 */     boolean optional = (!ctx.isAttributeRequired()) || (this.ignoreNotFoundField) ? true : ctx == null ? this.ignoreNotFoundField : false;
/* 128 */     return getJavaValue(namespaceURI, localName, null, o, false, optional);
/*     */   }
/*     */ 
/*     */   public Object getRoot(Object o, MarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/* 136 */     return o;
/*     */   }
/*     */ 
/*     */   private void mapFieldToElement(FieldToElementMapping mapping)
/*     */   {
/* 143 */     String mappingKey = mapping.cls.getName() + ":" + mapping.localName;
/* 144 */     this.fieldMappings.put(mappingKey, mapping);
/*     */   }
/*     */ 
/*     */   private Object getJavaValue(String namespaceURI, String localName, String fieldName, Object o, boolean forComplexType, boolean optional)
/*     */   {
/* 149 */     String mappingKey = o.getClass().getName() + ":" + localName;
/* 150 */     FieldToElementMapping mapping = (FieldToElementMapping)this.fieldMappings.get(mappingKey);
/* 151 */     if (mapping == null)
/*     */     {
/* 153 */       if (fieldName == null)
/*     */       {
/* 155 */         fieldName = Util.xmlNameToFieldName(localName, this.ignoreLowLine);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 161 */         mapping = new FieldToElementMapping(o.getClass(), fieldName, namespaceURI, localName, null);
/* 162 */         mapFieldToElement(mapping);
/*     */       }
/*     */       catch (JBossXBRuntimeException e)
/*     */       {
/* 166 */         if (optional)
/*     */         {
/* 168 */           if (log.isTraceEnabled())
/*     */           {
/* 170 */             log.trace(e.getMessage());
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 175 */           throw e;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 180 */     FieldInfo fieldInfo = null;
/* 181 */     if (mapping != null)
/*     */     {
/* 183 */       fieldInfo = mapping.fieldInfo;
/*     */     }
/*     */ 
/* 186 */     Object value = null;
/* 187 */     if ((fieldInfo != null) && ((!forComplexType) || ((forComplexType) && (!writeAsValue(fieldInfo.getType())))))
/*     */     {
/* 189 */       value = fieldInfo.getValue(o);
/*     */     }
/*     */ 
/* 192 */     if ((value != null) && (mapping != null) && (mapping.converter != null))
/*     */     {
/* 194 */       value = mapping.converter.marshal(value);
/*     */     }
/*     */ 
/* 197 */     return value;
/*     */   }
/*     */ 
/*     */   private boolean writeAsValue(Class type)
/*     */   {
/* 202 */     return (Classes.isPrimitive(type)) || (type == String.class) || (type == Date.class) || (type == BigDecimal.class) || (type == BigInteger.class);
/*     */   }
/*     */ 
/*     */   private class FieldToElementMapping
/*     */   {
/*     */     public final Class cls;
/*     */     public final String namespaceURI;
/*     */     public final String localName;
/*     */     public final TypeBinding converter;
/*     */     public final FieldInfo fieldInfo;
/*     */ 
/*     */     public FieldToElementMapping(Class cls, String field, String namespaceURI, String localName, TypeBinding converter)
/*     */     {
/* 296 */       this.cls = cls;
/* 297 */       this.namespaceURI = namespaceURI;
/* 298 */       this.localName = localName;
/* 299 */       this.converter = converter;
/*     */ 
/* 301 */       if (MappingObjectModelProvider.log.isTraceEnabled())
/*     */       {
/* 303 */         MappingObjectModelProvider.log.trace("new FieldToElementMapping: [cls=" + cls.getName() + ",field=" + field + ",qname=" + new QName(namespaceURI, localName) + "]");
/*     */       }
/*     */ 
/* 313 */       this.fieldInfo = FieldInfo.getFieldInfo(cls, field, true);
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 318 */       if (this == o)
/*     */       {
/* 320 */         return true;
/*     */       }
/* 322 */       if (!(o instanceof FieldToElementMapping))
/*     */       {
/* 324 */         return false;
/*     */       }
/*     */ 
/* 327 */       FieldToElementMapping fieldToElementMapping = (FieldToElementMapping)o;
/*     */ 
/* 329 */       if (this.cls != null ? !this.cls.equals(fieldToElementMapping.cls) : fieldToElementMapping.cls != null)
/*     */       {
/* 331 */         return false;
/*     */       }
/* 333 */       if (!this.fieldInfo.getName().equals(fieldToElementMapping.fieldInfo.getName()))
/*     */       {
/* 335 */         return false;
/*     */       }
/* 337 */       if (this.localName != null ? !this.localName.equals(fieldToElementMapping.localName) : fieldToElementMapping.localName != null)
/*     */       {
/* 341 */         return false;
/*     */       }
/*     */ 
/* 347 */       return this.namespaceURI != null ? this.namespaceURI.equals(fieldToElementMapping.namespaceURI) : fieldToElementMapping.namespaceURI == null;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 356 */       int result = this.cls != null ? this.cls.hashCode() : 0;
/* 357 */       result = 29 * result + this.fieldInfo.getName().hashCode();
/* 358 */       result = 29 * result + (this.namespaceURI != null ? this.namespaceURI.hashCode() : 0);
/* 359 */       result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
/* 360 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   private class ClassToElementMapping
/*     */   {
/*     */     public final Class cls;
/*     */     public final String namespaceURI;
/*     */     public final String localName;
/*     */     public final GenericObjectModelProvider provider;
/*     */ 
/*     */     public ClassToElementMapping(Class cls, String namespaceURI, String localName, GenericObjectModelProvider provider)
/*     */     {
/* 223 */       this.cls = cls;
/* 224 */       this.namespaceURI = namespaceURI;
/* 225 */       this.localName = localName;
/* 226 */       this.provider = provider;
/*     */ 
/* 228 */       if (MappingObjectModelProvider.log.isTraceEnabled())
/*     */       {
/* 230 */         MappingObjectModelProvider.log.trace("new ClassToElementMapping: [cls=" + cls.getName() + ",qname=" + new QName(namespaceURI, localName) + "]");
/*     */       }
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 241 */       if (this == o)
/*     */       {
/* 243 */         return true;
/*     */       }
/* 245 */       if (!(o instanceof ClassToElementMapping))
/*     */       {
/* 247 */         return false;
/*     */       }
/*     */ 
/* 250 */       ClassToElementMapping classToElementMapping = (ClassToElementMapping)o;
/*     */ 
/* 252 */       if (this.cls != null ? !this.cls.equals(classToElementMapping.cls) : classToElementMapping.cls != null)
/*     */       {
/* 254 */         return false;
/*     */       }
/* 256 */       if (this.localName != null ? !this.localName.equals(classToElementMapping.localName) : classToElementMapping.localName != null)
/*     */       {
/* 260 */         return false;
/*     */       }
/*     */ 
/* 266 */       return this.namespaceURI != null ? this.namespaceURI.equals(classToElementMapping.namespaceURI) : classToElementMapping.namespaceURI == null;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 275 */       int result = this.cls != null ? this.cls.hashCode() : 0;
/* 276 */       result = 29 * result + (this.namespaceURI != null ? this.namespaceURI.hashCode() : 0);
/* 277 */       result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
/* 278 */       return result;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.MappingObjectModelProvider
 * JD-Core Version:    0.6.0
 */