/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.io.StringWriter;
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class SchemalessMarshaller
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(SchemalessMarshaller.class);
/*     */   public static final String PROPERTY_JAXB_SCHEMA_LOCATION = "jaxb.schemaLocation";
/*  50 */   private final Properties props = new Properties();
/*     */ 
/*  52 */   private final Map gettersPerClass = new HashMap();
/*     */ 
/*  54 */   private final Content content = new Content();
/*     */ 
/*     */   public void setProperty(String name, String value)
/*     */   {
/*  58 */     this.props.setProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void marshal(Object root, StringWriter writer)
/*     */   {
/*  63 */     log.debug("marshal: root=" + root);
/*     */ 
/*  65 */     this.content.startDocument();
/*     */ 
/*  67 */     marshalObject(root, root.getClass().getName(), writer);
/*     */ 
/*  69 */     this.content.endDocument();
/*     */ 
/*  71 */     writer.write("<?xml version=\"");
/*  72 */     writer.write("1.0");
/*  73 */     writer.write("\" encoding=\"");
/*  74 */     writer.write("UTF-8");
/*  75 */     writer.write("\"?>\n");
/*     */ 
/*  77 */     ContentWriter contentWriter = new ContentWriter(writer, true);
/*     */     try
/*     */     {
/*  80 */       this.content.handleContent(contentWriter);
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/*  84 */       log.error("Failed to write content.", e);
/*  85 */       throw new IllegalStateException("Failed to write content: " + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void marshalObject(Object root, String localName, StringWriter writer)
/*     */   {
/*  91 */     List getters = getGetterList(root.getClass());
/*  92 */     AttributesImpl attrs = null;
/*  93 */     this.content.startElement(null, localName, localName, attrs);
/*     */ 
/*  95 */     for (int i = 0; i < getters.size(); i++) {
/*  97 */       Method getter = (Method)getters.get(i);
/*     */       Object child;
/*     */       try {
/* 101 */         child = getter.invoke(root, null);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 105 */         log.error("Failed to invoke getter " + getter.getName() + " on " + root, e);
/* 106 */         throw new IllegalStateException("Failed to invoke getter " + getter.getName() + " on " + root + ": " + e.getMessage());
/*     */       }
/*     */ 
/* 111 */       if (child == null)
/*     */         continue;
/* 113 */       String childName = getter.getName().substring(3);
/* 114 */       if (isAttributeType(child.getClass()))
/*     */       {
/* 116 */         marshalAttributeType(childName, child);
/*     */       }
/* 127 */       else if (child.getClass().isArray())
/*     */       {
/* 129 */         this.content.startElement(null, childName, childName, null);
/* 130 */         for (int arrInd = 0; arrInd < Array.getLength(child); arrInd++)
/*     */         {
/* 132 */           Object o = Array.get(child, arrInd);
/* 133 */           marshalCollectionItem(o, o.getClass().getName(), o.getClass().getName(), writer);
/*     */         }
/* 135 */         this.content.endElement(null, childName, childName);
/*     */       }
/* 137 */       else if (Collection.class.isAssignableFrom(child.getClass()))
/*     */       {
/* 139 */         this.content.startElement(null, childName, childName, null);
/* 140 */         Collection col = (Collection)child;
/* 141 */         for (Iterator iter = col.iterator(); iter.hasNext(); )
/*     */         {
/* 143 */           Object o = iter.next();
/* 144 */           marshalCollectionItem(o, o.getClass().getName(), o.getClass().getName(), writer);
/*     */         }
/* 146 */         this.content.endElement(null, childName, childName);
/*     */       }
/*     */       else
/*     */       {
/* 150 */         marshalObject(child, childName, writer);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 155 */     this.content.endElement(null, localName, localName);
/*     */   }
/*     */ 
/*     */   private void marshalCollectionItem(Object o, String childName, String qName, StringWriter writer)
/*     */   {
/* 160 */     if (o != null)
/*     */     {
/* 162 */       if (isAttributeType(o.getClass()))
/*     */       {
/* 164 */         marshalAttributeType(childName, o);
/*     */       }
/*     */       else
/*     */       {
/* 168 */         marshalObject(o, qName, writer);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void marshalAttributeType(String qName, Object child)
/*     */   {
/* 175 */     this.content.startElement(null, qName, qName, null);
/* 176 */     String value = child.toString();
/* 177 */     this.content.characters(value.toCharArray(), 0, value.length());
/* 178 */     this.content.endElement(null, qName, qName);
/*     */   }
/*     */ 
/*     */   private List getGetterList(Class aClass)
/*     */   {
/* 183 */     List getters = (List)this.gettersPerClass.get(aClass);
/* 184 */     if (getters == null)
/*     */     {
/* 186 */       getters = new ArrayList();
/* 187 */       Method[] methods = aClass.getMethods();
/* 188 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 190 */         Method method = methods[i];
/* 191 */         if (method.getDeclaringClass() == Object.class)
/*     */           continue;
/* 193 */         if (((!method.getName().startsWith("get")) && (!method.getName().startsWith("is"))) || ((method.getParameterTypes() != null) && (method.getParameterTypes().length != 0))) {
/*     */           continue;
/*     */         }
/* 196 */         getters.add(method);
/*     */       }
/*     */ 
/* 200 */       this.gettersPerClass.put(aClass, getters);
/*     */     }
/* 202 */     return getters;
/*     */   }
/*     */ 
/*     */   static boolean isAttributeType(Class cls)
/*     */   {
/* 219 */     return (cls.isPrimitive()) || (cls == Byte.class) || (cls == Short.class) || (cls == Integer.class) || (cls == Long.class) || (cls == Float.class) || (cls == Double.class) || (cls == Character.class) || (cls == Boolean.class) || (cls == String.class) || (cls == Date.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.SchemalessMarshaller
 * JD-Core Version:    0.6.0
 */