/*      */ package org.jboss.xb.binding;
/*      */ 
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.io.UnsupportedEncodingException;
/*      */ import java.math.BigDecimal;
/*      */ import java.math.BigInteger;
/*      */ import java.net.URI;
/*      */ import java.net.URISyntaxException;
/*      */ import java.text.DecimalFormat;
/*      */ import java.text.ParseException;
/*      */ import java.text.SimpleDateFormat;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Calendar;
/*      */ import java.util.Date;
/*      */ import java.util.List;
/*      */ import java.util.StringTokenizer;
/*      */ import java.util.TimeZone;
/*      */ import javax.xml.namespace.NamespaceContext;
/*      */ import javax.xml.namespace.QName;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.util.Base64;
/*      */ 
/*      */ public final class SimpleTypeBindings
/*      */   implements Serializable
/*      */ {
/*      */   static final long serialVersionUID = 4372272109355825813L;
/*      */   public static final String XS_ANYSIMPLETYPE_NAME = "anySimpleType";
/*      */   public static final String XS_STRING_NAME = "string";
/*      */   public static final String XS_BOOLEAN_NAME = "boolean";
/*      */   public static final String XS_DECIMAL_NAME = "decimal";
/*      */   public static final String XS_FLOAT_NAME = "float";
/*      */   public static final String XS_DOUBLE_NAME = "double";
/*      */   public static final String XS_DURATION_NAME = "duration";
/*      */   public static final String XS_DATETIME_NAME = "dateTime";
/*      */   public static final String XS_TIME_NAME = "time";
/*      */   public static final String XS_DATE_NAME = "date";
/*      */   public static final String XS_GYEARMONTH_NAME = "gYearMonth";
/*      */   public static final String XS_GYEAR_NAME = "gYear";
/*      */   public static final String XS_GMONTHDAY_NAME = "gMonthDay";
/*      */   public static final String XS_GDAY_NAME = "gDay";
/*      */   public static final String XS_GMONTH_NAME = "gMonth";
/*      */   public static final String XS_HEXBINARY_NAME = "hexBinary";
/*      */   public static final String XS_BASE64BINARY_NAME = "base64Binary";
/*      */   public static final String XS_ANYURI_NAME = "anyURI";
/*      */   public static final String XS_QNAME_NAME = "QName";
/*      */   public static final String XS_NOTATION_NAME = "NOTATION";
/*      */   public static final String XS_NORMALIZEDSTRING_NAME = "normalizedString";
/*      */   public static final String XS_TOKEN_NAME = "token";
/*      */   public static final String XS_LANGUAGE_NAME = "language";
/*      */   public static final String XS_NMTOKEN_NAME = "NMTOKEN";
/*      */   public static final String XS_NMTOKENS_NAME = "NMTOKENS";
/*      */   public static final String XS_NAME_NAME = "Name";
/*      */   public static final String XS_NCNAME_NAME = "NCName";
/*      */   public static final String XS_ID_NAME = "ID";
/*      */   public static final String XS_IDREF_NAME = "IDREF";
/*      */   public static final String XS_IDREFS_NAME = "IDREFS";
/*      */   public static final String XS_ENTITY_NAME = "ENTITY";
/*      */   public static final String XS_ENTITIES_NAME = "ENTITIES";
/*      */   public static final String XS_INTEGER_NAME = "integer";
/*      */   public static final String XS_NONPOSITIVEINTEGER_NAME = "nonPositiveInteger";
/*      */   public static final String XS_NEGATIVEINTEGER_NAME = "negativeInteger";
/*      */   public static final String XS_LONG_NAME = "long";
/*      */   public static final String XS_INT_NAME = "int";
/*      */   public static final String XS_SHORT_NAME = "short";
/*      */   public static final String XS_BYTE_NAME = "byte";
/*      */   public static final String XS_NONNEGATIVEINTEGER_NAME = "nonNegativeInteger";
/*      */   public static final String XS_UNSIGNEDLONG_NAME = "unsignedLong";
/*      */   public static final String XS_UNSIGNEDINT_NAME = "unsignedInt";
/*      */   public static final String XS_UNSIGNEDSHORT_NAME = "unsignedShort";
/*      */   public static final String XS_UNSIGNEDBYTE_NAME = "unsignedByte";
/*      */   public static final String XS_POSITIVEINTEGER_NAME = "positiveInteger";
/*  110 */   public static final int XS_INT = "int".hashCode();
/*  111 */   public static final int XS_LONG = "long".hashCode();
/*  112 */   public static final int XS_SHORT = "short".hashCode();
/*  113 */   public static final int XS_FLOAT = "float".hashCode();
/*  114 */   public static final int XS_DOUBLE = "double".hashCode();
/*  115 */   public static final int XS_BOOLEAN = "boolean".hashCode();
/*  116 */   public static final int XS_BYTE = "byte".hashCode();
/*  117 */   public static final int XS_STRING = "string".hashCode();
/*  118 */   public static final int XS_INTEGER = "integer".hashCode();
/*  119 */   public static final int XS_DECIMAL = "decimal".hashCode();
/*  120 */   public static final int XS_DATETIME = "dateTime".hashCode();
/*  121 */   public static final int XS_QNAME = "QName".hashCode();
/*  122 */   public static final int XS_ANYURI = "anyURI".hashCode();
/*  123 */   public static final int XS_UNSIGNEDLONG = "unsignedLong".hashCode();
/*  124 */   public static final int XS_UNSIGNEDINT = "unsignedInt".hashCode();
/*  125 */   public static final int XS_UNSIGNEDSHORT = "unsignedShort".hashCode();
/*  126 */   public static final int XS_UNSIGNEDBYTE = "unsignedByte".hashCode();
/*  127 */   public static final int XS_DATE = "date".hashCode();
/*  128 */   public static final int XS_TIME = "time".hashCode();
/*  129 */   public static final int XS_BASE64BINARY = "base64Binary".hashCode();
/*  130 */   public static final int XS_HEXBINARY = "hexBinary".hashCode();
/*  131 */   public static final int XS_ANYSIMPLETYPE = "anySimpleType".hashCode();
/*  132 */   public static final int XS_DURATION = "duration".hashCode();
/*  133 */   public static final int XS_GYEARMONTH = "gYearMonth".hashCode();
/*  134 */   public static final int XS_GYEAR = "gYear".hashCode();
/*  135 */   public static final int XS_GMONTHDAY = "gMonthDay".hashCode();
/*  136 */   public static final int XS_GMONTH = "gMonth".hashCode();
/*  137 */   public static final int XS_GDAY = "gDay".hashCode();
/*  138 */   public static final int XS_NORMALIZEDSTRING = "normalizedString".hashCode();
/*  139 */   public static final int XS_TOKEN = "token".hashCode();
/*  140 */   public static final int XS_LANGUAGE = "language".hashCode();
/*  141 */   public static final int XS_NAME = "Name".hashCode();
/*  142 */   public static final int XS_NCNAME = "NCName".hashCode();
/*  143 */   public static final int XS_ID = "ID".hashCode();
/*  144 */   public static final int XS_NMTOKEN = "NMTOKEN".hashCode();
/*  145 */   public static final int XS_NMTOKENS = "NMTOKENS".hashCode();
/*  146 */   public static final int XS_NONPOSITIVEINTEGER = "nonPositiveInteger".hashCode();
/*  147 */   public static final int XS_NEGATIVEINTEGER = "negativeInteger".hashCode();
/*  148 */   public static final int XS_NONNEGATIVEINTEGER = "nonNegativeInteger".hashCode();
/*  149 */   public static final int XS_POSITIVEINTEGER = "positiveInteger".hashCode();
/*  150 */   public static final int XS_NOTATION = "NOTATION".hashCode();
/*  151 */   public static final int XS_IDREF = "IDREF".hashCode();
/*  152 */   public static final int XS_IDREFS = "IDREFS".hashCode();
/*  153 */   public static final int XS_ENTITY = "ENTITY".hashCode();
/*  154 */   public static final int XS_ENTITIES = "ENTITIES".hashCode();
/*      */ 
/*  156 */   public static final TypeBinding STRING = new TypeBinding()
/*      */   {
/*      */     public Object unmarshal(String value)
/*      */     {
/*  160 */       return value;
/*      */     }
/*      */ 
/*      */     public String marshal(Object value)
/*      */     {
/*  165 */       return (String)value;
/*      */     }
/*  156 */   };
/*      */ 
/*  169 */   public static final TypeBinding INT = new TypeBinding()
/*      */   {
/*      */     public Object unmarshal(String value)
/*      */     {
/*  173 */       return Integer.valueOf(value);
/*      */     }
/*      */ 
/*      */     public String marshal(Object value)
/*      */     {
/*  178 */       return String.valueOf(value);
/*      */     }
/*  169 */   };
/*      */ 
/*  182 */   public static final TypeBinding LONG = new TypeBinding()
/*      */   {
/*      */     public Object unmarshal(String value)
/*      */     {
/*  186 */       return Long.valueOf(value);
/*      */     }
/*      */ 
/*      */     public String marshal(Object value)
/*      */     {
/*  191 */       return String.valueOf(value);
/*      */     }
/*  182 */   };
/*      */ 
/*  195 */   public static final TypeBinding DOUBLE = new TypeBinding()
/*      */   {
/*      */     public Object unmarshal(String value)
/*      */     {
/*  199 */       return Double.valueOf(value);
/*      */     }
/*      */ 
/*      */     public String marshal(Object value)
/*      */     {
/*  204 */       return String.valueOf(value);
/*      */     }
/*  195 */   };
/*      */ 
/*  208 */   public static final TypeBinding FLOAT = new TypeBinding()
/*      */   {
/*      */     public Object unmarshal(String value)
/*      */     {
/*  212 */       return Float.valueOf(value);
/*      */     }
/*      */ 
/*      */     public String marshal(Object value)
/*      */     {
/*  217 */       return String.valueOf(value);
/*      */     }
/*  208 */   };
/*      */ 
/*  221 */   public static final TypeBinding SHORT = new TypeBinding()
/*      */   {
/*      */     public Object unmarshal(String value)
/*      */     {
/*  225 */       return Short.valueOf(value);
/*      */     }
/*      */ 
/*      */     public String marshal(Object value)
/*      */     {
/*  230 */       return String.valueOf(value);
/*      */     }
/*  221 */   };
/*      */ 
/*  234 */   public static final TypeBinding BYTE = new TypeBinding()
/*      */   {
/*      */     public Object unmarshal(String value)
/*      */     {
/*  238 */       return Byte.valueOf(value);
/*      */     }
/*      */ 
/*      */     public String marshal(Object value)
/*      */     {
/*  243 */       return String.valueOf(value);
/*      */     }
/*  234 */   };
/*      */ 
/*  247 */   public static final TypeBinding CHAR = new TypeBinding()
/*      */   {
/*      */     public Object unmarshal(String value)
/*      */     {
/*  251 */       return value == null ? null : new Character(value.charAt(0));
/*      */     }
/*      */ 
/*      */     public String marshal(Object value)
/*      */     {
/*  256 */       return String.valueOf(value);
/*      */     }
/*  247 */   };
/*      */ 
/*  260 */   public static final TypeBinding JAVA_UTIL_DATE = new TypeBinding()
/*      */   {
/*      */     public Object unmarshal(String value)
/*      */     {
/*  264 */       return SimpleTypeBindings.unmarshalDate(value).getTime();
/*      */     }
/*      */ 
/*      */     public String marshal(Object value)
/*      */     {
/*  269 */       Calendar c = Calendar.getInstance();
/*  270 */       c.setTime((Date)value);
/*  271 */       return SimpleTypeBindings.marshalDate(c);
/*      */     }
/*  260 */   };
/*      */ 
/*      */   public static Class classForType(String xsdType, boolean nillable)
/*      */   {
/*  446 */     int typeCode = xsdType.hashCode();
/*      */     Class result;
/*  447 */     if (typeCode == XS_INT)
/*      */     {
/*  449 */       result = nillable ? Integer.class : Integer.TYPE;
/*      */     }
/*      */     else
/*      */     {
/*      */       Class result;
/*  451 */       if (typeCode == XS_LONG)
/*      */       {
/*  453 */         result = nillable ? Long.class : Long.TYPE;
/*      */       }
/*      */       else
/*      */       {
/*      */         Class result;
/*  455 */         if (typeCode == XS_SHORT)
/*      */         {
/*  457 */           result = nillable ? Short.class : Short.TYPE;
/*      */         }
/*      */         else
/*      */         {
/*      */           Class result;
/*  459 */           if (typeCode == XS_BYTE)
/*      */           {
/*  461 */             result = nillable ? Byte.class : Byte.TYPE;
/*      */           }
/*      */           else
/*      */           {
/*      */             Class result;
/*  463 */             if (typeCode == XS_FLOAT)
/*      */             {
/*  465 */               result = nillable ? Float.class : Float.TYPE;
/*      */             }
/*      */             else
/*      */             {
/*      */               Class result;
/*  467 */               if (typeCode == XS_DOUBLE)
/*      */               {
/*  469 */                 result = nillable ? Double.class : Double.TYPE;
/*      */               }
/*      */               else
/*      */               {
/*      */                 Class result;
/*  471 */                 if (typeCode == XS_BOOLEAN)
/*      */                 {
/*  473 */                   result = nillable ? Boolean.class : Boolean.TYPE;
/*      */                 }
/*      */                 else
/*      */                 {
/*      */                   Class result;
/*  475 */                   if (typeCode == XS_STRING)
/*      */                   {
/*  477 */                     result = String.class;
/*      */                   }
/*      */                   else
/*      */                   {
/*      */                     Class result;
/*  479 */                     if (typeCode == XS_INTEGER)
/*      */                     {
/*  481 */                       result = BigInteger.class;
/*      */                     }
/*      */                     else
/*      */                     {
/*      */                       Class result;
/*  483 */                       if (typeCode == XS_DECIMAL)
/*      */                       {
/*  485 */                         result = BigDecimal.class;
/*      */                       }
/*      */                       else
/*      */                       {
/*      */                         Class result;
/*  487 */                         if (typeCode == XS_DATETIME)
/*      */                         {
/*  489 */                           result = Calendar.class;
/*      */                         }
/*      */                         else
/*      */                         {
/*      */                           Class result;
/*  491 */                           if (typeCode == XS_QNAME)
/*      */                           {
/*  493 */                             result = QName.class;
/*      */                           }
/*      */                           else
/*      */                           {
/*      */                             Class result;
/*  495 */                             if (typeCode == XS_ANYURI)
/*      */                             {
/*  505 */                               result = URI.class;
/*      */                             }
/*      */                             else
/*      */                             {
/*      */                               Class result;
/*  507 */                               if (typeCode == XS_UNSIGNEDLONG)
/*      */                               {
/*  509 */                                 result = BigInteger.class;
/*      */                               }
/*      */                               else
/*      */                               {
/*      */                                 Class result;
/*  511 */                                 if (typeCode == XS_UNSIGNEDINT)
/*      */                                 {
/*  513 */                                   result = nillable ? Long.class : Long.TYPE;
/*      */                                 }
/*      */                                 else
/*      */                                 {
/*      */                                   Class result;
/*  515 */                                   if (typeCode == XS_UNSIGNEDSHORT)
/*      */                                   {
/*  517 */                                     result = nillable ? Integer.class : Integer.TYPE;
/*      */                                   }
/*      */                                   else
/*      */                                   {
/*      */                                     Class result;
/*  519 */                                     if (typeCode == XS_UNSIGNEDBYTE)
/*      */                                     {
/*  521 */                                       result = nillable ? Short.class : Short.TYPE;
/*      */                                     }
/*      */                                     else
/*      */                                     {
/*      */                                       Class result;
/*  523 */                                       if (typeCode == XS_DATE)
/*      */                                       {
/*  525 */                                         result = Calendar.class;
/*      */                                       }
/*      */                                       else
/*      */                                       {
/*      */                                         Class result;
/*  527 */                                         if (typeCode == XS_TIME)
/*      */                                         {
/*  529 */                                           result = Calendar.class;
/*      */                                         }
/*      */                                         else
/*      */                                         {
/*      */                                           Class result;
/*  531 */                                           if (typeCode == XS_BASE64BINARY)
/*      */                                           {
/*  533 */                                             result = [B.class;
/*      */                                           }
/*      */                                           else
/*      */                                           {
/*      */                                             Class result;
/*  535 */                                             if (typeCode == XS_HEXBINARY)
/*      */                                             {
/*  537 */                                               result = [B.class;
/*      */                                             }
/*      */                                             else
/*      */                                             {
/*      */                                               Class result;
/*  539 */                                               if (typeCode == XS_ANYSIMPLETYPE)
/*      */                                               {
/*  541 */                                                 result = String.class;
/*      */                                               } else {
/*  543 */                                                 if (typeCode == XS_DURATION)
/*      */                                                 {
/*  546 */                                                   throw new IllegalStateException("Recognized but not supported xsdType: duration");
/*      */                                                 }
/*      */                                                 Class result;
/*  548 */                                                 if (typeCode == XS_GYEARMONTH)
/*      */                                                 {
/*  550 */                                                   result = Calendar.class;
/*      */                                                 }
/*      */                                                 else
/*      */                                                 {
/*      */                                                   Class result;
/*  552 */                                                   if (typeCode == XS_GYEAR)
/*      */                                                   {
/*  554 */                                                     result = Calendar.class;
/*      */                                                   }
/*      */                                                   else
/*      */                                                   {
/*      */                                                     Class result;
/*  556 */                                                     if (typeCode == XS_GMONTHDAY)
/*      */                                                     {
/*  558 */                                                       result = Calendar.class;
/*      */                                                     }
/*      */                                                     else
/*      */                                                     {
/*      */                                                       Class result;
/*  560 */                                                       if (typeCode == XS_GMONTH)
/*      */                                                       {
/*  562 */                                                         result = Calendar.class;
/*      */                                                       }
/*      */                                                       else
/*      */                                                       {
/*      */                                                         Class result;
/*  564 */                                                         if (typeCode == XS_GDAY)
/*      */                                                         {
/*  566 */                                                           result = Calendar.class;
/*      */                                                         }
/*      */                                                         else
/*      */                                                         {
/*      */                                                           Class result;
/*  568 */                                                           if (typeCode == XS_NORMALIZEDSTRING)
/*      */                                                           {
/*  570 */                                                             result = String.class;
/*      */                                                           }
/*      */                                                           else
/*      */                                                           {
/*      */                                                             Class result;
/*  572 */                                                             if (typeCode == XS_TOKEN)
/*      */                                                             {
/*  574 */                                                               result = String.class;
/*      */                                                             }
/*      */                                                             else
/*      */                                                             {
/*      */                                                               Class result;
/*  576 */                                                               if (typeCode == XS_LANGUAGE)
/*      */                                                               {
/*  578 */                                                                 result = String.class;
/*      */                                                               }
/*      */                                                               else
/*      */                                                               {
/*      */                                                                 Class result;
/*  580 */                                                                 if (typeCode == XS_NAME)
/*      */                                                                 {
/*  582 */                                                                   result = String.class;
/*      */                                                                 }
/*      */                                                                 else
/*      */                                                                 {
/*      */                                                                   Class result;
/*  584 */                                                                   if (typeCode == XS_NCNAME)
/*      */                                                                   {
/*  586 */                                                                     result = String.class;
/*      */                                                                   }
/*      */                                                                   else
/*      */                                                                   {
/*      */                                                                     Class result;
/*  588 */                                                                     if (typeCode == XS_ID)
/*      */                                                                     {
/*  590 */                                                                       result = String.class;
/*      */                                                                     }
/*      */                                                                     else
/*      */                                                                     {
/*      */                                                                       Class result;
/*  592 */                                                                       if (typeCode == XS_NMTOKEN)
/*      */                                                                       {
/*  594 */                                                                         result = String.class;
/*      */                                                                       }
/*      */                                                                       else
/*      */                                                                       {
/*      */                                                                         Class result;
/*  596 */                                                                         if (typeCode == XS_NMTOKENS)
/*      */                                                                         {
/*  598 */                                                                           result = [Ljava.lang.String.class;
/*      */                                                                         }
/*      */                                                                         else
/*      */                                                                         {
/*      */                                                                           Class result;
/*  600 */                                                                           if (typeCode == XS_NONPOSITIVEINTEGER)
/*      */                                                                           {
/*  602 */                                                                             result = BigInteger.class;
/*      */                                                                           }
/*      */                                                                           else
/*      */                                                                           {
/*      */                                                                             Class result;
/*  604 */                                                                             if (typeCode == XS_NEGATIVEINTEGER)
/*      */                                                                             {
/*  606 */                                                                               result = BigInteger.class;
/*      */                                                                             }
/*      */                                                                             else
/*      */                                                                             {
/*      */                                                                               Class result;
/*  608 */                                                                               if (typeCode == XS_NONNEGATIVEINTEGER)
/*      */                                                                               {
/*  610 */                                                                                 result = BigInteger.class;
/*      */                                                                               }
/*      */                                                                               else
/*      */                                                                               {
/*      */                                                                                 Class result;
/*  612 */                                                                                 if (typeCode == XS_POSITIVEINTEGER)
/*      */                                                                                 {
/*  614 */                                                                                   result = BigInteger.class;
/*      */                                                                                 }
/*      */                                                                                 else
/*      */                                                                                 {
/*      */                                                                                   Class result;
/*  616 */                                                                                   if (typeCode == XS_NOTATION)
/*      */                                                                                   {
/*  618 */                                                                                     result = String.class;
/*      */                                                                                   }
/*      */                                                                                   else
/*      */                                                                                   {
/*      */                                                                                     Class result;
/*  620 */                                                                                     if (typeCode == XS_IDREF)
/*      */                                                                                     {
/*  622 */                                                                                       result = String.class;
/*      */                                                                                     }
/*      */                                                                                     else
/*      */                                                                                     {
/*      */                                                                                       Class result;
/*  624 */                                                                                       if (typeCode == XS_IDREFS)
/*      */                                                                                       {
/*  626 */                                                                                         result = [Ljava.lang.String.class;
/*      */                                                                                       }
/*      */                                                                                       else
/*      */                                                                                       {
/*      */                                                                                         Class result;
/*  628 */                                                                                         if (typeCode == XS_ENTITY)
/*      */                                                                                         {
/*  630 */                                                                                           result = String.class;
/*      */                                                                                         }
/*      */                                                                                         else
/*      */                                                                                         {
/*      */                                                                                           Class result;
/*  632 */                                                                                           if (typeCode == XS_ENTITIES)
/*      */                                                                                           {
/*  634 */                                                                                             result = [Ljava.lang.String.class;
/*      */                                                                                           }
/*      */                                                                                           else
/*      */                                                                                           {
/*  638 */                                                                                             throw new IllegalStateException("Not supported xsdType: " + xsdType + ", hashCode=" + xsdType.hashCode());
/*      */                                                                                           }
/*      */                                                                                         }
/*      */                                                                                       }
/*      */                                                                                     }
/*      */                                                                                   }
/*      */                                                                                 }
/*      */                                                                               }
/*      */                                                                             }
/*      */                                                                           }
/*      */                                                                         }
/*      */                                                                       }
/*      */                                                                     }
/*      */                                                                   }
/*      */                                                                 }
/*      */                                                               }
/*      */                                                             }
/*      */                                                           }
/*      */                                                         }
/*      */                                                       }
/*      */                                                     }
/*      */                                                   }
/*      */                                                 }
/*      */                                               }
/*      */                                             }
/*      */                                           }
/*      */                                         }
/*      */                                       }
/*      */                                     }
/*      */                                   }
/*      */                                 }
/*      */                               }
/*      */                             }
/*      */                           }
/*      */                         }
/*      */                       }
/*      */                     }
/*      */                   }
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     Class result;
/*  640 */     return result;
/*      */   }
/*      */ 
/*      */   public static Object unmarshal(String xsdType, String value, NamespaceContext nsCtx)
/*      */   {
/*  645 */     if (xsdType == null)
/*  646 */       throw new IllegalArgumentException("Schema type cannot be null");
/*  647 */     if (value == null) {
/*  648 */       throw new IllegalArgumentException("Value string cannot be null");
/*      */     }
/*  650 */     int typeCode = xsdType.hashCode();
/*      */     Object result;
/*  652 */     if (typeCode == XS_INT)
/*      */     {
/*  654 */       result = Integer.valueOf(value);
/*      */     }
/*      */     else
/*      */     {
/*      */       Object result;
/*  656 */       if (typeCode == XS_LONG)
/*      */       {
/*  658 */         result = Long.valueOf(value);
/*      */       }
/*      */       else
/*      */       {
/*      */         Object result;
/*  660 */         if (typeCode == XS_SHORT)
/*      */         {
/*  662 */           result = Short.valueOf(value);
/*      */         }
/*      */         else
/*      */         {
/*      */           Object result;
/*  664 */           if (typeCode == XS_BYTE)
/*      */           {
/*  666 */             result = Byte.valueOf(value);
/*      */           }
/*      */           else
/*      */           {
/*      */             Object result;
/*  668 */             if (typeCode == XS_FLOAT)
/*      */             {
/*      */               Object result;
/*  670 */               if ("INF".equals(value))
/*      */               {
/*  672 */                 result = new Float((1.0F / 1.0F));
/*      */               }
/*      */               else
/*      */               {
/*      */                 Object result;
/*  674 */                 if ("-INF".equals(value))
/*      */                 {
/*  676 */                   result = new Float((1.0F / -1.0F));
/*      */                 }
/*      */                 else
/*      */                 {
/*  680 */                   result = Float.valueOf(value);
/*      */                 }
/*      */               }
/*      */             }
/*      */             else
/*      */             {
/*      */               Object result;
/*  683 */               if (typeCode == XS_DOUBLE)
/*      */               {
/*      */                 Object result;
/*  685 */                 if ("INF".equals(value))
/*      */                 {
/*  687 */                   result = new Double((1.0D / 0.0D));
/*      */                 }
/*      */                 else
/*      */                 {
/*      */                   Object result;
/*  689 */                   if ("-INF".equals(value))
/*      */                   {
/*  691 */                     result = new Double((-1.0D / 0.0D));
/*      */                   }
/*      */                   else
/*      */                   {
/*  695 */                     result = Double.valueOf(value);
/*      */                   }
/*      */                 }
/*  698 */               } else if (typeCode == XS_BOOLEAN)
/*      */               {
/*      */                 Object result;
/*  700 */                 if (value.length() == 1)
/*      */                 {
/*  702 */                   switch (value.charAt(0))
/*      */                   {
/*      */                   case '1':
/*  705 */                     result = Boolean.TRUE;
/*  706 */                     break;
/*      */                   case '0':
/*  708 */                     result = Boolean.FALSE;
/*  709 */                     break;
/*      */                   default:
/*  711 */                     throw new JBossXBValueFormatException("An instance of a datatype that is defined as ?boolean? can have the following legal literals {true, false, 1, 0}. But got: " + value);
/*      */                   }
/*      */ 
/*      */                 }
/*      */                 else
/*      */                 {
/*  718 */                   result = Boolean.valueOf(value);
/*      */                 }
/*      */               }
/*      */               else
/*      */               {
/*      */                 Object result;
/*  721 */                 if (typeCode == XS_STRING)
/*      */                 {
/*  723 */                   result = value;
/*      */                 }
/*      */                 else
/*      */                 {
/*      */                   Object result;
/*  725 */                   if (typeCode == XS_INTEGER)
/*      */                   {
/*  727 */                     result = new BigInteger(value);
/*      */                   }
/*      */                   else
/*      */                   {
/*      */                     Object result;
/*  729 */                     if (typeCode == XS_DECIMAL)
/*      */                     {
/*  731 */                       result = new BigDecimal(value);
/*      */                     }
/*      */                     else
/*      */                     {
/*      */                       Object result;
/*  733 */                       if (typeCode == XS_DATETIME)
/*      */                       {
/*  735 */                         result = unmarshalDateTime(value);
/*      */                       }
/*      */                       else
/*      */                       {
/*      */                         Object result;
/*  737 */                         if (typeCode == XS_QNAME)
/*      */                         {
/*  739 */                           result = unmarshalQName(value, nsCtx);
/*      */                         }
/*      */                         else
/*      */                         {
/*      */                           Object result;
/*  741 */                           if (typeCode == XS_ANYURI)
/*      */                           {
/*      */                             try
/*      */                             {
/*  753 */                               result = new URI(value);
/*      */                             }
/*      */                             catch (URISyntaxException e)
/*      */                             {
/*  757 */                               throw new JBossXBValueFormatException("Failed to unmarshal anyURI value " + value, e);
/*      */                             }
/*      */                           }
/*  760 */                           else if (typeCode == XS_UNSIGNEDLONG)
/*      */                           {
/*  762 */                             BigInteger d = new BigInteger(value);
/*  763 */                             if ((d.doubleValue() < 0.0D) || (d.doubleValue() > 1.844674407370955E+19D))
/*      */                             {
/*  765 */                               throw new JBossXBValueFormatException("Invalid unsignedLong value: " + value);
/*      */                             }
/*  767 */                             result = d;
/*      */                           }
/*      */                           else
/*      */                           {
/*      */                             Object result;
/*  769 */                             if (typeCode == XS_UNSIGNEDINT)
/*      */                             {
/*  771 */                               long l = Long.parseLong(value);
/*  772 */                               if ((l < 0L) || (l > 4294967295L))
/*      */                               {
/*  774 */                                 throw new JBossXBValueFormatException("Invalid unsignedInt value: " + value);
/*      */                               }
/*  776 */                               result = new Long(l);
/*      */                             }
/*      */                             else
/*      */                             {
/*      */                               Object result;
/*  778 */                               if (typeCode == XS_UNSIGNEDSHORT)
/*      */                               {
/*  780 */                                 int i = Integer.parseInt(value);
/*  781 */                                 if ((i < 0) || (i > 65535))
/*      */                                 {
/*  783 */                                   throw new JBossXBValueFormatException("Invalid unsignedShort value: " + value);
/*      */                                 }
/*  785 */                                 result = new Integer(i);
/*      */                               }
/*      */                               else
/*      */                               {
/*      */                                 Object result;
/*  787 */                                 if (typeCode == XS_UNSIGNEDBYTE)
/*      */                                 {
/*  789 */                                   short s = Short.parseShort(value);
/*  790 */                                   if ((s < 0) || (s > 255))
/*      */                                   {
/*  792 */                                     throw new JBossXBValueFormatException("Invalid unsignedByte value: " + value);
/*      */                                   }
/*  794 */                                   result = new Short(s);
/*      */                                 }
/*      */                                 else
/*      */                                 {
/*      */                                   Object result;
/*  796 */                                   if (typeCode == XS_DATE)
/*      */                                   {
/*  798 */                                     result = unmarshalDate(value);
/*      */                                   }
/*      */                                   else
/*      */                                   {
/*      */                                     Object result;
/*  800 */                                     if (typeCode == XS_TIME)
/*      */                                     {
/*  802 */                                       result = unmarshalTime(value);
/*      */                                     }
/*      */                                     else
/*      */                                     {
/*      */                                       Object result;
/*  804 */                                       if (typeCode == XS_BASE64BINARY)
/*      */                                       {
/*  806 */                                         result = unmarshalBase64(value);
/*      */                                       }
/*      */                                       else
/*      */                                       {
/*      */                                         Object result;
/*  808 */                                         if (typeCode == XS_HEXBINARY)
/*      */                                         {
/*  810 */                                           result = unmarshalHexBinary(value);
/*      */                                         }
/*      */                                         else
/*      */                                         {
/*      */                                           Object result;
/*  812 */                                           if (typeCode == XS_ANYSIMPLETYPE)
/*      */                                           {
/*  814 */                                             result = value;
/*      */                                           } else {
/*  816 */                                             if (typeCode == XS_DURATION)
/*      */                                             {
/*  819 */                                               throw new IllegalStateException("Recognized but not supported xsdType: duration");
/*      */                                             }
/*      */                                             Object result;
/*  821 */                                             if (typeCode == XS_GYEARMONTH)
/*      */                                             {
/*  823 */                                               result = unmarshalGYearMonth(value);
/*      */                                             }
/*      */                                             else
/*      */                                             {
/*      */                                               Object result;
/*  825 */                                               if (typeCode == XS_GYEAR)
/*      */                                               {
/*  827 */                                                 result = unmarshalGYear(value);
/*      */                                               }
/*      */                                               else
/*      */                                               {
/*      */                                                 Object result;
/*  829 */                                                 if (typeCode == XS_GMONTHDAY)
/*      */                                                 {
/*  831 */                                                   result = unmarshalGMonthDay(value);
/*      */                                                 } else {
/*  833 */                                                   if (typeCode == XS_GMONTH)
/*      */                                                   {
/*  835 */                                                     return unmarshalGMonth(value);
/*      */                                                   }
/*  837 */                                                   if (typeCode == XS_GDAY)
/*      */                                                   {
/*  839 */                                                     return unmarshalGDay(value);
/*      */                                                   }
/*  841 */                                                   if (typeCode == XS_NORMALIZEDSTRING)
/*      */                                                   {
/*      */                                                     Object result;
/*  843 */                                                     if (isNormalizedString(value))
/*      */                                                     {
/*  845 */                                                       result = value;
/*      */                                                     }
/*      */                                                     else
/*      */                                                     {
/*  849 */                                                       throw new JBossXBValueFormatException("Invalid normalizedString value: " + value);
/*      */                                                     }
/*      */                                                   }
/*  852 */                                                   else if (typeCode == XS_TOKEN)
/*      */                                                   {
/*      */                                                     Object result;
/*  854 */                                                     if (isValidToken(value))
/*      */                                                     {
/*  856 */                                                       result = value;
/*      */                                                     }
/*      */                                                     else
/*      */                                                     {
/*  860 */                                                       throw new JBossXBValueFormatException("Invalid token value: " + value);
/*      */                                                     }
/*      */                                                   }
/*      */                                                   else
/*      */                                                   {
/*      */                                                     Object result;
/*  863 */                                                     if (typeCode == XS_LANGUAGE)
/*      */                                                     {
/*  865 */                                                       result = value;
/*      */                                                     }
/*      */                                                     else
/*      */                                                     {
/*      */                                                       Object result;
/*  867 */                                                       if (typeCode == XS_NAME)
/*      */                                                       {
/*  869 */                                                         result = value;
/*      */                                                       }
/*      */                                                       else
/*      */                                                       {
/*      */                                                         Object result;
/*  871 */                                                         if (typeCode == XS_NCNAME)
/*      */                                                         {
/*  873 */                                                           result = value;
/*      */                                                         }
/*      */                                                         else
/*      */                                                         {
/*      */                                                           Object result;
/*  875 */                                                           if (typeCode == XS_ID)
/*      */                                                           {
/*  877 */                                                             result = value;
/*      */                                                           }
/*      */                                                           else
/*      */                                                           {
/*      */                                                             Object result;
/*  879 */                                                             if (typeCode == XS_NMTOKEN)
/*      */                                                             {
/*  881 */                                                               result = value;
/*      */                                                             }
/*      */                                                             else
/*      */                                                             {
/*      */                                                               Object result;
/*  883 */                                                               if (typeCode == XS_NMTOKENS)
/*      */                                                               {
/*  885 */                                                                 result = unmarshalNMTokens(value);
/*      */                                                               }
/*  887 */                                                               else if (typeCode == XS_NONPOSITIVEINTEGER)
/*      */                                                               {
/*  889 */                                                                 Object result = new BigInteger(value);
/*  890 */                                                                 if (BigInteger.ZERO.compareTo((BigInteger)result) < 0)
/*      */                                                                 {
/*  892 */                                                                   throw new JBossXBValueFormatException("Invalid nonPositiveInteger value: " + value);
/*      */                                                                 }
/*      */                                                               }
/*  895 */                                                               else if (typeCode == XS_NEGATIVEINTEGER)
/*      */                                                               {
/*  897 */                                                                 Object result = new BigInteger(value);
/*  898 */                                                                 if (BigInteger.ZERO.compareTo((BigInteger)result) <= 0)
/*      */                                                                 {
/*  900 */                                                                   throw new JBossXBValueFormatException("Invalid negativeInteger value: " + value);
/*      */                                                                 }
/*      */                                                               }
/*  903 */                                                               else if (typeCode == XS_NONNEGATIVEINTEGER)
/*      */                                                               {
/*  905 */                                                                 Object result = new BigInteger(value);
/*  906 */                                                                 if (BigInteger.ZERO.compareTo((BigInteger)result) > 0)
/*      */                                                                 {
/*  908 */                                                                   throw new JBossXBValueFormatException("Invalid nonNegativeInteger value: " + value);
/*      */                                                                 }
/*      */                                                               }
/*  911 */                                                               else if (typeCode == XS_POSITIVEINTEGER)
/*      */                                                               {
/*  913 */                                                                 Object result = new BigInteger(value);
/*  914 */                                                                 if (BigInteger.ZERO.compareTo((BigInteger)result) >= 0)
/*      */                                                                 {
/*  916 */                                                                   throw new JBossXBValueFormatException("Invalid positiveInteger value: " + value);
/*      */                                                                 }
/*      */                                                               }
/*      */                                                               else
/*      */                                                               {
/*      */                                                                 Object result;
/*  919 */                                                                 if (typeCode == XS_NOTATION)
/*      */                                                                 {
/*  922 */                                                                   result = value;
/*      */                                                                 }
/*      */                                                                 else
/*      */                                                                 {
/*      */                                                                   Object result;
/*  924 */                                                                   if (typeCode == XS_IDREF)
/*      */                                                                   {
/*  926 */                                                                     result = value;
/*      */                                                                   }
/*      */                                                                   else
/*      */                                                                   {
/*      */                                                                     Object result;
/*  928 */                                                                     if (typeCode == XS_IDREFS)
/*      */                                                                     {
/*  930 */                                                                       result = unmarshalIdRefs(value);
/*      */                                                                     }
/*      */                                                                     else
/*      */                                                                     {
/*      */                                                                       Object result;
/*  932 */                                                                       if (typeCode == XS_ENTITY)
/*      */                                                                       {
/*  934 */                                                                         result = value;
/*      */                                                                       }
/*      */                                                                       else
/*      */                                                                       {
/*      */                                                                         Object result;
/*  936 */                                                                         if (typeCode == XS_ENTITIES)
/*      */                                                                         {
/*  938 */                                                                           result = unmarshalIdRefs(value);
/*      */                                                                         }
/*      */                                                                         else
/*      */                                                                         {
/*  942 */                                                                           throw new IllegalStateException("Not supported xsdType: " + xsdType + ", hashCode=" + xsdType.hashCode());
/*      */                                                                         }
/*      */                                                                       }
/*      */                                                                     }
/*      */                                                                   }
/*      */                                                                 }
/*      */                                                               }
/*      */                                                             }
/*      */                                                           }
/*      */                                                         }
/*      */                                                       }
/*      */                                                     }
/*      */                                                   }
/*      */                                                 }
/*      */                                               }
/*      */                                             }
/*      */                                           }
/*      */                                         }
/*      */                                       }
/*      */                                     }
/*      */                                   }
/*      */                                 }
/*      */                               }
/*      */                             }
/*      */                           }
/*      */                         }
/*      */                       }
/*      */                     }
/*      */                   }
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     Object result;
/*  944 */     return result;
/*      */   }
/*      */ 
/*      */   public static List unmarshalList(String itemType, String value, NamespaceContext nsCtx)
/*      */   {
/*  949 */     StringTokenizer tokenizer = new StringTokenizer(value);
/*  950 */     int total = tokenizer.countTokens();
/*  951 */     List list = new ArrayList(total);
/*  952 */     for (int i = 0; i < total; i++)
/*      */     {
/*  954 */       Object o = unmarshal(itemType, tokenizer.nextToken(), nsCtx);
/*  955 */       list.add(o);
/*      */     }
/*  957 */     return list;
/*      */   }
/*      */ 
/*      */   public static String marshalList(String itemType, List value, NamespaceContext nsCtx)
/*      */   {
/*  962 */     StringBuffer buf = new StringBuffer();
/*  963 */     for (int i = 0; i < value.size(); i++)
/*      */     {
/*  965 */       String item = marshal(itemType, value.get(i), nsCtx);
/*  966 */       if (i > 0)
/*      */       {
/*  968 */         buf.append(' ');
/*      */       }
/*  970 */       buf.append(item);
/*      */     }
/*  972 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   public static Object unmarshal(String value, Class javaType)
/*      */   {
/*      */     Object result;
/*  978 */     if (String.class == javaType)
/*      */     {
/*  980 */       result = value;
/*      */     }
/*      */     else
/*      */     {
/*      */       Object result;
/*  982 */       if ((Integer.TYPE == javaType) || (Integer.class == javaType))
/*      */       {
/*  984 */         result = Integer.valueOf(value);
/*      */       }
/*      */       else
/*      */       {
/*      */         Object result;
/*  986 */         if ((Long.TYPE == javaType) || (Long.class == javaType))
/*      */         {
/*  988 */           result = Long.valueOf(value);
/*      */         }
/*      */         else
/*      */         {
/*      */           Object result;
/*  990 */           if ((Double.TYPE == javaType) || (Double.class == javaType))
/*      */           {
/*  992 */             result = Double.valueOf(value);
/*      */           }
/*      */           else
/*      */           {
/*      */             Object result;
/*  994 */             if ((Float.TYPE == javaType) || (Float.class == javaType))
/*      */             {
/*  996 */               result = Float.valueOf(value);
/*      */             }
/*      */             else
/*      */             {
/*      */               Object result;
/*  998 */               if ((Short.TYPE == javaType) || (Short.class == javaType))
/*      */               {
/* 1000 */                 result = Short.valueOf(value);
/*      */               }
/*      */               else
/*      */               {
/*      */                 Object result;
/* 1002 */                 if ((Byte.TYPE == javaType) || (Byte.class == javaType))
/*      */                 {
/* 1004 */                   result = Byte.valueOf(value);
/*      */                 }
/*      */                 else
/*      */                 {
/*      */                   Object result;
/* 1006 */                   if ((Character.TYPE == javaType) || (Character.class == javaType))
/*      */                   {
/* 1008 */                     result = new Character(value.charAt(0));
/*      */                   }
/* 1010 */                   else if (Date.class == javaType)
/*      */                   {
/* 1012 */                     String FORMAT = "yyyy-MM-dd";
/*      */                     try
/*      */                     {
/* 1015 */                       result = new SimpleDateFormat("yyyy-MM-dd").parse(value);
/*      */                     }
/*      */                     catch (ParseException e)
/*      */                     {
/*      */                       Object result;
/* 1019 */                       throw new JBossXBRuntimeException("Failed to parse date accroding to yyyy-MM-dd format: " + value + ": " + e.getMessage());
/*      */                     }
/*      */                   }
/*      */                   else
/*      */                   {
/*      */                     Object result;
/* 1024 */                     if (Object.class == javaType)
/*      */                     {
/* 1026 */                       result = value;
/*      */                     }
/*      */                     else
/*      */                     {
/* 1030 */                       throw new JBossXBRuntimeException("Unexpected field type " + javaType);
/*      */                     }
/*      */                   }
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     Object result;
/* 1033 */     return result;
/*      */   }
/*      */ 
/*      */   public static String marshal(String xsdType, Object value, NamespaceContext nsCtx)
/*      */   {
/* 1038 */     if (value == null)
/*      */     {
/* 1040 */       throw new IllegalArgumentException("Can't marshal null value!");
/*      */     }
/*      */ 
/* 1043 */     int typeCode = xsdType.hashCode();
/*      */     String result;
/* 1045 */     if (typeCode == XS_INT)
/*      */     {
/* 1047 */       Integer i = (Integer)value;
/* 1048 */       result = i.toString();
/*      */     }
/*      */     else
/*      */     {
/*      */       String result;
/* 1050 */       if (typeCode == XS_LONG)
/*      */       {
/* 1052 */         Long l = (Long)value;
/* 1053 */         result = l.toString();
/*      */       }
/*      */       else
/*      */       {
/*      */         String result;
/* 1055 */         if (typeCode == XS_SHORT)
/*      */         {
/* 1057 */           Short s = (Short)value;
/* 1058 */           result = s.toString();
/*      */         }
/*      */         else
/*      */         {
/*      */           String result;
/* 1060 */           if (typeCode == XS_BYTE)
/*      */           {
/* 1062 */             Byte b = (Byte)value;
/* 1063 */             result = b.toString();
/*      */           }
/*      */           else
/*      */           {
/*      */             String result;
/* 1065 */             if (typeCode == XS_FLOAT)
/*      */             {
/* 1067 */               Float f = (Float)value;
/*      */               String result;
/* 1068 */               if (f.floatValue() == (1.0F / 1.0F))
/*      */               {
/* 1070 */                 result = "INF";
/*      */               }
/*      */               else
/*      */               {
/*      */                 String result;
/* 1072 */                 if (f.floatValue() == (1.0F / -1.0F))
/*      */                 {
/* 1074 */                   result = "-INF";
/*      */                 }
/*      */                 else
/*      */                 {
/* 1078 */                   result = f.toString();
/*      */                 }
/*      */               }
/*      */             }
/*      */             else
/*      */             {
/*      */               String result;
/* 1081 */               if (typeCode == XS_DOUBLE)
/*      */               {
/* 1083 */                 Double d = (Double)value;
/*      */                 String result;
/* 1084 */                 if (d.doubleValue() == (1.0D / 0.0D))
/*      */                 {
/* 1086 */                   result = "INF";
/*      */                 }
/*      */                 else
/*      */                 {
/*      */                   String result;
/* 1088 */                   if (d.doubleValue() == (-1.0D / 0.0D))
/*      */                   {
/* 1090 */                     result = "-INF";
/*      */                   }
/*      */                   else
/*      */                   {
/* 1094 */                     result = d.toString();
/*      */                   }
/*      */                 }
/* 1097 */               } else if (typeCode == XS_BOOLEAN)
/*      */               {
/*      */                 String result;
/* 1099 */                 if ((value instanceof Boolean))
/*      */                 {
/* 1101 */                   result = ((Boolean)value).booleanValue() ? "true" : "false";
/*      */                 }
/* 1103 */                 else if ((value instanceof Number))
/*      */                 {
/* 1105 */                   Number n = (Number)value;
/*      */                   String result;
/* 1106 */                   switch (n.byteValue())
/*      */                   {
/*      */                   case 1:
/* 1109 */                     result = "1";
/* 1110 */                     break;
/*      */                   case 0:
/* 1112 */                     result = "0";
/* 1113 */                     break;
/*      */                   default:
/* 1115 */                     throw new JBossXBValueFormatException("An instance of a datatype that is defined as ?boolean? can have the following legal literals {true, false, 1, 0}. But got: " + value);
/*      */                   }
/*      */ 
/*      */                 }
/*      */                 else
/*      */                 {
/* 1122 */                   throw new JBossXBValueFormatException("Java value for XSD boolean type expected to be an instance of java.lang.Boolean or java.lang.Number. But the value is of type " + value.getClass().getName());
/*      */                 }
/*      */               }
/*      */               else
/*      */               {
/*      */                 String result;
/* 1127 */                 if (typeCode == XS_STRING)
/*      */                 {
/* 1129 */                   result = (String)value;
/*      */                 }
/*      */                 else
/*      */                 {
/*      */                   String result;
/* 1131 */                   if (typeCode == XS_INTEGER)
/*      */                   {
/* 1133 */                     BigInteger bi = (BigInteger)value;
/* 1134 */                     result = bi.toString();
/*      */                   }
/*      */                   else
/*      */                   {
/*      */                     String result;
/* 1136 */                     if (typeCode == XS_DECIMAL)
/*      */                     {
/* 1138 */                       BigDecimal bd = (BigDecimal)value;
/* 1139 */                       result = bd.toString();
/*      */                     }
/*      */                     else
/*      */                     {
/*      */                       String result;
/* 1141 */                       if (typeCode == XS_DATETIME)
/*      */                       {
/*      */                         Calendar c;
/* 1144 */                         if (Date.class.isAssignableFrom(value.getClass()))
/*      */                         {
/* 1146 */                           Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
/* 1147 */                           c.clear();
/* 1148 */                           c.setTime((Date)value);
/*      */                         }
/*      */                         else
/*      */                         {
/* 1152 */                           c = (Calendar)value;
/*      */                         }
/* 1154 */                         result = marshalDateTime(c);
/*      */                       }
/*      */                       else
/*      */                       {
/*      */                         String result;
/* 1156 */                         if (typeCode == XS_QNAME)
/*      */                         {
/* 1158 */                           QName qName = (QName)value;
/* 1159 */                           result = marshalQName(qName, nsCtx);
/*      */                         }
/*      */                         else
/*      */                         {
/*      */                           String result;
/* 1161 */                           if (typeCode == XS_ANYURI)
/*      */                           {
/* 1163 */                             URI u = (URI)value;
/* 1164 */                             result = u.toString();
/*      */                           }
/*      */                           else
/*      */                           {
/*      */                             String result;
/* 1166 */                             if (typeCode == XS_UNSIGNEDLONG)
/*      */                             {
/* 1168 */                               BigInteger d = (BigInteger)value;
/* 1169 */                               if ((d.doubleValue() < 0.0D) || (d.doubleValue() > 1.844674407370955E+19D))
/*      */                               {
/* 1171 */                                 throw new JBossXBValueFormatException("Invalid unsignedLong value: " + value);
/*      */                               }
/* 1173 */                               result = d.toString();
/*      */                             }
/*      */                             else
/*      */                             {
/*      */                               String result;
/* 1175 */                               if (typeCode == XS_UNSIGNEDINT)
/*      */                               {
/* 1177 */                                 Long l = (Long)value;
/* 1178 */                                 if ((l.longValue() < 0L) || (l.longValue() > 4294967295L))
/*      */                                 {
/* 1180 */                                   throw new JBossXBValueFormatException("Invalid unsignedInt value: " + value);
/*      */                                 }
/* 1182 */                                 result = l.toString();
/*      */                               }
/*      */                               else
/*      */                               {
/*      */                                 String result;
/* 1184 */                                 if (typeCode == XS_UNSIGNEDSHORT)
/*      */                                 {
/* 1186 */                                   Integer i = (Integer)value;
/* 1187 */                                   if ((i.intValue() < 0) || (i.intValue() > 65535))
/*      */                                   {
/* 1189 */                                     throw new JBossXBValueFormatException("Invalid unsignedShort value: " + value);
/*      */                                   }
/* 1191 */                                   result = i.toString();
/*      */                                 }
/*      */                                 else
/*      */                                 {
/*      */                                   String result;
/* 1193 */                                   if (typeCode == XS_UNSIGNEDBYTE)
/*      */                                   {
/* 1195 */                                     Short s = (Short)value;
/* 1196 */                                     if ((s.shortValue() < 0) || (s.shortValue() > 255))
/*      */                                     {
/* 1198 */                                       throw new JBossXBValueFormatException("Invalid unsignedByte value: " + value);
/*      */                                     }
/* 1200 */                                     result = s.toString();
/*      */                                   }
/*      */                                   else
/*      */                                   {
/*      */                                     String result;
/* 1202 */                                     if (typeCode == XS_DATE)
/*      */                                     {
/* 1204 */                                       Calendar c = (Calendar)value;
/* 1205 */                                       result = marshalDate(c);
/*      */                                     }
/*      */                                     else
/*      */                                     {
/*      */                                       String result;
/* 1207 */                                       if (typeCode == XS_TIME)
/*      */                                       {
/* 1209 */                                         Calendar c = (Calendar)value;
/* 1210 */                                         result = marshalTime(c);
/*      */                                       }
/*      */                                       else
/*      */                                       {
/*      */                                         String result;
/* 1212 */                                         if (typeCode == XS_BASE64BINARY)
/*      */                                         {
/* 1214 */                                           byte[] b = (byte[])(byte[])value;
/* 1215 */                                           result = marshalBase64(b);
/*      */                                         }
/*      */                                         else
/*      */                                         {
/*      */                                           String result;
/* 1217 */                                           if (typeCode == XS_HEXBINARY)
/*      */                                           {
/* 1219 */                                             byte[] b = (byte[])(byte[])value;
/* 1220 */                                             result = marshalHexBinary(b);
/*      */                                           } else {
/* 1222 */                                             if (typeCode == XS_ANYSIMPLETYPE)
/*      */                                             {
/* 1224 */                                               return (String)value;
/*      */                                             }
/* 1226 */                                             if (typeCode == XS_DURATION)
/*      */                                             {
/* 1229 */                                               throw new IllegalStateException("Recognized but not supported xsdType: " + xsdType);
/*      */                                             }
/*      */                                             String result;
/* 1231 */                                             if (typeCode == XS_GYEARMONTH)
/*      */                                             {
/* 1233 */                                               Calendar c = (Calendar)value;
/* 1234 */                                               result = marshalGYearMonth(c);
/*      */                                             }
/*      */                                             else
/*      */                                             {
/*      */                                               String result;
/* 1236 */                                               if (typeCode == XS_GYEAR)
/*      */                                               {
/* 1238 */                                                 Calendar c = (Calendar)value;
/* 1239 */                                                 result = marshalGYear(c);
/*      */                                               }
/*      */                                               else
/*      */                                               {
/*      */                                                 String result;
/* 1241 */                                                 if (typeCode == XS_GMONTHDAY)
/*      */                                                 {
/* 1243 */                                                   Calendar c = (Calendar)value;
/* 1244 */                                                   result = marshalGMonthDay(c);
/*      */                                                 }
/*      */                                                 else
/*      */                                                 {
/*      */                                                   String result;
/* 1246 */                                                   if (typeCode == XS_GMONTH)
/*      */                                                   {
/* 1248 */                                                     Calendar c = (Calendar)value;
/* 1249 */                                                     result = marshalGMonth(c);
/*      */                                                   }
/*      */                                                   else
/*      */                                                   {
/*      */                                                     String result;
/* 1251 */                                                     if (typeCode == XS_GDAY)
/*      */                                                     {
/* 1253 */                                                       Calendar c = (Calendar)value;
/* 1254 */                                                       result = marshalGDay(c);
/*      */                                                     }
/*      */                                                     else
/*      */                                                     {
/*      */                                                       String result;
/* 1256 */                                                       if (typeCode == XS_NORMALIZEDSTRING)
/*      */                                                       {
/* 1258 */                                                         String s = (String)value;
/*      */                                                         String result;
/* 1259 */                                                         if (isNormalizedString(s))
/*      */                                                         {
/* 1261 */                                                           result = s;
/*      */                                                         }
/*      */                                                         else
/*      */                                                         {
/* 1265 */                                                           throw new JBossXBValueFormatException("Invalid normalizedString value: " + value);
/*      */                                                         }
/*      */                                                       }
/*      */                                                       else
/*      */                                                       {
/*      */                                                         String result;
/* 1268 */                                                         if (typeCode == XS_TOKEN)
/*      */                                                         {
/* 1270 */                                                           String s = (String)value;
/*      */                                                           String result;
/* 1271 */                                                           if (isValidToken(s))
/*      */                                                           {
/* 1273 */                                                             result = s;
/*      */                                                           }
/*      */                                                           else
/*      */                                                           {
/* 1277 */                                                             throw new JBossXBValueFormatException("Invalid token value: " + value);
/*      */                                                           }
/*      */                                                         }
/*      */                                                         else
/*      */                                                         {
/*      */                                                           String result;
/* 1280 */                                                           if (typeCode == XS_LANGUAGE)
/*      */                                                           {
/* 1282 */                                                             result = (String)value;
/*      */                                                           }
/*      */                                                           else
/*      */                                                           {
/*      */                                                             String result;
/* 1284 */                                                             if (typeCode == XS_NAME)
/*      */                                                             {
/* 1286 */                                                               result = (String)value;
/*      */                                                             }
/*      */                                                             else
/*      */                                                             {
/*      */                                                               String result;
/* 1288 */                                                               if (typeCode == XS_NCNAME)
/*      */                                                               {
/* 1290 */                                                                 result = (String)value;
/*      */                                                               }
/*      */                                                               else
/*      */                                                               {
/*      */                                                                 String result;
/* 1292 */                                                                 if (typeCode == XS_ID)
/*      */                                                                 {
/* 1294 */                                                                   result = (String)value;
/*      */                                                                 }
/*      */                                                                 else
/*      */                                                                 {
/*      */                                                                   String result;
/* 1296 */                                                                   if (typeCode == XS_NMTOKEN)
/*      */                                                                   {
/* 1298 */                                                                     result = (String)value;
/*      */                                                                   }
/*      */                                                                   else
/*      */                                                                   {
/*      */                                                                     String result;
/* 1300 */                                                                     if (typeCode == XS_NMTOKENS)
/*      */                                                                     {
/* 1302 */                                                                       String[] tokens = (String[])(String[])value;
/* 1303 */                                                                       if (tokens.length > 0)
/*      */                                                                       {
/* 1305 */                                                                         String result = tokens[0];
/* 1306 */                                                                         for (int i = 1; i < tokens.length; i++)
/*      */                                                                         {
/* 1308 */                                                                           result = result + ' ' + tokens[i];
/*      */                                                                         }
/*      */                                                                       }
/*      */                                                                       else
/*      */                                                                       {
/* 1313 */                                                                         result = "";
/*      */                                                                       }
/*      */                                                                     }
/*      */                                                                     else
/*      */                                                                     {
/*      */                                                                       String result;
/* 1316 */                                                                       if (typeCode == XS_NONPOSITIVEINTEGER)
/*      */                                                                       {
/* 1318 */                                                                         BigInteger bi = (BigInteger)value;
/* 1319 */                                                                         if (BigInteger.ZERO.compareTo(bi) < 0)
/*      */                                                                         {
/* 1321 */                                                                           throw new JBossXBValueFormatException("Invalid nonPositiveInteger value: " + value);
/*      */                                                                         }
/* 1323 */                                                                         result = bi.toString();
/*      */                                                                       }
/*      */                                                                       else
/*      */                                                                       {
/*      */                                                                         String result;
/* 1325 */                                                                         if (typeCode == XS_NEGATIVEINTEGER)
/*      */                                                                         {
/* 1327 */                                                                           BigInteger bi = (BigInteger)value;
/* 1328 */                                                                           if (BigInteger.ZERO.compareTo(bi) <= 0)
/*      */                                                                           {
/* 1330 */                                                                             throw new JBossXBValueFormatException("Invalid negativeInteger value: " + value);
/*      */                                                                           }
/* 1332 */                                                                           result = bi.toString();
/*      */                                                                         }
/*      */                                                                         else
/*      */                                                                         {
/*      */                                                                           String result;
/* 1334 */                                                                           if (typeCode == XS_NONNEGATIVEINTEGER)
/*      */                                                                           {
/* 1336 */                                                                             BigInteger bi = (BigInteger)value;
/* 1337 */                                                                             if (BigInteger.ZERO.compareTo(bi) > 0)
/*      */                                                                             {
/* 1339 */                                                                               throw new JBossXBValueFormatException("Invalid nonNegativeInteger value: " + value);
/*      */                                                                             }
/* 1341 */                                                                             result = bi.toString();
/*      */                                                                           }
/*      */                                                                           else
/*      */                                                                           {
/*      */                                                                             String result;
/* 1343 */                                                                             if (typeCode == XS_POSITIVEINTEGER)
/*      */                                                                             {
/* 1345 */                                                                               BigInteger bi = (BigInteger)value;
/* 1346 */                                                                               if (BigInteger.ZERO.compareTo(bi) >= 0)
/*      */                                                                               {
/* 1348 */                                                                                 throw new JBossXBValueFormatException("Invalid positiveInteger value: " + value);
/*      */                                                                               }
/* 1350 */                                                                               result = bi.toString();
/*      */                                                                             }
/*      */                                                                             else
/*      */                                                                             {
/*      */                                                                               String result;
/* 1352 */                                                                               if (typeCode == XS_NOTATION)
/*      */                                                                               {
/* 1355 */                                                                                 result = (String)value;
/*      */                                                                               }
/*      */                                                                               else
/*      */                                                                               {
/*      */                                                                                 String result;
/* 1357 */                                                                                 if (typeCode == XS_IDREF)
/*      */                                                                                 {
/* 1359 */                                                                                   result = (String)value;
/*      */                                                                                 }
/*      */                                                                                 else
/*      */                                                                                 {
/*      */                                                                                   String result;
/* 1361 */                                                                                   if (typeCode == XS_IDREFS)
/*      */                                                                                   {
/* 1363 */                                                                                     String[] refs = (String[])(String[])value;
/* 1364 */                                                                                     if (refs.length > 0)
/*      */                                                                                     {
/* 1366 */                                                                                       String result = refs[0];
/* 1367 */                                                                                       for (int i = 1; i < refs.length; i++)
/*      */                                                                                       {
/* 1369 */                                                                                         result = result + ' ' + refs[i];
/*      */                                                                                       }
/*      */                                                                                     }
/*      */                                                                                     else
/*      */                                                                                     {
/* 1374 */                                                                                       result = "";
/*      */                                                                                     }
/*      */                                                                                   }
/*      */                                                                                   else
/*      */                                                                                   {
/*      */                                                                                     String result;
/* 1377 */                                                                                     if (typeCode == XS_ENTITY)
/*      */                                                                                     {
/* 1379 */                                                                                       result = (String)value;
/*      */                                                                                     }
/*      */                                                                                     else
/*      */                                                                                     {
/*      */                                                                                       String result;
/* 1381 */                                                                                       if (typeCode == XS_ENTITIES)
/*      */                                                                                       {
/* 1383 */                                                                                         String[] refs = (String[])(String[])value;
/* 1384 */                                                                                         if (refs.length > 0)
/*      */                                                                                         {
/* 1386 */                                                                                           String result = refs[0];
/* 1387 */                                                                                           for (int i = 1; i < refs.length; i++)
/*      */                                                                                           {
/* 1389 */                                                                                             result = result + ' ' + refs[i];
/*      */                                                                                           }
/*      */                                                                                         }
/*      */                                                                                         else
/*      */                                                                                         {
/* 1394 */                                                                                           result = "";
/*      */                                                                                         }
/*      */                                                                                       }
/*      */                                                                                       else
/*      */                                                                                       {
/* 1399 */                                                                                         throw new IllegalStateException("Not supported xsdType: " + xsdType + ", hashCode=" + xsdType.hashCode());
/*      */                                                                                       }
/*      */                                                                                     }
/*      */                                                                                   }
/*      */                                                                                 }
/*      */                                                                               }
/*      */                                                                             }
/*      */                                                                           }
/*      */                                                                         }
/*      */                                                                       }
/*      */                                                                     }
/*      */                                                                   }
/*      */                                                                 }
/*      */                                                               }
/*      */                                                             }
/*      */                                                           }
/*      */                                                         }
/*      */                                                       }
/*      */                                                     }
/*      */                                                   }
/*      */                                                 }
/*      */                                               }
/*      */                                             }
/*      */                                           }
/*      */                                         }
/*      */                                       }
/*      */                                     }
/*      */                                   }
/*      */                                 }
/*      */                               }
/*      */                             }
/*      */                           }
/*      */                         }
/*      */                       }
/*      */                     }
/*      */                   }
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     String result;
/* 1401 */     return result;
/*      */   }
/*      */ 
/*      */   public static QName typeQName(Class cls)
/*      */   {
/* 1406 */     if (cls == null)
/*      */     {
/* 1408 */       throw new IllegalArgumentException("The argument must not be null.");
/*      */     }
/*      */ 
/* 1411 */     QName result = null;
/* 1412 */     if ((Integer.class == cls) || (Integer.TYPE == cls))
/*      */     {
/* 1414 */       result = Constants.QNAME_INT;
/*      */     }
/* 1416 */     else if ((cls == Long.class) || (Long.TYPE == cls))
/*      */     {
/* 1418 */       result = Constants.QNAME_LONG;
/*      */     }
/* 1420 */     else if ((cls == Short.class) || (Short.TYPE == cls))
/*      */     {
/* 1422 */       result = Constants.QNAME_SHORT;
/*      */     }
/* 1424 */     else if ((cls == Byte.class) || (Byte.TYPE == cls))
/*      */     {
/* 1426 */       result = Constants.QNAME_BYTE;
/*      */     }
/* 1428 */     else if ((cls == Float.class) || (Float.TYPE == cls))
/*      */     {
/* 1430 */       result = Constants.QNAME_FLOAT;
/*      */     }
/* 1432 */     else if ((cls == Double.class) || (Double.TYPE == cls))
/*      */     {
/* 1434 */       result = Constants.QNAME_DOUBLE;
/*      */     }
/* 1436 */     else if ((cls == Boolean.class) || (Boolean.TYPE == cls))
/*      */     {
/* 1438 */       result = Constants.QNAME_BOOLEAN;
/*      */     }
/* 1440 */     else if (cls == String.class)
/*      */     {
/* 1442 */       result = Constants.QNAME_STRING;
/*      */     }
/* 1444 */     else if (cls == BigInteger.class)
/*      */     {
/* 1446 */       result = Constants.QNAME_INTEGER;
/*      */     }
/* 1448 */     else if (cls == BigDecimal.class)
/*      */     {
/* 1450 */       result = Constants.QNAME_DECIMAL;
/*      */     }
/* 1452 */     else if ((cls == Date.class) || (Calendar.class.isAssignableFrom(cls)))
/*      */     {
/* 1454 */       result = Constants.QNAME_DATETIME;
/*      */     }
/* 1456 */     else if (cls == QName.class)
/*      */     {
/* 1458 */       result = Constants.QNAME_QNAME;
/*      */     }
/* 1460 */     else if (cls == URI.class)
/*      */     {
/* 1462 */       result = Constants.QNAME_ANYURI;
/*      */     }
/* 1464 */     else if (cls == [B.class)
/*      */     {
/* 1466 */       result = Constants.QNAME_BASE64BINARY;
/*      */     }
/* 1468 */     return result;
/*      */   }
/*      */ 
/*      */   public static String[] unmarshalNMTokens(String value)
/*      */   {
/* 1473 */     StringTokenizer tokenizer = new StringTokenizer(value);
/* 1474 */     String[] tokens = new String[tokenizer.countTokens()];
/* 1475 */     for (int i = 0; i < tokens.length; i++)
/*      */     {
/* 1477 */       tokens[i] = tokenizer.nextToken();
/*      */     }
/* 1479 */     return tokens;
/*      */   }
/*      */ 
/*      */   public static String[] unmarshalIdRefs(String value)
/*      */   {
/* 1484 */     StringTokenizer tokenizer = new StringTokenizer(value);
/* 1485 */     String[] tokens = new String[tokenizer.countTokens()];
/* 1486 */     for (int i = 0; i < tokens.length; i++)
/*      */     {
/* 1488 */       tokens[i] = tokenizer.nextToken();
/*      */     }
/* 1490 */     return tokens;
/*      */   }
/*      */ 
/*      */   public static Calendar unmarshalGMonthDay(String value)
/*      */   {
/* 1501 */     if ((value.length() < 6) || (value.charAt(0) != '-') || (value.charAt(1) != '-') || (value.charAt(4) != '-'))
/*      */     {
/* 1506 */       throw new JBossXBValueFormatException("gMonthDay value does not follow the format '--MM-DD[timezone]: " + value);
/*      */     }
/*      */ 
/* 1511 */     Calendar cal = Calendar.getInstance();
/* 1512 */     cal.clear();
/* 1513 */     cal.set(2, Integer.parseInt(value.substring(2, 4)) - 1);
/* 1514 */     cal.set(5, Integer.parseInt(value.substring(5, 7)));
/* 1515 */     if (value.length() > 7)
/*      */     {
/* 1517 */       cal.setTimeZone(parseTimeZone(value, 7));
/*      */     }
/* 1519 */     return cal;
/*      */   }
/*      */ 
/*      */   public static String marshalGMonthDay(Calendar value)
/*      */   {
/* 1530 */     String result = "--";
/* 1531 */     result = result + marshalInt(value.get(2) + 1, 2);
/* 1532 */     result = result + '-';
/* 1533 */     result = result + marshalInt(value.get(5), 2);
/* 1534 */     result = result + marshalTimeZone(value);
/* 1535 */     return result;
/*      */   }
/*      */ 
/*      */   public static Calendar unmarshalGMonth(String value)
/*      */   {
/* 1546 */     if ((value.length() < 4) || (value.charAt(0) != '-') || (value.charAt(1) != '-'))
/*      */     {
/* 1548 */       throw new JBossXBValueFormatException("gMonth value does not follow the format '--MM': " + value);
/*      */     }
/*      */ 
/* 1551 */     Calendar cal = Calendar.getInstance();
/* 1552 */     cal.clear();
/*      */ 
/* 1554 */     cal.set(2, Integer.parseInt(value.substring(2, 4)) - 1);
/* 1555 */     if (value.length() > 4)
/*      */     {
/* 1557 */       cal.setTimeZone(parseTimeZone(value, 4));
/*      */     }
/* 1559 */     return cal;
/*      */   }
/*      */ 
/*      */   public static String marshalGMonth(Calendar value)
/*      */   {
/* 1570 */     String result = "--";
/* 1571 */     result = result + marshalInt(value.get(2) + 1, 2);
/* 1572 */     result = result + marshalTimeZone(value);
/* 1573 */     return result;
/*      */   }
/*      */ 
/*      */   public static Calendar unmarshalGYear(String value)
/*      */   {
/* 1578 */     Calendar cal = Calendar.getInstance();
/* 1579 */     cal.clear();
/* 1580 */     int timeZone = parseGYear(value, 0, cal);
/* 1581 */     if (value.length() > timeZone)
/*      */     {
/* 1583 */       TimeZone tz = parseTimeZone(value, timeZone);
/* 1584 */       cal.setTimeZone(tz);
/*      */     }
/* 1586 */     return cal;
/*      */   }
/*      */ 
/*      */   public static String marshalGYear(Calendar value)
/*      */   {
/* 1591 */     String result = String.valueOf(value.get(1));
/* 1592 */     result = result + marshalTimeZone(value);
/* 1593 */     return result;
/*      */   }
/*      */ 
/*      */   public static Calendar unmarshalGYearMonth(String value)
/*      */   {
/* 1604 */     Calendar cal = Calendar.getInstance();
/* 1605 */     cal.clear();
/*      */ 
/* 1607 */     int month = parseGYear(value, 0, cal);
/* 1608 */     if (value.charAt(month) != '-')
/*      */     {
/* 1610 */       throw new JBossXBValueFormatException("gYearMonth value does not follow the format '[-]CCYY-MM[timezone]': " + value);
/*      */     }
/*      */ 
/* 1615 */     cal.set(2, Integer.parseInt(value.substring(month + 1, month + 3)) - 1);
/*      */ 
/* 1617 */     if (value.length() > month + 3)
/*      */     {
/* 1619 */       TimeZone tz = parseTimeZone(value, month + 3);
/* 1620 */       cal.setTimeZone(tz);
/*      */     }
/*      */ 
/* 1623 */     return cal;
/*      */   }
/*      */ 
/*      */   public static String marshalGYearMonth(Calendar value)
/*      */   {
/* 1634 */     String result = String.valueOf(value.get(1));
/* 1635 */     result = result + '-';
/* 1636 */     result = result + marshalInt(value.get(2) + 1, 2);
/* 1637 */     result = result + marshalTimeZone(value);
/* 1638 */     return result;
/*      */   }
/*      */ 
/*      */   public static Calendar unmarshalGDay(String value)
/*      */   {
/* 1649 */     if ((value.length() < 5) || (value.charAt(0) != '-') || (value.charAt(1) != '-') || (value.charAt(2) != '-'))
/*      */     {
/* 1651 */       throw new NumberFormatException("gDay value does not follow the format (---DD[timezonePart]): " + value);
/*      */     }
/*      */ 
/* 1655 */     int day = Integer.parseInt(value.substring(3, 5));
/* 1656 */     if ((day < 1) || (day > 31))
/*      */     {
/* 1658 */       throw new NumberFormatException("gDay value is not in the interval [1..31]: " + day);
/*      */     }
/*      */ 
/* 1662 */     TimeZone tz = parseTimeZone(value, 5);
/*      */ 
/* 1664 */     Calendar cal = Calendar.getInstance();
/* 1665 */     cal.clear();
/* 1666 */     if (tz != null)
/*      */     {
/* 1668 */       cal.setTimeZone(tz);
/*      */     }
/* 1670 */     cal.set(5, day);
/*      */ 
/* 1672 */     return cal;
/*      */   }
/*      */ 
/*      */   public static String marshalGDay(Calendar value)
/*      */   {
/* 1683 */     String result = "---";
/* 1684 */     result = result + marshalInt(value.get(5), 2);
/* 1685 */     result = result + marshalTimeZone(value);
/* 1686 */     return result;
/*      */   }
/*      */ 
/*      */   public static Calendar unmarshalDate(String value)
/*      */   {
/* 1699 */     Calendar cal = Calendar.getInstance();
/* 1700 */     cal.clear();
/*      */ 
/* 1702 */     int ind = parseDate(value, 0, cal);
/*      */ 
/* 1704 */     TimeZone tz = null;
/* 1705 */     if (ind < value.length())
/*      */     {
/* 1707 */       tz = parseTimeZone(value, ind);
/*      */     }
/*      */ 
/* 1710 */     if (tz != null)
/*      */     {
/* 1712 */       cal.setTimeZone(tz);
/*      */     }
/*      */ 
/* 1715 */     return cal;
/*      */   }
/*      */ 
/*      */   public static String marshalDate(Calendar value)
/*      */   {
/* 1726 */     String result = marshalInt(value.get(1), 4);
/* 1727 */     result = result + '-';
/* 1728 */     result = result + marshalInt(value.get(2) + 1, 2);
/* 1729 */     result = result + '-';
/* 1730 */     result = result + marshalInt(value.get(5), 2);
/* 1731 */     result = result + marshalTimeZone(value);
/* 1732 */     return result;
/*      */   }
/*      */ 
/*      */   public static Calendar unmarshalTime(String value)
/*      */   {
/* 1743 */     Calendar cal = Calendar.getInstance();
/* 1744 */     cal.clear();
/*      */ 
/* 1746 */     int tzLoc = parseTime(value, 0, cal);
/*      */ 
/* 1748 */     TimeZone tz = null;
/* 1749 */     if (value.length() > tzLoc)
/*      */     {
/* 1751 */       tz = parseTimeZone(value, tzLoc);
/*      */     }
/*      */ 
/* 1754 */     if (tz != null)
/*      */     {
/* 1756 */       cal.setTimeZone(tz);
/*      */     }
/* 1758 */     return cal;
/*      */   }
/*      */ 
/*      */   public static String marshalTime(Calendar value)
/*      */   {
/* 1769 */     String result = marshalInt(value.get(11), 2);
/* 1770 */     result = result + ':';
/* 1771 */     result = result + marshalInt(value.get(12), 2);
/* 1772 */     result = result + ':';
/* 1773 */     result = result + marshalInt(value.get(13), 2);
/* 1774 */     result = result + '.';
/*      */ 
/* 1776 */     int millis = value.get(14);
/* 1777 */     if (millis > 99)
/*      */     {
/* 1779 */       result = result + String.valueOf(millis);
/*      */     }
/* 1781 */     else if (millis > 9)
/*      */     {
/* 1783 */       result = result + "0" + String.valueOf(millis);
/*      */     }
/*      */     else
/*      */     {
/* 1787 */       result = result + "00" + String.valueOf(millis);
/*      */     }
/*      */ 
/* 1790 */     result = result + marshalTimeZone(value);
/* 1791 */     return result;
/*      */   }
/*      */ 
/*      */   public static Calendar unmarshalDateTime(String value)
/*      */   {
/* 1802 */     Calendar cal = Calendar.getInstance();
/* 1803 */     cal.clear();
/*      */ 
/* 1805 */     int timeInd = parseDate(value, 0, cal);
/* 1806 */     if (value.charAt(timeInd) != 'T')
/*      */     {
/* 1808 */       throw new JBossXBValueFormatException("DateTime value does not follow the format '[-]yyyy-mm-ddThh:mm:ss[.s+][timezone]': expected 'T' but got " + value.charAt(timeInd));
/*      */     }
/*      */ 
/* 1813 */     int tzStart = parseTime(value, timeInd + 1, cal);
/*      */ 
/* 1815 */     TimeZone tz = null;
/* 1816 */     if (value.length() > tzStart)
/*      */     {
/* 1818 */       tz = parseTimeZone(value, tzStart);
/*      */     }
/*      */ 
/* 1821 */     if (tz != null)
/*      */     {
/* 1823 */       cal.setTimeZone(tz);
/*      */     }
/*      */ 
/* 1826 */     return cal;
/*      */   }
/*      */ 
/*      */   public static String marshalDateTime(Calendar value)
/*      */   {
/* 1837 */     String result = marshalInt(value.get(1), 4);
/* 1838 */     result = result + '-';
/* 1839 */     result = result + marshalInt(value.get(2) + 1, 2);
/* 1840 */     result = result + '-';
/* 1841 */     result = result + marshalInt(value.get(5), 2);
/* 1842 */     result = result + 'T';
/* 1843 */     result = result + marshalInt(value.get(11), 2);
/* 1844 */     result = result + ':';
/* 1845 */     result = result + marshalInt(value.get(12), 2);
/* 1846 */     result = result + ':';
/* 1847 */     result = result + marshalInt(value.get(13), 2);
/* 1848 */     result = result + '.';
/*      */ 
/* 1850 */     int millis = value.get(14);
/* 1851 */     if (millis > 99)
/*      */     {
/* 1853 */       result = result + String.valueOf(millis);
/*      */     }
/* 1855 */     else if (millis > 9)
/*      */     {
/* 1857 */       result = result + "0" + String.valueOf(millis);
/*      */     }
/*      */     else
/*      */     {
/* 1861 */       result = result + "00" + String.valueOf(millis);
/*      */     }
/*      */ 
/* 1864 */     result = result + marshalTimeZone(value);
/* 1865 */     return result;
/*      */   }
/*      */ 
/*      */   public static byte[] unmarshalHexBinary(String value)
/*      */   {
/* 1876 */     if (value.length() % 2 != 0)
/*      */     {
/* 1878 */       throw new IllegalArgumentException("hexBinary value must have even length.");
/*      */     }
/*      */ 
/* 1881 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 1882 */     for (int i = 0; i < value.length(); i += 2)
/*      */     {
/* 1884 */       char c1 = value.charAt(i);
/* 1885 */       char c2 = value.charAt(i + 1);
/* 1886 */       byte b = 0;
/* 1887 */       if ((c1 >= '0') && (c1 <= '9'))
/*      */       {
/* 1889 */         b = (byte)(b + (c1 - '0') * 16);
/*      */       }
/* 1891 */       else if ((c1 >= 'a') && (c1 <= 'f'))
/*      */       {
/* 1893 */         b = (byte)(b + (c1 - 'a' + 10) * 16);
/*      */       }
/* 1895 */       else if ((c1 >= 'A') && (c1 <= 'F'))
/*      */       {
/* 1897 */         b = (byte)(b + (c1 - 'A' + 10) * 16);
/*      */       }
/*      */       else
/*      */       {
/* 1901 */         throw new IllegalArgumentException("hexBinary value contains illegal character: " + value);
/*      */       }
/*      */ 
/* 1904 */       if ((c2 >= '0') && (c2 <= '9'))
/*      */       {
/* 1906 */         b = (byte)(b + (c2 - '0'));
/*      */       }
/* 1908 */       else if ((c2 >= 'a') && (c2 <= 'f'))
/*      */       {
/* 1910 */         b = (byte)(b + (c2 - 'a' + 10));
/*      */       }
/* 1912 */       else if ((c2 >= 'A') && (c2 <= 'F'))
/*      */       {
/* 1914 */         b = (byte)(b + (c2 - 'A' + 10));
/*      */       }
/*      */       else
/*      */       {
/* 1918 */         throw new IllegalArgumentException("hexBinary value contains illegal character: " + value);
/*      */       }
/* 1920 */       baos.write(b);
/*      */     }
/* 1922 */     return baos.toByteArray();
/*      */   }
/*      */ 
/*      */   public static String marshalHexBinary(byte[] value)
/*      */   {
/* 1931 */     StringBuffer result = new StringBuffer(2 * value.length);
/* 1932 */     for (int i = 0; i < value.length; i++)
/*      */     {
/* 1934 */       result.append(convertDigit(value[i] >> 4));
/* 1935 */       result.append(convertDigit(value[i] & 0xF));
/*      */     }
/* 1937 */     return result.toString();
/*      */   }
/*      */ 
/*      */   public static boolean isNormalizedString(String value)
/*      */   {
/* 1942 */     for (int i = 0; i < value.length(); i++)
/*      */     {
/* 1944 */       char c = value.charAt(i);
/* 1945 */       if ((c == '\t') || (c == '\n') || (c == '\r'))
/*      */       {
/* 1947 */         return false;
/*      */       }
/*      */     }
/* 1950 */     return true;
/*      */   }
/*      */ 
/*      */   public static byte[] unmarshalBase64(String value)
/*      */   {
/*      */     byte[] valueBytes;
/*      */     try
/*      */     {
/* 1962 */       valueBytes = value.getBytes("UTF-8");
/*      */     }
/*      */     catch (UnsupportedEncodingException e)
/*      */     {
/* 1966 */       valueBytes = value.getBytes();
/*      */     }
/*      */ 
/* 1969 */     return Base64.decode(valueBytes, 0, valueBytes.length);
/*      */   }
/*      */ 
/*      */   public static String marshalBase64(byte[] value)
/*      */   {
/* 1977 */     return Base64.encodeBytes(value);
/*      */   }
/*      */ 
/*      */   public static QName unmarshalQName(String value, NamespaceContext nsRegistry)
/*      */   {
/* 1986 */     if (value.charAt(0) == '{')
/*      */     {
/* 1988 */       int i = value.lastIndexOf('}');
/* 1989 */       if (i == -1)
/* 1990 */         throw new IllegalStateException("Malformed QName: the closing '}' not found in " + value);
/* 1991 */       String nsURI = value.substring(1, i);
/* 1992 */       return new QName(nsURI, value.substring(i + 1));
/*      */     }
/*      */ 
/* 1995 */     int colonIndex = value.lastIndexOf(":");
/* 1996 */     if (colonIndex > 0)
/*      */     {
/* 1998 */       String prefix = value.substring(0, colonIndex);
/* 1999 */       String nsURI = nsRegistry.getNamespaceURI(prefix);
/* 2000 */       if (nsURI == null)
/*      */       {
/* 2002 */         throw new IllegalStateException("No namespace URI registered for prefix: " + prefix);
/*      */       }
/*      */ 
/* 2005 */       String localPart = value.substring(colonIndex + 1);
/* 2006 */       return new QName(nsURI, localPart, prefix);
/*      */     }
/*      */ 
/* 2010 */     return new QName(value);
/*      */   }
/*      */ 
/*      */   public static String marshalQName(QName value, NamespaceContext nsRegistry)
/*      */   {
/* 2020 */     String nsURI = value.getNamespaceURI();
/* 2021 */     if (nsURI.length() > 0)
/*      */     {
/*      */       String prefix;
/* 2024 */       if (nsRegistry != null)
/*      */       {
/* 2026 */         String prefix = nsRegistry.getPrefix(nsURI);
/* 2027 */         if (prefix == null)
/*      */         {
/* 2029 */           return '{' + nsURI + '}' + value.getLocalPart();
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 2035 */         prefix = value.getPrefix();
/*      */       }
/* 2037 */       return prefix.length() > 0 ? prefix + ":" + value.getLocalPart() : value.getLocalPart();
/*      */     }
/*      */ 
/* 2041 */     return value.getLocalPart();
/*      */   }
/*      */ 
/*      */   public static boolean isValidToken(String value)
/*      */   {
/* 2047 */     if ((value != null) && (value.length() > 0))
/*      */     {
/* 2049 */       if ((value.charAt(0) == ' ') || (value.charAt(value.length() - 1) == ' '))
/*      */       {
/* 2051 */         return false;
/*      */       }
/*      */ 
/* 2054 */       for (int i = 0; i < value.length(); i++)
/*      */       {
/* 2056 */         char c = value.charAt(i);
/* 2057 */         if ((c == '\t') || (c == '\n') || (c == '\r'))
/*      */         {
/* 2059 */           return false;
/*      */         }
/* 2061 */         if (c != ' ')
/*      */           continue;
/* 2063 */         if ((i + 1 < value.length()) && (value.charAt(i + 1) == ' '))
/*      */         {
/* 2065 */           return false;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2071 */     return true;
/*      */   }
/*      */ 
/*      */   private static int parseGYear(String value, int start, Calendar cal)
/*      */   {
/* 2076 */     int negative = value.charAt(start) == '-' ? 1 : 0;
/* 2077 */     cal.set(1, Integer.parseInt(value.substring(start, start + 4 + negative)));
/* 2078 */     return start + 4 + negative;
/*      */   }
/*      */ 
/*      */   private static int parseDate(String value, int start, Calendar cal)
/*      */   {
/* 2083 */     if (value.charAt(start) == '-')
/*      */     {
/* 2085 */       start++;
/*      */     }
/*      */ 
/* 2088 */     if (!Character.isDigit(value.charAt(start)))
/*      */     {
/* 2090 */       throw new JBossXBValueFormatException("Date value does not follow the format '-'? yyyy '-' mm '-' dd: " + value);
/*      */     }
/*      */ 
/* 2095 */     int nextToken = value.indexOf('-', start);
/* 2096 */     if ((nextToken == -1) || (nextToken - start < 4))
/*      */     {
/* 2098 */       throw new JBossXBValueFormatException("Date value does not follow the format '-'? yyyy '-' mm '-' dd: " + value);
/*      */     }
/*      */ 
/* 2103 */     int year = Integer.parseInt(value.substring(start, nextToken));
/*      */ 
/* 2105 */     start = nextToken + 1;
/* 2106 */     nextToken = value.indexOf('-', start);
/* 2107 */     if ((nextToken == -1) || (nextToken - start < 2))
/*      */     {
/* 2109 */       throw new JBossXBValueFormatException("Date value does not follow the format '-'? yyyy '-' mm '-' dd: " + value);
/*      */     }
/*      */ 
/* 2114 */     int month = Integer.parseInt(value.substring(start, nextToken));
/*      */ 
/* 2116 */     start = nextToken + 1;
/* 2117 */     nextToken += 3;
/* 2118 */     int day = Integer.parseInt(value.substring(start, nextToken));
/*      */ 
/* 2120 */     cal.set(1, year);
/* 2121 */     cal.set(2, month - 1);
/* 2122 */     cal.set(5, day);
/*      */ 
/* 2124 */     return nextToken;
/*      */   }
/*      */ 
/*      */   private static int parseTime(String value, int start, Calendar cal)
/*      */   {
/* 2136 */     if ((value.charAt(start + 2) != ':') || (value.charAt(start + 5) != ':'))
/*      */     {
/* 2138 */       throw new JBossXBValueFormatException("Time value does not follow the format 'hh:mm:ss.[s+]': " + value);
/*      */     }
/*      */ 
/* 2141 */     int hh = Integer.parseInt(value.substring(start, start + 2));
/* 2142 */     int mm = Integer.parseInt(value.substring(start + 3, start + 5));
/* 2143 */     int ss = Integer.parseInt(value.substring(start + 6, start + 8));
/*      */ 
/* 2145 */     int millis = 0;
/*      */ 
/* 2147 */     int x = start + 8;
/*      */ 
/* 2149 */     if ((value.length() > x) && (value.charAt(x) == '.'))
/*      */     {
/* 2151 */       int mul = 100;
/* 2152 */       for (x++; x < value.length(); x++)
/*      */       {
/* 2154 */         char c = value.charAt(x);
/*      */ 
/* 2156 */         if (!Character.isDigit(c))
/*      */           break;
/* 2158 */         if (mul == 0)
/*      */           continue;
/* 2160 */         millis += Character.digit(c, 10) * mul;
/* 2161 */         mul = mul == 1 ? 0 : mul / 10;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2171 */     cal.set(11, hh);
/* 2172 */     cal.set(12, mm);
/* 2173 */     cal.set(13, ss);
/* 2174 */     cal.set(14, millis);
/*      */ 
/* 2176 */     return x;
/*      */   }
/*      */ 
/*      */   private static TimeZone parseTimeZone(String value, int start)
/*      */   {
/* 2188 */     if ((value.charAt(start) == '+') || (value.charAt(start) == '-'))
/*      */     {
/*      */       TimeZone tz;
/* 2190 */       if ((value.length() - start == 6) && (Character.isDigit(value.charAt(start + 1))) && (Character.isDigit(value.charAt(start + 2))) && (value.charAt(start + 3) == ':') && (Character.isDigit(value.charAt(start + 4))) && (Character.isDigit(value.charAt(start + 5))))
/*      */       {
/* 2197 */         tz = TimeZone.getTimeZone("GMT" + value.substring(start));
/*      */       }
/*      */       else
/*      */       {
/* 2201 */         throw new NumberFormatException("Timezone value does not follow the format ([+/-]HH:MM): " + value.substring(start));
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*      */       TimeZone tz;
/* 2206 */       if (value.charAt(start) == 'Z')
/*      */       {
/* 2208 */         tz = TimeZone.getTimeZone("GMT");
/*      */       }
/*      */       else
/*      */       {
/* 2212 */         throw new NumberFormatException("Timezone value does not follow the format ([+/-]HH:MM): " + value.substring(start));
/*      */       }
/*      */     }
/*      */     TimeZone tz;
/* 2216 */     return tz;
/*      */   }
/*      */ 
/*      */   private static String marshalTimeZone(Calendar value)
/*      */   {
/* 2227 */     int offset = value.get(15) + value.get(16);
/* 2228 */     if (offset == 0)
/*      */     {
/* 2230 */       return "Z";
/*      */     }
/*      */ 
/* 2233 */     DecimalFormat hourFormat = new DecimalFormat("'+'00;-00");
/* 2234 */     DecimalFormat minuteFormat = new DecimalFormat("00");
/*      */ 
/* 2236 */     int minutes = offset / 60000;
/* 2237 */     int hours = minutes / 60;
/*      */ 
/* 2239 */     minutes -= hours * 60;
/*      */ 
/* 2241 */     return hourFormat.format(hours) + ":" + minuteFormat.format(minutes);
/*      */   }
/*      */ 
/*      */   private static String marshalInt(int value, int length)
/*      */   {
/* 2246 */     String result = String.valueOf(value);
/* 2247 */     if (result.length() < length)
/*      */     {
/* 2249 */       while (result.length() < length)
/*      */       {
/* 2251 */         result = '0' + result;
/*      */       }
/*      */     }
/* 2254 */     if (result.length() > length)
/*      */     {
/* 2256 */       throw new JBossXBValueFormatException("Can't marshal int value " + value + " to a string with length of " + length);
/*      */     }
/*      */ 
/* 2260 */     return result;
/*      */   }
/*      */ 
/*      */   private static char convertDigit(int value)
/*      */   {
/* 2265 */     value &= 15;
/* 2266 */     if (value >= 10)
/*      */     {
/* 2268 */       return (char)(value - 10 + 97);
/*      */     }
/*      */ 
/* 2272 */     return (char)(value + 48);
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  278 */     int[] codes = new int[45];
/*  279 */     String[] names = new String[codes.length];
/*  280 */     int i = 0;
/*      */ 
/*  282 */     names[i] = "int";
/*  283 */     codes[(i++)] = XS_INT;
/*      */ 
/*  285 */     names[i] = "long";
/*  286 */     codes[(i++)] = XS_LONG;
/*      */ 
/*  288 */     names[i] = "short";
/*  289 */     codes[(i++)] = XS_SHORT;
/*      */ 
/*  291 */     names[i] = "float";
/*  292 */     codes[(i++)] = XS_FLOAT;
/*      */ 
/*  294 */     names[i] = "double";
/*  295 */     codes[(i++)] = XS_DOUBLE;
/*      */ 
/*  297 */     names[i] = "boolean";
/*  298 */     codes[(i++)] = XS_BOOLEAN;
/*      */ 
/*  300 */     names[i] = "byte";
/*  301 */     codes[(i++)] = XS_BYTE;
/*      */ 
/*  303 */     names[i] = "string";
/*  304 */     codes[(i++)] = XS_STRING;
/*      */ 
/*  306 */     names[i] = "integer";
/*  307 */     codes[(i++)] = XS_INTEGER;
/*      */ 
/*  309 */     names[i] = "decimal";
/*  310 */     codes[(i++)] = XS_DECIMAL;
/*      */ 
/*  312 */     names[i] = "dateTime";
/*  313 */     codes[(i++)] = XS_DATETIME;
/*      */ 
/*  315 */     names[i] = "QName";
/*  316 */     codes[(i++)] = XS_QNAME;
/*      */ 
/*  318 */     names[i] = "anyURI";
/*  319 */     codes[(i++)] = XS_ANYURI;
/*      */ 
/*  321 */     names[i] = "unsignedInt";
/*  322 */     codes[(i++)] = XS_UNSIGNEDINT;
/*      */ 
/*  324 */     names[i] = "unsignedShort";
/*  325 */     codes[(i++)] = XS_UNSIGNEDSHORT;
/*      */ 
/*  327 */     names[i] = "unsignedByte";
/*  328 */     codes[(i++)] = XS_UNSIGNEDBYTE;
/*      */ 
/*  330 */     names[i] = "date";
/*  331 */     codes[(i++)] = XS_DATE;
/*      */ 
/*  333 */     names[i] = "time";
/*  334 */     codes[(i++)] = XS_TIME;
/*      */ 
/*  336 */     names[i] = "base64Binary";
/*  337 */     codes[(i++)] = XS_BASE64BINARY;
/*      */ 
/*  339 */     names[i] = "hexBinary";
/*  340 */     codes[(i++)] = XS_HEXBINARY;
/*      */ 
/*  342 */     names[i] = "anySimpleType";
/*  343 */     codes[(i++)] = XS_ANYSIMPLETYPE;
/*      */ 
/*  345 */     names[i] = "duration";
/*  346 */     codes[(i++)] = XS_DURATION;
/*      */ 
/*  348 */     names[i] = "gYearMonth";
/*  349 */     codes[(i++)] = XS_GYEARMONTH;
/*      */ 
/*  351 */     names[i] = "gYear";
/*  352 */     codes[(i++)] = XS_GYEAR;
/*      */ 
/*  354 */     names[i] = "gMonthDay";
/*  355 */     codes[(i++)] = XS_GMONTHDAY;
/*      */ 
/*  357 */     names[i] = "gMonth";
/*  358 */     codes[(i++)] = XS_GMONTH;
/*      */ 
/*  360 */     names[i] = "gDay";
/*  361 */     codes[(i++)] = XS_GDAY;
/*      */ 
/*  363 */     names[i] = "normalizedString";
/*  364 */     codes[(i++)] = XS_NORMALIZEDSTRING;
/*      */ 
/*  366 */     names[i] = "token";
/*  367 */     codes[(i++)] = XS_TOKEN;
/*      */ 
/*  369 */     names[i] = "language";
/*  370 */     codes[(i++)] = XS_LANGUAGE;
/*      */ 
/*  372 */     names[i] = "Name";
/*  373 */     codes[(i++)] = XS_NAME;
/*      */ 
/*  375 */     names[i] = "NCName";
/*  376 */     codes[(i++)] = XS_NCNAME;
/*      */ 
/*  378 */     names[i] = "ID";
/*  379 */     codes[(i++)] = XS_ID;
/*      */ 
/*  381 */     names[i] = "NMTOKEN";
/*  382 */     codes[(i++)] = XS_NMTOKEN;
/*      */ 
/*  384 */     names[i] = "NMTOKENS";
/*  385 */     codes[(i++)] = XS_NMTOKENS;
/*      */ 
/*  387 */     names[i] = "nonPositiveInteger";
/*  388 */     codes[(i++)] = XS_NONPOSITIVEINTEGER;
/*      */ 
/*  390 */     names[i] = "nonNegativeInteger";
/*  391 */     codes[(i++)] = XS_NONNEGATIVEINTEGER;
/*      */ 
/*  393 */     names[i] = "positiveInteger";
/*  394 */     codes[(i++)] = XS_POSITIVEINTEGER;
/*      */ 
/*  396 */     names[i] = "negativeInteger";
/*  397 */     codes[(i++)] = XS_NEGATIVEINTEGER;
/*      */ 
/*  399 */     names[i] = "unsignedLong";
/*  400 */     codes[(i++)] = XS_UNSIGNEDLONG;
/*      */ 
/*  402 */     names[i] = "NOTATION";
/*  403 */     codes[(i++)] = XS_NOTATION;
/*      */ 
/*  405 */     names[i] = "IDREF";
/*  406 */     codes[(i++)] = XS_IDREF;
/*      */ 
/*  408 */     names[i] = "IDREFS";
/*  409 */     codes[(i++)] = XS_IDREFS;
/*      */ 
/*  411 */     names[i] = "ENTITY";
/*  412 */     codes[(i++)] = XS_ENTITY;
/*      */ 
/*  414 */     names[i] = "ENTITIES";
/*  415 */     codes[(i++)] = XS_ENTITIES;
/*      */ 
/*  417 */     Logger log = Logger.getLogger(SimpleTypeBindings.class);
/*  418 */     boolean allAreUnique = true;
/*  419 */     for (int outer = 0; outer < names.length; outer++)
/*      */     {
/*  421 */       int outerCode = codes[outer];
/*  422 */       String outerName = names[outer];
/*      */ 
/*  424 */       for (int inner = outer + 1; inner < names.length; inner++)
/*      */       {
/*  426 */         int innerCode = codes[inner];
/*  427 */         String innerName = names[inner];
/*      */ 
/*  429 */         if (outerCode != innerCode)
/*      */           continue;
/*  431 */         log.error("Types have the same hash code " + outerCode + ": " + outerName + " and " + innerName);
/*  432 */         allAreUnique = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  437 */     if (!allAreUnique)
/*      */     {
/*  439 */       throw new IllegalStateException("Not all the schema types have unique hash codes! See log for more details.");
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.SimpleTypeBindings
 * JD-Core Version:    0.6.0
 */