/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Date;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.XSImplementation;
/*     */ import org.apache.xerces.xs.XSLoader;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.LSInputAdaptor;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.XsdBinderTerminatingErrorHandler;
/*     */ import org.w3c.dom.DOMConfiguration;
/*     */ import org.w3c.dom.DOMErrorHandler;
/*     */ import org.w3c.dom.bootstrap.DOMImplementationRegistry;
/*     */ import org.w3c.dom.ls.LSInput;
/*     */ import org.w3c.dom.ls.LSResourceResolver;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public final class Util
/*     */ {
/*     */   public static final char HYPHEN_MINUS = '-';
/*     */   public static final char FULL_STOP = '.';
/*     */   public static final char COLLON = ':';
/*     */   public static final char LOW_LINE = '_';
/*     */   public static final char MIDDLE_DOT = '·';
/*     */   public static final char GREEK_ANO_TELEIA = '·';
/*     */   public static final char ARABIC_END_OF_AYAH = '۝';
/*     */   public static final char ARABIC_START_OF_RUB_EL_HIZB = '۞';
/*  70 */   private static final Logger log = Logger.getLogger(Util.class);
/*     */   private static XSImplementation xsImpl;
/*     */ 
/*     */   public static String getPrefixedName(QName qName)
/*     */   {
/*  84 */     String result = "";
/*  85 */     if (qName != null)
/*     */     {
/*  87 */       String prefix = qName.getPrefix();
/*  88 */       if (prefix.length() > 0)
/*     */       {
/*  90 */         result = prefix + ':' + qName.getLocalPart();
/*     */       }
/*     */       else
/*     */       {
/*  94 */         result = qName.getLocalPart();
/*     */       }
/*     */     }
/*  97 */     return result;
/*     */   }
/*     */ 
/*     */   public static String getPrefixedName(QName qName, NamespaceContext nc)
/*     */   {
/* 112 */     String result = "";
/* 113 */     if (qName != null)
/*     */     {
/* 115 */       String prefix = qName.getPrefix();
/* 116 */       if (prefix.length() > 0)
/*     */       {
/* 118 */         result = prefix + ':' + qName.getLocalPart();
/*     */       }
/*     */       else
/*     */       {
/* 122 */         String ns = qName.getNamespaceURI();
/* 123 */         prefix = nc.getPrefix(ns);
/* 124 */         if ((prefix != null) && (prefix.length() > 0))
/*     */         {
/* 126 */           result = prefix + ':' + qName.getLocalPart();
/*     */         }
/*     */         else
/*     */         {
/* 130 */           result = qName.getLocalPart();
/*     */         }
/*     */       }
/*     */     }
/* 134 */     return result;
/*     */   }
/*     */ 
/*     */   public static String xmlNameToClassName(String name, boolean ignoreLowLine)
/*     */   {
/* 149 */     return Util.XMLNameToJavaIdentifierConverter.PARSER.parse(XMLNameToJavaIdentifierConverter.CLASS_NAME, name, ignoreLowLine);
/*     */   }
/*     */ 
/*     */   public static String xmlNameToFieldName(String name, boolean ignoreLowLine)
/*     */   {
/* 157 */     return Util.XMLNameToJavaIdentifierConverter.PARSER.parse(XMLNameToJavaIdentifierConverter.FIELD_NAME, name, ignoreLowLine);
/*     */   }
/*     */ 
/*     */   public static String xmlNameToGetMethodName(String name, boolean ignoreLowLine)
/*     */   {
/* 175 */     return "get" + xmlNameToClassName(name, ignoreLowLine);
/*     */   }
/*     */ 
/*     */   public static String xmlNameToSetMethodName(String name, boolean ignoreLowLine)
/*     */   {
/* 190 */     return "set" + xmlNameToClassName(name, ignoreLowLine);
/*     */   }
/*     */ 
/*     */   public static String xmlNameToConstantName(String name)
/*     */   {
/* 204 */     return Util.XMLNameToJavaIdentifierConverter.PARSER.parse(XMLNameToJavaIdentifierConverter.CONSTANT_NAME, name, true);
/*     */   }
/*     */ 
/*     */   public static String xmlNamespaceToJavaPackage(String namespace)
/*     */   {
/* 219 */     if (namespace.length() == 0)
/*     */     {
/* 221 */       return namespace;
/*     */     }
/*     */ 
/* 224 */     char[] src = namespace.toLowerCase().toCharArray();
/* 225 */     char[] dst = new char[namespace.length()];
/*     */ 
/* 227 */     int srcInd = 0;
/*     */ 
/* 229 */     while (src[(srcInd++)] != ':');
/* 233 */     while (src[srcInd] == '/')
/*     */     {
/* 235 */       srcInd++;
/*     */     }
/*     */ 
/* 239 */     if ((src[srcInd] == 'w') && (src[(srcInd + 1)] == 'w') && (src[(srcInd + 2)] == 'w'))
/*     */     {
/* 241 */       srcInd += 4;
/*     */     }
/*     */ 
/* 245 */     int domainStart = srcInd;
/* 246 */     while ((srcInd < src.length) && (src[srcInd] != '/'))
/*     */     {
/* 248 */       srcInd++;
/*     */     }
/*     */ 
/* 251 */     int dstInd = 0;
/*     */ 
/* 253 */     int start = srcInd - 1; for (int end = srcInd; ; start--)
/*     */     {
/* 255 */       if (start == domainStart)
/*     */       {
/* 257 */         System.arraycopy(src, start, dst, dstInd, end - start);
/* 258 */         dstInd += end - start;
/* 259 */         break;
/*     */       }
/*     */ 
/* 262 */       if (src[start] != '.')
/*     */         continue;
/* 264 */       System.arraycopy(src, start + 1, dst, dstInd, end - start - 1);
/* 265 */       dstInd += end - start;
/* 266 */       dst[(dstInd - 1)] = '.';
/* 267 */       end = start;
/*     */     }
/*     */ 
/* 272 */     while (srcInd < src.length)
/*     */     {
/* 274 */       char c = src[(srcInd++)];
/* 275 */       if (c == '/')
/*     */       {
/* 277 */         if (srcInd < src.length)
/*     */         {
/* 279 */           dst = append(dst, dstInd++, '.');
/* 280 */           if (!Character.isJavaIdentifierStart(src[srcInd]))
/*     */           {
/* 282 */             dst = append(dst, dstInd++, '_');
/*     */           }
/*     */         }
/*     */       } else {
/* 286 */         if (c == '.')
/*     */         {
/*     */           break;
/*     */         }
/*     */ 
/* 293 */         dst = append(dst, dstInd++, Character.isJavaIdentifierPart(c) ? c : '_');
/*     */       }
/*     */     }
/*     */ 
/* 297 */     return String.valueOf(dst, 0, dstInd);
/*     */   }
/*     */ 
/*     */   public static String xmlNameToClassName(String namespaceUri, String localName, boolean ignoreLowLine)
/*     */   {
/* 310 */     return xmlNamespaceToJavaPackage(namespaceUri) + '.' + xmlNameToClassName(localName, ignoreLowLine);
/*     */   }
/*     */ 
/*     */   public static boolean isAttributeType(Class type)
/*     */   {
/* 317 */     return (Classes.isPrimitive(type)) || (type == String.class) || (type == Date.class);
/*     */   }
/*     */ 
/*     */   public static String getSchemaLocation(Attributes attrs, String nsUri)
/*     */   {
/* 330 */     String location = null;
/* 331 */     String schemaLocation = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
/* 332 */     if (schemaLocation != null)
/*     */     {
/* 334 */       StringTokenizer tokenizer = new StringTokenizer(schemaLocation, " \t\n\r");
/* 335 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 337 */         String namespace = tokenizer.nextToken();
/* 338 */         if ((namespace.equals(nsUri)) && (tokenizer.hasMoreTokens()))
/*     */         {
/* 340 */           location = tokenizer.nextToken();
/* 341 */           break;
/*     */         }
/*     */       }
/*     */     }
/* 345 */     return location;
/*     */   }
/*     */ 
/*     */   public static XSModel loadSchema(String xsdURL, SchemaBindingResolver schemaResolver)
/*     */   {
/* 350 */     boolean trace = log.isTraceEnabled();
/* 351 */     long start = System.currentTimeMillis();
/* 352 */     if (trace) {
/* 353 */       log.trace("loading xsd: " + xsdURL);
/*     */     }
/* 355 */     if (xsImpl == null)
/*     */     {
/* 357 */       xsImpl = getXSImplementation();
/*     */     }
/*     */ 
/* 360 */     XSLoader schemaLoader = xsImpl.createXSLoader(null);
/* 361 */     if (schemaResolver != null)
/*     */     {
/* 363 */       setResourceResolver(schemaLoader, schemaResolver);
/*     */     }
/*     */ 
/* 366 */     setDOMErrorHandler(schemaLoader);
/* 367 */     XSModel model = schemaLoader.loadURI(xsdURL);
/* 368 */     if (model == null)
/*     */     {
/* 370 */       throw new IllegalArgumentException("Invalid URI for schema: " + xsdURL);
/*     */     }
/*     */ 
/* 373 */     if (trace)
/* 374 */       log.trace("Loaded xsd: " + xsdURL + " in " + (System.currentTimeMillis() - start) + "ms");
/* 375 */     return model;
/*     */   }
/*     */ 
/*     */   public static XSModel loadSchema(InputStream is, String encoding, SchemaBindingResolver schemaResolver)
/*     */   {
/* 380 */     if (log.isTraceEnabled())
/*     */     {
/* 382 */       log.trace("loading xsd from InputStream");
/*     */     }
/*     */ 
/* 385 */     LSInputAdaptor input = new LSInputAdaptor(is, encoding);
/*     */ 
/* 387 */     XSImplementation impl = getXSImplementation();
/* 388 */     XSLoader schemaLoader = impl.createXSLoader(null);
/* 389 */     setDOMErrorHandler(schemaLoader);
/* 390 */     if (schemaResolver != null)
/*     */     {
/* 392 */       setResourceResolver(schemaLoader, schemaResolver);
/*     */     }
/*     */ 
/* 395 */     return schemaLoader.load(input);
/*     */   }
/*     */ 
/*     */   public static XSModel loadSchema(Reader reader, String encoding, SchemaBindingResolver schemaResolver)
/*     */   {
/* 400 */     if (log.isTraceEnabled())
/*     */     {
/* 402 */       log.trace("loading xsd from Reader");
/*     */     }
/*     */ 
/* 405 */     LSInputAdaptor input = new LSInputAdaptor(reader, encoding);
/*     */ 
/* 407 */     XSImplementation impl = getXSImplementation();
/* 408 */     XSLoader schemaLoader = impl.createXSLoader(null);
/* 409 */     setDOMErrorHandler(schemaLoader);
/* 410 */     if (schemaResolver != null)
/*     */     {
/* 412 */       setResourceResolver(schemaLoader, schemaResolver);
/*     */     }
/*     */ 
/* 415 */     return schemaLoader.load(input);
/*     */   }
/*     */ 
/*     */   public static XSModel loadSchema(String data, String encoding)
/*     */   {
/* 420 */     if (log.isTraceEnabled())
/*     */     {
/* 422 */       log.trace("loading xsd from string");
/*     */     }
/*     */ 
/* 425 */     LSInputAdaptor input = new LSInputAdaptor(data, encoding);
/*     */ 
/* 427 */     XSImplementation impl = getXSImplementation();
/* 428 */     XSLoader schemaLoader = impl.createXSLoader(null);
/* 429 */     setDOMErrorHandler(schemaLoader);
/* 430 */     return schemaLoader.load(input);
/*     */   }
/*     */ 
/*     */   private static char[] append(char[] buf, int index, char ch)
/*     */   {
/* 448 */     if (index >= buf.length)
/*     */     {
/* 450 */       char[] tmp = buf;
/* 451 */       buf = new char[index + 4];
/* 452 */       System.arraycopy(tmp, 0, buf, 0, tmp.length);
/*     */     }
/* 454 */     buf[index] = ch;
/* 455 */     return buf;
/*     */   }
/*     */ 
/*     */   private static void setResourceResolver(XSLoader schemaLoader, SchemaBindingResolver schemaResolver)
/*     */   {
/* 460 */     DOMConfiguration config = schemaLoader.getConfig();
/* 461 */     config.setParameter("resource-resolver", new LSResourceResolver(schemaResolver)
/*     */     {
/*     */       public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI)
/*     */       {
/* 465 */         if ("http://www.w3.org/2001/XMLSchema".equals(type))
/*     */         {
/* 467 */           String schemaLocation = systemId;
/* 468 */           return this.val$schemaResolver.resolveAsLSInput(namespaceURI, baseURI, schemaLocation);
/*     */         }
/* 470 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   private static void setDOMErrorHandler(XSLoader schemaLoader)
/*     */   {
/* 478 */     DOMConfiguration config = schemaLoader.getConfig();
/* 479 */     DOMErrorHandler errorHandler = (DOMErrorHandler)config.getParameter("error-handler");
/* 480 */     if (errorHandler == null)
/*     */     {
/* 482 */       config.setParameter("error-handler", XsdBinderTerminatingErrorHandler.newInstance());
/*     */     }
/*     */   }
/*     */ 
/*     */   private static XSImplementation getXSImplementation()
/*     */   {
/* 488 */     return (XSImplementation)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 494 */         ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */         try
/*     */         {
/* 498 */           String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
/* 499 */           loader.loadClass(name);
/* 500 */           System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/* 505 */           String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
/* 506 */           System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
/*     */         }
/*     */         XSImplementation impl;
/*     */         try
/*     */         {
/* 512 */           DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
/* 513 */           impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 517 */           throw new IllegalStateException("Failed to create schema loader: " + e.getClass().getName() + " " + e.getMessage());
/*     */         }
/* 519 */         return impl;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static abstract interface XMLNameToJavaIdentifierConverter
/*     */   {
/*     */     public static final byte IGNORE = 0;
/*     */     public static final byte APPEND = 1;
/*     */     public static final byte APPEND_WITH_LOW_LINE = 2;
/*     */     public static final byte APPEND_UPPER_CASED = 3;
/*     */     public static final byte APPEND_UPPER_CASED_WITH_LOW_LINE = 4;
/* 642 */     public static final XMLNameToJavaIdentifierConverter CLASS_NAME = new XMLNameToJavaIdentifierConverter()
/*     */     {
/*     */       public char firstCharacter(char ch, String str, int secondCharIndex)
/*     */       {
/* 646 */         return Character.toUpperCase(ch);
/*     */       }
/*     */ 
/*     */       public byte commandForNext(char prev, char next, boolean ignoreLowLine)
/*     */       {
/*     */         byte command;
/*     */         byte command;
/* 652 */         if (Character.isDigit(next))
/*     */         {
/* 654 */           command = 1;
/*     */         }
/*     */         else
/*     */         {
/*     */           byte command;
/* 656 */           if (next == '_')
/*     */           {
/* 658 */             command = ignoreLowLine ? 0 : 1;
/*     */           }
/*     */           else
/*     */           {
/*     */             byte command;
/* 660 */             if (Character.isJavaIdentifierPart(next))
/*     */             {
/*     */               byte command;
/* 662 */               if ((Character.isJavaIdentifierPart(prev)) && (!Character.isDigit(prev)))
/*     */               {
/* 664 */                 command = prev == '_' ? 3 : 1;
/*     */               }
/*     */               else
/*     */               {
/* 668 */                 command = 3;
/*     */               }
/*     */             }
/*     */             else
/*     */             {
/* 673 */               command = 0;
/*     */             }
/*     */           }
/*     */         }
/* 675 */         return command;
/*     */       }
/* 642 */     };
/*     */ 
/* 682 */     public static final XMLNameToJavaIdentifierConverter FIELD_NAME = new XMLNameToJavaIdentifierConverter()
/*     */     {
/*     */       public char firstCharacter(char ch, String str, int secondCharIndex)
/*     */       {
/* 686 */         if (Character.isLowerCase(ch))
/*     */         {
/* 688 */           return ch;
/*     */         }
/*     */ 
/* 692 */         return (str.length() > secondCharIndex) && (Character.isJavaIdentifierPart(str.charAt(secondCharIndex))) && (Character.isUpperCase(str.charAt(secondCharIndex))) ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
/*     */       }
/*     */ 
/*     */       public byte commandForNext(char prev, char next, boolean ignoreLowLine)
/*     */       {
/* 703 */         return CLASS_NAME.commandForNext(prev, next, ignoreLowLine);
/*     */       }
/* 682 */     };
/*     */ 
/* 710 */     public static final XMLNameToJavaIdentifierConverter CONSTANT_NAME = new XMLNameToJavaIdentifierConverter()
/*     */     {
/*     */       public char firstCharacter(char ch, String str, int secondCharIndex)
/*     */       {
/* 714 */         return Character.toUpperCase(ch);
/*     */       }
/*     */ 
/*     */       public byte commandForNext(char prev, char next, boolean ignoreLowLine)
/*     */       {
/*     */         byte command;
/*     */         byte command;
/* 720 */         if (Character.isDigit(next))
/*     */         {
/* 722 */           command = Character.isDigit(prev) ? 1 : 4;
/*     */         }
/*     */         else
/*     */         {
/*     */           byte command;
/* 724 */           if (Character.isJavaIdentifierPart(next))
/*     */           {
/*     */             byte command;
/* 726 */             if (Character.isDigit(prev))
/*     */             {
/* 728 */               command = 4;
/*     */             }
/*     */             else
/*     */             {
/*     */               byte command;
/* 730 */               if (Character.isJavaIdentifierPart(prev))
/*     */               {
/* 732 */                 command = Character.isUpperCase(next) ? 2 : Character.isUpperCase(prev) ? 3 : 3;
/*     */               }
/*     */               else
/*     */               {
/* 738 */                 command = 4;
/*     */               }
/*     */             }
/*     */           }
/*     */           else {
/* 743 */             command = 0;
/*     */           }
/*     */         }
/* 745 */         return command;
/*     */       }
/* 710 */     };
/*     */ 
/*     */     public abstract byte commandForNext(char paramChar1, char paramChar2, boolean paramBoolean);
/*     */ 
/*     */     public abstract char firstCharacter(char paramChar, String paramString, int paramInt);
/*     */ 
/*     */     public static final class PARSER
/*     */     {
/*     */       static String parse(Util.XMLNameToJavaIdentifierConverter converter, String xmlName, boolean ignoreLowLine)
/*     */       {
/* 578 */         if ((xmlName == null) || (xmlName.length() == 0))
/*     */         {
/* 580 */           throw new IllegalArgumentException("Bad XML name: " + xmlName);
/*     */         }
/*     */ 
/* 583 */         char c = xmlName.charAt(0);
/* 584 */         int i = 1;
/* 585 */         if ((!Character.isJavaIdentifierStart(c)) || ((c == '_') && (ignoreLowLine)))
/*     */         {
/* 587 */           while (i < xmlName.length())
/*     */           {
/* 589 */             c = xmlName.charAt(i++);
/* 590 */             if (!Character.isJavaIdentifierStart(c)) continue; if (c != '_') break; if (ignoreLowLine)
/*     */             {
/*     */               continue;
/*     */             }
/*     */           }
/*     */ 
/* 596 */           if (i == xmlName.length())
/*     */           {
/* 598 */             throw new IllegalArgumentException("XML name contains no valid character to start Java identifier: " + xmlName);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 604 */         char[] buf = new char[xmlName.length() - i + 1];
/* 605 */         buf[0] = converter.firstCharacter(c, xmlName, i);
/* 606 */         int bufInd = 1;
/* 607 */         while (i < xmlName.length())
/*     */         {
/* 609 */           char prev = c;
/* 610 */           c = xmlName.charAt(i++);
/* 611 */           byte command = converter.commandForNext(prev, c, ignoreLowLine);
/* 612 */           switch (command)
/*     */           {
/*     */           case 0:
/* 615 */             break;
/*     */           case 1:
/* 617 */             buf = Util.access$000(buf, bufInd++, c);
/* 618 */             break;
/*     */           case 2:
/* 620 */             buf = Util.access$000(buf, bufInd++, '_');
/* 621 */             buf = Util.access$000(buf, bufInd++, c);
/* 622 */             break;
/*     */           case 3:
/* 624 */             buf = Util.access$000(buf, bufInd++, Character.toUpperCase(c));
/* 625 */             break;
/*     */           case 4:
/* 627 */             buf = Util.access$000(buf, bufInd++, '_');
/* 628 */             buf = Util.access$000(buf, bufInd++, Character.toUpperCase(c));
/* 629 */             break;
/*     */           default:
/* 631 */             throw new IllegalArgumentException("Unexpected command: " + command);
/*     */           }
/*     */         }
/*     */ 
/* 635 */         return new String(buf, 0, bufInd);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.Util
 * JD-Core Version:    0.6.0
 */