/*    */ package org.jboss.xb.binding.sunday.unmarshalling;
/*    */ 
/*    */ import javax.xml.namespace.NamespaceContext;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*    */ import org.xml.sax.Attributes;
/*    */ 
/*    */ public class AttributesHandler
/*    */ {
/* 37 */   private static final Logger log = Logger.getLogger(AttributesHandler.class);
/*    */ 
/* 39 */   public static final AttributesHandler INSTANCE = new AttributesHandler();
/*    */ 
/*    */   public void attributes(Object o, QName elementName, TypeBinding type, Attributes attrs, NamespaceContext nsCtx)
/*    */   {
/* 43 */     for (int i = 0; i < attrs.getLength(); i++)
/*    */     {
/* 45 */       QName qName = new QName(attrs.getURI(i), attrs.getLocalName(i));
/* 46 */       AttributeBinding binding = type.getAttribute(qName);
/* 47 */       if (binding != null)
/*    */       {
/* 49 */         AttributeHandler handler = binding.getHandler();
/* 50 */         Object value = handler.unmarshal(elementName, qName, binding, nsCtx, attrs.getValue(i));
/* 51 */         handler.attribute(elementName, qName, binding, o, value);
/*    */       } else {
/* 53 */         if ("http://www.w3.org/2001/XMLSchema-instance".equals(qName.getNamespaceURI()))
/*    */           continue;
/* 55 */         SchemaBinding schemaBinding = type.getSchemaBinding();
/* 56 */         if ((schemaBinding != null) && (schemaBinding.isStrictSchema()))
/*    */         {
/* 58 */           throw new JBossXBRuntimeException("Attribute is not bound: element owner " + elementName + ", attribute " + qName);
/*    */         }
/*    */ 
/* 62 */         if (!log.isTraceEnabled())
/*    */           continue;
/* 64 */         log.trace("Attribute is not bound: element owner " + elementName + ", attribute " + qName);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.AttributesHandler
 * JD-Core Version:    0.6.0
 */