/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ public class ParticleBinding
/*     */ {
/*     */   private TermBinding term;
/*  31 */   private int minOccurs = 1;
/*  32 */   private int maxOccurs = 1;
/*     */   private boolean maxOccursUnbounded;
/*     */ 
/*     */   public ParticleBinding(TermBinding term, int minOccurs, int maxOccurs, boolean maxOccursUnbounded)
/*     */   {
/*  37 */     this.term = term;
/*  38 */     this.minOccurs = minOccurs;
/*  39 */     this.maxOccurs = maxOccurs;
/*  40 */     this.maxOccursUnbounded = maxOccursUnbounded;
/*     */   }
/*     */ 
/*     */   public ParticleBinding(TermBinding term)
/*     */   {
/*  45 */     this.term = term;
/*     */   }
/*     */ 
/*     */   public int getMinOccurs()
/*     */   {
/*  50 */     return this.minOccurs;
/*     */   }
/*     */ 
/*     */   public int getMaxOccurs()
/*     */   {
/*  55 */     return this.maxOccurs;
/*     */   }
/*     */ 
/*     */   public boolean getMaxOccursUnbounded()
/*     */   {
/*  60 */     return this.maxOccursUnbounded;
/*     */   }
/*     */ 
/*     */   public void setMinOccurs(int minOccurs)
/*     */   {
/*  65 */     this.minOccurs = minOccurs;
/*     */   }
/*     */ 
/*     */   public void setMaxOccurs(int maxOccurs)
/*     */   {
/*  70 */     this.maxOccurs = maxOccurs;
/*     */   }
/*     */ 
/*     */   public void setMaxOccursUnbounded(boolean maxOccursUnbounded)
/*     */   {
/*  75 */     this.maxOccursUnbounded = maxOccursUnbounded;
/*     */   }
/*     */ 
/*     */   public TermBinding getTerm()
/*     */   {
/*  80 */     return this.term;
/*     */   }
/*     */ 
/*     */   public void setTerm(TermBinding term)
/*     */   {
/*  85 */     this.term = term;
/*     */   }
/*     */ 
/*     */   public boolean isRepeatable()
/*     */   {
/*  90 */     return (this.maxOccursUnbounded) || (this.maxOccurs > 1) || (this.minOccurs > 1);
/*     */   }
/*     */ 
/*     */   public boolean isRequired()
/*     */   {
/*  95 */     return isRequired(0);
/*     */   }
/*     */ 
/*     */   public boolean isRequired(int occurs)
/*     */   {
/* 100 */     return (this.minOccurs > occurs) && ((!this.term.isModelGroup()) || (((ModelGroupBinding)this.term).hasRequiredParticle()));
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 105 */     return "[" + this.term.toString() + ", minOccurs=" + this.minOccurs + ", maxOccurs=" + (this.maxOccursUnbounded ? "unbounded" : String.valueOf(this.maxOccurs)) + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding
 * JD-Core Version:    0.6.0
 */