/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.util.Calendar;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.Constants;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.metadata.PackageMetaData;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;
/*     */ import org.jboss.xb.util.DomCharactersHandler;
/*     */ import org.jboss.xb.util.DomLocalMarshaller;
/*     */ import org.jboss.xb.util.DomParticleHandler;
/*     */ 
/*     */ public class SchemaBinding
/*     */ {
/*  50 */   private static final ValueAdapter DATE_ADAPTER = new ValueAdapter()
/*     */   {
/*     */     public Object cast(Object o, Class c)
/*     */     {
/*  54 */       if ((o != null) && (Date.class.isAssignableFrom(c)))
/*     */       {
/*  56 */         o = ((Calendar)o).getTime();
/*     */       }
/*  58 */       return o; }  } ;
/*     */ 
/*  63 */   private Set namespaces = Collections.EMPTY_SET;
/*     */ 
/*  65 */   private Map<String, String> nsByPrefix = Collections.emptyMap();
/*     */ 
/*  67 */   private Map<QName, TypeBinding> types = new HashMap();
/*     */ 
/*  69 */   private Map<QName, ParticleBinding> elements = new HashMap();
/*     */ 
/*  71 */   private Map<QName, ModelGroupBinding> groups = new HashMap();
/*     */   private PackageMetaData packageMetaData;
/*     */   private SchemaBindingResolver schemaResolver;
/*  77 */   private boolean strictSchema = true;
/*     */ 
/*  79 */   private boolean ignoreUnresolvedFieldOrClass = true;
/*     */ 
/*  81 */   private boolean ignoreLowLine = true;
/*     */ 
/*  83 */   private boolean replacePropertyRefs = true;
/*     */   private boolean unmarshalListsToArrays;
/*     */   private boolean useNoArgCtorIfFound;
/*  89 */   private String simpleContentProperty = "value";
/*     */ 
/*  94 */   private boolean ignoreWhitespacesInMixedContent = true;
/*     */   private XOPUnmarshaller xopUnmarshaller;
/*     */   private XOPMarshaller xopMarshaller;
/*     */ 
/* 103 */   public SchemaBinding() { addType(new SimpleTypeBinding(Constants.QNAME_ANYSIMPLETYPE));
/* 104 */     addType(new SimpleTypeBinding(Constants.QNAME_STRING));
/* 105 */     addType(new SimpleTypeBinding(Constants.QNAME_BOOLEAN));
/* 106 */     addType(new SimpleTypeBinding(Constants.QNAME_DECIMAL));
/* 107 */     addType(new SimpleTypeBinding(Constants.QNAME_FLOAT));
/* 108 */     addType(new SimpleTypeBinding(Constants.QNAME_DOUBLE));
/* 109 */     addType(new SimpleTypeBinding(Constants.QNAME_DURATION));
/* 110 */     addType(new SimpleTypeBinding(Constants.QNAME_DATETIME, DATE_ADAPTER));
/* 111 */     addType(new SimpleTypeBinding(Constants.QNAME_TIME, DATE_ADAPTER));
/* 112 */     addType(new SimpleTypeBinding(Constants.QNAME_DATE, DATE_ADAPTER));
/* 113 */     addType(new SimpleTypeBinding(Constants.QNAME_GYEARMONTH));
/* 114 */     addType(new SimpleTypeBinding(Constants.QNAME_GYEAR));
/* 115 */     addType(new SimpleTypeBinding(Constants.QNAME_GMONTHDAY));
/* 116 */     addType(new SimpleTypeBinding(Constants.QNAME_GDAY));
/* 117 */     addType(new SimpleTypeBinding(Constants.QNAME_GMONTH));
/* 118 */     addType(new SimpleTypeBinding(Constants.QNAME_HEXBINARY));
/* 119 */     addType(new SimpleTypeBinding(Constants.QNAME_BASE64BINARY));
/* 120 */     addType(new SimpleTypeBinding(Constants.QNAME_ANYURI));
/* 121 */     addType(new SimpleTypeBinding(Constants.QNAME_QNAME));
/* 122 */     addType(new SimpleTypeBinding(Constants.QNAME_NOTATION));
/* 123 */     addType(new SimpleTypeBinding(Constants.QNAME_NORMALIZEDSTRING));
/* 124 */     addType(new SimpleTypeBinding(Constants.QNAME_TOKEN));
/* 125 */     addType(new SimpleTypeBinding(Constants.QNAME_LANGUAGE));
/* 126 */     addType(new SimpleTypeBinding(Constants.QNAME_NMTOKEN));
/* 127 */     addType(new SimpleTypeBinding(Constants.QNAME_NMTOKENS));
/* 128 */     addType(new SimpleTypeBinding(Constants.QNAME_NAME));
/* 129 */     addType(new SimpleTypeBinding(Constants.QNAME_NCNAME));
/* 130 */     addType(new SimpleTypeBinding(Constants.QNAME_ID));
/* 131 */     addType(new SimpleTypeBinding(Constants.QNAME_IDREF));
/* 132 */     addType(new SimpleTypeBinding(Constants.QNAME_IDREFS));
/* 133 */     addType(new SimpleTypeBinding(Constants.QNAME_ENTITY));
/* 134 */     addType(new SimpleTypeBinding(Constants.QNAME_ENTITIES));
/* 135 */     addType(new SimpleTypeBinding(Constants.QNAME_INTEGER));
/* 136 */     addType(new SimpleTypeBinding(Constants.QNAME_NONPOSITIVEINTEGER));
/* 137 */     addType(new SimpleTypeBinding(Constants.QNAME_NEGATIVEINTEGER));
/* 138 */     addType(new SimpleTypeBinding(Constants.QNAME_LONG));
/* 139 */     addType(new SimpleTypeBinding(Constants.QNAME_INT));
/* 140 */     addType(new SimpleTypeBinding(Constants.QNAME_SHORT));
/* 141 */     addType(new SimpleTypeBinding(Constants.QNAME_BYTE));
/* 142 */     addType(new SimpleTypeBinding(Constants.QNAME_NONNEGATIVEINTEGER));
/* 143 */     addType(new SimpleTypeBinding(Constants.QNAME_UNSIGNEDLONG));
/* 144 */     addType(new SimpleTypeBinding(Constants.QNAME_UNSIGNEDINT));
/* 145 */     addType(new SimpleTypeBinding(Constants.QNAME_UNSIGNEDSHORT));
/* 146 */     addType(new SimpleTypeBinding(Constants.QNAME_UNSIGNEDBYTE));
/* 147 */     addType(new SimpleTypeBinding(Constants.QNAME_POSITIVEINTEGER));
/*     */   }
/*     */ 
/*     */   public void addPrefixMapping(String prefix, String ns)
/*     */   {
/* 152 */     if (this.nsByPrefix == Collections.EMPTY_MAP)
/*     */     {
/* 154 */       this.nsByPrefix = Collections.singletonMap(prefix, ns);
/*     */     }
/*     */     else
/*     */     {
/* 158 */       if (this.nsByPrefix.size() == 1)
/*     */       {
/* 160 */         this.nsByPrefix = new HashMap(this.nsByPrefix);
/*     */       }
/* 162 */       this.nsByPrefix.put(prefix, ns);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getNamespace(String prefix)
/*     */   {
/* 168 */     return (String)this.nsByPrefix.get(prefix);
/*     */   }
/*     */ 
/*     */   public Set getNamespaces()
/*     */   {
/* 178 */     return this.namespaces;
/*     */   }
/*     */ 
/*     */   public void setNamespaces(Set namespaces)
/*     */   {
/* 189 */     if (namespaces == null)
/* 190 */       throw new IllegalArgumentException("Null namespaces");
/* 191 */     this.namespaces = namespaces;
/*     */   }
/*     */ 
/*     */   public TypeBinding getType(QName qName)
/*     */   {
/* 196 */     return (TypeBinding)this.types.get(qName);
/*     */   }
/*     */ 
/*     */   public void addType(TypeBinding type)
/*     */   {
/* 201 */     QName qName = type.getQName();
/* 202 */     if (qName == null)
/*     */     {
/* 204 */       throw new JBossXBRuntimeException("Global type must have a name.");
/*     */     }
/* 206 */     this.types.put(qName, type);
/*     */   }
/*     */ 
/*     */   public ElementBinding getElement(QName name)
/*     */   {
/* 211 */     ParticleBinding particle = (ParticleBinding)this.elements.get(name);
/* 212 */     ElementBinding element = (ElementBinding)(particle == null ? null : particle.getTerm());
/* 213 */     return element;
/*     */   }
/*     */ 
/*     */   public ParticleBinding getElementParticle(QName name)
/*     */   {
/* 218 */     return (ParticleBinding)this.elements.get(name);
/*     */   }
/*     */ 
/*     */   public void addElement(ElementBinding element)
/*     */   {
/* 223 */     ParticleBinding particle = new ParticleBinding(element);
/* 224 */     this.elements.put(element.getQName(), particle);
/*     */   }
/*     */ 
/*     */   public ElementBinding addElement(QName name, TypeBinding type)
/*     */   {
/* 229 */     ElementBinding element = new ElementBinding(this, name, type);
/* 230 */     addElement(element);
/* 231 */     return element;
/*     */   }
/*     */ 
/*     */   public Iterator getElements()
/*     */   {
/* 236 */     return new Iterator()
/*     */     {
/* 238 */       private Iterator<ParticleBinding> particleIterator = SchemaBinding.this.elements.values().iterator();
/*     */ 
/*     */       public boolean hasNext()
/*     */       {
/* 242 */         return this.particleIterator.hasNext();
/*     */       }
/*     */ 
/*     */       public Object next()
/*     */       {
/* 247 */         ParticleBinding particle = (ParticleBinding)this.particleIterator.next();
/* 248 */         return particle.getTerm();
/*     */       }
/*     */ 
/*     */       public void remove()
/*     */       {
/* 253 */         throw new UnsupportedOperationException("remove is not implemented.");
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public Iterator<ParticleBinding> getElementParticles() {
/* 260 */     return this.elements.values().iterator();
/*     */   }
/*     */ 
/*     */   public Iterator<TypeBinding> getTypes()
/*     */   {
/* 265 */     return Collections.unmodifiableCollection(this.types.values()).iterator();
/*     */   }
/*     */ 
/*     */   public ModelGroupBinding getGroup(QName name)
/*     */   {
/* 270 */     return (ModelGroupBinding)this.groups.get(name);
/*     */   }
/*     */ 
/*     */   public void addGroup(QName name, ModelGroupBinding group)
/*     */   {
/* 275 */     this.groups.put(name, group);
/*     */   }
/*     */ 
/*     */   public Iterator<ModelGroupBinding> getGroups()
/*     */   {
/* 280 */     return this.groups.values().iterator();
/*     */   }
/*     */ 
/*     */   public PackageMetaData getPackageMetaData()
/*     */   {
/* 285 */     return this.packageMetaData;
/*     */   }
/*     */ 
/*     */   public void setPackageMetaData(PackageMetaData packageMetaData)
/*     */   {
/* 290 */     this.packageMetaData = packageMetaData;
/*     */   }
/*     */ 
/*     */   public SchemaBindingResolver getSchemaResolver()
/*     */   {
/* 295 */     return this.schemaResolver;
/*     */   }
/*     */ 
/*     */   public void setSchemaResolver(SchemaBindingResolver schemaResolver)
/*     */   {
/* 300 */     this.schemaResolver = schemaResolver;
/*     */   }
/*     */ 
/*     */   public boolean isStrictSchema()
/*     */   {
/* 305 */     return this.strictSchema;
/*     */   }
/*     */ 
/*     */   public void setStrictSchema(boolean strictSchema)
/*     */   {
/* 315 */     this.strictSchema = strictSchema;
/*     */   }
/*     */ 
/*     */   public boolean isIgnoreUnresolvedFieldOrClass()
/*     */   {
/* 320 */     return this.ignoreUnresolvedFieldOrClass;
/*     */   }
/*     */ 
/*     */   public void setIgnoreUnresolvedFieldOrClass(boolean ignoreUnresolvedFieldOrClass)
/*     */   {
/* 331 */     this.ignoreUnresolvedFieldOrClass = ignoreUnresolvedFieldOrClass;
/*     */   }
/*     */ 
/*     */   public boolean isReplacePropertyRefs()
/*     */   {
/* 336 */     return this.replacePropertyRefs;
/*     */   }
/*     */ 
/*     */   public void setReplacePropertyRefs(boolean flag)
/*     */   {
/* 344 */     this.replacePropertyRefs = flag;
/*     */   }
/*     */ 
/*     */   public boolean isIgnoreLowLine()
/*     */   {
/* 349 */     return this.ignoreLowLine;
/*     */   }
/*     */ 
/*     */   public void setIgnoreLowLine(boolean ignoreLowLine)
/*     */   {
/* 358 */     this.ignoreLowLine = ignoreLowLine;
/*     */   }
/*     */ 
/*     */   public boolean isUnmarshalListsToArrays()
/*     */   {
/* 363 */     return this.unmarshalListsToArrays;
/*     */   }
/*     */ 
/*     */   public void setUnmarshalListsToArrays(boolean unmarshalListsToArrays)
/*     */   {
/* 372 */     this.unmarshalListsToArrays = unmarshalListsToArrays;
/*     */   }
/*     */ 
/*     */   public boolean isUseNoArgCtorIfFound()
/*     */   {
/* 377 */     return this.useNoArgCtorIfFound;
/*     */   }
/*     */ 
/*     */   public void setUseNoArgCtorIfFound(boolean useNoArgCtorIfFound)
/*     */   {
/* 386 */     this.useNoArgCtorIfFound = useNoArgCtorIfFound;
/*     */   }
/*     */ 
/*     */   public String getSimpleContentProperty()
/*     */   {
/* 391 */     return this.simpleContentProperty;
/*     */   }
/*     */ 
/*     */   public void setSimpleContentProperty(String simpleContentProperty)
/*     */   {
/* 400 */     this.simpleContentProperty = simpleContentProperty;
/*     */   }
/*     */ 
/*     */   public XOPUnmarshaller getXopUnmarshaller()
/*     */   {
/* 408 */     return this.xopUnmarshaller;
/*     */   }
/*     */ 
/*     */   public void setXopUnmarshaller(XOPUnmarshaller xopUnmarshaller)
/*     */   {
/* 416 */     this.xopUnmarshaller = xopUnmarshaller;
/*     */   }
/*     */ 
/*     */   public XOPMarshaller getXopMarshaller()
/*     */   {
/* 424 */     return this.xopMarshaller;
/*     */   }
/*     */ 
/*     */   public void setXopMarshaller(XOPMarshaller xopMarshaller)
/*     */   {
/* 432 */     this.xopMarshaller = xopMarshaller;
/*     */   }
/*     */ 
/*     */   public void setUnresolvedContentBoundToDOM(boolean toDom)
/*     */   {
/* 437 */     TypeBinding type = getType(Constants.QNAME_ANYTYPE);
/* 438 */     if (type == null)
/*     */     {
/* 441 */       return;
/*     */     }
/*     */ 
/* 445 */     WildcardBinding wildcard = type.getWildcard();
/* 446 */     if (toDom)
/*     */     {
/* 448 */       wildcard.setUnresolvedCharactersHandler(DomCharactersHandler.INSTANCE);
/* 449 */       wildcard.setUnresolvedElementHandler(DomParticleHandler.INSTANCE);
/* 450 */       wildcard.setUnresolvedMarshaller(DomLocalMarshaller.INSTANCE);
/*     */     }
/*     */     else
/*     */     {
/* 454 */       wildcard.setUnresolvedCharactersHandler(null);
/* 455 */       wildcard.setUnresolvedElementHandler(null);
/* 456 */       wildcard.setUnresolvedMarshaller(null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isUnresolvedContentBoundToDOM()
/*     */   {
/* 462 */     TypeBinding type = getType(Constants.QNAME_ANYTYPE);
/* 463 */     if (type == null)
/*     */     {
/* 466 */       return false;
/*     */     }
/*     */ 
/* 470 */     WildcardBinding wildcard = type.getWildcard();
/* 471 */     return ((wildcard.getUnresolvedCharactersHandler() instanceof DomCharactersHandler)) && ((wildcard.getUnresolvedElementHandler() instanceof DomParticleHandler)) && ((wildcard.getUnresolvedMarshaller() instanceof DomLocalMarshaller));
/*     */   }
/*     */ 
/*     */   public boolean isIgnoreWhitespacesInMixedContent()
/*     */   {
/* 478 */     return this.ignoreWhitespacesInMixedContent;
/*     */   }
/*     */ 
/*     */   public void setIgnoreWhitespacesInMixedContent(boolean value)
/*     */   {
/* 483 */     this.ignoreWhitespacesInMixedContent = value;
/*     */   }
/*     */ 
/*     */   void addElementParticle(ParticleBinding particle)
/*     */   {
/* 488 */     ElementBinding element = (ElementBinding)particle.getTerm();
/* 489 */     this.elements.put(element.getQName(), particle);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding
 * JD-Core Version:    0.6.0
 */