/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class SchemaResolverConfig
/*     */   implements SchemaResolverConfigMBean
/*     */ {
/*  41 */   private static final Logger log = Logger.getLogger(SchemaResolverConfig.class);
/*     */ 
/*  44 */   protected static DefaultSchemaResolver resolver = (DefaultSchemaResolver)SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
/*     */   protected Properties schemaInitializers;
/*     */   protected Properties schemaLocations;
/*     */   protected Properties parseAnnotations;
/*     */   protected Properties bindingClasses;
/*     */   protected Properties bindingClassesByLocation;
/*     */ 
/*     */   public boolean getCacheResolvedSchemas()
/*     */   {
/*  63 */     return resolver.isCacheResolvedSchemas();
/*     */   }
/*     */ 
/*     */   public void setCacheResolvedSchemas(boolean flag) {
/*  67 */     resolver.setCacheResolvedSchemas(flag);
/*     */   }
/*     */ 
/*     */   public Properties getSchemaInitializers()
/*     */   {
/*  72 */     return this.schemaInitializers;
/*     */   }
/*     */ 
/*     */   public void setSchemaInitializers(Properties schemaInitializers)
/*     */   {
/*  77 */     this.schemaInitializers = schemaInitializers;
/*     */     Iterator i;
/*  78 */     if ((schemaInitializers != null) && (schemaInitializers.size() != 0))
/*     */     {
/*  80 */       for (i = schemaInitializers.entrySet().iterator(); i.hasNext(); )
/*     */       {
/*  82 */         Map.Entry entry = (Map.Entry)i.next();
/*  83 */         String namespace = (String)entry.getKey();
/*  84 */         String initializer = (String)entry.getValue();
/*     */         try
/*     */         {
/*  87 */           resolver.addSchemaInitializer(namespace, initializer);
/*     */         }
/*     */         catch (Exception ignored)
/*     */         {
/*  91 */           log.debug("Ignored: ", ignored);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Properties getSchemaLocations()
/*     */   {
/*  99 */     return this.schemaLocations;
/*     */   }
/*     */ 
/*     */   public void setSchemaLocations(Properties schemaLocations)
/*     */   {
/* 104 */     this.schemaLocations = schemaLocations;
/*     */     Iterator i;
/* 105 */     if ((schemaLocations != null) && (schemaLocations.size() != 0))
/*     */     {
/* 107 */       for (i = schemaLocations.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 109 */         Map.Entry entry = (Map.Entry)i.next();
/* 110 */         String namespace = (String)entry.getKey();
/* 111 */         String location = (String)entry.getValue();
/* 112 */         resolver.addSchemaLocation(namespace, location);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Properties getParseAnnotations()
/*     */   {
/* 119 */     return this.parseAnnotations;
/*     */   }
/*     */ 
/*     */   public void setParseAnnotations(Properties parseAnnotations)
/*     */   {
/* 124 */     this.parseAnnotations = parseAnnotations;
/*     */     Iterator i;
/* 125 */     if ((parseAnnotations != null) && (parseAnnotations.size() != 0))
/*     */     {
/* 127 */       for (i = parseAnnotations.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 129 */         Map.Entry entry = (Map.Entry)i.next();
/* 130 */         String namespace = (String)entry.getKey();
/* 131 */         String value = (String)entry.getValue();
/* 132 */         Boolean booleanValue = Boolean.valueOf(value);
/* 133 */         resolver.addSchemaParseAnnotations(namespace, booleanValue);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Properties getBindingClassesByLocations()
/*     */   {
/* 140 */     return this.bindingClassesByLocation;
/*     */   }
/*     */ 
/*     */   public void setBindingClassesByLocations(Properties bindingClassesByLocation)
/*     */   {
/* 145 */     this.bindingClassesByLocation = bindingClassesByLocation;
/*     */     ClassLoader loader;
/*     */     Iterator i;
/* 146 */     if ((bindingClassesByLocation != null) && (bindingClassesByLocation.size() != 0))
/*     */     {
/* 148 */       loader = Thread.currentThread().getContextClassLoader();
/* 149 */       for (i = bindingClassesByLocation.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 151 */         Map.Entry entry = (Map.Entry)i.next();
/* 152 */         String schemaLocation = (String)entry.getKey();
/* 153 */         String value = (String)entry.getValue();
/*     */         try
/*     */         {
/* 156 */           Class clazz = loader.loadClass(value);
/* 157 */           resolver.addClassBindingForLocation(schemaLocation, clazz);
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/* 161 */           log.warn("Failed to load class: " + value, e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Properties getBindingClasses()
/*     */   {
/* 169 */     return this.bindingClasses;
/*     */   }
/*     */ 
/*     */   public void setBindingClasses(Properties bindingClasses)
/*     */   {
/* 174 */     this.bindingClasses = bindingClasses;
/*     */     ClassLoader loader;
/*     */     Iterator i;
/* 175 */     if ((bindingClasses != null) && (bindingClasses.size() != 0))
/*     */     {
/* 177 */       loader = Thread.currentThread().getContextClassLoader();
/* 178 */       for (i = bindingClasses.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 180 */         Map.Entry entry = (Map.Entry)i.next();
/* 181 */         String namespace = (String)entry.getKey();
/* 182 */         String value = (String)entry.getValue();
/*     */         try
/*     */         {
/* 185 */           Class clazz = loader.loadClass(value);
/* 186 */           resolver.addClassBinding(namespace, clazz);
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/* 190 */           log.warn("Failed to load class: " + value, e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.SchemaResolverConfig
 * JD-Core Version:    0.6.0
 */