/*      */ package org.jboss.xb.binding.sunday.unmarshalling;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.List;
/*      */ import java.util.ListIterator;
/*      */ import javax.xml.namespace.QName;
/*      */ import org.apache.xerces.xs.XSTypeDefinition;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.util.StringPropertyReplacer;
/*      */ import org.jboss.xb.binding.Constants;
/*      */ import org.jboss.xb.binding.GenericValueContainer;
/*      */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*      */ import org.jboss.xb.binding.NamespaceRegistry;
/*      */ import org.jboss.xb.binding.Util;
/*      */ import org.jboss.xb.binding.group.ValueList;
/*      */ import org.jboss.xb.binding.group.ValueList.NonRequiredValue;
/*      */ import org.jboss.xb.binding.group.ValueListHandler;
/*      */ import org.jboss.xb.binding.group.ValueListHandler.FACTORY;
/*      */ import org.jboss.xb.binding.group.ValueListInitializer;
/*      */ import org.jboss.xb.binding.introspection.FieldInfo;
/*      */ import org.jboss.xb.binding.metadata.CharactersMetaData;
/*      */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*      */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*      */ import org.jboss.xb.binding.parser.JBossXBParser.DtdAwareContentHandler;
/*      */ import org.jboss.xb.binding.sunday.xop.XOPIncludeHandler;
/*      */ import org.xml.sax.Attributes;
/*      */ 
/*      */ public class SundayContentHandler
/*      */   implements JBossXBParser.DtdAwareContentHandler
/*      */ {
/*   60 */   private static final Logger log = Logger.getLogger(SundayContentHandler.class);
/*      */ 
/*   62 */   private static final Object NIL = new Object();
/*      */   private final SchemaBinding schema;
/*      */   private final SchemaBindingResolver schemaResolver;
/*   67 */   private final StackImpl stack = new StackImpl();
/*      */   private Object root;
/*   70 */   private NamespaceRegistry nsRegistry = new NamespaceRegistry();
/*      */ 
/*   72 */   private ParticleHandler defParticleHandler = DefaultHandlers.ELEMENT_HANDLER;
/*      */ 
/*   74 */   private UnmarshallingContextImpl ctx = new UnmarshallingContextImpl(null);
/*      */   private String dtdRootName;
/*      */   private String dtdPublicId;
/*      */   private String dtdSystemId;
/*      */   private boolean sawDTD;
/*   81 */   private final boolean trace = log.isTraceEnabled();
/*      */ 
/*      */   public SundayContentHandler(SchemaBinding schema)
/*      */   {
/*   85 */     this.schema = schema;
/*   86 */     this.schemaResolver = null;
/*      */   }
/*      */ 
/*      */   public SundayContentHandler(SchemaBindingResolver schemaResolver)
/*      */   {
/*   91 */     this.schemaResolver = schemaResolver;
/*   92 */     this.schema = null;
/*      */   }
/*      */ 
/*      */   public void startDTD(String dtdRootName, String dtdPublicId, String dtdSystemId)
/*      */   {
/*   98 */     this.dtdRootName = dtdRootName;
/*   99 */     this.dtdPublicId = dtdPublicId;
/*  100 */     this.dtdSystemId = dtdSystemId;
/*      */   }
/*      */ 
/*      */   public void endDTD() {
/*  104 */     this.sawDTD = true;
/*      */   }
/*      */ 
/*      */   public void characters(char[] ch, int start, int length)
/*      */   {
/*  109 */     StackItem stackItem = this.stack.peek();
/*  110 */     if (stackItem.cursor != null)
/*      */     {
/*  112 */       return;
/*      */     }
/*      */ 
/*  115 */     ElementBinding e = (ElementBinding)stackItem.particle.getTerm();
/*      */ 
/*  150 */     if (stackItem.ended)
/*      */     {
/*  152 */       int i = 0;
/*      */       do
/*      */       {
/*  155 */         i++; stackItem = this.stack.peek(i);
/*      */       }
/*  157 */       while ((stackItem.cursor != null) && (i < this.stack.size()));
/*      */ 
/*  159 */       e = (ElementBinding)stackItem.particle.getTerm();
/*      */     }
/*      */ 
/*  163 */     if (e.getType().isTextContentAllowed())
/*      */     {
/*  165 */       if (stackItem.indentation != Boolean.FALSE)
/*      */       {
/*  167 */         if (e.getType().isSimple())
/*      */         {
/*  170 */           stackItem.indentation = Boolean.FALSE;
/*  171 */           stackItem.ignorableCharacters = false;
/*      */         }
/*  173 */         else if ((e.getSchema() != null) && (!e.getSchema().isIgnoreWhitespacesInMixedContent()))
/*      */         {
/*  175 */           stackItem.indentation = Boolean.FALSE;
/*  176 */           stackItem.ignorableCharacters = false;
/*      */         }
/*      */         else
/*      */         {
/*  182 */           for (int i = start; i < start + length; i++)
/*      */           {
/*  184 */             if (ch[i] == '\n')
/*      */             {
/*  186 */               stackItem.indentation = Boolean.TRUE;
/*      */             } else {
/*  188 */               if (Character.isWhitespace(ch[i]))
/*      */                 continue;
/*  190 */               stackItem.indentation = Boolean.FALSE;
/*  191 */               stackItem.ignorableCharacters = false;
/*  192 */               break;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*  198 */       if (stackItem.textContent == null)
/*      */       {
/*  200 */         stackItem.textContent = new StringBuffer();
/*      */       }
/*  202 */       stackItem.textContent.append(ch, start, length);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void endElement(String namespaceURI, String localName, String qName)
/*      */   {
/*  208 */     ElementBinding elementBinding = null;
/*  209 */     QName endName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
/*      */     while (true)
/*      */     {
/*  213 */       StackItem item = this.stack.peek();
/*  214 */       if (item.cursor == null)
/*      */       {
/*  216 */         if (item.ended)
/*      */         {
/*  218 */           pop();
/*  219 */           if (!item.particle.isRepeatable())
/*      */             continue;
/*  221 */           endRepeatableParticle(item.particle); continue;
/*      */         }
/*      */ 
/*  226 */         elementBinding = (ElementBinding)item.particle.getTerm();
/*  227 */         item.ended = true;
/*  228 */         break;
/*      */       }
/*      */ 
/*  233 */       if (!item.ended)
/*      */       {
/*  235 */         endParticle(item, endName, 1);
/*      */       }
/*      */ 
/*  238 */       ParticleBinding currentParticle = item.cursor.getCurrentParticle();
/*  239 */       TermBinding term = currentParticle.getTerm();
/*  240 */       if ((term.isWildcard()) && (currentParticle.isRepeatable()))
/*      */       {
/*  242 */         endRepeatableParticle(currentParticle);
/*      */       }
/*      */ 
/*  245 */       pop();
/*  246 */       if (item.particle.isRepeatable())
/*      */       {
/*  248 */         endRepeatableParticle(item.particle);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  253 */     if (elementBinding == null)
/*      */     {
/*  255 */       throw new JBossXBRuntimeException("Failed to endElement " + qName + ": binding not found");
/*      */     }
/*      */ 
/*  258 */     if (!elementBinding.getQName().equals(endName))
/*      */     {
/*  260 */       throw new JBossXBRuntimeException("Failed to end element " + new QName(namespaceURI, localName) + ": element on the stack is " + elementBinding.getQName());
/*      */     }
/*      */ 
/*  266 */     endElement();
/*      */   }
/*      */ 
/*      */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts, XSTypeDefinition xercesType)
/*      */   {
/*  275 */     QName startName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
/*  276 */     ParticleBinding particle = null;
/*  277 */     ParticleHandler handler = null;
/*  278 */     TypeBinding parentType = null;
/*  279 */     boolean repeated = false;
/*  280 */     boolean repeatedParticle = false;
/*  281 */     StackItem item = null;
/*  282 */     ModelGroupBinding.Cursor cursor = null;
/*  283 */     SchemaBinding schemaBinding = this.schema;
/*      */ 
/*  285 */     if (this.stack.isEmpty())
/*      */     {
/*  287 */       if (schemaBinding != null)
/*      */       {
/*  289 */         particle = schemaBinding.getElementParticle(startName);
/*      */       }
/*  291 */       else if (this.schemaResolver != null)
/*      */       {
/*  293 */         String schemaLocation = atts == null ? null : Util.getSchemaLocation(atts, namespaceURI);
/*      */ 
/*  295 */         if ((this.sawDTD) && ((schemaLocation == null) || (schemaLocation.length() == 0)))
/*      */         {
/*  297 */           schemaLocation = this.dtdSystemId;
/*      */         }
/*      */ 
/*  300 */         if (schemaLocation == null)
/*  301 */           schemaLocation = localName;
/*  302 */         schemaBinding = this.schemaResolver.resolve(namespaceURI, null, schemaLocation);
/*  303 */         if (schemaBinding != null)
/*      */         {
/*  305 */           particle = schemaBinding.getElementParticle(startName);
/*      */         }
/*      */         else
/*      */         {
/*  309 */           throw new JBossXBRuntimeException("Failed to resolve schema nsURI=" + namespaceURI + " location=" + schemaLocation);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  314 */         throw new JBossXBRuntimeException("Neither schema binding nor schema binding resolver is available!");
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  319 */       while (!this.stack.isEmpty())
/*      */       {
/*  321 */         item = this.stack.peek();
/*  322 */         if (item.cursor == null)
/*      */         {
/*  324 */           TermBinding term = item.particle.getTerm();
/*  325 */           ElementBinding element = (ElementBinding)term;
/*  326 */           if (item.ended)
/*      */           {
/*  328 */             if (element.getQName().equals(startName))
/*      */             {
/*  330 */               particle = item.particle;
/*  331 */               parentType = item.parentType;
/*  332 */               repeated = true;
/*  333 */               item.reset();
/*      */ 
/*  335 */               if (particle.isRepeatable())
/*      */                 break;
/*  337 */               endRepeatableParent(startName); break;
/*      */             }
/*      */ 
/*  342 */             pop();
/*  343 */             if (!item.particle.isRepeatable())
/*      */               continue;
/*  345 */             endRepeatableParticle(item.particle); continue;
/*      */           }
/*      */ 
/*  352 */           parentType = element.getType();
/*  353 */           ParticleBinding typeParticle = parentType.getParticle();
/*  354 */           ModelGroupBinding modelGroup = typeParticle == null ? null : (ModelGroupBinding)typeParticle.getTerm();
/*  355 */           if (modelGroup == null)
/*      */           {
/*  357 */             if (startName.equals(Constants.QNAME_XOP_INCLUDE))
/*      */             {
/*  359 */               TypeBinding anyUriType = this.schema.getType(Constants.QNAME_ANYURI);
/*  360 */               if (anyUriType == null)
/*      */               {
/*  362 */                 log.warn("Type " + Constants.QNAME_ANYURI + " not bound.");
/*      */               }
/*      */ 
/*  365 */               TypeBinding xopIncludeType = new TypeBinding(new QName("http://www.w3.org/2004/08/xop/include", "Include"));
/*  366 */               xopIncludeType.setSchemaBinding(this.schema);
/*  367 */               xopIncludeType.addAttribute(new QName("href"), anyUriType, DefaultHandlers.ATTRIBUTE_HANDLER);
/*  368 */               xopIncludeType.setHandler(new XOPIncludeHandler(parentType, this.schema.getXopUnmarshaller()));
/*      */ 
/*  370 */               ElementBinding xopInclude = new ElementBinding(this.schema, Constants.QNAME_XOP_INCLUDE, xopIncludeType);
/*      */ 
/*  372 */               particle = new ParticleBinding(xopInclude);
/*      */ 
/*  374 */               ElementBinding parentElement = (ElementBinding)item.particle.getTerm();
/*  375 */               parentElement.setXopUnmarshaller(this.schema.getXopUnmarshaller());
/*      */ 
/*  377 */               flushIgnorableCharacters();
/*  378 */               item.handler = DefaultHandlers.XOP_HANDLER;
/*  379 */               item.ignoreCharacters = true;
/*  380 */               item.o = item.handler.startParticle(this.stack.peek().o, startName, this.stack.peek().particle, null, this.nsRegistry);
/*  381 */               break;
/*      */             }
/*      */ 
/*  384 */             QName typeName = parentType.getQName();
/*  385 */             throw new JBossXBRuntimeException((typeName == null ? "Anonymous" : typeName.toString()) + " type of element " + element.getQName() + " should be complex and contain " + startName + " as a child element.");
/*      */           }
/*      */ 
/*  392 */           cursor = modelGroup.newCursor(typeParticle);
/*  393 */           List newCursors = cursor.startElement(startName, atts);
/*  394 */           if (newCursors.isEmpty())
/*      */           {
/*  396 */             throw new JBossXBRuntimeException(startName + " not found as a child of " + ((ElementBinding)term).getQName());
/*      */           }
/*      */ 
/*  403 */           flushIgnorableCharacters();
/*      */ 
/*  405 */           Object o = item.o;
/*      */ 
/*  407 */           for (int i = newCursors.size() - 1; i >= 0; i--)
/*      */           {
/*  409 */             cursor = (ModelGroupBinding.Cursor)newCursors.get(i);
/*      */ 
/*  411 */             ParticleBinding modelGroupParticle = cursor.getParticle();
/*  412 */             if (modelGroupParticle.isRepeatable())
/*      */             {
/*  414 */               startRepeatableParticle(startName, modelGroupParticle);
/*      */             }
/*      */ 
/*  417 */             handler = getHandler(modelGroupParticle);
/*  418 */             o = handler.startParticle(o, startName, modelGroupParticle, atts, this.nsRegistry);
/*  419 */             push(cursor, o, handler, parentType);
/*      */           }
/*  421 */           particle = cursor.getCurrentParticle();
/*      */ 
/*  424 */           break;
/*      */         }
/*      */ 
/*  428 */         cursor = item.cursor;
/*  429 */         if (cursor == null)
/*      */         {
/*  431 */           throw new JBossXBRuntimeException("No cursor for " + startName);
/*      */         }
/*      */ 
/*  435 */         if ((!item.ended) && (cursor.isPositioned()) && ((cursor.getParticle().getTerm() instanceof ChoiceBinding)))
/*      */         {
/*  437 */           endParticle(item, startName, 1);
/*  438 */           if (item.particle.isRepeatable())
/*      */             continue;
/*  440 */           pop(); continue;
/*      */         }
/*      */ 
/*  446 */         ParticleBinding prevParticle = cursor.isPositioned() ? cursor.getCurrentParticle() : null;
/*  447 */         List newCursors = cursor.startElement(startName, atts);
/*  448 */         if (newCursors.isEmpty())
/*      */         {
/*  450 */           if (!item.ended)
/*      */           {
/*  452 */             endParticle(item, startName, 1);
/*      */           }
/*  454 */           pop();
/*      */         }
/*      */         else
/*      */         {
/*  458 */           if (item.ended)
/*      */           {
/*  460 */             if (!item.particle.isRepeatable())
/*      */             {
/*  462 */               throw new JBossXBRuntimeException("The particle expected to be repeatable but it's not: " + item.particle.getTerm());
/*      */             }
/*  464 */             item.reset();
/*      */ 
/*  466 */             handler = getHandler(item.particle);
/*  467 */             item.o = handler.startParticle(this.stack.peek(1).o, startName, item.particle, atts, this.nsRegistry);
/*      */           }
/*      */ 
/*  470 */           ParticleBinding curParticle = cursor.getCurrentParticle();
/*  471 */           if (curParticle != prevParticle)
/*      */           {
/*  473 */             if ((prevParticle != null) && (prevParticle.isRepeatable()) && (prevParticle.getTerm().isModelGroup()))
/*      */             {
/*  475 */               endRepeatableParticle(prevParticle);
/*      */             }
/*      */ 
/*  478 */             if ((newCursors.size() > 1) && (curParticle.isRepeatable()))
/*      */             {
/*  480 */               startRepeatableParticle(startName, curParticle);
/*      */             }
/*      */           }
/*      */           else
/*      */           {
/*  485 */             repeatedParticle = true;
/*      */           }
/*      */ 
/*  489 */           parentType = item.parentType;
/*  490 */           Object o = item.o;
/*  491 */           for (int i = newCursors.size() - 2; i >= 0; i--)
/*      */           {
/*  493 */             cursor = (ModelGroupBinding.Cursor)newCursors.get(i);
/*      */ 
/*  495 */             ParticleBinding modelGroupParticle = cursor.getParticle();
/*  496 */             handler = getHandler(modelGroupParticle);
/*  497 */             o = handler.startParticle(o, startName, modelGroupParticle, atts, this.nsRegistry);
/*  498 */             push(cursor, o, handler, parentType);
/*      */           }
/*  500 */           cursor = (ModelGroupBinding.Cursor)newCursors.get(0);
/*  501 */           particle = cursor.getCurrentParticle();
/*  502 */           break;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  508 */     Object o = null;
/*  509 */     if (particle != null)
/*      */     {
/*  511 */       Object parent = repeated ? this.stack.peek(1).o : this.stack.isEmpty() ? null : this.stack.peek().o;
/*      */ 
/*  513 */       if ((particle.getTerm() instanceof WildcardBinding))
/*      */       {
/*  519 */         ElementBinding element = cursor.getElement();
/*  520 */         if (element == null)
/*      */         {
/*  522 */           throw new JBossXBRuntimeException("Failed to resolve element " + startName + " for wildcard.");
/*      */         }
/*      */ 
/*  527 */         if ((!repeatedParticle) && (particle.isRepeatable()))
/*      */         {
/*  529 */           startRepeatableParticle(startName, particle);
/*      */         }
/*  531 */         particle = new ParticleBinding(element);
/*      */       }
/*      */ 
/*  534 */       ElementBinding element = (ElementBinding)particle.getTerm();
/*      */ 
/*  537 */       String xsiType = atts.getValue("xsi:type");
/*  538 */       if (xsiType != null)
/*      */       {
/*  540 */         if (this.trace)
/*      */         {
/*  542 */           log.trace(element.getQName() + " uses xsi:type " + xsiType);
/*      */         }
/*      */ 
/*  547 */         int colon = xsiType.indexOf(':');
/*      */         String xsiTypeLocal;
/*      */         String xsiTypePrefix;
/*      */         String xsiTypeLocal;
/*  548 */         if (colon == -1)
/*      */         {
/*  550 */           String xsiTypePrefix = "";
/*  551 */           xsiTypeLocal = xsiType;
/*      */         }
/*      */         else
/*      */         {
/*  555 */           xsiTypePrefix = xsiType.substring(0, colon);
/*  556 */           xsiTypeLocal = xsiType.substring(colon + 1);
/*      */         }
/*      */ 
/*  559 */         String xsiTypeNs = this.nsRegistry.getNamespaceURI(xsiTypePrefix);
/*  560 */         QName xsiTypeQName = new QName(xsiTypeNs, xsiTypeLocal);
/*      */ 
/*  562 */         TypeBinding xsiTypeBinding = schemaBinding.getType(xsiTypeQName);
/*  563 */         if (xsiTypeBinding == null)
/*      */         {
/*  565 */           throw new JBossXBRuntimeException("Type binding not found for type " + xsiTypeQName + " specified with xsi:type for element " + startName);
/*      */         }
/*      */ 
/*  571 */         element = new ElementBinding(schemaBinding, startName, xsiTypeBinding);
/*  572 */         particle = new ParticleBinding(element, particle.getMinOccurs(), particle.getMaxOccurs(), particle.getMaxOccursUnbounded());
/*      */       }
/*      */ 
/*  580 */       if ((!repeated) && (particle.isRepeatable()))
/*      */       {
/*  582 */         startRepeatableParticle(startName, particle);
/*      */       }
/*      */ 
/*  585 */       TypeBinding type = element.getType();
/*  586 */       if (type == null)
/*      */       {
/*  588 */         throw new JBossXBRuntimeException("No type for element " + element);
/*      */       }
/*      */ 
/*  591 */       handler = type.getHandler();
/*  592 */       if (handler == null)
/*      */       {
/*  594 */         handler = this.defParticleHandler;
/*      */       }
/*      */ 
/*  597 */       List localInterceptors = parentType == null ? Collections.EMPTY_LIST : parentType.getInterceptors(startName);
/*  598 */       List interceptors = element.getInterceptors();
/*  599 */       if (interceptors.size() + localInterceptors.size() > 0)
/*      */       {
/*  601 */         if (repeated)
/*      */         {
/*  603 */           pop();
/*      */         }
/*      */ 
/*  606 */         for (int i = 0; i < localInterceptors.size(); i++)
/*      */         {
/*  608 */           ElementInterceptor interceptor = (ElementInterceptor)localInterceptors.get(i);
/*  609 */           parent = interceptor.startElement(parent, startName, type);
/*  610 */           push(particle, parent, handler, parentType);
/*  611 */           interceptor.attributes(parent, startName, type, atts, this.nsRegistry);
/*      */         }
/*      */ 
/*  614 */         for (int i = 0; i < interceptors.size(); i++)
/*      */         {
/*  616 */           ElementInterceptor interceptor = (ElementInterceptor)interceptors.get(i);
/*  617 */           parent = interceptor.startElement(parent, startName, type);
/*  618 */           push(particle, parent, handler, parentType);
/*  619 */           interceptor.attributes(parent, startName, type, atts, this.nsRegistry);
/*      */         }
/*      */ 
/*  622 */         if (repeated)
/*      */         {
/*  625 */           this.stack.push(item);
/*      */         }
/*      */       }
/*      */ 
/*  629 */       String nil = atts.getValue("xsi:nil");
/*  630 */       if ((nil == null) || ((!"1".equals(nil)) && (!"true".equals(nil))))
/*      */       {
/*  632 */         o = handler.startParticle(parent, startName, particle, atts, this.nsRegistry);
/*      */       }
/*      */       else
/*      */       {
/*  636 */         o = NIL;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  641 */       ElementBinding parentBinding = null;
/*  642 */       if (!this.stack.isEmpty())
/*      */       {
/*  644 */         ParticleBinding stackParticle = repeated ? this.stack.peek(1).particle : this.stack.peek().particle;
/*  645 */         if (stackParticle != null)
/*      */         {
/*  647 */           parentBinding = (ElementBinding)stackParticle.getTerm();
/*      */         }
/*      */       }
/*      */ 
/*  651 */       if ((parentBinding != null) && (parentBinding.getSchema() != null))
/*      */       {
/*  653 */         schemaBinding = parentBinding.getSchema();
/*      */       }
/*      */ 
/*  656 */       String msg = "Element " + startName + " is not bound " + (parentBinding == null ? "as a global element." : new StringBuilder().append("in type ").append(parentBinding.getType().getQName()).toString());
/*      */ 
/*  660 */       if ((schemaBinding != null) && (schemaBinding.isStrictSchema()))
/*      */       {
/*  662 */         throw new JBossXBRuntimeException(msg);
/*      */       }
/*  664 */       if (this.trace)
/*      */       {
/*  666 */         log.trace(msg);
/*      */       }
/*      */     }
/*      */ 
/*  670 */     if (repeated)
/*      */     {
/*  672 */       item.o = o;
/*      */ 
/*  674 */       item.particle = particle;
/*      */     }
/*      */     else
/*      */     {
/*  678 */       push(particle, o, handler, parentType);
/*      */     }
/*      */   }
/*      */ 
/*      */   private ParticleHandler getHandler(ParticleBinding modelGroupParticle)
/*      */   {
/*  684 */     ParticleHandler handler = ((ModelGroupBinding)modelGroupParticle.getTerm()).getHandler();
/*  685 */     return handler == null ? this.defParticleHandler : handler;
/*      */   }
/*      */ 
/*      */   private void endRepeatableParent(QName startName)
/*      */   {
/*  690 */     int parentPos = 1;
/*      */ 
/*  692 */     ParticleBinding parentParticle = null;
/*      */     while (true)
/*      */     {
/*  695 */       parentItem = this.stack.peek(parentPos);
/*  696 */       if (parentItem.cursor == null)
/*      */       {
/*  698 */         throw new JBossXBRuntimeException("Failed to start " + startName + ": the element is not repeatable, repeatable parent expected to be a model group but got element " + ((ElementBinding)parentItem.particle.getTerm()).getQName());
/*      */       }
/*      */ 
/*  705 */       parentParticle = parentItem.particle;
/*  706 */       if (parentParticle.isRepeatable())
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*  711 */       parentPos++; endParticle(parentItem, startName, parentPos);
/*      */     }
/*      */ 
/*  714 */     if (!parentParticle.isRepeatable())
/*      */     {
/*  716 */       StringBuffer msg = new StringBuffer();
/*      */ 
/*  718 */       StackItem item = this.stack.peek();
/*  719 */       ParticleBinding currentParticle = item.particle;
/*  720 */       msg.append("Failed to start ").append(startName).append(": ").append(currentParticle.getTerm()).append(" is not repeatable.").append(" Its parent ").append(parentParticle.getTerm()).append(" expected to be repeatable!").append("\ncurrent stack: ");
/*      */ 
/*  728 */       for (int i = this.stack.size() - 1; i >= 0; i--)
/*      */       {
/*  730 */         item = this.stack.peek(i);
/*  731 */         ParticleBinding particle = item.particle;
/*  732 */         TermBinding term = particle.getTerm();
/*  733 */         if (term.isModelGroup())
/*      */         {
/*  735 */           if ((term instanceof SequenceBinding))
/*      */           {
/*  737 */             msg.append("sequence");
/*      */           }
/*  739 */           else if ((term instanceof ChoiceBinding))
/*      */           {
/*  741 */             msg.append("choice");
/*      */           }
/*      */           else
/*      */           {
/*  745 */             msg.append("all");
/*      */           }
/*      */         }
/*  748 */         else if (term.isWildcard())
/*      */         {
/*  750 */           msg.append("wildcard");
/*      */         }
/*      */         else
/*      */         {
/*  754 */           msg.append(((ElementBinding)term).getQName());
/*      */         }
/*  756 */         msg.append("\\");
/*      */       }
/*      */ 
/*  759 */       throw new JBossXBRuntimeException(msg.toString());
/*      */     }
/*      */ 
/*  763 */     endParticle(parentItem, startName, parentPos + 1);
/*      */ 
/*  765 */     StackItem parentItem = this.stack.peek(parentPos + 1);
/*  766 */     while (parentPos > 0)
/*      */     {
/*  768 */       StackItem item = this.stack.peek(parentPos--);
/*  769 */       ParticleHandler handler = getHandler(item.particle);
/*  770 */       item.reset();
/*  771 */       item.o = handler.startParticle(parentItem.o, startName, item.particle, null, this.nsRegistry);
/*  772 */       parentItem = item;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void startRepeatableParticle(QName startName, ParticleBinding particle)
/*      */   {
/*  778 */     if (this.trace) {
/*  779 */       log.trace(" start repeatable (" + this.stack.size() + "): " + particle.getTerm());
/*      */     }
/*  781 */     TermBinding term = particle.getTerm();
/*  782 */     if (term.isSkip())
/*      */     {
/*  784 */       return;
/*      */     }
/*      */ 
/*  787 */     StackItem item = this.stack.peek();
/*  788 */     if ((item.o != null) && (!(item.o instanceof GenericValueContainer)) && (!(item.o instanceof Collection)) && (term.getAddMethodMetaData() == null) && (term.getMapEntryMetaData() == null) && (term.getPutMethodMetaData() == null))
/*      */     {
/*  795 */       ValueListHandler handler = ValueListHandler.FACTORY.lazy(item.o);
/*  796 */       Class cls = item.o.getClass();
/*  797 */       item.repeatableParticleValue = new ValueListInitializer().newValueList(handler, cls);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void endRepeatableParticle(ParticleBinding particle)
/*      */   {
/*  803 */     if (this.trace) {
/*  804 */       log.trace(" end repeatable (" + this.stack.size() + "): " + particle.getTerm());
/*      */     }
/*  806 */     StackItem item = this.stack.peek();
/*  807 */     ValueList valueList = item.repeatableParticleValue;
/*  808 */     if (valueList != null)
/*      */     {
/*  810 */       item.repeatableParticleValue = null;
/*  811 */       if (valueList.size() == 0)
/*      */       {
/*  813 */         return;
/*      */       }
/*      */ 
/*  816 */       if (particle.getTerm().isWildcard())
/*      */       {
/*  818 */         ParticleHandler handler = null;
/*      */ 
/*  828 */         QName qName = valueList.getValue(0).qName;
/*  829 */         Collection col = new ArrayList();
/*  830 */         for (int i = 0; i < valueList.size(); i++)
/*      */         {
/*  832 */           ValueList.NonRequiredValue value = valueList.getValue(i);
/*  833 */           col.add(value.value);
/*      */ 
/*  835 */           if (handler == value.handler)
/*      */             continue;
/*  837 */           if ((handler == null) && (i == 0))
/*      */           {
/*  839 */             handler = (ParticleHandler)value.handler;
/*      */           }
/*      */           else
/*      */           {
/*  843 */             throw new JBossXBRuntimeException("Handlers in the list are supposed to be the same.");
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  848 */         StackItem parentItem = this.stack.peek(1);
/*  849 */         handler.setParent(parentItem.o, col, qName, particle, parentItem.particle);
/*      */       }
/*      */       else
/*      */       {
/*  853 */         valueList.getHandler().newInstance(particle, valueList);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void endParticle(StackItem item, QName qName, int parentStackPos)
/*      */   {
/*  860 */     if (item.ended)
/*      */     {
/*  862 */       throw new JBossXBRuntimeException(item.particle.getTerm() + " has already been ended.");
/*      */     }
/*      */ 
/*  865 */     ParticleBinding modelGroupParticle = item.particle;
/*  866 */     ParticleHandler handler = item.handler;
/*      */     Object o;
/*      */     Object o;
/*  869 */     if (((item.o instanceof ValueList)) && (!modelGroupParticle.getTerm().isSkip()))
/*      */     {
/*  871 */       if (this.trace)
/*      */       {
/*  873 */         log.trace("endParticle " + modelGroupParticle.getTerm() + " valueList");
/*      */       }
/*  875 */       ValueList valueList = (ValueList)item.o;
/*  876 */       o = valueList.getHandler().newInstance(modelGroupParticle, valueList);
/*      */     }
/*      */     else
/*      */     {
/*  880 */       o = handler.endParticle(item.o, qName, modelGroupParticle);
/*      */     }
/*      */ 
/*  883 */     item.ended = true;
/*      */ 
/*  886 */     item = this.stack.peek(parentStackPos);
/*  887 */     if (item.o != null)
/*      */     {
/*  889 */       ParticleBinding parentParticle = getParentParticle();
/*  890 */       if (parentParticle == null)
/*      */       {
/*  892 */         parentParticle = item.particle;
/*      */       }
/*  894 */       setParent(handler, item.repeatableParticleValue == null ? item.o : item.repeatableParticleValue, o, qName, modelGroupParticle, parentParticle);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void startPrefixMapping(String prefix, String uri)
/*      */   {
/*  902 */     this.nsRegistry.addPrefixMapping(prefix, uri);
/*      */   }
/*      */ 
/*      */   public void endPrefixMapping(String prefix)
/*      */   {
/*  907 */     this.nsRegistry.removePrefixMapping(prefix);
/*      */   }
/*      */ 
/*      */   public void processingInstruction(String target, String data)
/*      */   {
/*      */   }
/*      */ 
/*      */   public Object getRoot()
/*      */   {
/*  916 */     return this.root;
/*      */   }
/*      */ 
/*      */   private void flushIgnorableCharacters()
/*      */   {
/*  923 */     StackItem stackItem = this.stack.peek();
/*  924 */     if ((stackItem.cursor != null) || (stackItem.textContent == null))
/*      */     {
/*  926 */       return;
/*      */     }
/*      */ 
/*  929 */     if ((stackItem.indentation == Boolean.TRUE) || (stackItem.ignorableCharacters))
/*      */     {
/*  931 */       if (log.isTraceEnabled())
/*      */       {
/*  933 */         log.trace("ignored characters: " + ((ElementBinding)stackItem.particle.getTerm()).getQName() + " '" + stackItem.textContent + "'");
/*      */       }
/*      */ 
/*  936 */       stackItem.textContent = null;
/*  937 */       stackItem.indentation = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   private ParticleBinding getParentParticle()
/*      */   {
/*  943 */     ListIterator iter = this.stack.prevIterator();
/*  944 */     while (iter.hasPrevious())
/*      */     {
/*  946 */       StackItem prev = (StackItem)iter.previous();
/*  947 */       ParticleBinding peeked = prev.particle;
/*      */ 
/*  949 */       TermBinding term = peeked.getTerm();
/*  950 */       if (!term.isSkip())
/*      */       {
/*  952 */         return peeked;
/*      */       }
/*      */     }
/*  955 */     return null;
/*      */   }
/*      */ 
/*      */   private void endElement()
/*      */   {
/*  960 */     StackItem item = this.stack.peek();
/*  961 */     Object o = item.o;
/*  962 */     ParticleBinding particle = item.particle;
/*      */ 
/*  964 */     ElementBinding element = (ElementBinding)particle.getTerm();
/*  965 */     QName endName = element.getQName();
/*  966 */     TypeBinding type = element.getType();
/*  967 */     List interceptors = element.getInterceptors();
/*  968 */     int interceptorsTotal = interceptors.size();
/*      */ 
/*  970 */     List localInterceptors = item.parentType == null ? Collections.EMPTY_LIST : item.parentType.getInterceptors(endName);
/*  971 */     int localInterceptorsTotal = localInterceptors.size();
/*      */ 
/*  973 */     if (o != NIL)
/*      */     {
/*  979 */       flushIgnorableCharacters();
/*      */ 
/*  981 */       TypeBinding charType = type.getSimpleType();
/*  982 */       if (charType == null)
/*      */       {
/*  984 */         charType = type;
/*      */       }
/*      */ 
/*  987 */       CharactersHandler charHandler = item.ignoreCharacters ? null : charType.getCharactersHandler();
/*      */ 
/*  997 */       String textContent = item.textContent == null ? "" : item.textContent.toString();
/*  998 */       if ((textContent.length() > 0) || ((charHandler != null) && (type.isSimple())))
/*      */       {
/* 1001 */         SchemaBinding schema = element.getSchema();
/*      */         String dataContent;
/*      */         String dataContent;
/* 1002 */         if (textContent.length() == 0)
/*      */         {
/* 1004 */           dataContent = null;
/*      */         }
/*      */         else
/*      */         {
/* 1008 */           dataContent = textContent.toString();
/* 1009 */           if ((schema != null) && (schema.isReplacePropertyRefs()))
/*      */           {
/* 1011 */             dataContent = StringPropertyReplacer.replaceProperties(dataContent);
/*      */           }
/*      */         }
/*      */         Object unmarshalled;
/*      */         Object unmarshalled;
/* 1017 */         if (charHandler == null)
/*      */         {
/* 1019 */           if ((!type.isSimple()) && (schema != null) && (schema.isStrictSchema()) && (!element.isSkip()))
/*      */           {
/* 1025 */             throw new JBossXBRuntimeException("Element " + endName + " with type binding " + type.getQName() + " does not include text content binding: " + dataContent);
/*      */           }
/*      */ 
/* 1032 */           unmarshalled = dataContent;
/*      */         }
/*      */         else
/*      */         {
/* 1036 */           ValueMetaData valueMetaData = element.getValueMetaData();
/* 1037 */           if (valueMetaData == null)
/*      */           {
/* 1039 */             CharactersMetaData charactersMetaData = type.getCharactersMetaData();
/* 1040 */             if (charactersMetaData != null)
/*      */             {
/* 1042 */               valueMetaData = charactersMetaData.getValue();
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1047 */           unmarshalled = dataContent == null ? charHandler.unmarshalEmpty(endName, charType, this.nsRegistry, valueMetaData) : charHandler.unmarshal(endName, charType, this.nsRegistry, valueMetaData, dataContent);
/*      */         }
/*      */ 
/* 1052 */         if (unmarshalled != null)
/*      */         {
/* 1055 */           if (o == null)
/*      */           {
/* 1057 */             o = unmarshalled;
/*      */           }
/* 1059 */           else if (charHandler != null)
/*      */           {
/* 1061 */             TermBeforeSetParentCallback beforeSetParent = charType.getBeforeSetParentCallback();
/* 1062 */             if (beforeSetParent != null)
/*      */             {
/* 1064 */               this.ctx.parent = o;
/* 1065 */               this.ctx.particle = particle;
/* 1066 */               this.ctx.parentParticle = getParentParticle();
/* 1067 */               unmarshalled = beforeSetParent.beforeSetParent(unmarshalled, this.ctx);
/* 1068 */               this.ctx.clear();
/*      */             }
/*      */ 
/* 1071 */             if ((o instanceof ValueList))
/*      */             {
/* 1073 */               ValueList valueList = (ValueList)o;
/* 1074 */               if (type.isSimple())
/*      */               {
/* 1076 */                 valueList.getInitializer().addTermValue(endName, particle, charHandler, valueList, unmarshalled, null);
/*      */               }
/*      */               else
/*      */               {
/* 1086 */                 valueList.getInitializer().addTextValue(endName, particle, charHandler, valueList, unmarshalled);
/*      */               }
/*      */ 
/*      */             }
/*      */             else
/*      */             {
/* 1096 */               charHandler.setValue(endName, element, o, unmarshalled);
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/* 1101 */         for (int i = interceptorsTotal - 1; i >= 0; i--)
/*      */         {
/* 1103 */           ElementInterceptor interceptor = (ElementInterceptor)interceptors.get(i);
/* 1104 */           interceptor.characters(this.stack.peek(interceptorsTotal + localInterceptorsTotal - i).o, endName, type, this.nsRegistry, dataContent);
/*      */         }
/*      */ 
/* 1109 */         for (int i = localInterceptorsTotal - 1; i >= 0; i--)
/*      */         {
/* 1111 */           ElementInterceptor interceptor = (ElementInterceptor)localInterceptors.get(i);
/* 1112 */           interceptor.characters(this.stack.peek(localInterceptorsTotal - i).o, endName, type, this.nsRegistry, dataContent);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1120 */       o = null;
/*      */     }
/*      */ 
/* 1127 */     StackItem parentItem = this.stack.size() == 1 ? null : this.stack.peek(1);
/* 1128 */     Object parent = parentItem == null ? null : parentItem.o;
/* 1129 */     ParticleHandler handler = this.stack.peek().handler;
/*      */ 
/* 1131 */     if (((o instanceof ValueList)) && (!particle.getTerm().isSkip()))
/*      */     {
/* 1133 */       if (this.trace)
/*      */       {
/* 1135 */         log.trace("endParticle " + endName + " valueList");
/*      */       }
/* 1137 */       ValueList valueList = (ValueList)o;
/* 1138 */       o = valueList.getHandler().newInstance(particle, valueList);
/*      */     }
/*      */     else
/*      */     {
/* 1142 */       o = handler.endParticle(o, endName, particle);
/*      */     }
/*      */ 
/* 1145 */     for (int i = interceptorsTotal - 1; i >= 0; i--)
/*      */     {
/* 1147 */       ElementInterceptor interceptor = (ElementInterceptor)interceptors.get(i);
/* 1148 */       interceptor.endElement(this.stack.peek(interceptorsTotal - i).o, endName, type);
/*      */     }
/*      */ 
/* 1155 */     if (localInterceptorsTotal + interceptorsTotal == 0)
/*      */     {
/* 1157 */       ParticleBinding parentParticle = getParentParticle();
/* 1158 */       boolean hasWildcard = false;
/* 1159 */       ParticleHandler wildcardHandler = null;
/* 1160 */       if ((parentParticle != null) && (parentParticle.getTerm().isElement()))
/*      */       {
/* 1162 */         WildcardBinding wildcard = ((ElementBinding)parentParticle.getTerm()).getType().getWildcard();
/* 1163 */         if (wildcard != null)
/*      */         {
/* 1165 */           hasWildcard = true;
/* 1166 */           if (parentItem.cursor.isWildcardContent())
/*      */           {
/* 1168 */             wildcardHandler = wildcard.getWildcardHandler();
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1173 */       if (parent != null)
/*      */       {
/* 1179 */         if (wildcardHandler != null)
/*      */         {
/* 1181 */           setParent(wildcardHandler, parentItem.repeatableParticleValue == null ? parent : parentItem.repeatableParticleValue, o, endName, particle, parentParticle);
/*      */         }
/*      */         else
/*      */         {
/* 1187 */           setParent(handler, parentItem.repeatableParticleValue == null ? parent : parentItem.repeatableParticleValue, o, endName, particle, parentParticle);
/*      */         }
/*      */ 
/*      */       }
/* 1192 */       else if ((parentParticle != null) && (hasWildcard) && (this.stack.size() > 1))
/*      */       {
/* 1195 */         ListIterator iter = this.stack.prevIterator();
/* 1196 */         while (iter.hasPrevious())
/*      */         {
/* 1198 */           StackItem peeked = (StackItem)iter.previous();
/* 1199 */           peeked.o = o;
/* 1200 */           if (peeked.cursor == null)
/*      */           {
/*      */             break;
/*      */           }
/*      */         }
/*      */ 
/* 1206 */         if (this.trace)
/*      */         {
/* 1208 */           log.trace("Value of " + endName + " " + o + " is promoted as the value of its parent element.");
/*      */         }
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1214 */       StackItem popped = pop();
/*      */ 
/* 1216 */       for (int i = interceptorsTotal - 1; i >= 0; i--)
/*      */       {
/* 1218 */         ElementInterceptor interceptor = (ElementInterceptor)interceptors.get(i);
/* 1219 */         parent = pop().o;
/* 1220 */         interceptor.add(parent, o, endName);
/* 1221 */         o = parent;
/*      */       }
/*      */ 
/* 1224 */       for (int i = localInterceptorsTotal - 1; i >= 0; i--)
/*      */       {
/* 1226 */         ElementInterceptor interceptor = (ElementInterceptor)localInterceptors.get(i);
/* 1227 */         parent = pop().o;
/* 1228 */         interceptor.add(parent, o, endName);
/* 1229 */         o = parent;
/*      */       }
/*      */ 
/* 1233 */       this.stack.push(popped);
/*      */     }
/*      */ 
/* 1236 */     if (this.stack.size() == 1)
/*      */     {
/* 1238 */       o = type.getValueAdapter().cast(o, Object.class);
/* 1239 */       this.root = o;
/* 1240 */       this.stack.clear();
/* 1241 */       if (this.sawDTD)
/*      */       {
/*      */         try
/*      */         {
/* 1247 */           Class[] sig = { String.class, String.class, String.class };
/* 1248 */           Method setDTD = o.getClass().getMethod("setDTD", sig);
/* 1249 */           Object[] args = { this.dtdRootName, this.dtdPublicId, this.dtdSystemId };
/* 1250 */           setDTD.invoke(o, args);
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1254 */           log.debug("No setDTD found on root: " + o);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void setParent(ParticleHandler handler, Object parent, Object o, QName endName, ParticleBinding particle, ParticleBinding parentParticle)
/*      */   {
/* 1267 */     TermBeforeSetParentCallback beforeSetParent = particle.getTerm().getBeforeSetParentCallback();
/* 1268 */     if (beforeSetParent != null)
/*      */     {
/* 1270 */       this.ctx.parent = parent;
/* 1271 */       this.ctx.particle = particle;
/* 1272 */       this.ctx.parentParticle = parentParticle;
/* 1273 */       o = beforeSetParent.beforeSetParent(o, this.ctx);
/* 1274 */       this.ctx.clear();
/*      */     }
/*      */ 
/* 1277 */     if ((parent instanceof ValueList))
/*      */     {
/* 1279 */       if (parent == o)
/*      */       {
/* 1281 */         return;
/*      */       }
/* 1283 */       ValueList valueList = (ValueList)parent;
/* 1284 */       valueList.getInitializer().addTermValue(endName, particle, handler, valueList, o, parentParticle);
/*      */     }
/*      */     else
/*      */     {
/* 1288 */       handler.setParent(parent, o, endName, particle, parentParticle);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void push(ParticleBinding particle, Object o, ParticleHandler handler, TypeBinding parentType)
/*      */   {
/* 1294 */     StackItem item = new StackItem(particle);
/* 1295 */     item.o = o;
/* 1296 */     item.handler = handler;
/* 1297 */     item.parentType = parentType;
/* 1298 */     this.stack.push(item);
/* 1299 */     if (this.trace)
/*      */     {
/* 1301 */       Object binding = null;
/* 1302 */       if (particle != null)
/*      */       {
/* 1304 */         binding = particle.getTerm();
/*      */       }
/* 1306 */       log.trace("pushed " + ((ElementBinding)particle.getTerm()).getQName() + "=" + o + ", binding=" + binding);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void push(ModelGroupBinding.Cursor cursor, Object o, ParticleHandler handler, TypeBinding parentType)
/*      */   {
/* 1312 */     StackItem item = new StackItem(cursor);
/* 1313 */     item.o = o;
/* 1314 */     item.handler = handler;
/* 1315 */     item.parentType = parentType;
/* 1316 */     this.stack.push(item);
/* 1317 */     if (this.trace)
/*      */     {
/* 1319 */       log.trace("pushed cursor " + cursor + ", o=" + o);
/*      */     }
/*      */   }
/*      */ 
/*      */   private StackItem pop()
/*      */   {
/* 1325 */     StackItem item = this.stack.pop();
/* 1326 */     if (this.trace)
/*      */     {
/* 1328 */       if (item.cursor == null)
/*      */       {
/* 1330 */         log.trace("poped " + ((ElementBinding)item.particle.getTerm()).getQName() + "=" + item.particle);
/*      */       }
/*      */       else
/*      */       {
/* 1334 */         log.trace("poped " + item.cursor.getCurrentParticle().getTerm());
/*      */       }
/*      */     }
/* 1337 */     return item;
/*      */   }
/*      */ 
/*      */   private class UnmarshallingContextImpl
/*      */     implements UnmarshallingContext
/*      */   {
/*      */     Object parent;
/*      */     ParticleBinding particle;
/*      */     ParticleBinding parentParticle;
/*      */ 
/*      */     private UnmarshallingContextImpl()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Object getParentValue()
/*      */     {
/* 1448 */       return this.parent;
/*      */     }
/*      */ 
/*      */     public ParticleBinding getParticle()
/*      */     {
/* 1453 */       return this.particle;
/*      */     }
/*      */ 
/*      */     public ParticleBinding getParentParticle()
/*      */     {
/* 1458 */       return this.parentParticle;
/*      */     }
/*      */ 
/*      */     public String resolvePropertyName()
/*      */     {
/* 1463 */       TermBinding term = this.particle.getTerm();
/* 1464 */       PropertyMetaData propertyMetaData = term.getPropertyMetaData();
/* 1465 */       String prop = propertyMetaData == null ? null : propertyMetaData.getName();
/*      */ 
/* 1467 */       if (prop != null)
/*      */       {
/* 1469 */         return prop;
/*      */       }
/*      */ 
/* 1472 */       if (term.isElement())
/*      */       {
/* 1474 */         QName name = ((ElementBinding)term).getQName();
/* 1475 */         prop = Util.xmlNameToFieldName(name.getLocalPart(), term.getSchema().isIgnoreLowLine());
/*      */       }
/*      */ 
/* 1478 */       return prop;
/*      */     }
/*      */ 
/*      */     public Class resolvePropertyType()
/*      */     {
/* 1483 */       if (this.parent == null)
/*      */       {
/* 1485 */         return null;
/*      */       }
/*      */ 
/* 1488 */       String prop = resolvePropertyName();
/* 1489 */       if (prop != null)
/*      */       {
/* 1491 */         FieldInfo fieldInfo = FieldInfo.getFieldInfo(this.parent.getClass(), prop, false);
/* 1492 */         if (fieldInfo != null)
/*      */         {
/* 1494 */           return fieldInfo.getType();
/*      */         }
/*      */       }
/* 1497 */       return null;
/*      */     }
/*      */ 
/*      */     void clear()
/*      */     {
/* 1504 */       SundayContentHandler.this.ctx.parent = null;
/* 1505 */       SundayContentHandler.this.ctx.particle = null;
/* 1506 */       SundayContentHandler.this.ctx.parentParticle = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   static class StackImpl
/*      */   {
/* 1397 */     private List list = new ArrayList();
/*      */ 
/*      */     public void clear()
/*      */     {
/* 1401 */       this.list.clear();
/*      */     }
/*      */ 
/*      */     public void push(SundayContentHandler.StackItem o)
/*      */     {
/* 1406 */       this.list.add(o);
/*      */     }
/*      */ 
/*      */     public SundayContentHandler.StackItem pop()
/*      */     {
/* 1411 */       return (SundayContentHandler.StackItem)this.list.remove(this.list.size() - 1);
/*      */     }
/*      */ 
/*      */     public ListIterator prevIterator()
/*      */     {
/* 1416 */       return this.list.listIterator(this.list.size() - 1);
/*      */     }
/*      */ 
/*      */     public SundayContentHandler.StackItem peek()
/*      */     {
/* 1421 */       return (SundayContentHandler.StackItem)this.list.get(this.list.size() - 1);
/*      */     }
/*      */ 
/*      */     public SundayContentHandler.StackItem peek(int i)
/*      */     {
/* 1426 */       return (SundayContentHandler.StackItem)this.list.get(this.list.size() - 1 - i);
/*      */     }
/*      */ 
/*      */     public boolean isEmpty()
/*      */     {
/* 1431 */       return this.list.isEmpty();
/*      */     }
/*      */ 
/*      */     public int size()
/*      */     {
/* 1436 */       return this.list.size();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class StackItem
/*      */   {
/*      */     final ModelGroupBinding.Cursor cursor;
/*      */     ParticleBinding particle;
/*      */     ParticleHandler handler;
/*      */     TypeBinding parentType;
/*      */     boolean ignoreCharacters;
/*      */     Object o;
/*      */     ValueList repeatableParticleValue;
/*      */     StringBuffer textContent;
/*      */     Boolean indentation;
/* 1353 */     boolean ignorableCharacters = true;
/*      */     boolean ended;
/*      */ 
/*      */     public StackItem(ModelGroupBinding.Cursor cursor)
/*      */     {
/* 1358 */       if (cursor == null) {
/* 1359 */         throw new IllegalArgumentException("Null cursor");
/*      */       }
/* 1361 */       this.cursor = cursor;
/* 1362 */       this.particle = cursor.getParticle();
/*      */     }
/*      */ 
/*      */     public StackItem(ParticleBinding particle)
/*      */     {
/* 1367 */       if (particle == null) {
/* 1368 */         throw new IllegalArgumentException("Null particle");
/*      */       }
/* 1370 */       this.cursor = null;
/* 1371 */       this.particle = particle;
/*      */     }
/*      */ 
/*      */     void reset()
/*      */     {
/* 1376 */       if (!this.ended)
/*      */       {
/* 1378 */         throw new JBossXBRuntimeException("Attempt to reset a particle that has already been reset: " + this.particle.getTerm());
/*      */       }
/*      */ 
/* 1383 */       this.ended = false;
/* 1384 */       this.o = null;
/* 1385 */       if (this.textContent != null)
/*      */       {
/* 1387 */         this.textContent.delete(0, this.textContent.length());
/*      */       }
/*      */ 
/* 1390 */       this.indentation = null;
/* 1391 */       this.ignorableCharacters = true;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.SundayContentHandler
 * JD-Core Version:    0.6.0
 */