/*    */ package org.jboss.xb.binding.sunday.xop;
/*    */ 
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.ByteArrayOutputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import java.io.OutputStream;
/*    */ import javax.activation.DataSource;
/*    */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*    */ 
/*    */ public class SimpleDataSource
/*    */   implements DataSource
/*    */ {
/*    */   public final byte[] bytes;
/*    */   public final String contentType;
/*    */ 
/*    */   public SimpleDataSource(Object o, String contentType)
/*    */   {
/* 45 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 46 */     ObjectOutputStream oos = null;
/*    */     try
/*    */     {
/* 49 */       oos = new ObjectOutputStream(baos);
/* 50 */       oos.writeObject(o);
/*    */     }
/*    */     catch (IOException e)
/*    */     {
/* 54 */       throw new JBossXBRuntimeException("XOP failed to serialize object " + o + ": " + e.getMessage());
/*    */     }
/*    */     finally
/*    */     {
/* 58 */       if (oos != null)
/*    */       {
/*    */         try
/*    */         {
/* 62 */           oos.close();
/*    */         }
/*    */         catch (IOException e)
/*    */         {
/*    */         }
/*    */       }
/*    */     }
/* 69 */     this.bytes = baos.toByteArray();
/*    */ 
/* 71 */     this.contentType = contentType;
/*    */   }
/*    */ 
/*    */   public String getContentType()
/*    */   {
/* 76 */     return this.contentType;
/*    */   }
/*    */ 
/*    */   public InputStream getInputStream() throws IOException
/*    */   {
/* 81 */     return new ByteArrayInputStream(this.bytes);
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 86 */     throw new UnsupportedOperationException("getName is not implemented.");
/*    */   }
/*    */ 
/*    */   public OutputStream getOutputStream() throws IOException
/*    */   {
/* 91 */     throw new UnsupportedOperationException("getOutputStream is not implemented.");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.xop.SimpleDataSource
 * JD-Core Version:    0.6.0
 */