/*     */ package org.jboss.xb.builder.runtime;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
/*     */ import org.jboss.xb.spi.BeanAdapter;
/*     */ import org.jboss.xb.spi.BeanAdapterFactory;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class BeanHandler extends DefaultElementHandler
/*     */ {
/*  47 */   private final Logger log = Logger.getLogger(getClass());
/*     */ 
/*  50 */   private boolean trace = this.log.isTraceEnabled();
/*     */   private String name;
/*     */   private BeanAdapterFactory beanAdapterFactory;
/*     */ 
/*     */   public BeanHandler(String name, BeanAdapterFactory beanAdapterFactory)
/*     */   {
/*  67 */     if (name == null)
/*  68 */       throw new IllegalArgumentException("Null name");
/*  69 */     if (beanAdapterFactory == null)
/*  70 */       throw new IllegalArgumentException("Null bean adapter factory");
/*  71 */     this.name = name;
/*  72 */     this.beanAdapterFactory = beanAdapterFactory;
/*     */   }
/*     */ 
/*     */   public BeanAdapterFactory getBeanAdapterFactory()
/*     */   {
/*  82 */     return this.beanAdapterFactory;
/*     */   }
/*     */ 
/*     */   public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx)
/*     */   {
/* 107 */     if (this.trace) {
/* 108 */       this.log.trace(" startElement " + elementName + " bean=" + this.name + " parent=" + BuilderUtil.toDebugString(parent));
/*     */     }
/* 110 */     Object o = null;
/*     */     try
/*     */     {
/* 113 */       o = this.beanAdapterFactory.newInstance();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 117 */       throw new RuntimeException("QName " + elementName + " error invoking beanAdapterFactory.newInstance() for bean=" + this.name, t);
/*     */     }
/*     */ 
/* 120 */     if ((o != null) && (particle.getTerm().isElement()))
/*     */     {
/* 122 */       ElementBinding element = (ElementBinding)particle.getTerm();
/* 123 */       attrs = element.getType().expandWithDefaultAttributes(attrs);
/* 124 */       attributes(o, elementName, element, attrs, nsCtx);
/*     */     }
/* 126 */     return o;
/*     */   }
/*     */ 
/*     */   public void setParent(Object parent, Object o, QName qName, ParticleBinding particle, ParticleBinding parentParticle)
/*     */   {
/* 132 */     if (this.trace) {
/* 133 */       this.log.trace("setParent " + qName + " parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o));
/*     */     }
/* 135 */     TermBinding term = particle.getTerm();
/* 136 */     ValueAdapter valueAdapter = null;
/* 137 */     if (term.isModelGroup())
/*     */     {
/* 139 */       QName modelGroupName = ((ModelGroupBinding)term).getQName();
/* 140 */       if (modelGroupName != null)
/*     */       {
/* 142 */         qName = modelGroupName;
/*     */       }
/*     */     }
/* 145 */     else if (term.isElement())
/*     */     {
/* 147 */       valueAdapter = ((ElementBinding)term).getValueAdapter();
/*     */     }
/*     */ 
/* 150 */     if ((parent != null) && ((parent instanceof ArrayWrapper)))
/*     */     {
/* 152 */       ArrayWrapper wrapper = (ArrayWrapper)parent;
/* 153 */       wrapper.add(o);
/* 154 */       wrapper.setChildParticle(particle);
/* 155 */       wrapper.setParentParticle(parentParticle);
/* 156 */       return;
/*     */     }
/*     */     BeanAdapter beanAdapter;
/*     */     BeanAdapter beanAdapter;
/* 160 */     if ((parent instanceof ArrayWrapper))
/* 161 */       beanAdapter = (BeanAdapter)((ArrayWrapper)parent).getParent();
/*     */     else
/* 163 */       beanAdapter = (BeanAdapter)parent;
/* 164 */     AbstractPropertyHandler propertyHandler = beanAdapter.getPropertyHandler(qName);
/* 165 */     if (propertyHandler == null)
/*     */     {
/* 167 */       AbstractPropertyHandler wildcardHandler = beanAdapter.getWildcardHandler();
/* 168 */       if (wildcardHandler != null)
/*     */       {
/* 170 */         if ((o != null) && ((o instanceof ArrayWrapper)))
/*     */         {
/* 172 */           ArrayWrapper wrapper = (ArrayWrapper)o;
/* 173 */           wildcardHandler.doHandle(beanAdapter, wrapper, wrapper.getElementName());
/* 174 */           return;
/*     */         }
/*     */       }
/* 177 */       TermBinding element = term;
/* 178 */       if (element.getSchema().isStrictSchema())
/*     */       {
/* 180 */         throw new RuntimeException("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o) + " available=" + beanAdapter.getAvailable());
/*     */       }
/* 182 */       if (this.trace)
/* 183 */         this.log.trace("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o));
/* 184 */       return;
/*     */     }
/*     */     Iterator i$;
/* 187 */     if ((particle.isRepeatable()) && ((propertyHandler instanceof CollectionPropertyHandler)))
/*     */     {
/* 191 */       for (i$ = ((Collection)o).iterator(); i$.hasNext(); ) { Object item = i$.next();
/*     */ 
/* 193 */         if (valueAdapter != null)
/*     */         {
/* 195 */           item = valueAdapter.cast(item, null);
/*     */         }
/* 197 */         propertyHandler.doHandle(beanAdapter, item, qName);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 203 */       if (valueAdapter != null)
/*     */       {
/* 205 */         o = valueAdapter.cast(o, null);
/*     */       }
/* 207 */       propertyHandler.doHandle(beanAdapter, o, qName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object endParticle(Object o, QName qName, ParticleBinding particle)
/*     */   {
/* 223 */     if (this.trace) {
/* 224 */       this.log.trace("endElement " + qName + " o=" + BuilderUtil.toDebugString(o));
/*     */     }
/* 226 */     BeanAdapter beanAdapter = (BeanAdapter)o;
/* 227 */     return beanAdapter.getValue();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.runtime.BeanHandler
 * JD-Core Version:    0.6.0
 */