/*     */ package org.jboss.xb.builder.runtime;
/*     */ 
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
/*     */ import org.jboss.xb.spi.BeanAdapter;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class ChildWildcardHandler
/*     */   implements ParticleHandler
/*     */ {
/*     */   private PropertyInfo propertyInfo;
/*     */   private BeanInfo beanInfo;
/*     */   private String property;
/*     */ 
/*     */   public ChildWildcardHandler(PropertyInfo propertyInfo)
/*     */   {
/*  61 */     if (propertyInfo == null)
/*  62 */       throw new IllegalArgumentException("Null propertyInfo");
/*  63 */     this.propertyInfo = propertyInfo;
/*     */   }
/*     */ 
/*     */   public ChildWildcardHandler(PropertyInfo propertyInfo, BeanInfo beanInfo, String property)
/*     */   {
/*  76 */     if (propertyInfo == null)
/*  77 */       throw new IllegalArgumentException("Null propertyInfo");
/*  78 */     if (beanInfo == null)
/*  79 */       throw new IllegalArgumentException("Null beanInfo");
/*  80 */     if (property == null)
/*  81 */       throw new IllegalArgumentException("Null property");
/*  82 */     this.propertyInfo = propertyInfo;
/*  83 */     this.beanInfo = beanInfo;
/*  84 */     this.property = property;
/*     */   }
/*     */ 
/*     */   public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx)
/*     */   {
/*  89 */     return parent;
/*     */   }
/*     */ 
/*     */   public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle)
/*     */   {
/*  95 */     BeanAdapter beanAdapter = (BeanAdapter)parent;
/*  96 */     if (this.beanInfo != null)
/*     */     {
/*     */       try
/*     */       {
/* 100 */         ClassInfo classInfo = this.beanInfo.getClassInfo();
/* 101 */         TypeInfo valueType = classInfo.getTypeInfoFactory().getTypeInfo(o.getClass());
/* 102 */         if (!classInfo.isAssignableFrom(valueType))
/*     */         {
/* 104 */           Object wrapper = this.beanInfo.newInstance();
/* 105 */           this.beanInfo.setProperty(wrapper, this.property, o);
/* 106 */           o = wrapper;
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 111 */         throw new RuntimeException("Error wrapping object in " + this.beanInfo.getName());
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 116 */       beanAdapter.set(this.propertyInfo, o);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 120 */       throw new RuntimeException("Error setting wildcard property " + this.propertyInfo.getName() + " parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object endParticle(Object o, QName elementName, ParticleBinding particle)
/*     */   {
/* 126 */     return o;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.runtime.ChildWildcardHandler
 * JD-Core Version:    0.6.0
 */