/*     */ package org.jboss.xb.util;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.helpers.AttributesImpl;
/*     */ 
/*     */ public class Dom2Sax
/*     */ {
/*     */   public static void dom2sax(Element e, ContentHandler ch)
/*     */     throws SAXException
/*     */   {
/*  46 */     if (e == null)
/*     */     {
/*  48 */       throw new IllegalArgumentException("The element argument must not be null!");
/*     */     }
/*     */ 
/*  51 */     ch.startDocument();
/*     */ 
/*  53 */     process(e, ch, new NamespaceRegistry());
/*     */ 
/*  55 */     ch.endDocument();
/*     */   }
/*     */ 
/*     */   private static void process(Element e, ContentHandler ch, NamespaceRegistry nsReg) throws SAXException
/*     */   {
/*  60 */     AttributesImpl attrs = new AttributesImpl();
/*     */ 
/*  62 */     List startedPrefixes = Collections.EMPTY_LIST;
/*     */ 
/*  64 */     NamedNodeMap domAttrs = e.getAttributes();
/*  65 */     if ((domAttrs != null) && (domAttrs.getLength() > 0))
/*     */     {
/*  68 */       for (int i = 0; i < domAttrs.getLength(); i++)
/*     */       {
/*  70 */         Attr attr = (Attr)domAttrs.item(i);
/*  71 */         String attrNs = attr.getNamespaceURI();
/*  72 */         String attrLocal = attr.getLocalName();
/*  73 */         if (attrLocal == null)
/*     */         {
/*  75 */           attrLocal = attr.getNodeName();
/*     */         }
/*     */ 
/*  78 */         if ((attrNs == null) || (!isXmlns(attrNs)))
/*     */           continue;
/*     */         String attrPrefix;
/*     */         String prefix;
/*     */         String attrPrefix;
/*  82 */         if ("xmlns".equals(attrLocal))
/*     */         {
/*  84 */           String prefix = "";
/*  85 */           attrPrefix = "";
/*     */         }
/*     */         else
/*     */         {
/*  89 */           prefix = attrLocal;
/*  90 */           attrPrefix = "xmlns";
/*     */         }
/*     */ 
/*  93 */         String attrVal = attr.getValue();
/*  94 */         nsReg.addPrefixMapping(prefix, attrVal);
/*  95 */         ch.startPrefixMapping(prefix, attrVal);
/*  96 */         startedPrefixes = add(startedPrefixes, prefix);
/*     */ 
/*  98 */         attrs.addAttribute(attrNs, attrLocal, buildQName(attrPrefix, attrLocal), null, attrVal);
/*     */       }
/*     */ 
/* 102 */       for (int i = 0; i < domAttrs.getLength(); i++)
/*     */       {
/* 104 */         Attr attr = (Attr)domAttrs.item(i);
/* 105 */         String attrNs = attr.getNamespaceURI();
/* 106 */         String attrLocal = attr.getLocalName();
/* 107 */         if (attrLocal == null)
/*     */         {
/* 109 */           attrLocal = attr.getNodeName();
/*     */         }
/*     */ 
/* 112 */         if (attrNs == null)
/*     */         {
/* 114 */           attrNs = "";
/*     */         }
/*     */ 
/* 117 */         if (isXmlns(attrNs))
/*     */           continue;
/* 119 */         String prefix = nsReg.getPrefix(attrNs);
/* 120 */         if ((prefix == null) && (attrNs.length() > 0))
/*     */         {
/* 122 */           prefix = attrLocal + "_ns";
/* 123 */           nsReg.addPrefixMapping(prefix, attrNs);
/* 124 */           ch.startPrefixMapping(prefix, attrNs);
/* 125 */           startedPrefixes = add(startedPrefixes, prefix);
/* 126 */           attrs.addAttribute("http://www.w3.org/2001/XMLSchema", prefix, "xmlns:" + prefix, null, attrNs);
/*     */         }
/*     */ 
/* 129 */         attrs.addAttribute(attrNs, attrLocal, buildQName(prefix, attrLocal), null, attr.getValue());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 134 */     String localName = e.getLocalName();
/* 135 */     if (localName == null)
/*     */     {
/* 137 */       localName = e.getNodeName();
/*     */     }
/*     */ 
/* 140 */     String ns = e.getNamespaceURI();
/* 141 */     if (ns == null)
/*     */     {
/* 143 */       ns = "";
/*     */     }
/*     */ 
/* 146 */     String prefix = nsReg.getPrefix(ns);
/* 147 */     if ((prefix == null) && (ns.length() > 0))
/*     */     {
/* 149 */       prefix = localName + "_ns";
/* 150 */       nsReg.addPrefixMapping(prefix, ns);
/* 151 */       ch.startPrefixMapping(prefix, ns);
/* 152 */       startedPrefixes = add(startedPrefixes, prefix);
/* 153 */       attrs.addAttribute("http://www.w3.org/2001/XMLSchema", prefix, "xmlns:" + prefix, null, ns);
/*     */     }
/*     */ 
/* 156 */     String qName = buildQName(prefix, localName);
/* 157 */     ch.startElement(ns, localName, qName, attrs);
/*     */ 
/* 159 */     NodeList childNodes = e.getChildNodes();
/* 160 */     if ((childNodes != null) && (childNodes.getLength() > 0))
/*     */     {
/* 162 */       for (int i = 0; i < childNodes.getLength(); i++)
/*     */       {
/* 164 */         Node node = childNodes.item(i);
/* 165 */         switch (node.getNodeType())
/*     */         {
/*     */         case 1:
/* 168 */           process((Element)node, ch, nsReg);
/* 169 */           break;
/*     */         case 3:
/*     */         case 4:
/* 172 */           String value = node.getNodeValue();
/* 173 */           ch.characters(value.toCharArray(), 0, value.length());
/* 174 */           break;
/*     */         case 5:
/* 176 */           String ref = '&' + node.getNodeName() + ';';
/* 177 */           ch.characters(ref.toCharArray(), 0, ref.length());
/* 178 */           break;
/*     */         case 6:
/* 180 */           ch.skippedEntity(node.getNodeName());
/*     */         case 2:
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 186 */     ch.endElement(ns, localName, qName);
/*     */ 
/* 188 */     if (startedPrefixes.size() > 0)
/*     */     {
/* 190 */       for (int i = startedPrefixes.size() - 1; i >= 0; i--)
/*     */       {
/* 192 */         String pref = (String)startedPrefixes.get(i);
/* 193 */         nsReg.removePrefixMapping(pref);
/* 194 */         ch.endPrefixMapping(pref);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static boolean isXmlns(String ns)
/*     */   {
/* 201 */     return ns.startsWith("http://www.w3.org/2000/xmlns");
/*     */   }
/*     */ 
/*     */   private static String buildQName(String prefix, String localName)
/*     */   {
/* 206 */     return prefix + ':' + localName;
/*     */   }
/*     */ 
/*     */   private static List add(List list, Object o)
/*     */   {
/* 213 */     switch (list.size())
/*     */     {
/*     */     case 0:
/* 216 */       list = Collections.singletonList(o);
/* 217 */       break;
/*     */     case 1:
/* 219 */       list = new ArrayList(list);
/*     */     default:
/* 221 */       list.add(o);
/*     */     }
/* 223 */     return list;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.util.Dom2Sax
 * JD-Core Version:    0.6.0
 */