/*    */ package org.jnp.interfaces;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.Serializable;
/*    */ import java.rmi.MarshalledObject;
/*    */ 
/*    */ public class MarshalledValuePair
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -3403843515711139134L;
/* 40 */   private static boolean enableCallByReference = true;
/*    */   public MarshalledObject marshalledValue;
/*    */   public transient Object value;
/*    */ 
/*    */   public static boolean getEnableCallByReference()
/*    */   {
/* 50 */     return enableCallByReference;
/*    */   }
/*    */ 
/*    */   public static void setEnableCallByReference(boolean flag)
/*    */   {
/* 58 */     enableCallByReference = flag;
/*    */   }
/*    */ 
/*    */   public MarshalledValuePair(Object value)
/*    */     throws IOException
/*    */   {
/* 64 */     this.value = value;
/* 65 */     this.marshalledValue = new MarshalledObject(value);
/*    */   }
/*    */ 
/*    */   public Object get() throws ClassNotFoundException, IOException
/*    */   {
/* 70 */     Object theValue = enableCallByReference ? this.value : null;
/* 71 */     if ((theValue == null) && (this.marshalledValue != null))
/* 72 */       theValue = this.marshalledValue.get();
/* 73 */     return theValue;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jnp.interfaces.MarshalledValuePair
 * JD-Core Version:    0.6.0
 */