/*     */ package org.jnp.server;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Vector;
/*     */ import javax.naming.Binding;
/*     */ import javax.naming.CannotProceedException;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InvalidNameException;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameAlreadyBoundException;
/*     */ import javax.naming.NameClassPair;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.NotContextException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.spi.ResolveResult;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jnp.interfaces.Naming;
/*     */ import org.jnp.interfaces.NamingContext;
/*     */ import org.jnp.interfaces.NamingParser;
/*     */ 
/*     */ public class NamingServer
/*     */   implements Naming, Serializable
/*     */ {
/*  58 */   private static Logger log = Logger.getLogger(NamingServer.class);
/*     */   private static final long serialVersionUID = 4183855539507934373L;
/*  66 */   protected Hashtable table = new Hashtable();
/*     */   protected Name prefix;
/*  68 */   protected NamingParser parser = new NamingParser();
/*     */   protected NamingServer parent;
/*     */ 
/*     */   public NamingServer()
/*     */     throws NamingException
/*     */   {
/*  77 */     this(null, null);
/*     */   }
/*     */ 
/*     */   public NamingServer(Name prefix, NamingServer parent)
/*     */     throws NamingException
/*     */   {
/*  83 */     if (prefix == null) prefix = this.parser.parse("");
/*  84 */     this.prefix = prefix;
/*     */ 
/*  86 */     this.parent = parent;
/*     */   }
/*     */ 
/*     */   public synchronized void bind(Name name, Object obj, String className)
/*     */     throws NamingException
/*     */   {
/*  95 */     if (name.isEmpty())
/*     */     {
/*  98 */       throw new InvalidNameException();
/*  99 */     }if (name.size() > 1)
/*     */     {
/* 104 */       Object ctx = getObject(name);
/* 105 */       if (ctx != null)
/*     */       {
/* 107 */         if ((ctx instanceof NamingServer))
/*     */         {
/* 109 */           ((NamingServer)ctx).bind(name.getSuffix(1), obj, className); } else {
/* 110 */           if ((ctx instanceof Reference))
/*     */           {
/* 113 */             if (((Reference)ctx).get("nns") != null)
/*     */             {
/* 115 */               CannotProceedException cpe = new CannotProceedException();
/* 116 */               cpe.setResolvedObj(ctx);
/* 117 */               cpe.setRemainingName(name.getSuffix(1));
/* 118 */               throw cpe;
/*     */             }
/*     */ 
/* 121 */             throw new NotContextException();
/*     */           }
/*     */ 
/* 125 */           throw new NotContextException();
/*     */         }
/*     */       }
/*     */       else {
/* 129 */         throw new NameNotFoundException();
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 134 */       if (name.get(0).equals(""))
/*     */       {
/* 136 */         throw new InvalidNameException();
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 142 */         getBinding(name);
/*     */ 
/* 144 */         throw new NameAlreadyBoundException();
/*     */       }
/*     */       catch (NameNotFoundException e) {
/* 147 */         setBinding(name, obj, className);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void rebind(Name name, Object obj, String className)
/*     */     throws NamingException
/*     */   {
/* 156 */     if (name.isEmpty())
/*     */     {
/* 159 */       throw new InvalidNameException();
/* 160 */     }if (name.size() > 1)
/*     */     {
/* 165 */       Object ctx = getObject(name);
/* 166 */       if ((ctx instanceof NamingServer))
/*     */       {
/* 168 */         ((NamingServer)ctx).rebind(name.getSuffix(1), obj, className); } else {
/* 169 */         if ((ctx instanceof Reference))
/*     */         {
/* 172 */           if (((Reference)ctx).get("nns") != null)
/*     */           {
/* 174 */             CannotProceedException cpe = new CannotProceedException();
/* 175 */             cpe.setResolvedObj(ctx);
/* 176 */             cpe.setRemainingName(name.getSuffix(1));
/* 177 */             throw cpe;
/*     */           }
/*     */ 
/* 180 */           throw new NotContextException();
/*     */         }
/*     */ 
/* 184 */         throw new NotContextException();
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 189 */       if (name.get(0).equals(""))
/*     */       {
/* 191 */         throw new InvalidNameException();
/*     */       }
/*     */ 
/* 195 */       setBinding(name, obj, className);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void unbind(Name name)
/*     */     throws NamingException
/*     */   {
/* 203 */     if (name.isEmpty())
/*     */     {
/* 206 */       throw new InvalidNameException();
/* 207 */     }if (name.size() > 1)
/*     */     {
/* 212 */       Object ctx = getObject(name);
/* 213 */       if ((ctx instanceof NamingServer))
/*     */       {
/* 215 */         ((NamingServer)ctx).unbind(name.getSuffix(1)); } else {
/* 216 */         if ((ctx instanceof Reference))
/*     */         {
/* 219 */           if (((Reference)ctx).get("nns") != null)
/*     */           {
/* 221 */             CannotProceedException cpe = new CannotProceedException();
/* 222 */             cpe.setResolvedObj(ctx);
/* 223 */             cpe.setRemainingName(name.getSuffix(1));
/* 224 */             throw cpe;
/*     */           }
/*     */ 
/* 227 */           throw new NotContextException();
/*     */         }
/*     */ 
/* 231 */         throw new NotContextException();
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 236 */       if (name.get(0).equals(""))
/*     */       {
/* 238 */         throw new InvalidNameException();
/*     */       }
/*     */ 
/* 242 */       if (getBinding(name) != null)
/*     */       {
/* 244 */         removeBinding(name);
/*     */       }
/*     */       else
/* 247 */         throw new NameNotFoundException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object lookup(Name name)
/*     */     throws NamingException
/*     */   {
/*     */     Object result;
/*     */     Object result;
/* 258 */     if (name.isEmpty())
/*     */     {
/* 261 */       result = new NamingContext(null, (Name)(Name)this.prefix.clone(), getRoot());
/*     */     }
/*     */     else
/*     */     {
/*     */       Object result;
/* 262 */       if (name.size() > 1)
/*     */       {
/* 267 */         Object ctx = getObject(name);
/*     */         Object result;
/* 268 */         if ((ctx instanceof NamingServer))
/*     */         {
/* 270 */           result = ((NamingServer)ctx).lookup(name.getSuffix(1));
/*     */         }
/*     */         else
/*     */         {
/*     */           Object result;
/* 271 */           if ((ctx instanceof Reference))
/*     */           {
/* 274 */             if (((Reference)ctx).get("nns") != null)
/*     */             {
/* 276 */               CannotProceedException cpe = new CannotProceedException();
/* 277 */               cpe.setResolvedObj(ctx);
/* 278 */               cpe.setRemainingName(name.getSuffix(1));
/* 279 */               throw cpe;
/*     */             }
/*     */ 
/* 282 */             result = new ResolveResult(ctx, name.getSuffix(1));
/*     */           }
/*     */           else {
/* 285 */             throw new NotContextException();
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/*     */         Object result;
/* 290 */         if (name.get(0).equals(""))
/*     */         {
/* 292 */           result = new NamingContext(null, this.prefix, getRoot());
/*     */         }
/*     */         else
/*     */         {
/* 296 */           Object res = getObject(name);
/*     */           Object result;
/* 298 */           if ((res instanceof NamingServer))
/*     */           {
/* 300 */             Name fullName = (Name)(Name)this.prefix.clone();
/* 301 */             fullName.addAll(name);
/* 302 */             result = new NamingContext(null, fullName, getRoot());
/*     */           }
/*     */           else {
/* 305 */             result = res;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 309 */     return result;
/*     */   }
/*     */ 
/*     */   public Collection list(Name name)
/*     */     throws NamingException
/*     */   {
/* 316 */     if (name.isEmpty())
/*     */     {
/* 320 */       Vector list = new Vector();
/* 321 */       Enumeration keys = this.table.keys();
/* 322 */       while (keys.hasMoreElements())
/*     */       {
/* 324 */         String key = (String)keys.nextElement();
/* 325 */         Binding b = getBinding(key);
/*     */ 
/* 327 */         list.addElement(new NameClassPair(b.getName(), b.getClassName(), true));
/*     */       }
/* 329 */       return list;
/*     */     }
/*     */ 
/* 334 */     Object ctx = getObject(name);
/* 335 */     if ((ctx instanceof NamingServer))
/*     */     {
/* 337 */       return ((NamingServer)ctx).list(name.getSuffix(1));
/* 338 */     }if ((ctx instanceof Reference))
/*     */     {
/* 341 */       if (((Reference)ctx).get("nns") != null)
/*     */       {
/* 343 */         CannotProceedException cpe = new CannotProceedException();
/* 344 */         cpe.setResolvedObj(ctx);
/* 345 */         cpe.setRemainingName(name.getSuffix(1));
/* 346 */         throw cpe;
/*     */       }
/*     */ 
/* 349 */       throw new NotContextException();
/*     */     }
/*     */ 
/* 353 */     throw new NotContextException();
/*     */   }
/*     */ 
/*     */   public Collection listBindings(Name name)
/*     */     throws NamingException
/*     */   {
/* 361 */     if (name.isEmpty())
/*     */     {
/* 363 */       Collection bindings = this.table.values();
/* 364 */       Collection newBindings = new Vector(bindings.size());
/* 365 */       Iterator iter = bindings.iterator();
/* 366 */       while (iter.hasNext())
/*     */       {
/* 368 */         Binding b = (Binding)iter.next();
/* 369 */         if ((b.getObject() instanceof NamingServer))
/*     */         {
/* 371 */           Name n = (Name)this.prefix.clone();
/* 372 */           n.add(b.getName());
/* 373 */           newBindings.add(new Binding(b.getName(), b.getClassName(), new NamingContext(null, n, getRoot())));
/*     */         }
/*     */         else
/*     */         {
/* 378 */           newBindings.add(b);
/*     */         }
/*     */       }
/*     */ 
/* 382 */       return newBindings;
/*     */     }
/*     */ 
/* 385 */     Object ctx = getObject(name);
/* 386 */     if ((ctx instanceof NamingServer))
/*     */     {
/* 388 */       return ((NamingServer)ctx).listBindings(name.getSuffix(1));
/* 389 */     }if ((ctx instanceof Reference))
/*     */     {
/* 392 */       if (((Reference)ctx).get("nns") != null)
/*     */       {
/* 394 */         CannotProceedException cpe = new CannotProceedException();
/* 395 */         cpe.setResolvedObj(ctx);
/* 396 */         cpe.setRemainingName(name.getSuffix(1));
/* 397 */         throw cpe;
/*     */       }
/*     */ 
/* 400 */       throw new NotContextException();
/*     */     }
/*     */ 
/* 404 */     throw new NotContextException();
/*     */   }
/*     */ 
/*     */   public Context createSubcontext(Name name)
/*     */     throws NamingException
/*     */   {
/* 412 */     if (name.size() == 0) {
/* 413 */       throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
/*     */     }
/* 415 */     NamingException ex = null;
/* 416 */     Context subCtx = null;
/* 417 */     if (name.size() > 1)
/*     */     {
/* 419 */       Object ctx = getObject(name);
/* 420 */       if (ctx != null)
/*     */       {
/* 422 */         Name subCtxName = name.getSuffix(1);
/* 423 */         if ((ctx instanceof NamingServer))
/*     */         {
/* 425 */           subCtx = ((NamingServer)ctx).createSubcontext(subCtxName);
/*     */         } else {
/* 427 */           if ((ctx instanceof Reference))
/*     */           {
/* 430 */             if (((Reference)ctx).get("nns") != null)
/*     */             {
/* 432 */               CannotProceedException cpe = new CannotProceedException();
/* 433 */               cpe.setResolvedObj(ctx);
/* 434 */               cpe.setRemainingName(subCtxName);
/* 435 */               throw cpe;
/*     */             }
/*     */ 
/* 439 */             ex = new NotContextException();
/* 440 */             ex.setResolvedName(name.getPrefix(0));
/* 441 */             ex.setRemainingName(subCtxName);
/* 442 */             throw ex;
/*     */           }
/*     */ 
/* 447 */           ex = new NotContextException();
/* 448 */           ex.setResolvedName(name.getPrefix(0));
/* 449 */           ex.setRemainingName(subCtxName);
/* 450 */           throw ex;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 455 */         ex = new NameNotFoundException();
/* 456 */         ex.setRemainingName(name);
/* 457 */         throw ex;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 462 */       Object binding = this.table.get(name.get(0));
/* 463 */       if (binding != null)
/*     */       {
/* 465 */         ex = new NameAlreadyBoundException();
/* 466 */         ex.setResolvedName(this.prefix);
/* 467 */         ex.setRemainingName(name);
/* 468 */         throw ex;
/*     */       }
/*     */ 
/* 472 */       Name fullName = (Name)this.prefix.clone();
/* 473 */       fullName.addAll(name);
/* 474 */       NamingServer subContext = new NamingServer(fullName, this);
/* 475 */       setBinding(name, subContext, NamingContext.class.getName());
/* 476 */       subCtx = new NamingContext(null, fullName, getRoot());
/*     */     }
/*     */ 
/* 479 */     return subCtx;
/*     */   }
/*     */ 
/*     */   public Naming getRoot()
/*     */   {
/* 484 */     if (this.parent == null) {
/* 485 */       return this;
/*     */     }
/* 487 */     return this.parent.getRoot();
/*     */   }
/*     */ 
/*     */   private void setBinding(Name name, Object obj, String className)
/*     */   {
/* 499 */     String n = name.toString();
/* 500 */     this.table.put(n, new Binding(n, className, obj, true));
/* 501 */     if (log.isTraceEnabled())
/*     */     {
/* 503 */       StringBuffer tmp = new StringBuffer(super.toString());
/* 504 */       tmp.append(", setBinding: name=");
/* 505 */       tmp.append(name);
/* 506 */       tmp.append(", obj=");
/* 507 */       tmp.append(obj);
/* 508 */       tmp.append(", className=");
/* 509 */       tmp.append(className);
/* 510 */       log.trace(tmp.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private Binding getBinding(String key)
/*     */     throws NameNotFoundException
/*     */   {
/* 517 */     Binding b = (Binding)this.table.get(key);
/* 518 */     if (b == null)
/*     */     {
/* 520 */       if (log.isTraceEnabled())
/*     */       {
/* 522 */         StringBuffer tmp = new StringBuffer(super.toString());
/* 523 */         tmp.append(", No binding for: ");
/* 524 */         tmp.append(key);
/* 525 */         tmp.append(" in context ");
/* 526 */         tmp.append(this.prefix);
/* 527 */         tmp.append(", bindings:\n");
/* 528 */         Iterator bindings = this.table.values().iterator();
/* 529 */         while (bindings.hasNext())
/*     */         {
/* 531 */           Binding value = (Binding)bindings.next();
/* 532 */           tmp.append(value.getName());
/* 533 */           tmp.append('=');
/* 534 */           if (value.getObject() != null)
/* 535 */             tmp.append(value.getObject().toString());
/*     */           else
/* 537 */             tmp.append("null");
/* 538 */           tmp.append('\n');
/*     */         }
/* 540 */         log.trace(tmp.toString());
/*     */       }
/* 542 */       throw new NameNotFoundException(key + " not bound");
/*     */     }
/* 544 */     return b;
/*     */   }
/*     */ 
/*     */   private Binding getBinding(Name key)
/*     */     throws NameNotFoundException
/*     */   {
/* 550 */     return getBinding(key.get(0));
/*     */   }
/*     */ 
/*     */   private Object getObject(Name key)
/*     */     throws NameNotFoundException
/*     */   {
/* 556 */     return getBinding(key).getObject();
/*     */   }
/*     */ 
/*     */   private void removeBinding(Name name)
/*     */   {
/* 561 */     this.table.remove(name.get(0));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jnp.server.NamingServer
 * JD-Core Version:    0.6.0
 */