/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.util.SecurityActions;
import org.jboss.aop.util.reference.ConstructorPersistentReference;
import org.jboss.aop.util.reference.MethodPersistentReference;

public class MethodHashing {
    static Map methodHashesByName = new WeakHashMap();
    static Map methodHashesByClass = new WeakHashMap();
    static Map constructorHashesByClass = new WeakHashMap();

    public static Method findMethodByHash(Class clazz, long hash) throws Exception {
        return MethodHashing.findMethodByHash(clazz, new Long(hash));
    }

    public static Method findMethodByHash(Class clazz, Long hash) throws Exception {
        Map hashes = MethodHashing.getMethodHashes(clazz);
        MethodPersistentReference ref = (MethodPersistentReference)hashes.get(hash);
        if (ref != null) {
            return ref.getMethod();
        }
        if (clazz.isInterface()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int numInterfaces = interfaces.length;
            for (int count = 0; count < numInterfaces; ++count) {
                Method method = MethodHashing.findMethodByHash(interfaces[count], hash);
                if (method == null) continue;
                return method;
            }
        } else if (clazz.getSuperclass() != null) {
            return MethodHashing.findMethodByHash(clazz.getSuperclass(), hash);
        }
        return null;
    }

    public static Constructor findConstructorByHash(Class clazz, long hash) throws Exception {
        return MethodHashing.findConstructorByHash(clazz, new Long(hash));
    }

    public static Constructor findConstructorByHash(Class clazz, Long hash) throws Exception {
        Map hashes = MethodHashing.getConstructorHashes(clazz);
        ConstructorPersistentReference ref = (ConstructorPersistentReference)hashes.get(hash);
        if (ref != null) {
            return ref.getConstructor();
        }
        if (clazz.getSuperclass() != null) {
            return MethodHashing.findConstructorByHash(clazz, hash);
        }
        return null;
    }

    public static long methodHash(Method method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuffer methodDesc = new StringBuffer(method.getName() + "(");
        for (int j = 0; j < parameterTypes.length; ++j) {
            methodDesc.append(MethodHashing.getTypeString(parameterTypes[j]));
        }
        methodDesc.append(")" + MethodHashing.getTypeString(method.getReturnType()));
        return MethodHashing.createHash(methodDesc.toString());
    }

    public static long createHash(String methodDesc) throws Exception {
        long hash = 0L;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
        dataoutputstream.writeUTF(methodDesc);
        dataoutputstream.flush();
        byte[] abyte0 = messagedigest.digest();
        for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
            hash += (long)(abyte0[j] & 0xFF) << j * 8;
        }
        return hash;
    }

    public static long constructorHash(Constructor method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuffer methodDesc = new StringBuffer(method.getName() + "(");
        for (int j = 0; j < parameterTypes.length; ++j) {
            methodDesc.append(MethodHashing.getTypeString(parameterTypes[j]));
        }
        methodDesc.append(")");
        return MethodHashing.createHash(methodDesc.toString());
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + MethodHashing.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    public static long calculateHash(Method method) {
        Map methodHashes = (Map)methodHashesByName.get(method.getDeclaringClass());
        if (methodHashes == null) {
            methodHashes = MethodHashing.getInterfaceHashes(method.getDeclaringClass());
            WeakHashMap newHashMap = new WeakHashMap();
            newHashMap.putAll(methodHashesByName);
            newHashMap.put(method.getDeclaringClass(), methodHashes);
            methodHashesByName = newHashMap;
        }
        return (Long)methodHashes.get(method.toString());
    }

    public static Map getInterfaceHashes(Class intf) {
        Method[] methods = SecurityActions.getDeclaredMethods(intf);
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            try {
                long hash = MethodHashing.methodHash(method);
                map.put(method.toString(), new Long(hash));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return map;
    }

    private static Map getMethodHashes(Class clazz) {
        Map methodHashes = (Map)methodHashesByClass.get(clazz);
        if (methodHashes == null) {
            methodHashes = MethodHashing.getMethodHashMap(clazz);
            methodHashesByClass.put(clazz, methodHashes);
        }
        return methodHashes;
    }

    private static Map getMethodHashMap(Class clazz) {
        Method[] methods = SecurityActions.getDeclaredMethods(clazz);
        HashMap<Long, MethodPersistentReference> map = new HashMap<Long, MethodPersistentReference>();
        for (int i = 0; i < methods.length; ++i) {
            try {
                long hash = MethodHashing.methodHash(methods[i]);
                map.put(new Long(hash), new MethodPersistentReference(methods[i], 2));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return map;
    }

    private static Map getConstructorHashes(Class clazz) {
        Map constructorHashes = (Map)constructorHashesByClass.get(clazz);
        if (constructorHashes == null) {
            constructorHashes = MethodHashing.getConstructorHashMap(clazz);
            constructorHashesByClass.put(clazz, constructorHashes);
        }
        return constructorHashes;
    }

    private static Map getConstructorHashMap(Class clazz) {
        Constructor[] constructors = SecurityActions.getDeclaredConstructors(clazz);
        HashMap<Long, ConstructorPersistentReference> map = new HashMap<Long, ConstructorPersistentReference>();
        for (int i = 0; i < constructors.length; ++i) {
            try {
                long hash = MethodHashing.constructorHash(constructors[i]);
                map.put(new Long(hash), new ConstructorPersistentReference(constructors[i], 2));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return map;
    }
}

