/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.spi;

import java.io.Serializable;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AutowireType
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final AutowireType NONE = new AutowireType("None");
    public static final AutowireType BY_CLASS = new AutowireType("ByClass");
    public static final AutowireType BY_NAME = new AutowireType("ByName");
    public static final AutowireType CONSTRUCTOR = new AutowireType("Constructor");
    public static final AutowireType AUTO = new AutowireType("Auto");
    public static final AutowireType[] TYPES = new AutowireType[]{NONE, BY_CLASS, BY_NAME, CONSTRUCTOR, AUTO};
    protected final String typeString;

    private AutowireType(String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException("Null type string");
        }
        this.typeString = typeString;
    }

    public static AutowireType getInstance(String typeString) {
        for (AutowireType type : TYPES) {
            if (!type.getTypeString().equalsIgnoreCase(typeString)) continue;
            return type;
        }
        return NONE;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AutowireType)) {
            return false;
        }
        AutowireType other = (AutowireType)object;
        return this.typeString.equals(other.getTypeString());
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.typeString);
    }

    protected int getHashCode() {
        return this.typeString.hashCode();
    }
}

