/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.quartz;

import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.timerservice.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.quartz.QuartzTimerServiceFactory;
import org.jboss.ejb3.timerservice.quartz.TimerImpl;
import org.jboss.logging.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class PersistentTimer
implements Serializable,
TimerHandle {
    private static final Logger log = Logger.getLogger(PersistentTimer.class);
    private static final long serialVersionUID = 1L;
    private String triggerName;
    private String triggerGroup;
    private String containerGuid;
    private Serializable info;

    protected PersistentTimer(Trigger trigger, String containerGuid, Serializable info) {
        assert (trigger != null);
        assert (containerGuid != null);
        this.triggerName = trigger.getName();
        this.triggerGroup = trigger.getGroup();
        this.info = info;
        this.containerGuid = containerGuid;
    }

    protected TimedObjectInvoker getTimedObjectInvoker() {
        TimedObjectInvoker invoker = (TimedObjectInvoker)((Object)Ejb3Registry.getContainer(this.containerGuid));
        assert (invoker != null);
        return invoker;
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        try {
            Scheduler scheduler = QuartzTimerServiceFactory.getScheduler();
            Trigger trigger = scheduler.getTrigger(this.triggerName, this.triggerGroup);
            if (trigger == null) {
                throw new NoSuchObjectLocalException("can't find trigger '" + this.triggerName + "' in group '" + this.triggerGroup + "'");
            }
            return new TimerImpl(scheduler, trigger, this.info);
        }
        catch (SchedulerException e) {
            log.error("getTimer failed", e);
            throw new EJBException((Exception)((Object)e));
        }
    }
}

