/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.client.Closeable;
import org.jboss.jms.wireformat.ClosingResponse;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class ClosingRequest
extends RequestSupport {
    private long sequence;

    public ClosingRequest() {
    }

    public ClosingRequest(long sequence, String objectId, byte version) {
        super(objectId, 601, version);
        this.sequence = sequence;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.sequence = is.readLong();
    }

    public ResponseSupport serverInvoke() throws Exception {
        Closeable endpoint = (Closeable)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        long id = endpoint.closing(this.sequence);
        return new ClosingResponse(id);
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeLong(this.sequence);
        os.flush();
    }

    public String toString() {
        return "ClosingRequest[ID=" + this.objectId + ", ver=" + this.version + "]";
    }
}

