/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.builders;

import java.io.Serializable;
import org.jboss.logging.Logger;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DomFields
extends DefaultFieldsImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(DomFields.class);
    private Element element;
    private boolean deleteOnEmptyValue = true;

    public DomFields(Element element, String elementName) {
        this(element, elementName, true);
    }

    public DomFields(Element element, String elementName, boolean deleteOnEmptyValue) {
        this.element = element;
        this.setField("name", (Serializable)((Object)elementName));
        this.deleteOnEmptyValue = deleteOnEmptyValue;
    }

    public String getElementName() {
        return (String)((Object)super.getField("name"));
    }

    public Serializable getField(String name) {
        if ("value".equals(name)) {
            String elementName = this.getElementName();
            NodeList nodes = this.element.getElementsByTagName(elementName);
            if (nodes.getLength() == 0) {
                return null;
            }
            Element element = (Element)nodes.item(0);
            return element.getTextContent();
        }
        return super.getField(name);
    }

    public void setField(String name, Serializable value) {
        if ("value".equals(name)) {
            String string = value.toString();
            String elementName = this.getElementName();
            NodeList nodes = this.element.getElementsByTagName(elementName);
            Element childElement = null;
            if (nodes.getLength() == 0) {
                if (string == null || this.deleteOnEmptyValue && string.length() == 0) {
                    return;
                }
                Document doc = this.element.getOwnerDocument();
                childElement = doc.createElement(elementName);
                this.element.appendChild(childElement);
            } else {
                childElement = (Element)nodes.item(0);
                if (string == null || string.length() == 0) {
                    this.element.removeChild(childElement);
                    return;
                }
            }
            childElement.setTextContent(string);
            if (log.isTraceEnabled()) {
                Document document = this.element.getOwnerDocument();
                StringBuffer tmp = new StringBuffer("After update of ");
                tmp.append(elementName);
                tmp.append('[');
                tmp.append(DOMWriter.printNode(document, false));
                tmp.append(']');
                log.trace(tmp.toString());
            }
            return;
        }
        super.setField(name, value);
    }
}

