/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.local;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.XAResource;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnection;
import org.jboss.resource.adapter.jdbc.local.LocalManagedConnectionFactory;

public class LocalManagedConnection
extends BaseWrapperManagedConnection
implements LocalTransaction {
    public LocalManagedConnection(LocalManagedConnectionFactory mcf, Connection con, Properties props, int transactionIsolation, int psCacheSize) throws SQLException {
        super(mcf, con, props, transactionIsolation, psCacheSize);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new JBossResourceException("Local tx only!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws ResourceException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                this.inManagedTransaction = false;
            }
        }
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws ResourceException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                this.inManagedTransaction = false;
            }
        }
        try {
            this.con.rollback();
        }
        catch (SQLException e) {
            try {
                this.checkException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws ResourceException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.inManagedTransaction) {
                try {
                    if (this.underlyingAutoCommit) {
                        this.underlyingAutoCommit = false;
                        this.con.setAutoCommit(false);
                    }
                    this.checkState();
                    this.inManagedTransaction = true;
                }
                catch (SQLException e) {
                    this.checkException(e);
                }
            } else {
                throw new JBossResourceException("Trying to begin a nested local tx");
            }
        }
    }
}

