/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.web;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.resources.WebResource;
import org.jboss.security.integration.ejb.SecurityHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAuthorizationHelper
extends SecurityHelper {
    private boolean enableAudit = true;

    public WebAuthorizationHelper(SecurityContext sc, boolean enableAudit) {
        super(sc);
        this.enableAudit = enableAudit;
    }

    public boolean checkResourcePermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, Subject callerSubject, AuthorizationManager authzMgr, String canonicalRequestURI) {
        boolean isAuthorized;
        block4: {
            isAuthorized = false;
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            webResource.setCallerSubject(callerSubject);
            webResource.setCanonicalRequestURI(canonicalRequestURI);
            try {
                String level;
                int permit = authzMgr.authorize(webResource);
                isAuthorized = permit == 1;
                String string = level = permit == 1 ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                isAuthorized = false;
                if (log.isTraceEnabled()) {
                    log.trace("hasResourcePermission check failed:" + e.getLocalizedMessage());
                }
                if (!this.enableAudit) break block4;
                this.authorizationAudit("Error", webResource, e);
            }
        }
        return isAuthorized;
    }

    public boolean hasRole(String roleName, Principal principal, String servletName, Set<Principal> principalRoles, AuthorizationManager authzMgr) {
        boolean hasTheRole;
        block4: {
            hasTheRole = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleName", roleName);
            map.put("roleRefPermissionCheck", Boolean.TRUE);
            map.put("servletName", servletName);
            map.put("principal.roles", principalRoles);
            map.put("authorizationManager", authzMgr);
            WebResource webResource = new WebResource(Collections.unmodifiableMap(map));
            webResource.setPrincipal(principal);
            try {
                String level;
                int permit = authzMgr.authorize(webResource);
                hasTheRole = permit == 1;
                String string = level = hasTheRole ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasTheRole = false;
                if (log.isTraceEnabled()) {
                    log.trace("hasRole check failed:" + e.getLocalizedMessage());
                }
                if (!this.enableAudit) break block4;
                this.authorizationAudit("Error", webResource, e);
            }
        }
        return hasTheRole;
    }

    public boolean hasUserDataPermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, AuthorizationManager authzMgr) {
        boolean hasPerm;
        block4: {
            hasPerm = false;
            contextMap.put("authorizationManager", authzMgr);
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            try {
                String level;
                int permit = authzMgr.authorize(webResource);
                hasPerm = permit == 1;
                String string = level = hasPerm ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasPerm = false;
                if (log.isTraceEnabled()) {
                    log.trace("hasRole check failed:" + e.getLocalizedMessage());
                }
                if (!this.enableAudit) break block4;
                this.authorizationAudit("Error", webResource, e);
            }
        }
        return hasPerm;
    }
}

