/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.encoding.TypeMapping;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.helpers.JavaToWSDLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToWSDL11 {
    private static final Logger log = Logger.getLogger(JavaToWSDL11.class);
    private final String wsdlNamespace = "http://schemas.xmlsoap.org/wsdl/";
    private HashMap<String, Boolean> features = new HashMap();
    private Map<String, String> packageNamespaceMap = null;
    private TypeMapping typeMapping = null;
    private JavaWsdlMapping javaWsdlMapping = null;
    private UnifiedMetaData umd = null;
    private boolean qualifiedElements = false;

    public JavaToWSDL11() {
        if (log.isDebugEnabled()) {
            log.debug("Creating JavaToWSDL11 instance");
        }
    }

    public void addFeature(String name, boolean value) {
        this.features.put(name, new Boolean(value));
    }

    public void addFeatures(Map<String, Boolean> map) {
        this.features.putAll(map);
    }

    public boolean getFeature(String name) {
        Boolean val = this.features.get(name);
        if (val != null) {
            return val;
        }
        throw new WSException("Feature unrecognized");
    }

    public void setPackageNamespaceMap(Map<String, String> map) {
        this.packageNamespaceMap = map;
    }

    public TypeMapping getTypeMapping() {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been generated");
        }
        return this.typeMapping;
    }

    public void setUnifiedMetaData(UnifiedMetaData um) {
        this.umd = um;
    }

    public WSDLDefinitions generate(Class endpoint) {
        JBossXSModel schemaModel;
        WSDLDefinitions wsdl = null;
        if (this.umd != null) {
            JavaToWSDLHelper helper = new JavaToWSDLHelper();
            try {
                helper.setPackageNamespaceMap(this.packageNamespaceMap);
                wsdl = this.handleJavaToWSDLGeneration(helper, endpoint.getName());
                this.typeMapping = helper.getTypeMapping();
            }
            catch (IOException e) {
                log.error("Error during Java->WSDL generation:", e);
            }
        }
        if (this.qualifiedElements && (schemaModel = WSDLUtils.getSchemaModel(wsdl.getWsdlTypes())) != null) {
            schemaModel.setQualifiedElements(true);
        }
        return wsdl;
    }

    public boolean isQualifiedElements() {
        return this.qualifiedElements;
    }

    public void setQualifiedElements(boolean qualifiedElements) {
        this.qualifiedElements = qualifiedElements;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    private WSDLDefinitions handleJavaToWSDLGeneration(JavaToWSDLHelper helper, String endpointName) throws IOException {
        WSDLDefinitions wsdl = null;
        if (this.umd == null) {
            throw new WSException("Unified Meta Data Model is null");
        }
        for (ServiceMetaData service : this.umd.getServices()) {
            EndpointMetaData epMetaData = service.getEndpointByServiceEndpointInterface(endpointName);
            if (epMetaData == null) continue;
            wsdl = helper.generate(service);
            break;
        }
        this.javaWsdlMapping = helper.getJavaWsdlMapping();
        return wsdl;
    }
}

