/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.ArrayList;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.joinpoint.Joinpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdviceStack {
    protected String name;
    protected ArrayList<InterceptorFactory> interceptorFactories;

    public AdviceStack(String name, ArrayList<InterceptorFactory> factories) {
        this.name = name;
        this.interceptorFactories = factories;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<InterceptorFactory> getInterceptorFactories() {
        return this.interceptorFactories;
    }

    public Interceptor[] createInterceptors(Advisor advisor, Joinpoint jp) {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        for (int i = 0; i < this.interceptorFactories.size(); ++i) {
            InterceptorFactory factory = this.interceptorFactories.get(i);
            if (!factory.isDeployed()) continue;
            interceptors.add(factory.create(advisor, jp));
        }
        return interceptors.toArray(new Interceptor[interceptors.size()]);
    }

    public Interceptor[] createInterceptors() {
        return this.createInterceptors(null, null);
    }
}

