/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.array;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.array.Type;

public class ArrayBinding {
    protected String name;
    protected Type type;
    protected InterceptorFactory[] interceptorFactories = new InterceptorFactory[0];

    public ArrayBinding(String name, InterceptorFactory[] factories, Type type) {
        this.name = name;
        this.interceptorFactories = factories;
        this.type = type;
    }

    public void addInterceptorFactory(InterceptorFactory factory) {
        List<InterceptorFactory> list2 = Arrays.asList(this.interceptorFactories);
        list2 = new ArrayList<InterceptorFactory>(list2);
        list2.add(factory);
        this.interceptorFactories = list2.toArray(new InterceptorFactory[list2.size()]);
    }

    public String getName() {
        return this.name;
    }

    public InterceptorFactory[] getInterceptorFactories() {
        return this.interceptorFactories;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayBinding)) {
            return false;
        }
        return ((ArrayBinding)obj).getName().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isRead() {
        return this.type == Type.READ_ONLY || this.type == Type.READ_WRITE;
    }

    public boolean isWrite() {
        return this.type == Type.WRITE_ONLY || this.type == Type.READ_WRITE;
    }
}

