/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.FieldAccess;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.JoinPointBean;
import org.jboss.aop.util.JavassistToReflect;
import org.jboss.aop.util.ReflectToJavassist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldJoinPointGenerator
extends JoinPointGenerator {
    public static final String WRITE_JOINPOINT_FIELD_PREFIX = "joinpoint_w_";
    public static final String READ_JOINPOINT_FIELD_PREFIX = "joinpoint_r_";
    public static final String WRITE_JOINPOINT_CLASS_PREFIX = "JoinPoint_w_";
    public static final String READ_JOINPOINT_CLASS_PREFIX = "JoinPoint_r_";
    private static final Class JOINPOINT_TYPE = FieldAccess.class;
    private static final Class READ_INVOCATION_TYPE = FieldReadInvocation.class;
    private static final Class WRITE_INVOCATION_TYPE = FieldWriteInvocation.class;
    private static final CtClass READ_INVOCATION_CT_TYPE;
    private static final CtClass WRITE_INVOCATION_CT_TYPE;
    private static final String TYPED_VALUE_FIELD = "typedValue";
    WeakReference<Class<?>> returnClassType;
    WeakReference<Type> returnType;
    boolean read;
    boolean hasTargetObject;

    public FieldJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        super(advisor, info, FieldJoinPointGenerator.getParameters((FieldInfo)info), ((FieldInfo)info).isRead() ? 0 : 1, ((FieldInfo)info).isRead());
        if (((FieldInfo)info).isRead()) {
            this.read = true;
            this.returnClassType = new WeakReference(((FieldInfo)info).getField().getType());
            this.returnType = new WeakReference<Type>(((FieldInfo)info).getField().getGenericType());
        }
        this.hasTargetObject = !Modifier.isStatic(((FieldInfo)info).getField().getModifiers());
    }

    private static JoinPointGenerator.JoinPointParameters getParameters(FieldInfo info) {
        if (Modifier.isStatic(info.getField().getModifiers())) {
            return JoinPointGenerator.JoinPointParameters.ONLY_ARGS;
        }
        return JoinPointGenerator.JoinPointParameters.TARGET_ARGS;
    }

    @Override
    protected void initialiseJoinPointNames(JoinPointInfo info) {
        FieldInfo finfo = (FieldInfo)info;
        this.joinpointClassName = FieldJoinPointGenerator.getGeneratedJoinPointClassName(this.fieldName(finfo), finfo.isRead());
        this.joinpointFieldName = FieldJoinPointGenerator.getGeneratedJoinPointFieldName(this.fieldName(finfo), finfo.isRead());
    }

    @Override
    protected String getJoinPointArg(int index) {
        return "this.typedValue";
    }

    private String fieldName(FieldInfo info) {
        return info.getField().getName();
    }

    @Override
    protected boolean isVoid() {
        return !this.read;
    }

    @Override
    protected Class<?> getReturnClassType() {
        if (this.returnClassType != null) {
            return (Class)this.returnClassType.get();
        }
        return null;
    }

    @Override
    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup) {
        Class[] classArray;
        Type[] typeArray;
        FieldAccess fieldAccess = (FieldAccess)joinPoint;
        Field field = fieldAccess.getField();
        Class clazz = setup.getAspectClass();
        String string = setup.getAdviceName();
        Class clazz2 = fieldAccess.isRead() ? READ_INVOCATION_TYPE : WRITE_INVOCATION_TYPE;
        Type type = fieldAccess.isRead() ? field.getGenericType() : Void.TYPE;
        if (fieldAccess.isRead()) {
            typeArray = new Type[]{};
        } else {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = field.getGenericType();
        }
        if (fieldAccess.isRead()) {
            classArray = new Class[]{};
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = field.getType();
        }
        return new AdviceMethodProperties(joinPoint, clazz, string, JOINPOINT_TYPE, clazz2, type, typeArray, classArray, null, field.getDeclaringClass(), this.hasTargetObject());
    }

    @Override
    protected boolean hasTargetObject() {
        return this.hasTargetObject;
    }

    protected static String getGeneratedJoinPointFieldName(String fieldName, boolean read) {
        if (read) {
            return READ_JOINPOINT_FIELD_PREFIX + fieldName;
        }
        return WRITE_JOINPOINT_FIELD_PREFIX + fieldName;
    }

    private static String getGeneratedJoinPointClassName(String fieldName, boolean read) {
        if (read) {
            return READ_JOINPOINT_CLASS_PREFIX + fieldName;
        }
        return WRITE_JOINPOINT_CLASS_PREFIX + fieldName;
    }

    protected static CtClass createReadJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index) throws NotFoundException, CannotCompileException {
        ReadBaseClassGenerator factory = new ReadBaseClassGenerator(instrumentor, advisedClass, advisedField, finame, index);
        return factory.generate();
    }

    protected static CtClass createWriteJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index) throws NotFoundException, CannotCompileException {
        WriteBaseClassGenerator factory = new WriteBaseClassGenerator(instrumentor, advisedClass, advisedField, finame, index);
        return factory.generate();
    }

    static {
        try {
            READ_INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(READ_INVOCATION_TYPE);
            WRITE_INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(WRITE_INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class WriteBaseClassGenerator
    extends BaseClassGenerator {
        private static final String GET_VALUE = "getValue";
        private static final String SET_VALUE = "setValue";

        WriteBaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index) throws NotFoundException {
            super(instrumentor, advisedClass, advisedField, finame, index, false);
        }

        protected CtClass setupClass() throws NotFoundException, CannotCompileException {
            CtClass setUp = super.setupClass();
            CtField valueField = new CtField(this.getArgumentType(), FieldJoinPointGenerator.TYPED_VALUE_FIELD, setUp);
            this.jp.addField(valueField);
            CtMethod oldGetValue = WRITE_INVOCATION_CT_TYPE.getDeclaredMethod(GET_VALUE);
            CtMethod getValue = CtNewMethod.make((CtClass)oldGetValue.getReturnType(), (String)GET_VALUE, (CtClass[])oldGetValue.getParameterTypes(), (CtClass[])oldGetValue.getExceptionTypes(), (String)"{return ($w)typedValue;}", (CtClass)setUp);
            setUp.addMethod(getValue);
            CtMethod oldSetValue = WRITE_INVOCATION_CT_TYPE.getDeclaredMethod(SET_VALUE);
            CtMethod setValue = CtNewMethod.make((CtClass)oldSetValue.getReturnType(), (String)GET_VALUE, (CtClass[])oldSetValue.getParameterTypes(), (CtClass[])oldSetValue.getExceptionTypes(), (String)("{typedValue = " + JavassistToReflect.castInvocationValueToTypeString(this.getArgumentType(), "$1") + ";}"), (CtClass)setUp);
            setUp.addMethod(setValue);
            return setUp;
        }

        protected CtClass getSuperClass() throws NotFoundException {
            return WRITE_INVOCATION_CT_TYPE;
        }

        protected CtClass getArgumentType() throws NotFoundException {
            return this.advisedField.getType();
        }

        protected String createSetValue() {
            if (this.hasTargetObject) {
                return "typedValue = $3;";
            }
            return "typedValue = $2;";
        }

        protected CtClass[] getInvokeJoinPointParams() throws NotFoundException {
            CtClass[] ctClassArray;
            if (this.hasTargetObject) {
                CtClass[] ctClassArray2 = new CtClass[2];
                ctClassArray2[0] = this.advisedClass;
                ctClassArray = ctClassArray2;
                ctClassArray2[1] = this.advisedField.getType();
            } else {
                CtClass[] ctClassArray3 = new CtClass[1];
                ctClassArray = ctClassArray3;
                ctClassArray3[0] = this.advisedField.getType();
            }
            return ctClassArray;
        }

        protected CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            CtMethod invokeJoinpointMethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)"invokeJoinpoint", (CtClass[])this.getInvokeJoinPointParams(), (CtClass[])JoinPointGenerator.THROWS_THROWABLE, null, (CtClass)this.jp);
            invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(invokeJoinpointMethod);
            return invokeJoinpointMethod;
        }

        protected String createInvokeNextDispatchMethodBody() throws NotFoundException {
            return "{" + (this.hasTargetObject ? "typedTargetObject." + this.advisedField.getName() + " = " + FieldJoinPointGenerator.TYPED_VALUE_FIELD : this.advisedClass.getName() + "." + this.advisedField.getName() + " = " + FieldJoinPointGenerator.TYPED_VALUE_FIELD) + (this.hasTargetObject ? "; return typedTargetObject." + this.advisedField.getName() + ";" : "; return " + this.advisedClass.getName() + "." + this.advisedField.getName() + ";") + "}";
        }

        protected String createInvokeJoinPointDispatchMethodBody() {
            return this.hasTargetObject ? "{$1." + this.advisedField.getName() + " = $2;}" : "{" + this.advisedClass.getName() + "." + this.advisedField.getName() + " = $1;}";
        }

        protected void addArgumentFieldAndAccessor() throws CannotCompileException, NotFoundException {
            CtField inconsistentArgs = new CtField(CtClass.booleanType, "inconsistentArgs", this.jp);
            this.jp.addField(inconsistentArgs, CtField.Initializer.byExpr((String)"false"));
            super.addArgumentFieldAndAccessor();
            CtMethod enforceArgsConsistency = CtNewMethod.make((String)this.createEnforceArgsConsistencyBody(), (CtClass)this.jp);
            enforceArgsConsistency.setModifiers(4);
            this.jp.addMethod(enforceArgsConsistency);
        }

        protected String createGetArgumentsBody() {
            StringBuffer code = new StringBuffer("public java.lang.Object[] ");
            code.append("getArguments");
            code.append("(){ inconsistentArgs = true;   ");
            code.append("   if(");
            code.append("arguments");
            code.append("  == null)");
            code.append("   {");
            code.append("      ");
            code.append("arguments");
            code.append(" = new java.lang.Object[]{");
            code.append(GET_VALUE);
            code.append("()};");
            code.append("   }");
            code.append("   return ");
            code.append("arguments");
            code.append("; ");
            code.append("}");
            return code.toString();
        }

        protected String createSetArgumentsBody() {
            StringBuffer code = new StringBuffer("public void setArguments(java.lang.Object[] args)");
            code.append("{   inconsistentArgs = true;   ");
            code.append("if (args == null || args.length != 1)");
            code.append("{throw new RuntimeException(");
            code.append("\"Field write arguments must be a non-null array containing");
            code.append(" a single element: the value of the field write\");}");
            code.append("arguments");
            code.append("=args;");
            code.append("}");
            return code.toString();
        }

        protected String createEnforceArgsConsistencyBody() {
            StringBuffer code = new StringBuffer("public void ");
            code.append("enforceArgsConsistency");
            code.append("() {if(inconsistentArgs) { this.");
            code.append(SET_VALUE).append("(").append("arguments").append("[0]);}}");
            return code.toString();
        }
    }

    private static class ReadBaseClassGenerator
    extends BaseClassGenerator {
        ReadBaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index) throws NotFoundException {
            super(instrumentor, advisedClass, advisedField, finame, index, true);
        }

        protected CtClass getSuperClass() throws NotFoundException {
            return READ_INVOCATION_CT_TYPE;
        }

        protected CtClass getArgumentType() {
            return null;
        }

        protected String createSetValue() {
            return "";
        }

        protected CtClass[] getInvokeJoinPointParams() throws NotFoundException {
            CtClass[] ctClassArray;
            if (this.hasTargetObject) {
                CtClass[] ctClassArray2 = new CtClass[1];
                ctClassArray = ctClassArray2;
                ctClassArray2[0] = this.advisedClass;
            } else {
                ctClassArray = new CtClass[]{};
            }
            return ctClassArray;
        }

        protected CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            CtMethod invokeJoinpointMethod = CtNewMethod.make((CtClass)this.advisedField.getType(), (String)"invokeJoinpoint", (CtClass[])this.getInvokeJoinPointParams(), (CtClass[])JoinPointGenerator.THROWS_THROWABLE, null, (CtClass)this.jp);
            invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(invokeJoinpointMethod);
            return invokeJoinpointMethod;
        }

        protected String createInvokeNextDispatchMethodBody() {
            return this.hasTargetObject ? "{return typedTargetObject." + this.advisedField.getName() + ";}" : "{return " + this.advisedClass.getName() + "." + this.advisedField.getName() + ";}";
        }

        protected String createInvokeJoinPointDispatchMethodBody() {
            return this.hasTargetObject ? "{return $1." + this.advisedField.getName() + ";}" : "{return " + this.advisedClass.getName() + "." + this.advisedField.getName() + ";}";
        }

        protected String createGetArgumentsBody() {
            StringBuffer code = new StringBuffer("public java.lang.Object[] ");
            code.append("getArguments");
            code.append("(){ ");
            code.append("   return ");
            code.append("arguments");
            code.append("; ");
            code.append("}");
            return code.toString();
        }

        protected String createSetArgumentsBody() {
            StringBuffer code = new StringBuffer("public void setArguments(java.lang.Object[] args)");
            code.append("{   ");
            code.append("if (args != null){ throw new RuntimeException(\"Arguments array of field read must be null\");}");
            code.append("arguments");
            code.append("=args;");
            code.append("}");
            return code.toString();
        }
    }

    static abstract class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass advisedClass;
        CtField advisedField;
        String finame;
        boolean hasTargetObject;
        CtClass jp;
        CtClass fieldType;
        CtClass fieldInfoClass;
        boolean read;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index, boolean read) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.advisedClass = advisedClass;
            this.advisedField = advisedField;
            this.finame = finame;
            this.fieldType = advisedField.getType();
            this.read = read;
            this.fieldInfoClass = instrumentor.forName("org.jboss.aop.FieldInfo");
            this.hasTargetObject = !Modifier.isStatic(advisedField.getModifiers());
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            if (this.hasTargetObject) {
                this.addTypedTargetField();
            }
            this.addArgumentFieldAndAccessor();
            this.addInvokeJoinpointMethod();
            this.addFieldInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructors();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
            return this.jp;
        }

        protected void addArgumentFieldAndAccessor() throws CannotCompileException, NotFoundException {
            CtField argumentsField = new CtField(this.instrumentor.forName("java.lang.Object[]"), "arguments", this.jp);
            argumentsField.setModifiers(4);
            this.jp.addField(argumentsField);
            CtMethod getArguments = CtNewMethod.make((String)this.createGetArgumentsBody(), (CtClass)this.jp);
            getArguments.setModifiers(1);
            this.jp.addMethod(getArguments);
            CtMethod setArguments = CtNewMethod.make((String)this.createSetArgumentsBody(), (CtClass)this.jp);
            setArguments.setModifiers(1);
            this.jp.addMethod(setArguments);
        }

        protected abstract String createGetArgumentsBody();

        protected abstract String createSetArgumentsBody();

        private static String debugFields(CtClass clazz) throws NotFoundException {
            StringBuffer sb = new StringBuffer();
            sb.append(clazz.getName());
            CtField[] fields = clazz.getFields();
            for (int i = 0; i < fields.length; ++i) {
                sb.append("\n\t\t\t\t" + Modifier.toString(fields[i].getModifiers()) + " " + fields[i].getName() + " " + fields[i].getType());
            }
            return sb.toString();
        }

        protected CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = FieldJoinPointGenerator.getGeneratedJoinPointClassName(this.advisedField.getName(), this.read);
            CtClass superClass = this.read ? READ_INVOCATION_CT_TYPE : WRITE_INVOCATION_CT_TYPE;
            this.jp = TransformerCommon.makeNestedClass(this.advisedClass, className, true, 9, superClass);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        protected abstract CtClass getSuperClass() throws NotFoundException;

        private void addTypedTargetField() throws CannotCompileException {
            CtField targetField = new CtField(this.advisedClass, "typedTargetObject", this.jp);
            this.jp.addField(targetField);
            targetField.setModifiers(4);
        }

        private void addPublicConstructor() throws CannotCompileException {
            CtConstructor publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.fieldInfoClass}, (CtClass[])new CtClass[0], (String)"{super($1, $1.getInterceptors()); this.info = $1;}", (CtClass)this.jp);
            this.jp.addConstructor(publicConstructor);
        }

        protected void addProtectedConstructors() throws CannotCompileException, NotFoundException {
            CtClass[] ctorParams1 = this.hasTargetObject ? new CtClass[2] : new CtClass[1];
            CtClass[] ctorParams2 = this.hasTargetObject ? new CtClass[3] : new CtClass[2];
            ctorParams1[0] = ctorParams2[0] = this.jp;
            if (this.hasTargetObject) {
                ctorParams1[1] = ctorParams2[1] = this.advisedClass;
            }
            ctorParams2[ctorParams2.length - 1] = this.getArgumentType();
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            if (this.hasTargetObject) {
                body.append("   this.typedTargetObject = $2;");
                body.append("   super.setTargetObject($2);");
            }
            if (this.getArgumentType() != null) {
                CtConstructor protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams1, (CtClass[])new CtClass[0], (String)(body.toString() + "}"), (CtClass)this.jp);
                protectedConstructor.setModifiers(4);
                this.jp.addConstructor(protectedConstructor);
            } else {
                ctorParams2 = ctorParams1;
            }
            String setArguments = this.createSetValue();
            CtConstructor protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams2, (CtClass[])new CtClass[0], (String)(body.toString() + setArguments + "}"), (CtClass)this.jp);
            protectedConstructor.setModifiers(4);
            this.jp.addConstructor(protectedConstructor);
        }

        protected abstract CtClass getArgumentType() throws NotFoundException;

        protected abstract String createSetValue();

        protected abstract CtClass[] getInvokeJoinPointParams() throws NotFoundException;

        protected abstract CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException;

        private void addFieldInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.fieldInfoClass, "info", this.jp);
            infoField.setModifiers(4);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            this.addInvokeNextDispatchMethod();
            this.addInvokeJoinPointDispatchMethod();
            this.addInvokeTargetMethod();
        }

        private void addInvokeNextDispatchMethod() throws CannotCompileException, NotFoundException {
            String body = this.createInvokeNextDispatchMethodBody();
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)(this.read ? this.advisedField.getType() : CtClass.voidType), (String)"dispatch", (CtClass[])JoinPointGenerator.EMPTY_CTCLASS_ARRAY, (CtClass[])JoinPointGenerator.EMPTY_CTCLASS_ARRAY, (String)body, (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", JoinPointGenerator.EMPTY_CTCLASS_ARRAY), e);
            }
        }

        protected abstract String createInvokeNextDispatchMethodBody() throws NotFoundException;

        protected void addInvokeJoinPointDispatchMethod() throws NotFoundException, CannotCompileException {
            CtClass[] params = this.getInvokeJoinPointParams();
            if (params.length == 0) {
                return;
            }
            String body = this.createInvokeJoinPointDispatchMethodBody();
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)(this.read ? this.advisedField.getType() : CtClass.voidType), (String)"dispatch", (CtClass[])params, (CtClass[])new CtClass[0], (String)body, (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", params), e);
            }
        }

        protected abstract String createInvokeJoinPointDispatchMethodBody() throws NotFoundException;

        private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException {
            CtMethod template = READ_INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
            String body = this.read ? "{return ($w)dispatch();}" : "{dispatch(); return null;}";
            CtMethod invokeTarget = CtNewMethod.make((CtClass)template.getReturnType(), (String)template.getName(), (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)body, (CtClass)this.jp);
            this.jp.addMethod(invokeTarget);
        }
    }
}

