/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.aspects;

import java.lang.annotation.Annotation;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntroduction<T extends Annotation>
implements Interceptor {
    @Override
    public String getName() {
        return this.getClass().getName();
    }

    protected abstract Class<T> getBindingAnnotation();

    protected boolean isBindingInfoPresent(Invocation invocation) {
        return invocation.resolveClassAnnotation(this.getBindingAnnotation()) != null;
    }

    protected T resolveBindingInfo(Invocation invocation) {
        Class<T> bindingClass = this.getBindingAnnotation();
        Object bindingInfo = invocation.resolveClassAnnotation(bindingClass);
        return (T)((Annotation)bindingClass.cast(bindingInfo));
    }

    protected void onRegistration(Invocation invocation, KernelControllerContext context) {
        this.onRegistration(context, this.resolveBindingInfo(invocation));
    }

    protected void onRegistration(KernelControllerContext context, T annotation) {
    }

    protected void onUnregistration(Invocation invocation, KernelControllerContext context) {
        this.onUnregistration(context, this.resolveBindingInfo(invocation));
    }

    protected void onUnregistration(KernelControllerContext context, T annotation) {
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
        String methodName = mi.getMethod().getName();
        boolean infoPresent = this.isBindingInfoPresent(invocation);
        if ("setKernelControllerContext".equals(methodName) && infoPresent) {
            this.onRegistration(invocation, context);
        } else if (infoPresent) {
            this.onUnregistration(invocation, context);
        }
        return null;
    }
}

