/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.io.Serializable;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.reflect.plugins.AnnotationHolder;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class AbstractPropertyInfo
extends AnnotationHolder
implements PropertyInfo,
Serializable {
    private static final long serialVersionUID = 2L;
    protected transient BeanInfo beanInfo;
    protected String name;
    protected String upperName;
    protected TypeInfo type;
    protected MethodInfo getter;
    protected MethodInfo setter;

    public AbstractPropertyInfo() {
        this(null, null, null, null, null);
    }

    public AbstractPropertyInfo(String name) {
        this(name, name, null, null, null);
    }

    public AbstractPropertyInfo(String name, String upperName, TypeInfo type, MethodInfo getter, MethodInfo setter) {
        this.name = name;
        this.upperName = upperName;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    public AbstractPropertyInfo(String name, String upperName, TypeInfo type, MethodInfo getter, MethodInfo setter, AnnotationValue[] annotations) {
        super(annotations);
        this.name = name;
        this.upperName = upperName;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getUpperName() {
        return this.upperName;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public void setType(TypeInfo type) {
        this.type = type;
    }

    public MethodInfo getGetter() {
        return this.getter;
    }

    public void setGetter(MethodInfo getter) {
        this.getter = getter;
    }

    public MethodInfo getSetter() {
        return this.setter;
    }

    public void setSetter(MethodInfo setter) {
        this.setter = setter;
    }

    public Object get(Object bean) throws Throwable {
        if (bean == null) {
            throw new IllegalArgumentException("Null bean");
        }
        if (this.getter == null) {
            throw new IllegalArgumentException("Property is not readable: " + this.getName() + " for " + this.beanInfo.getName());
        }
        return this.getter.invoke(bean, null);
    }

    public void set(Object bean, Object value) throws Throwable {
        if (bean == null) {
            throw new IllegalArgumentException("Null bean");
        }
        if (this.setter == null) {
            throw new IllegalArgumentException("Property is not writable: " + this.getName() + " for " + this.beanInfo.getName());
        }
        this.setter.invoke(bean, new Object[]{value});
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractPropertyInfo)) {
            return false;
        }
        AbstractPropertyInfo other = (AbstractPropertyInfo)object;
        if (AbstractPropertyInfo.notEqual(this.name, other.name)) {
            return false;
        }
        if (AbstractPropertyInfo.notEqual(this.getter, other.getter)) {
            return false;
        }
        return !AbstractPropertyInfo.notEqual(this.setter, other.setter);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" getter=").append(this.getter);
        buffer.append(" setter=").append(this.setter);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    public int getHashCode() {
        return this.name.hashCode();
    }
}

