/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerWrapper
implements Deployer,
ManagedObjectCreator {
    private Logger log;
    private Deployer deployer;
    private ManagedObjectCreator managedObjectCreator;

    public DeployerWrapper(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.deployer = deployer;
        if (deployer instanceof ManagedObjectCreator) {
            this.managedObjectCreator = (ManagedObjectCreator)((Object)deployer);
        }
        this.log = Logger.getLogger(deployer.getClass());
    }

    public ManagedObjectCreator getManagedObjectCreator() {
        return this.managedObjectCreator;
    }

    public void setManagedObjectCreator(ManagedObjectCreator managedObjectCreator) {
        this.managedObjectCreator = managedObjectCreator;
    }

    @Override
    public String getType() {
        return this.deployer.getType();
    }

    @Override
    public int getRelativeOrder() {
        return this.deployer.getRelativeOrder();
    }

    @Override
    public void setRelativeOrder(int order) {
        this.deployer.setRelativeOrder(order);
    }

    @Override
    public boolean isAllInputs() {
        return this.deployer.isAllInputs();
    }

    @Override
    public boolean isComponentsOnly() {
        return this.deployer.isComponentsOnly();
    }

    @Override
    public boolean isWantComponents() {
        return this.deployer.isWantComponents();
    }

    @Override
    public boolean isTopLevelOnly() {
        return this.deployer.isTopLevelOnly();
    }

    @Override
    public Class<?> getInput() {
        return this.deployer.getInput();
    }

    @Override
    public Class<?> getOutput() {
        return this.deployer.getOutput();
    }

    @Override
    public Set<String> getInputs() {
        Set<String> result = this.deployer.getInputs();
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public Set<String> getOutputs() {
        Set<String> result = this.deployer.getOutputs();
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public DeploymentStage getStage() {
        return this.deployer.getStage();
    }

    @Override
    public boolean isParentFirst() {
        return this.deployer.isParentFirst();
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        try {
            this.log.trace("Deploying: " + unit.getName());
            this.deployer.deploy(unit);
            this.log.trace("Deployed:  " + unit.getName());
        }
        catch (Throwable t) {
            this.log.debug("Error during deploy: " + unit.getName(), t);
            throw DeploymentException.rethrowAsDeploymentException("Error during deploy: " + unit.getName(), t);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        try {
            this.log.trace("Undeploying: " + unit.getName());
            this.deployer.undeploy(unit);
            this.log.trace("Undeployed:  " + unit.getName());
        }
        catch (Throwable t) {
            this.log.error("Error during undeploy: " + unit.getName(), t);
        }
    }

    @Override
    public void build(DeploymentUnit unit, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        try {
            ManagedObjectCreator creator = this.getManagedObjectCreator();
            if (creator != null) {
                creator.build(unit, managedObjects);
            }
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException("Error building managed objects for " + unit.getName(), t);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Deployer)) {
            return false;
        }
        if (obj instanceof DeployerWrapper) {
            obj = ((DeployerWrapper)obj).deployer;
        }
        return this.deployer.equals(obj);
    }

    public int hashCode() {
        return this.deployer.hashCode();
    }

    public String toString() {
        return this.deployer.toString();
    }
}

