/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.Set;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.EARDeployment;
import org.jboss.metadata.common.jboss.LoaderRepositoryConfigMetaData;
import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAppParsingDeployer
extends SchemaResolverDeployer<JBossAppMetaData> {
    private boolean isolated = false;
    private boolean callByValue = false;
    private String unauthenticatedIdentity = null;

    public JBossAppParsingDeployer() {
        super(JBossAppMetaData.class);
        this.setName("jboss-app.xml");
    }

    public String getAppXmlPath() {
        return this.getName();
    }

    public void setAppXmlPath(String appXmlPath) {
        this.setName(appXmlPath);
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    public String getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    public void setUnauthenticatedIdentity(String unauthenticatedIdentity) {
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    @Override
    protected void createMetaData(DeploymentUnit unit, String name, String suffix) throws DeploymentException {
        super.createMetaData(unit, name, suffix);
        EarMetaData specMetaData = unit.getAttachment(EarMetaData.class);
        JBossAppMetaData metaData = unit.getAttachment(JBossAppMetaData.class);
        if (specMetaData == null && metaData == null) {
            return;
        }
        if (metaData == null) {
            metaData = new JBossAppMetaData();
        }
        JBossAppMetaData mergedMetaData = new JBossAppMetaData();
        mergedMetaData.merge(metaData, specMetaData);
        unit.getTransientManagedObjects().addAttachment(JBossAppMetaData.class, mergedMetaData);
        unit.addAttachment("Raw" + JBossAppMetaData.class.getName(), metaData, JBossAppMetaData.class);
    }

    @Override
    protected void init(VFSDeploymentUnit unit, JBossAppMetaData metaData, VirtualFile file) throws Exception {
        if (metaData != null) {
            LoaderRepositoryMetaData lrmd = metaData.getLoaderRepository();
            LoaderRepositoryFactory.LoaderRepositoryConfig loaderCfg = null;
            if (loaderCfg == null && this.isolated) {
                loaderCfg = this.initLoaderRepository(metaData, unit);
            }
            if (lrmd != null) {
                loaderCfg = new LoaderRepositoryFactory.LoaderRepositoryConfig();
                loaderCfg.repositoryClassName = lrmd.getLoaderRepositoryClass();
                loaderCfg.repositoryName = new ObjectName(lrmd.getName());
                Set<LoaderRepositoryConfigMetaData> configs = lrmd.getLoaderRepositoryConfig();
                if (configs != null && !configs.isEmpty()) {
                    LoaderRepositoryConfigMetaData config = configs.iterator().next();
                    loaderCfg.configParserClassName = config.getConfigParserClass();
                    loaderCfg.repositoryConfig = config.getConfig();
                }
            }
            if (loaderCfg != null) {
                unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, loaderCfg);
            }
        }
        if (this.callByValue) {
            unit.addAttachment("EAR.callByValue", Boolean.TRUE, Boolean.class);
        }
        if (this.unauthenticatedIdentity != null) {
            unit.addAttachment("EAR.unauthenticatedIdentity", this.unauthenticatedIdentity, String.class);
        }
    }

    protected LoaderRepositoryFactory.LoaderRepositoryConfig initLoaderRepository(JBossAppMetaData metaData, DeploymentUnit unit) throws DeploymentException {
        try {
            String name = EARDeployment.getJMXName(metaData, unit) + ",extension=LoaderRepository";
            ObjectName objectName = new ObjectName(name);
            LoaderRepositoryFactory.LoaderRepositoryConfig config = new LoaderRepositoryFactory.LoaderRepositoryConfig();
            config.repositoryName = objectName;
            return config;
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to create LoaderRepositoryConfig", e);
        }
    }
}

