/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.ejb.EJBException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRInvocation;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMRFieldBridge2;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.LocalEJBInvocation;
import org.jboss.logging.Logger;

public class RelationInterceptor
extends AbstractInterceptor {
    private Logger log;

    public void setContainer(Container container) {
        this.container = (EntityContainer)container;
        if (container != null) {
            this.log = Logger.getLogger(this.getClass().getName() + "." + container.getBeanMetaData().getEjbName());
        }
    }

    public Object invoke(Invocation mi) throws Exception {
        if (!(mi instanceof CMRInvocation)) {
            return this.getNext().invoke(mi);
        }
        org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRMessage msg = ((CMRInvocation)mi).getCmrMessage();
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
        JDBCCMRFieldBridge2 cmrField = (JDBCCMRFieldBridge2)mi.getArguments()[0];
        if (org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRMessage.ADD_RELATION == msg) {
            Object relatedId = mi.getArguments()[1];
            if (this.log.isTraceEnabled()) {
                this.log.trace("Add relation: field=" + cmrField.getFieldName() + " id=" + ctx.getId() + " relatedId=" + relatedId);
            }
            cmrField.addRelatedId(ctx, relatedId);
        } else if (org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRMessage.REMOVE_RELATION == msg) {
            Object relatedId = mi.getArguments()[1];
            if (this.log.isTraceEnabled()) {
                this.log.trace("Remove relation: field=" + cmrField.getFieldName() + " id=" + ctx.getId() + " relatedId=" + relatedId);
            }
            cmrField.removeRelatedId(ctx, relatedId);
        } else {
            throw new EJBException("Unknown cmp2.0-relationship-message=" + msg);
        }
        return null;
    }

    public static final class CMRMessage
    implements Serializable {
        private static int nextOrdinal = 0;
        private static final CMRMessage[] VALUES = new CMRMessage[5];
        public static final CMRMessage ADD_RELATED_ID = new CMRMessage("ADD_RELATED_ID");
        public static final CMRMessage REMOVE_RELATED_ID = new CMRMessage("REMOVE_RELATED_ID");
        public static final CMRMessage DESTROY_EXISTING_RELATIONSHIPS = new CMRMessage("DESTROY_EXISTING_RELATIONSHIPS");
        private final transient String name;
        private final int ordinal;

        private CMRMessage(String name) {
            this.name = name;
            this.ordinal = nextOrdinal++;
            CMRMessage.VALUES[this.ordinal] = this;
        }

        public String toString() {
            return this.name;
        }

        Object readResolve() throws ObjectStreamException {
            return VALUES[this.ordinal];
        }
    }

    public static class RelationInvocation
    extends LocalEJBInvocation {
        public final CMRMessage msg;

        public RelationInvocation(CMRMessage msg) {
            this.msg = msg;
        }
    }
}

