/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.management.ObjectName;
import org.jboss.ejb3.ClientKernelAbstraction;
import org.jboss.ejb3.embedded.resource.RARDeployment;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.logging.Logger;

public class MCClientKernelAbstraction
implements ClientKernelAbstraction {
    private static final Logger log = Logger.getLogger(MCClientKernelAbstraction.class);
    protected Kernel kernel;

    public MCClientKernelAbstraction(Kernel kernel) {
        this.kernel = kernel;
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws Exception {
        String name = objectName.getCanonicalName();
        KernelRegistryEntry entry = this.kernel.getRegistry().getEntry(name);
        if (entry != null) {
            Object target = entry.getTarget();
            if (target instanceof RARDeployment) {
                RARDeployment deployment = (RARDeployment)target;
                return deployment.invoke(operationName, params, signature);
            }
            Class[] types = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                types[i] = Thread.currentThread().getContextClassLoader().loadClass(signature[i]);
            }
            Method method = target.getClass().getMethod(operationName, types);
            return method.invoke(target, params);
        }
        return null;
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws Exception {
        String name = objectName.getCanonicalName();
        KernelRegistryEntry entry = this.kernel.getRegistry().getEntry(name);
        if (entry != null) {
            Object target = entry.getTarget();
            Field field = target.getClass().getField(attribute);
            return field.get(target);
        }
        return null;
    }
}

