/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.entity.HibernateSession;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionScopedEntityManager
implements EntityManager,
HibernateSession,
Externalizable {
    private static final long serialVersionUID = 4260828563883650376L;
    private transient ManagedEntityManagerFactory factory;

    @Override
    public Session getHibernateSession() {
        EntityManager em = this.factory.getTransactionScopedEntityManager();
        if (em instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)em).getSession();
        }
        throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
    }

    public TransactionScopedEntityManager(ManagedEntityManagerFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory must not be null");
        }
        this.factory = factory;
    }

    public TransactionScopedEntityManager() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.factory.getKernelName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String kernelName = in.readUTF();
        PersistenceUnitDeployment deployment = PersistenceUnitRegistry.getPersistenceUnit(kernelName);
        if (deployment == null) {
            throw new IOException("Unable to find persistence unit in registry: " + kernelName);
        }
        this.factory = deployment.getManagedFactory();
    }

    @Override
    public Object getDelegate() {
        return this.factory.getTransactionScopedEntityManager().getDelegate();
    }

    @Override
    public void joinTransaction() {
        this.factory.verifyInTx();
        this.factory.getTransactionScopedEntityManager().joinTransaction();
    }

    @Override
    public void clear() {
        this.factory.getTransactionScopedEntityManager().clear();
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.factory.getTransactionScopedEntityManager().getFlushMode();
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        this.factory.verifyInTx();
        this.factory.getTransactionScopedEntityManager().lock(entity, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        EntityManager em = this.factory.getTransactionScopedEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        try {
            T t = em.getReference(entityClass, primaryKey);
            return t;
        }
        finally {
            if (!this.factory.isInTx()) {
                em.clear();
            }
        }
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        this.factory.getTransactionScopedEntityManager().setFlushMode(flushMode);
    }

    @Override
    public Query createQuery(String ejbqlString) {
        EntityManager em = this.factory.getTransactionScopedEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createQuery(ejbqlString);
    }

    @Override
    public Query createNamedQuery(String name) {
        EntityManager em = this.factory.getTransactionScopedEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createNamedQuery(name);
    }

    @Override
    public Query createNativeQuery(String sqlString) {
        EntityManager em = this.factory.getTransactionScopedEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createNativeQuery(sqlString);
    }

    @Override
    public Query createNativeQuery(String sqlString, Class resultClass) {
        EntityManager em = this.factory.getTransactionScopedEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createNativeQuery(sqlString, resultClass);
    }

    @Override
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        EntityManager em = this.factory.getTransactionScopedEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createNativeQuery(sqlString, resultSetMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> A find(Class<A> entityClass, Object primaryKey) {
        EntityManager em = this.factory.getTransactionScopedEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        try {
            A a = em.find(entityClass, primaryKey);
            return a;
        }
        finally {
            if (!this.factory.isInTx()) {
                em.clear();
            }
        }
    }

    @Override
    public void persist(Object entity) {
        this.factory.verifyInTx();
        this.factory.getTransactionScopedEntityManager().persist(entity);
    }

    public <A> A merge(A entity) {
        this.factory.verifyInTx();
        return this.factory.getTransactionScopedEntityManager().merge(entity);
    }

    @Override
    public void remove(Object entity) {
        this.factory.verifyInTx();
        this.factory.getTransactionScopedEntityManager().remove(entity);
    }

    @Override
    public void refresh(Object entity) {
        this.factory.verifyInTx();
        this.factory.getTransactionScopedEntityManager().refresh(entity);
    }

    @Override
    public boolean contains(Object entity) {
        return this.factory.getTransactionScopedEntityManager().contains(entity);
    }

    @Override
    public void flush() {
        this.factory.verifyInTx();
        this.factory.getTransactionScopedEntityManager().flush();
    }

    @Override
    public void close() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    @Override
    public boolean isOpen() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    @Override
    public EntityTransaction getTransaction() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }
}

