/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
        }
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(final Principal principal, final Object credential, final Subject subject) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.pushSubjectContext(subject, principal, credential);
                        return null;
                    }
                });
            }

            public void dup() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.dupSubjectContext();
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.popSubjectContext();
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                SecurityAssociation.pushSubjectContext(subject, principal, credential);
            }

            public void dup() {
                SecurityAssociation.dupSubjectContext();
            }

            public void pop() {
                SecurityAssociation.popSubjectContext();
            }
        };

        public void push(Principal var1, Object var2, Subject var3);

        public void dup();

        public void pop();
    }
}

