/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.ClusterNotification;
import org.jboss.messaging.core.contract.ClusterNotificationListener;
import org.jboss.messaging.core.contract.ClusterNotifier;
import org.jboss.messaging.util.ConcurrentReaderHashSet;

public class DefaultClusterNotifier
implements ClusterNotifier {
    private static final Logger log = Logger.getLogger(DefaultClusterNotifier.class);
    private Set listeners = new ConcurrentReaderHashSet();

    public void registerListener(ClusterNotificationListener listener) {
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Listener " + listener + " is already registered");
        }
        this.listeners.add(listener);
    }

    public void sendNotification(ClusterNotification notification) {
        for (ClusterNotificationListener listener : this.listeners) {
            listener.notify(notification);
        }
    }

    public void unregisterListener(ClusterNotificationListener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalStateException("Listener " + listener + " is not registered");
        }
    }
}

