/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.ClusterNotification;
import org.jboss.messaging.core.contract.ClusterNotificationListener;
import org.jboss.messaging.core.impl.tx.TransactionRepository;

public class FailoverWaiter
implements ClusterNotificationListener {
    private static final Logger log = Logger.getLogger(FailoverWaiter.class);
    private int failingOverFor = -1;
    private int failedOverFor = -1;
    private Object failoverStatusLock = new Object();
    private long failoverStartTimeout;
    private long failoverCompleteTimeout;
    private int nodeID;
    private TransactionRepository txRepository;

    public FailoverWaiter(int nodeID, long failoverStartTimeout, long failoverCompleteTimeout, TransactionRepository txRepository) {
        this.nodeID = nodeID;
        this.failoverStartTimeout = failoverStartTimeout;
        this.failoverCompleteTimeout = failoverCompleteTimeout;
        this.txRepository = txRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForFailover(int failedNodeID) throws Exception {
        long start;
        log.trace("Waiting for failover for " + failedNodeID + " failingOverFor: " + this.failingOverFor + " failedOverFor: " + this.failedOverFor);
        Object object = this.failoverStatusLock;
        synchronized (object) {
            for (long startToWait = this.failoverStartTimeout; startToWait > 0L && this.failingOverFor != failedNodeID && this.failedOverFor != failedNodeID; startToWait -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                try {
                    log.debug(this + " blocking on the failover lock, waiting for failover to start");
                    this.failoverStatusLock.wait(startToWait);
                    log.debug(this + " releasing the failover lock, checking again whether failover started ...");
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            if (this.failingOverFor != failedNodeID && this.failedOverFor != failedNodeID) {
                log.debug("Timed out waiting for failover to start");
                return -1;
            }
        }
        object = this.failoverStatusLock;
        synchronized (object) {
            for (long completeToWait = this.failoverCompleteTimeout; completeToWait > 0L && this.failedOverFor != failedNodeID; completeToWait -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                try {
                    log.debug(this + " blocking on the failover lock, waiting for failover to complete");
                    this.failoverStatusLock.wait(completeToWait);
                    log.debug(this + " releasing the failover lock, checking again whether failover completed ...");
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            if (this.failedOverFor != failedNodeID) {
                log.debug("Timed out waiting for failover to complete");
                return -1;
            }
        }
        return this.nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(ClusterNotification notification) {
        if (notification.type == 2) {
            Object object = this.failoverStatusLock;
            synchronized (object) {
                this.failingOverFor = notification.nodeID;
                this.failoverStatusLock.notifyAll();
            }
        }
        if (notification.type == 3) {
            try {
                this.txRepository.loadPreparedTransactions();
            }
            catch (Exception e) {
                log.error("Failed to load prepared transactions", e);
            }
            Object object = this.failoverStatusLock;
            synchronized (object) {
                this.failedOverFor = this.failingOverFor;
                this.failingOverFor = -1;
                this.failoverStatusLock.notifyAll();
            }
        }
        if (notification.type == 4) {
            Object object = this.failoverStatusLock;
            synchronized (object) {
                if (notification.nodeID == this.failedOverFor) {
                    this.failedOverFor = -1;
                    this.failoverStatusLock.notifyAll();
                }
            }
        }
    }
}

