/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.MessagingComponent;

public class JDBCSupport
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(JDBCSupport.class);
    private static boolean trace = log.isTraceEnabled();
    protected DataSource ds;
    private TransactionManager tm;
    protected Properties sqlProperties;
    private Map defaultDMLStatements = new LinkedHashMap();
    private Map defaultDDLStatements = new LinkedHashMap();
    private boolean createTablesOnStartup = true;

    public JDBCSupport() {
        this.sqlProperties = new Properties();
    }

    public JDBCSupport(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup) {
        this();
        this.ds = ds;
        this.tm = tm;
        if (sqlProperties != null) {
            this.sqlProperties = sqlProperties;
        }
        this.createTablesOnStartup = createTablesOnStartup;
    }

    public void start() throws Exception {
        this.defaultDMLStatements.putAll(this.getDefaultDMLStatements());
        this.defaultDDLStatements.putAll(this.getDefaultDDLStatements());
        Properties sqlPropertiesCopy = new Properties();
        for (Map.Entry<Object, Object> entry : this.sqlProperties.entrySet()) {
            if (this.ignoreVerificationOnStartup((String)entry.getKey())) continue;
            sqlPropertiesCopy.put(entry.getKey(), entry.getValue());
        }
        for (String string : sqlPropertiesCopy.keySet()) {
            this.getSQLStatement(string);
        }
        if (!sqlPropertiesCopy.isEmpty()) {
            for (String string : this.defaultDMLStatements.keySet()) {
                if (this.sqlProperties.get(string) != null) continue;
                throw new IllegalStateException("SQL statement " + string + " is not specified in the SQL properties");
            }
            for (String string : this.defaultDDLStatements.keySet()) {
                if (sqlPropertiesCopy.get(string) != null) continue;
                throw new IllegalStateException("SQL statement " + string + " is not specified in the SQL properties");
            }
        }
        if (this.createTablesOnStartup) {
            this.createSchema();
        } else {
            log.debug("Schema is not being created as createTablesOnStartup=" + this.createTablesOnStartup);
        }
    }

    public void stop() throws Exception {
    }

    protected String getSQLStatement(String statementName) {
        String defaultStatement = (String)this.defaultDMLStatements.get(statementName);
        if (defaultStatement == null) {
            defaultStatement = (String)this.defaultDDLStatements.get(statementName);
        }
        if (defaultStatement == null) {
            throw new IllegalArgumentException("No such SQL statement: " + statementName);
        }
        return this.sqlProperties.getProperty(statementName, defaultStatement);
    }

    protected Map getDefaultDMLStatements() {
        return Collections.EMPTY_MAP;
    }

    protected Map getDefaultDDLStatements() {
        return Collections.EMPTY_MAP;
    }

    protected boolean ignoreVerificationOnStartup(String statementName) {
        return false;
    }

    protected void closeResultSet(ResultSet rs) {
        block3: {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable e) {
                    if (!trace) break block3;
                    log.trace("Failed to close result set", e);
                }
            }
        }
    }

    protected void closeStatement(Statement st) {
        block3: {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable e) {
                    if (!trace) break block3;
                    log.trace("Failed to close statement", e);
                }
            }
        }
    }

    protected void closeConnection(Connection conn) {
        block3: {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable e) {
                    if (!trace) break block3;
                    log.trace("Failed to close statement", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchema() throws Exception {
        Iterator i = this.defaultDDLStatements.keySet().iterator();
        while (i.hasNext()) {
            Connection conn = null;
            Statement st = null;
            TransactionWrapper tx = new TransactionWrapper();
            try {
                conn = this.ds.getConnection();
                String statementName = (String)i.next();
                String statement = this.getSQLStatement(statementName);
                if (!"IGNORE".equals(statement)) {
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace("Executing: " + statement);
                        }
                        st = conn.createStatement();
                        st.executeUpdate(statement);
                    }
                    catch (Exception e) {
                        log.debug("Failed to execute: " + statement, e);
                        tx.exceptionOccurred();
                    }
                } else {
                    log.debug("createSchema ignoring statement for " + statementName);
                }
                this.closeStatement(st);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeStatement(st);
                this.closeConnection(conn);
                tx.end();
                throw throwable;
            }
            tx.end();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class JDBCTxRunner2<T> {
        private static final int MAX_TRIES = 25;
        protected Connection conn;

        protected JDBCTxRunner2() {
        }

        public T execute() throws Exception {
            Transaction tx = JDBCSupport.this.tm.suspend();
            try {
                this.conn = JDBCSupport.this.ds.getConnection();
                this.conn.setAutoCommit(false);
                T res = this.doTransaction();
                this.conn.commit();
                T t = res;
                return t;
            }
            catch (Exception e) {
                try {
                    this.conn.rollback();
                }
                catch (Throwable t) {
                    log.trace("Failed to rollback", t);
                }
                throw e;
            }
            finally {
                JDBCSupport.this.closeConnection(this.conn);
                if (tx != null) {
                    JDBCSupport.this.tm.resume(tx);
                }
            }
        }

        public T executeWithRetry() throws Exception {
            int tries = 0;
            while (true) {
                try {
                    T res = this.execute();
                    if (tries > 0) {
                        log.warn("Update worked after retry");
                    }
                    return res;
                }
                catch (SQLException e) {
                    log.warn("SQLException caught, SQLState " + e.getSQLState() + " code:" + e.getErrorCode() + "- assuming deadlock detected, try:" + (tries + 1), e);
                    if (++tries == 25) {
                        log.error("Retried " + tries + " times, now giving up");
                        throw new IllegalStateException("Failed to excecute transaction");
                    }
                    log.warn("Trying again after a pause");
                    Thread.sleep((long)(Math.random() * 500.0));
                    continue;
                }
                break;
            }
        }

        public abstract T doTransaction() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class JDBCTxRunner<T> {
        private static final int MAX_TRIES = 25;
        protected Connection conn;
        private TransactionWrapper wrap;

        protected JDBCTxRunner() {
        }

        public T execute() throws Exception {
            this.wrap = new TransactionWrapper();
            try {
                this.conn = JDBCSupport.this.ds.getConnection();
                T t = this.doTransaction();
                return t;
            }
            catch (Exception e) {
                this.wrap.exceptionOccurred();
                throw e;
            }
            finally {
                this.wrap.end();
                JDBCSupport.this.closeConnection(this.conn);
            }
        }

        public T executeWithRetry() throws Exception {
            int tries = 0;
            while (true) {
                try {
                    T res = this.execute();
                    if (tries > 0) {
                        log.warn("Update worked after retry");
                    }
                    return res;
                }
                catch (SQLException e) {
                    log.warn("SQLException caught, SQLState " + e.getSQLState() + " code:" + e.getErrorCode() + "- assuming deadlock detected, try:" + (tries + 1), e);
                    if (++tries == 25) {
                        log.error("Retried " + tries + " times, now giving up");
                        throw new IllegalStateException("Failed to excecute transaction");
                    }
                    log.warn("Trying again after a pause");
                    Thread.sleep((long)(Math.random() * 500.0));
                    continue;
                }
                break;
            }
        }

        public abstract T doTransaction() throws Exception;
    }

    protected class TransactionWrapper {
        private Transaction oldTx;
        private boolean failed;

        public TransactionWrapper() throws Exception {
            this.oldTx = JDBCSupport.this.tm.suspend();
            JDBCSupport.this.tm.begin();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() throws Exception {
            try {
                if (1 == JDBCSupport.this.tm.getStatus()) {
                    this.failed = true;
                    if (trace) {
                        log.trace("Rolling back tx");
                    }
                    JDBCSupport.this.tm.rollback();
                } else {
                    if (trace) {
                        log.trace("Committing tx");
                    }
                    JDBCSupport.this.tm.commit();
                }
            }
            finally {
                if (this.oldTx != null && JDBCSupport.this.tm != null) {
                    if (trace) {
                        log.trace("Resuming tx");
                    }
                    JDBCSupport.this.tm.resume(this.oldTx);
                }
            }
        }

        public void exceptionOccurred() throws Exception {
            JDBCSupport.this.tm.setRollbackOnly();
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

