/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.message;

import java.util.Map;
import org.jboss.jms.message.JBossBytesMessage;
import org.jboss.jms.message.JBossMapMessage;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.JBossObjectMessage;
import org.jboss.jms.message.JBossStreamMessage;
import org.jboss.jms.message.JBossTextMessage;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.impl.message.CoreMessage;
import org.jboss.messaging.core.impl.message.MessageSupport;

public class MessageFactory {
    public static Message createMessage(byte type) {
        MessageSupport m = null;
        if (type == 1) {
            m = new JBossMessage();
        } else if (type == 2) {
            m = new JBossObjectMessage();
        } else if (type == 3) {
            m = new JBossTextMessage();
        } else if (type == 4) {
            m = new JBossBytesMessage();
        } else if (type == 5) {
            m = new JBossMapMessage();
        } else if (type == 6) {
            m = new JBossStreamMessage();
        } else if (type == 127) {
            m = new CoreMessage();
        } else {
            throw new IllegalArgumentException("Invalid type " + type);
        }
        return m;
    }

    public static Message createMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map headers, byte[] payload, byte type) {
        MessageSupport m = null;
        switch (type) {
            case 1: {
                m = new JBossMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
                break;
            }
            case 2: {
                m = new JBossObjectMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
                break;
            }
            case 3: {
                m = new JBossTextMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
                break;
            }
            case 4: {
                m = new JBossBytesMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
                break;
            }
            case 5: {
                m = new JBossMapMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
                break;
            }
            case 6: {
                m = new JBossStreamMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
                break;
            }
            case 127: {
                m = new CoreMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + type);
            }
        }
        m.setPersisted(true);
        return m;
    }
}

