/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.messaging.core.impl.postoffice.MappingInfo;
import org.jboss.messaging.core.impl.postoffice.PostOfficeAddressInfo;
import org.jboss.messaging.util.StreamUtils;
import org.jboss.messaging.util.Streamable;

class SharedState
implements Streamable {
    private List mappings;
    private Map replicatedData;
    private Map nodeIDAddressMap;

    SharedState() {
    }

    SharedState(List mappings, Map replicatedData, Map nodeIDAddressMap) {
        this.mappings = mappings;
        this.replicatedData = replicatedData;
        this.nodeIDAddressMap = nodeIDAddressMap;
    }

    List getMappings() {
        return this.mappings;
    }

    Map getReplicatedData() {
        return this.replicatedData;
    }

    Map getNodeIDAddressMap() {
        return this.nodeIDAddressMap;
    }

    public void read(DataInputStream in) throws Exception {
        int i;
        int size = in.readInt();
        this.mappings = new ArrayList(size);
        for (i = 0; i < size; ++i) {
            MappingInfo mapping = new MappingInfo();
            mapping.read(in);
            this.mappings.add(mapping);
        }
        size = in.readInt();
        this.replicatedData = new HashMap(size);
        for (i = 0; i < size; ++i) {
            Serializable key = (Serializable)StreamUtils.readObject(in, true);
            HashMap replicants = StreamUtils.readMap(in, false);
            this.replicatedData.put(key, replicants);
        }
        size = in.readInt();
        this.nodeIDAddressMap = new HashMap(size);
        for (i = 0; i < size; ++i) {
            int nodeID = in.readInt();
            PostOfficeAddressInfo info = new PostOfficeAddressInfo();
            info.read(in);
            this.nodeIDAddressMap.put(new Integer(nodeID), info);
        }
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.mappings.size());
        for (MappingInfo mappingInfo : this.mappings) {
            mappingInfo.write(out);
        }
        out.writeInt(this.replicatedData.size());
        for (Map.Entry entry : this.replicatedData.entrySet()) {
            Serializable key = (Serializable)entry.getKey();
            StreamUtils.writeObject(out, key, true, true);
            Map replicants = (Map)entry.getValue();
            StreamUtils.writeMap(out, replicants, false);
        }
        out.writeInt(this.nodeIDAddressMap.size());
        for (Map.Entry entry : this.nodeIDAddressMap.entrySet()) {
            Integer nodeID = (Integer)entry.getKey();
            PostOfficeAddressInfo info = (PostOfficeAddressInfo)entry.getValue();
            out.writeInt(nodeID);
            info.write(out);
        }
    }
}

