/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.serviceref;

import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.jboss.CallPropertyMetaData;
import org.jboss.metadata.javaee.jboss.JBossPortComponentRef;
import org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData;
import org.jboss.metadata.javaee.jboss.StubPropertyMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.PortComponentRef;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.wsf.spi.serviceref.ServiceRefHandlerFactory;

public class ServiceReferenceHandler {
    private final Logger log = Logger.getLogger(ServiceReferenceHandler.class);
    private ServiceRefHandler delegate;

    public ServiceReferenceHandler() {
        if (this.delegate == null) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            this.delegate = spiProvider.getSPI(ServiceRefHandlerFactory.class).getServiceRefHandler();
        }
        if (this.delegate == null) {
            this.log.warn("ServiceRefHandler not available");
        }
    }

    public void bindServiceRef(Context encCtx, String encName, UnifiedVirtualFile vfsRoot, ClassLoader loader, ServiceReferenceMetaData sref) throws NamingException {
        if (this.delegate != null && !sref.isProcessed()) {
            UnifiedServiceRefMetaData spiRef = this.getUnifiedServiceRefMetaData(vfsRoot, sref);
            this.delegate.bindServiceRef(encCtx, encName, vfsRoot, loader, spiRef);
            sref.setProcessed(true);
        }
    }

    private UnifiedServiceRefMetaData getUnifiedServiceRefMetaData(UnifiedVirtualFile vfsRoot, ServiceReferenceMetaData sref) {
        ServiceReferenceHandlerChainsMetaData serviceReferenceHandlerChainsMetaData;
        ServiceReferenceHandlersMetaData srHandlers;
        UnifiedServiceRefMetaData result = new UnifiedServiceRefMetaData(vfsRoot);
        result.setServiceRefName(sref.getServiceRefName());
        result.setServiceInterface(sref.getServiceInterface());
        result.setServiceRefType(sref.getServiceRefType());
        result.setWsdlFile(sref.getWsdlFile());
        result.setMappingFile(sref.getJaxrpcMappingFile());
        result.setServiceQName(sref.getServiceQname());
        result.setAnnotatedElement(sref.getAnnotatedElement());
        result.setProcessed(sref.isProcessed());
        List<? extends PortComponentRef> pcRefs = sref.getPortComponentRef();
        if (pcRefs != null) {
            for (PortComponentRef portComponentRef : pcRefs) {
                UnifiedPortComponentRefMetaData upcRef = this.getUnifiedPortComponentRefMetaData(result, portComponentRef);
                if (upcRef.getServiceEndpointInterface() != null || upcRef.getPortQName() != null) {
                    result.addPortComponentRef(upcRef);
                    continue;
                }
                this.log.warn("Ignore <port-component-ref> without <service-endpoint-interface> and <port-qname>: " + upcRef);
            }
        }
        if ((srHandlers = sref.getHandlers()) != null) {
            for (ServiceReferenceHandlerMetaData srHandlerMetaData : srHandlers) {
                UnifiedHandlerMetaData uHandlerMetaData = this.getUnifiedHandlerMetaData(srHandlerMetaData);
                result.addHandler(uHandlerMetaData);
            }
        }
        if ((serviceReferenceHandlerChainsMetaData = sref.getHandlerChains()) != null) {
            UnifiedHandlerChainsMetaData uHandlerChains = new UnifiedHandlerChainsMetaData();
            List<ServiceReferenceHandlerChainMetaData> srHandlerChainList = serviceReferenceHandlerChainsMetaData.getHandlers();
            for (ServiceReferenceHandlerChainMetaData srHandlerChain : srHandlerChainList) {
                UnifiedHandlerChainMetaData uHandlerChain = new UnifiedHandlerChainMetaData();
                uHandlerChain.setServiceNamePattern(srHandlerChain.getServiceNamePattern());
                uHandlerChain.setPortNamePattern(srHandlerChain.getPortNamePattern());
                uHandlerChain.setProtocolBindings(srHandlerChain.getProtocolBindings());
                List<ServiceReferenceHandlerMetaData> srHandlerChainHandlers = srHandlerChain.getHandler();
                for (ServiceReferenceHandlerMetaData srHandlerMetaData : srHandlerChainHandlers) {
                    UnifiedHandlerMetaData uHandlerMetaData = this.getUnifiedHandlerMetaData(srHandlerMetaData);
                    uHandlerChain.addHandler(uHandlerMetaData);
                }
                uHandlerChains.addHandlerChain(uHandlerChain);
            }
            result.setHandlerChains(uHandlerChains);
        }
        if (sref instanceof JBossServiceReferenceMetaData) {
            JBossServiceReferenceMetaData jbRef = (JBossServiceReferenceMetaData)sref;
            result.setServiceImplClass(jbRef.getServiceClass());
            result.setConfigName(jbRef.getConfigName());
            result.setConfigFile(jbRef.getConfigFile());
            result.setWsdlOverride(jbRef.getWsdlOverride());
            result.setHandlerChain(jbRef.getHandlerChain());
        }
        return result;
    }

    private UnifiedHandlerMetaData getUnifiedHandlerMetaData(ServiceReferenceHandlerMetaData srhmd) {
        List<String> portNames;
        List<String> soapRoles;
        List<QName> soapHeaders;
        UnifiedHandlerMetaData uhmd = new UnifiedHandlerMetaData();
        uhmd.setHandlerName(srhmd.getHandlerName());
        uhmd.setHandlerClass(srhmd.getHandlerClass());
        List<ParamValueMetaData> initParams = srhmd.getInitParam();
        if (initParams != null) {
            for (ParamValueMetaData initParam : initParams) {
                UnifiedInitParamMetaData param = new UnifiedInitParamMetaData();
                param.setParamName(initParam.getParamName());
                param.setParamValue(initParam.getParamValue());
                uhmd.addInitParam(param);
            }
        }
        if ((soapHeaders = srhmd.getSoapHeader()) != null) {
            for (QName soapHeader : soapHeaders) {
                uhmd.addSoapHeader(soapHeader);
            }
        }
        if ((soapRoles = srhmd.getSoapRole()) != null) {
            for (String soapRole : soapRoles) {
                uhmd.addSoapRole(soapRole);
            }
        }
        if ((portNames = srhmd.getPortName()) != null) {
            for (String portName : portNames) {
                uhmd.addPortName(portName);
            }
        }
        return uhmd;
    }

    private UnifiedPortComponentRefMetaData getUnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData usref, PortComponentRef pcref) {
        UnifiedPortComponentRefMetaData result = new UnifiedPortComponentRefMetaData(usref);
        result.setServiceEndpointInterface(pcref.getServiceEndpointInterface());
        result.setEnableMTOM(pcref.isEnableMtom());
        result.setPortComponentLink(pcref.getPortComponentLink());
        if (pcref instanceof JBossPortComponentRef) {
            List<CallPropertyMetaData> callProps;
            JBossPortComponentRef jbpcref = (JBossPortComponentRef)pcref;
            result.setPortQName(jbpcref.getPortQname());
            result.setConfigName(jbpcref.getConfigName());
            result.setConfigFile(jbpcref.getConfigFile());
            List<StubPropertyMetaData> stubProps = jbpcref.getStubProperties();
            if (stubProps != null) {
                for (StubPropertyMetaData stubProp : stubProps) {
                    UnifiedStubPropertyMetaData prop = new UnifiedStubPropertyMetaData();
                    prop.setPropName(stubProp.getPropName());
                    prop.setPropValue(stubProp.getPropValue());
                    result.addStubProperty(prop);
                }
            }
            if ((callProps = jbpcref.getCallProperties()) != null) {
                for (CallPropertyMetaData callProp : callProps) {
                    UnifiedCallPropertyMetaData prop = new UnifiedCallPropertyMetaData();
                    prop.setPropName(callProp.getPropName());
                    prop.setPropValue(callProp.getPropValue());
                    result.addCallProperty(prop);
                }
            }
        }
        return result;
    }
}

